/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.umap.imp;

import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.umap.IUserMappingData;
import com.sap.security.api.umap.NoLogonDataAvailableException;
import com.sap.security.api.umap.UserMappingNotAvailableException;
import com.sap.security.api.umap.system.ISystemLandscapeObject;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.umap.imp.AbstractEncryptedFieldBlob;
import com.sap.security.core.umap.imp.Base64EncodedFieldBlob;
import com.sap.security.core.umap.imp.EncryptedFieldBlob;
import com.sap.security.core.umap.imp.UserMapping;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class UserMappingDataImp
implements IUserMappingData {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/umap/imp/UserMappingDataImp.java#8 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static final byte[] BASE64_ID = new byte[]{98, 97, 115, 101, 54, 52, 58};
    private static final int MODE_WRAP = 0;
    private static final int MODE_UNWRAP = 1;
    private static final String WEAK_PREFIX = "WeakCrypto:";
    private static final String[] WEAK_ATTR_VALUE = new String[]{"1"};
    private static final String M_ENRICH_HTTPURLCONN = "UserMappingDataImp.enrich(HttpURLConnection)";
    private static final String M_ENRICH_MAP = "UserMappingDataImp.enrich(Map)";
    private static final String M_ENRICH_PROPERTIES = "UserMappingDataImp.enrich(Properties)";
    private static final String M_ENRICH_SOAPMSG = "UserMappingDataImp.enrich(SOAPMessage)";
    private static final String M_GET_ENCR_FIELD_BLOB = "UserMappingDataImp.getEncryptedFieldBlob(byte[], String, boolean)";
    private static final String M_GET_LOGON_DATA = "UserMappingDataImp.getLogonDataForSystem()";
    private static final String M_HANDLE_ENCR_FIELDS = "UserMappingDataImp.handleEncryptedFields(int, String)";
    private static final String M_HANDLE_KEYED_HASH_F = "UserMappingDataImp.handleKeyedHashField(Object, int)";
    private static final String M_INTERNAL_INIT = "UserMappingDataImp.internalInit(ISystemLandscapeObject, IPrincipal, SecretKey, boolean)";
    private static final String M_ITERATE_THROUGH_G_A_R = "UserMappingDataImp.iterateThroughGroupsAndRoles()";
    private static final String M_RECURSIVE_SEARCH = "UserMappingDataImp.recursiveUserMappingSearch(IPrincipal, String)";
    private static final String M_STORE_LOGON_DATA = "UserMappingDataImp.storeLogonData(Map)";
    private static final String UMAP_USER = "user";
    private static final String UMAP_PASSWORD = "mappedpassword";
    private static final String JCO_USER = "jco.client.user";
    private static final String JCO_PASSWORD = "jco.client.passwd";
    private static final String EXC_POLICY_FILES_MISSING = "Unsupported keysize or algorithm parameters";
    private static final String NULL = "(null)";
    protected static IUMTrace _s_trace = null;
    private boolean _strongEncryption;
    private ISystemLandscapeObject _system;
    private String _systemAlias;
    private IPrincipal _principal;
    private Map _logonData;
    private boolean _isMappingDirect;
    private SecretKey _key;
    private Calendar _lastEncryptionDate = null;
    private boolean _bIsRefSystem;
    private HashSet _recursionBlocker;

    public UserMappingDataImp(ISystemLandscapeObject system, IPrincipal principal, SecretKey key, boolean strongEncryption) {
        this._systemAlias = system != null ? system.getAlias() : NULL;
        this.internalInit(system, principal, key, strongEncryption);
    }

    public UserMappingDataImp(String sysid, IPrincipal principal, Map sysAttrBag, SecretKey key, boolean strongEncryption) {
        this._systemAlias = sysid;
        this.internalInit(UserMapping.getSystemByAlias(sysid), principal, key, strongEncryption);
    }

    private void internalInit(ISystemLandscapeObject system, IPrincipal principal, SecretKey key, boolean strongEncryption) {
        if (principal == null) {
            if (_s_trace.beWarning()) {
                String msg = UserMapping.getTraceString("User mapping requested, but principal is null.", principal, this._systemAlias);
                _s_trace.warningT(M_INTERNAL_INIT, msg);
            }
            throw new NullPointerException("Principal must not be null");
        }
        this._strongEncryption = strongEncryption;
        this._system = system;
        this._principal = principal;
        this._isMappingDirect = true;
        this._recursionBlocker = new HashSet();
        this._key = key;
        this.setIsRefSystem();
        if (_s_trace.beInfo()) {
            String msg = MessageFormat.format("User mapping requested. The system is {0}an SAP reference system and is defined to use the logon method \"{1}\".", this._bIsRefSystem ? "" : "not ", this.getLogonMethod() != null ? this.getLogonMethod() : NULL);
            msg = UserMapping.getTraceString(msg, principal, this._systemAlias);
            _s_trace.infoT(M_INTERNAL_INIT, msg);
        }
        try {
            if (this._system != null) {
                this.getLogonDataForSystem();
            }
        }
        catch (IOException ex) {
            this._logonData = null;
            String msg = "(dummy message)";
            if (_s_trace.beWarning()) {
                msg = UserMapping.getTraceString("Deserializing the logon data failed.", principal, this._systemAlias);
            }
            _s_trace.warningT(M_INTERNAL_INIT, msg, ex);
            this.logReadFailed();
        }
    }

    protected void setIsRefSystem() {
        this._bIsRefSystem = this._system == null ? false : UMFactory.getProperties().get("ume.r3.mastersystem", "").equals(this._system.getAlias());
    }

    public void enrich(Map logonData) throws NoLogonDataAvailableException {
        if (this._logonData == null) {
            if (_s_trace.beInfo()) {
                String msg = UserMapping.getTraceString("No logon data available: No data found in user''s attributes.", this._principal, this._systemAlias);
                _s_trace.infoT(M_ENRICH_MAP, msg);
            }
            throw new NoLogonDataAvailableException("No data for system " + this._systemAlias);
        }
        logonData.putAll(this._logonData);
        if (_s_trace.beInfo()) {
            Map logLogonData = this.getUncriticalLogonData(logonData);
            String msg = MessageFormat.format("UserMapping: Successfully added logon data to Map object: \"{0}\" (sensitive data has been omitted)", logLogonData);
            _s_trace.infoT(M_ENRICH_MAP, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
        }
        if (SecurityAudit.isLogged("USERMAPPING.USE")) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this._system != null) {
                details.put("systemtype", this._system.getAttribute("SystemType"));
            } else {
                details.put("systemtype", NULL);
            }
            details.put("system", this._systemAlias);
            SecurityAudit.log("USERMAPPING.USE", this._principal.getUniqueID(), details);
        }
    }

    private Map getUncriticalLogonData(Map logonData) {
        HashMap logLogonData = new HashMap(logonData.size());
        logLogonData.putAll(logonData);
        logLogonData.remove(UMAP_PASSWORD);
        logLogonData.remove(JCO_PASSWORD);
        logLogonData.remove(JCO_PASSWORD);
        return logLogonData;
    }

    public void enrich(HttpURLConnection conn) throws NoLogonDataAvailableException {
        if (!(this._principal instanceof IUser)) {
            throw new IllegalStateException("Enrich not possible for principal: " + this._principal.toString());
        }
        String ticket = (String)((IUser)this._principal).getTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING");
        if (ticket == null || "".equals(ticket)) {
            if (_s_trace.beInfo()) {
                String msg = UserMapping.getTraceString("No logon data available: Ticket is empty.", this._principal, this._systemAlias);
                _s_trace.infoT(M_ENRICH_HTTPURLCONN, msg);
            }
            throw new NoLogonDataAvailableException("No ticket in user object.");
        }
        conn.setRequestProperty("Cookie", "MYSAPSSO2=" + ticket);
        if (_s_trace.beInfo()) {
            String msg = UserMapping.getTraceString("Successfully added SAP Logon Ticket to HttpURLConnection.", this._principal, this._systemAlias);
            _s_trace.infoT(M_ENRICH_HTTPURLCONN, msg);
        }
        if (SecurityAudit.isLogged("USERMAPPING.USE")) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this._system != null) {
                details.put("systemtype", this._system.getAttribute("SystemType"));
            } else {
                details.put("systemtype", NULL);
            }
            details.put("system", this._systemAlias);
            SecurityAudit.log("USERMAPPING.USE", this._principal.getUniqueID(), details);
        }
    }

    public void enrich(SOAPMessage msg) throws NoLogonDataAvailableException {
        String logonmethod = this.getLogonMethod();
        String auth_header_name = null;
        String auth_header_value = null;
        if (logonmethod == null) {
            logonmethod = "SAPLOGONTICKET";
        }
        if (logonmethod.equals("SAPLOGONTICKET")) {
            String ticket = (String)((IUser)this._principal).getTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING");
            auth_header_name = "Cookie";
            auth_header_value = "MYSAPSSO2=" + ticket;
        } else if (logonmethod.equals("UIDPW")) {
            HashMap m = new HashMap();
            this.enrich(m);
            String uid = (String)m.get(UMAP_USER);
            String pwd = (String)m.get(UMAP_PASSWORD);
            if (uid == null || pwd == null) {
                if (_s_trace.beInfo()) {
                    String trcmsg = UserMapping.getTraceString("No logon data available: User or password is empty.", this._principal, this._systemAlias);
                    _s_trace.infoT(M_ENRICH_SOAPMSG, trcmsg);
                }
                throw new NoLogonDataAvailableException("User or password is empty.");
            }
            auth_header_name = "Authorization";
            auth_header_value = "Basic " + Base64.encode(new String(uid + ":" + pwd).getBytes());
        } else {
            throw new IllegalStateException("logonMethod " + logonmethod + " not supported for enrich (SOAPMessage)");
        }
        MimeHeaders headers = msg.getMimeHeaders();
        String[] s = headers.getHeader("Cookie");
        if (s == null || s.length > 1) {
            headers.addHeader(auth_header_name, auth_header_value);
        } else {
            auth_header_value = MessageFormat.format("{0}; {1}", s[0], auth_header_value);
            headers.setHeader(auth_header_name, auth_header_value);
        }
        if (_s_trace.beInfo()) {
            String traceMsg = MessageFormat.format("Successfully added logon data to SOAPMessage object as HTTP header \"{0}\"", auth_header_name);
            _s_trace.infoT(M_ENRICH_SOAPMSG, UserMapping.getTraceString(traceMsg, this._principal, this._systemAlias));
        }
        if (SecurityAudit.isLogged("USERMAPPING.USE")) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this._system != null) {
                details.put("systemtype", this._system.getAttribute("SystemType"));
            } else {
                details.put("systemtype", NULL);
            }
            details.put("system", this._systemAlias);
            SecurityAudit.log("USERMAPPING.USE", this._principal.getUniqueID(), details);
        }
    }

    public void enrich(Properties jcoProps) throws NoLogonDataAvailableException {
        if (!(this._principal instanceof IUser)) {
            if (_s_trace.beWarning()) {
                String msg = UserMapping.getTraceString("Principal to enrich is not a user.", this._principal, this._systemAlias);
                _s_trace.warningT(M_ENRICH_PROPERTIES, msg);
            }
            throw new IllegalStateException("Enrich not possible for principal: " + this._principal.toString());
        }
        String logonMethod = this.getLogonMethod();
        if (logonMethod == null) {
            if (_s_trace.beInfo()) {
                String msg = UserMapping.getTraceString("No logon method defined forsystem; using default method \"SAP Logon Ticket\"", this._principal, this._systemAlias);
                _s_trace.infoT(M_ENRICH_PROPERTIES, msg);
            }
            logonMethod = "SAPLOGONTICKET";
        }
        if (logonMethod.equals("SAPLOGONTICKET")) {
            String ticket = (String)((IUser)this._principal).getTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING");
            if (ticket == null || "".equals(ticket)) {
                if (_s_trace.beInfo()) {
                    String msg = UserMapping.getTraceString("No logon data available: Ticket is empty.", this._principal, this._systemAlias);
                    _s_trace.infoT(M_ENRICH_PROPERTIES, msg);
                }
                throw new NoLogonDataAvailableException("No ticket in principal object.");
            }
            jcoProps.setProperty(JCO_USER, "$MYSAPSSO2$");
            jcoProps.setProperty(JCO_PASSWORD, ticket);
        } else if (logonMethod.equals("UIDPW")) {
            HashMap m = new HashMap();
            boolean logonDataFound = true;
            try {
                this.enrich(m);
            }
            catch (NoLogonDataAvailableException ex) {
                logonDataFound = false;
            }
            String user = (String)m.get(UMAP_USER);
            String pwd = (String)m.get(UMAP_PASSWORD);
            if (!logonDataFound || user == null || pwd == null || user.equals("")) {
                if (_s_trace.beInfo()) {
                    String msg = UserMapping.getTraceString("No logon data available: No data found in user''s attributes or user/password is empty.", this._principal, this._systemAlias);
                    _s_trace.infoT(M_ENRICH_PROPERTIES, msg);
                }
                throw new NoLogonDataAvailableException("No credentials for connection to R/3 system.");
            }
            jcoProps.setProperty(JCO_USER, user);
            jcoProps.setProperty(JCO_PASSWORD, pwd);
        } else if (logonMethod.equals("X509CERT")) {
            String x509Cert = null;
            X509Certificate[] certs = null;
            try {
                certs = ((IUser)this._principal).getUserAccounts()[0].getCertificates();
                if (certs == null || certs.length == 0) {
                    certs = (X509Certificate[])((IUser)this._principal).getTransientAttribute("com.sap.security.core.usermanagement", "$X509CERT$");
                }
                if (certs == null || certs.length == 0) {
                    if (_s_trace.beInfo()) {
                        String msg = UserMapping.getTraceString("No logon data available: User has no certificate.", this._principal, this._systemAlias);
                        _s_trace.infoT(M_ENRICH_PROPERTIES, msg);
                    }
                    throw new NoLogonDataAvailableException("This user doesn''t have a certificate");
                }
                x509Cert = Base64.encode(certs[0].getEncoded());
            }
            catch (UMException e) {
                String msg = "(dummy message)";
                if (_s_trace.beWarning()) {
                    msg = UserMapping.getTraceString("No logon data available.", this._principal, this._systemAlias);
                }
                _s_trace.warningT(M_ENRICH_PROPERTIES, msg, e);
                throw new NoLogonDataAvailableException(e.toString());
            }
            catch (GeneralSecurityException e) {
                String msg = "(dummy message)";
                if (_s_trace.beWarning()) {
                    msg = UserMapping.getTraceString("No logon data available.", this._principal, this._systemAlias);
                    _s_trace.warningT(M_ENRICH_PROPERTIES, msg, e);
                }
                throw new NoLogonDataAvailableException(e.toString());
            }
            jcoProps.setProperty(JCO_USER, "$X509CERT$");
            jcoProps.setProperty(JCO_PASSWORD, x509Cert);
        }
        if (_s_trace.beInfo()) {
            Map logLogonData = this.getUncriticalLogonData(jcoProps);
            String msg = MessageFormat.format("Successfully added logon data to Properties object: \"{0}\" (sensitive data has been omitted)", logLogonData);
            _s_trace.infoT(M_ENRICH_PROPERTIES, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
        }
        if (SecurityAudit.isLogged("USERMAPPING.USE")) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this._system != null) {
                details.put("systemtype", this._system.getAttribute("SystemType"));
            } else {
                details.put("systemtype", NULL);
            }
            details.put("system", this._systemAlias);
            SecurityAudit.log("USERMAPPING.USE", this._principal.getUniqueID(), details);
        }
    }

    private String getLogonMethod() {
        if (this._system != null) {
            return this._system.getLogonMethod();
        }
        return null;
    }

    public IPrincipal getPrincipal() {
        return this._principal;
    }

    public String getSystemId() {
        if (this._system != null) {
            return this._system.getAlias();
        }
        return null;
    }

    public void deleteLogonData() throws IOException {
        this.storeLogonData(null);
    }

    public void storeLogonData(Map logonData) throws IOException {
        if (this._system == null) {
            if (_s_trace.beWarning()) {
                String msg = UserMapping.getTraceString("Can't save user mapping data because there was is no specific system defined in the constructor call", this._principal, (ISystemLandscapeObject)null);
                _s_trace.warningT(M_STORE_LOGON_DATA, msg);
            }
            throw new UMRuntimeException("Can't save user mapping data for 'null' system.");
        }
        boolean storeInverseMapping = false;
        IUserMaint principalm = null;
        try {
            if (this._principal instanceof IUser) {
                principalm = UMFactory.getUserFactory().getMutableUser(this._principal.getUniqueID());
                storeInverseMapping = true;
            } else if (this._principal instanceof IGroup) {
                principalm = UMFactory.getGroupFactory().getMutableGroup(this._principal.getUniqueID());
                storeInverseMapping = false;
            } else if (this._principal instanceof IRole) {
                principalm = UMFactory.getRoleFactory().getMutableRole(this._principal.getUniqueID());
                storeInverseMapping = false;
            }
        }
        catch (UMException e) {
            String msg = "(dummy message)";
            if (_s_trace.beError()) {
                msg = UserMapping.getTraceString("Unable to get mutable user, so unable to store user mapping data.", this._principal, this._systemAlias);
                _s_trace.errorT(M_STORE_LOGON_DATA, msg, e);
            }
            this.logSaveFailed();
            throw new IOException("Unable to store logon data.");
        }
        if (this.isPlainAttributeMapping()) {
            if (!(this._principal instanceof IUser)) {
                String msg = "Saving user mapping data for an SAP reference system is only possible for users, but not for groups and roles.";
                if (_s_trace.beError()) {
                    _s_trace.errorT(M_STORE_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
                }
                throw new IOException(msg);
            }
            if (this.isReadOnly()) {
                String msg = MessageFormat.format("User attribute holding the mapped backend user for the SAP reference system is read-only (logical attribute ''{0}'', physical attribute ''{1}''). Can't save the new backend user.", "REFERENCE_SYSTEM_USER", this.getPhysicalRefSysMappingAttribute());
                if (_s_trace.beError()) {
                    _s_trace.errorT(M_STORE_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
                }
                throw new IOException(msg);
            }
            principalm.setAttribute("$usermapping$", "REFERENCE_SYSTEM_USER", new String[]{logonData != null ? (String)logonData.get(UMAP_USER) : null});
        } else {
            String msg;
            if (logonData != null && !this.isFullyAvailable()) {
                throw new UserMappingNotAvailableException("User Mapping not fully available.");
            }
            String mappingNamespace = "$usermapping$";
            byte[] mappingValue = null;
            String[] weakFlag = null;
            String inverseMappingNamespace = "$inverse_usermapping$";
            String[] inverseMappingValue = null;
            String key = this.getKeyForUserAndSystem();
            if (logonData != null) {
                String unchangedPw = null;
                if (this._logonData != null && this._logonData.get(UMAP_PASSWORD) != null && ((String)logonData.get(UMAP_PASSWORD)).equals("********")) {
                    unchangedPw = (String)this._logonData.get(UMAP_PASSWORD);
                }
                this._logonData = new HashMap();
                this._logonData.putAll(logonData);
                if (unchangedPw != null) {
                    this._logonData.put(UMAP_PASSWORD, unchangedPw);
                }
                this.checkCodeAuthorizationOnSave();
                try {
                    this.handleEncryptedFields(0, this._principal.getUniqueID());
                }
                catch (UnsupportedEncodingException e) {
                    String msg2 = "(dummy message)";
                    if (_s_trace.beError()) {
                        msg2 = UserMapping.getTraceString("UTF8 encoding not supported.", this._principal, this._systemAlias);
                        _s_trace.errorT(M_STORE_LOGON_DATA, msg2, e);
                    }
                    this.logSaveFailed();
                    throw new IOException("Unable to store data (UTF8 encoding not supported)");
                }
                catch (GeneralSecurityException e) {
                    if (_s_trace.beError()) {
                        String msg3 = UserMapping.getTraceString("Security Exception while storing user mapping data.", this._principal, this._systemAlias);
                        _s_trace.errorT(M_STORE_LOGON_DATA, msg3, e);
                    }
                    this.logSaveFailed();
                    throw new IOException("Unable to store data (" + e + ")");
                }
                catch (UMException e) {
                    if (_s_trace.beError()) {
                        String msg4 = UserMapping.getTraceString("ASN.1 coding problems while storing user mapping data.", this._principal, this._systemAlias);
                        _s_trace.errorT(M_STORE_LOGON_DATA, msg4, e);
                    }
                    this.logSaveFailed();
                    throw new IOException("Unable to store data (" + (Object)((Object)e) + ")");
                }
                mappingValue = UserMappingDataImp.serializeMap(this._logonData);
                if (!this._strongEncryption) {
                    weakFlag = WEAK_ATTR_VALUE;
                }
                if (storeInverseMapping) {
                    Object value = this._logonData.get(UMAP_USER);
                    if (value == null) {
                        if (_s_trace.beWarning()) {
                            String msg5 = UserMapping.getTraceString("Inconsistency found: _logonData hashmap has no key \"user\".", this._principal, this._systemAlias);
                            _s_trace.warningT(M_STORE_LOGON_DATA, msg5);
                        }
                    } else {
                        inverseMappingValue = new String[]{(String)value};
                    }
                }
            }
            principalm.setBinaryAttribute(mappingNamespace, key, mappingValue);
            if (_s_trace.beInfo()) {
                msg = UserMapping.getTraceString("setBinaryAttribute() succeeded.", this._principal, this._systemAlias);
                _s_trace.infoT(M_STORE_LOGON_DATA, msg);
            }
            if (logonData == null || !this._strongEncryption) {
                principalm.setAttribute(mappingNamespace, WEAK_PREFIX + key, weakFlag);
            }
            if (storeInverseMapping) {
                principalm.setAttribute(inverseMappingNamespace, key, inverseMappingValue);
                if (_s_trace.beInfo()) {
                    msg = UserMapping.getTraceString("setAttribute() for inverse user mapping succeeded.", this._principal, this._systemAlias);
                    _s_trace.infoT(M_STORE_LOGON_DATA, msg);
                }
            }
        }
        try {
            String event;
            principalm.commit();
            String string = event = logonData != null ? "USERMAPPING.CREATE" : "USERMAPPING.DELETE";
            if (SecurityAudit.isLogged(event)) {
                HashMap<String, Object> details = new HashMap<String, Object>();
                if (this._system != null) {
                    details.put("systemtype", this._system.getAttribute("SystemType"));
                } else {
                    details.put("systemtype", NULL);
                }
                details.put("system", this._systemAlias);
                SecurityAudit.log(event, this._principal.getUniqueID(), details);
            }
            this._principal.refresh();
        }
        catch (UMException e) {
            if (_s_trace.beError()) {
                String msg = UserMapping.getTraceString("Committing changes failed.", (IPrincipal)principalm, this._systemAlias);
                _s_trace.errorT(M_STORE_LOGON_DATA, msg, e);
            }
            this.logSaveFailed();
            throw new IOException("Unable to commit changes for principal " + principalm.getDisplayName() + ".");
        }
    }

    public boolean isReadOnly() {
        boolean isReadOnly;
        block3: {
            isReadOnly = false;
            if (this.isPlainAttributeMapping()) {
                try {
                    isReadOnly = !UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable(this._principal.getUniqueID(), "$usermapping$", "REFERENCE_SYSTEM_USER");
                }
                catch (UMException e) {
                    if (!_s_trace.beWarning()) break block3;
                    String msg = MessageFormat.format("Could not determine whether the attribute holding the mapped backend user for the SAP reference system is writable or read-only (logical attribute ''{0}'', physical attribute ''{1}'').", "REFERENCE_SYSTEM_USER", this.getPhysicalRefSysMappingAttribute());
                    _s_trace.warningT(M_STORE_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias), e);
                }
            }
        }
        return isReadOnly;
    }

    protected void handleEncryptedFields(int mode, String principalName) throws UnsupportedEncodingException, GeneralSecurityException, UMException {
        if (this._logonData == null) {
            return;
        }
        Iterator e = this._logonData.keySet().iterator();
        while (e.hasNext()) {
            String key = (String)e.next();
            if (-1 == key.indexOf(UMAP_PASSWORD)) continue;
            Object value = this._logonData.get(key);
            if (this._bIsRefSystem) {
                this._logonData.put(key, this.handleKeyedHashField(value, mode));
                return;
            }
            try {
                AbstractEncryptedFieldBlob blob = null;
                if (mode == 0) {
                    blob = this.getEncryptedFieldBlob(((String)value).getBytes("UTF8"), principalName, true);
                    byte[] blobData = blob.encrypt(this._key);
                    if (blob instanceof Base64EncodedFieldBlob) {
                        blobData = this.addPrefixToBytes(blobData, BASE64_ID);
                    }
                    this._logonData.put(key, blobData);
                    continue;
                }
                blob = this.getEncryptedFieldBlob((byte[])value, " ", false);
                blob.decrypt(this._key);
                this._lastEncryptionDate = blob.getLastEncryptionDate();
                this._logonData.put(key, new String(blob.getCredentialsValue(), "UTF8"));
            }
            catch (SecurityException exc) {
                String logMsg = "A cryptographic operation on user mapping data failed. ";
                String excMsg = exc.getMessage();
                logMsg = excMsg != null && -1 != excMsg.indexOf(EXC_POLICY_FILES_MISSING) ? logMsg + "It seems the reason is that the so-called JCE Policy Files have not been installed correctly in the JDK that is used by this server. Please check the documentation on how to get and install those files." : logMsg + "For further information about the reason, please check the trace file.";
                _s_trace.logErrorT(logMsg, null);
                _s_trace.errorT(M_HANDLE_ENCR_FIELDS, UserMapping.getTraceString("Encrypting or decrypting user mapping data failed, probably because JCE policy files are missing.", this._principal, this._systemAlias), exc);
                throw new GeneralSecurityException("A cryptographic operation on user mapping data failed: " + exc);
            }
            catch (BadPaddingException exc) {
                _s_trace.errorT(M_HANDLE_ENCR_FIELDS, UserMapping.getTraceString("Decryption of user mapping data failed, probably because the user mapping master key has been changed between saving the affected data and now.", this._principal, this._systemAlias), exc);
            }
        }
    }

    protected Object handleKeyedHashField(Object input, int mode) throws UnsupportedEncodingException, GeneralSecurityException, UMException {
        String msg;
        String useridInBlob;
        String userid;
        AbstractEncryptedFieldBlob blob = null;
        if (mode == 0) {
            blob = this.getEncryptedFieldBlob(((String)this._logonData.get(UMAP_USER)).getBytes("UTF8"), " ", true);
            blob.setFlag(AbstractEncryptedFieldBlob.REFERENCE_SYSTEM_FLAG, true);
            byte[] blobData = blob.encrypt(this._key);
            if (blob instanceof Base64EncodedFieldBlob) {
                blobData = this.addPrefixToBytes(blobData, BASE64_ID);
            }
            return blobData;
        }
        blob = this.getEncryptedFieldBlob((byte[])input, " ", false);
        blob.decrypt(this._key);
        this._lastEncryptionDate = blob.getLastEncryptionDate();
        boolean nonRefSysMapping = false;
        if (!blob.getFlag(AbstractEncryptedFieldBlob.REFERENCE_SYSTEM_FLAG)) {
            nonRefSysMapping = true;
            if (_s_trace.beError()) {
                String msg2 = UserMapping.getTraceString("System is UME reference system, but reference system flag is not set in user mapping data. Maybe this user mapping data has been stored for a non-reference system?", this._principal, this._systemAlias);
                _s_trace.errorT(M_HANDLE_KEYED_HASH_F, msg2);
            }
        }
        if (!(userid = (String)this._logonData.get(UMAP_USER)).equals(useridInBlob = new String(blob.getCredentialsValue(), "UTF8"))) {
            nonRefSysMapping = true;
            if (_s_trace.beError()) {
                msg = UserMapping.getTraceString("Plausibility check for user mapping data failed.", this._principal, this._systemAlias);
                _s_trace.errorT(M_HANDLE_KEYED_HASH_F, msg);
            }
        }
        if (nonRefSysMapping) {
            msg = UserMapping.getTraceString("User mapping data is not valid for a reference system. Maybe this user mapping data has been stored for a non-reference system?", this._principal, this._systemAlias);
            throw new GeneralSecurityException(msg);
        }
        return "";
    }

    public Calendar getDateOfLastKeyChange() {
        return this._lastEncryptionDate;
    }

    private void getLogonDataForSystem() throws IOException {
        boolean bFound;
        if (this._principal instanceof IUser && this.isPlainAttributeMapping()) {
            String[] mappedUsers = this._principal.getAttribute("$usermapping$", "REFERENCE_SYSTEM_USER");
            if (mappedUsers == null || mappedUsers.length == 0) {
                if (_s_trace.beInfo()) {
                    String msg = MessageFormat.format("No backend user for SAP reference system found in user''s (logical) attribute \"{0}\" (physical attribute \"{1}\").", "REFERENCE_SYSTEM_USER", this.getPhysicalRefSysMappingAttribute());
                    _s_trace.infoT(M_GET_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
                }
                return;
            }
            if (mappedUsers.length == 1) {
                this._logonData = new HashMap(1);
                this._logonData.put(UMAP_USER, mappedUsers[0]);
                if (_s_trace.beInfo()) {
                    String msg = MessageFormat.format("Backend user ID \"{0}\" for SAPreference system found in user''s (logical) attribute \"{1}\" (physical attribute \"{2}\").", mappedUsers[0], "REFERENCE_SYSTEM_USER", this.getPhysicalRefSysMappingAttribute());
                    _s_trace.infoT(M_GET_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
                }
                this._isMappingDirect = true;
                return;
            }
            if (_s_trace.beWarning()) {
                String physicalAttribute = this.getPhysicalRefSysMappingAttribute();
                String msg = MessageFormat.format("User has multiple values for logical attribute \"{0}\" (physical attribute \"{1}\") which contains the user''s mapped user ID in the backend system. Ignoring all values. Please make sure there is only one mapped backend user ID per user.", "REFERENCE_SYSTEM_USER", physicalAttribute);
                _s_trace.warningT(M_GET_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
            }
            return;
        }
        String keyForUserAndSystem = this.getKeyForUserAndSystem();
        byte[] vs = this._principal.getBinaryAttribute("$usermapping$", keyForUserAndSystem);
        if (vs == null || vs.length == 0) {
            vs = this.iterateThroughGroupsAndRoles();
            this._isMappingDirect = false;
        }
        boolean bl = bFound = vs != null && vs.length != 0;
        if (_s_trace.beInfo()) {
            String msg = MessageFormat.format("Logon data has {0}been found.It''s {1}a direct mapping.", bFound ? "" : "not ", this._isMappingDirect ? "" : "not ");
            _s_trace.infoT(M_GET_LOGON_DATA, UserMapping.getTraceString(msg, this._principal, this._systemAlias));
        }
        if (bFound) {
            this._logonData = UserMappingDataImp.deserializeMap(vs);
        }
        if (this._logonData != null) {
            Throwable exc = null;
            try {
                this.handleEncryptedFields(1, this._principal.getUniqueID());
            }
            catch (UnsupportedEncodingException ee) {
                exc = ee;
            }
            catch (GeneralSecurityException gse) {
                exc = gse;
            }
            catch (UMException ce) {
                exc = ce;
            }
            if (exc != null) {
                if (_s_trace.beError()) {
                    String msg = UserMapping.getTraceString("Retrieving logon data failed.", this._principal, this._systemAlias);
                    _s_trace.errorT(M_GET_LOGON_DATA, msg, exc);
                }
                this.logReadFailed();
                throw new IOException(exc.toString());
            }
        }
    }

    private String getPhysicalRefSysMappingAttribute() {
        String physicalAttribute;
        block5: {
            physicalAttribute = null;
            try {
                DSConfigurationModel[] dsConfigModels = PrincipalDatabagFactory.getInstance().getRuntimeConfiguration();
                int i = 0;
                while (i < dsConfigModels.length) {
                    physicalAttribute = dsConfigModels[i].getPhysicalAttribute("USER", "$usermapping$", "REFERENCE_SYSTEM_USER");
                    if (physicalAttribute == null || physicalAttribute.equals("REFERENCE_SYSTEM_USER")) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (PersistenceException e) {
                if (!_s_trace.beWarning()) break block5;
                String msg = UserMapping.getTraceString("Could not get runtime configuration from PrincipalDatabagFactory. Going on anyway.", this._principal, this._systemAlias);
                _s_trace.warningT(M_STORE_LOGON_DATA, msg, (Throwable)((Object)e));
            }
        }
        if (physicalAttribute == null || physicalAttribute.equals("REFERENCE_SYSTEM_USER")) {
            physicalAttribute = "(unknown)";
        }
        return physicalAttribute;
    }

    protected String getKeyForUserAndSystem() {
        if (this._system != null) {
            return this._system.getStorageKeyPrefix() + ":" + this._system.getUniqueKey();
        }
        return null;
    }

    private static byte[] serializeMap(Map logonData) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(logonData);
        oos.flush();
        os.flush();
        byte[] b = os.toByteArray();
        oos.close();
        os.close();
        return b;
    }

    private static Map deserializeMap(byte[] v) throws IOException {
        if (v == null) {
            throw new NullPointerException("Argument must not be null in deserializeMap");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(v);
        ObjectInputStream ois = new ObjectInputStream(is);
        Map m = null;
        try {
            m = (Map)ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
        ois.close();
        is.close();
        return m;
    }

    private byte[] iterateThroughGroupsAndRoles() {
        byte[] result = this.recursiveUserMappingSearch(this._principal, this.getKeyForUserAndSystem());
        if (result != null) {
            return result;
        }
        IRoleFactory rfac = UMFactory.getRoleFactory();
        if (this._principal instanceof IUser) {
            IUser user = (IUser)this._principal;
            Iterator roles = user.getRoles(false);
            IRole role = null;
            while (roles.hasNext()) {
                String uid = (String)roles.next();
                try {
                    role = rfac.getRole(uid);
                }
                catch (UMException e) {
                    String msg = "(dummy message)";
                    if (_s_trace.beWarning()) {
                        msg = MessageFormat.format("An exception occured while searching roles for user mapping data. Skipping role \"{0}\".", uid);
                        msg = UserMapping.getTraceString(msg, this._principal, this._systemAlias);
                    }
                    _s_trace.warningT(M_ITERATE_THROUGH_G_A_R, msg, e);
                    continue;
                }
                result = role.getBinaryAttribute("$usermapping$", this.getKeyForUserAndSystem());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private byte[] recursiveUserMappingSearch(IPrincipal principal, String systemKey) {
        byte[] result = null;
        if (principal != this._principal && (result = principal.getBinaryAttribute("$usermapping$", systemKey)) != null) {
            return result;
        }
        Iterator groups = null;
        IGroup principalAsGroup = null;
        if (principal instanceof IUser) {
            groups = ((IUser)principal).getParentGroups(false);
        } else if (principal instanceof IGroup) {
            principalAsGroup = (IGroup)principal;
            groups = principalAsGroup.getParentGroups(false);
        } else {
            groups = principal instanceof IUserAccount ? ((IUserAccount)principal).getParentGroups(false) : null;
        }
        if (principalAsGroup != null && (principalAsGroup.equals((Object)"GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE") || principalAsGroup.equals((Object)"GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS") || principalAsGroup.equals((Object)"GRUP.SUPER_GROUPS_DATASOURCE.Anonymous Users"))) {
            return null;
        }
        IGroupFactory gfac = UMFactory.getGroupFactory();
        IGroup nextGroup = null;
        while (groups != null && groups.hasNext() && result == null) {
            String uid = (String)groups.next();
            if (this.preventRecursion(uid)) continue;
            try {
                nextGroup = gfac.getGroup(uid);
            }
            catch (UMException e) {
                String msg = "(dummy message)";
                if (_s_trace.beWarning()) {
                    msg = MessageFormat.format("An exception occured while searching groups for user mapping data. Skipping group \"{0}\".", uid);
                    msg = UserMapping.getTraceString(msg, this._principal, this._systemAlias);
                }
                _s_trace.warningT(M_RECURSIVE_SEARCH, msg, e);
                continue;
            }
            result = this.recursiveUserMappingSearch((IPrincipal)nextGroup, systemKey);
        }
        return result;
    }

    private boolean preventRecursion(String principalid) {
        if (this._recursionBlocker.contains(principalid)) {
            return true;
        }
        this._recursionBlocker.add(principalid);
        return false;
    }

    public boolean isMappingDirect() {
        return this._isMappingDirect;
    }

    private void checkCodeAuthorizationOnSave() {
        SecurityManager secm;
        if (this._bIsRefSystem && (secm = UMFactory.getSecurityManager()) != null) {
            ProtectedCallPermission p = new ProtectedCallPermission("com.sap.security.core.umap.imp.UserMappingDataImp", "saveLogonData");
            secm.checkPermission((Permission)p);
        }
    }

    private boolean isFullyAvailable() {
        if (this._strongEncryption) {
            return this._key != null;
        }
        return true;
    }

    private AbstractEncryptedFieldBlob getEncryptedFieldBlob(byte[] data, String plausiValue, boolean mode) {
        if (mode) {
            if (this._strongEncryption) {
                return new EncryptedFieldBlob(data, plausiValue, true);
            }
            return new Base64EncodedFieldBlob(data, plausiValue, true);
        }
        if (data.length >= BASE64_ID.length && this.startsByteArrayWith(data, BASE64_ID)) {
            if (this._strongEncryption) {
                String msg = UserMapping.getTraceString("Strong cryptography for user mapping entries has been enabled, but there is an unencrypted mapping. For security reasons you should replace this entry by a new (encrypted) one by deleting the mapping data and saving it again.", this._principal, this._systemAlias);
                _s_trace.logWarningT(msg, null);
                _s_trace.warningT(M_GET_ENCR_FIELD_BLOB, msg);
                throw new UserMappingNotAvailableException(msg);
            }
            byte[] tmp = new byte[data.length - BASE64_ID.length];
            System.arraycopy(data, BASE64_ID.length, tmp, 0, tmp.length);
            data = tmp;
            return new Base64EncodedFieldBlob(data, plausiValue, false);
        }
        if (!this._strongEncryption) {
            String msg = UserMapping.getTraceString("Can''t read encrypted user mapping entry when usage of strong cryptography is deactivated!", this._principal, this._systemAlias);
            _s_trace.logWarningT(msg, null);
            _s_trace.errorT(M_GET_ENCR_FIELD_BLOB, msg);
            throw new UserMappingNotAvailableException(msg);
        }
        return new EncryptedFieldBlob(data, plausiValue, false);
    }

    private boolean isPlainAttributeMapping() {
        return this._bIsRefSystem && "attribute".equals(UMFactory.getProperties().get("ume.usermapping.refsys.mapping.type"));
    }

    private void logReadFailed() {
        String msg = MessageFormat.format("UserMapping: Retrieving logon data for user \"{0}\" and system \"{1}\" failed.", this._principal.getDisplayName(), this._systemAlias);
        _s_trace.logWarningT(msg, null);
    }

    private void logSaveFailed() {
        String msg = MessageFormat.format("UserMapping: Storing user mapping for user \"{0}\" and system \"{1}\" failed.", this._principal.getDisplayName(), this._systemAlias);
        _s_trace.logWarningT(msg, null);
    }

    private boolean startsByteArrayWith(byte[] source, byte[] reference) {
        if (source.length < reference.length) {
            return false;
        }
        int i = 0;
        while (i < reference.length) {
            if (source[i] != reference[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] addPrefixToBytes(byte[] bytes, byte[] prefix) {
        byte[] tmp = new byte[bytes.length + BASE64_ID.length];
        System.arraycopy(prefix, 0, tmp, 0, BASE64_ID.length);
        System.arraycopy(bytes, 0, tmp, BASE64_ID.length, bytes.length);
        return tmp;
    }

    static {
        _s_trace = InternalUMFactory.getTrace(VERSIONSTRING);
    }
}

