/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.umap.imp;

import com.sap.security.api.IGroup;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IRole;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserAccountSearchFilter;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.umap.IUserMapping;
import com.sap.security.api.umap.IUserMappingData;
import com.sap.security.api.umap.MultipleHitException;
import com.sap.security.api.umap.NoLogonDataAvailableException;
import com.sap.security.api.umap.UserMappingNotAvailableException;
import com.sap.security.api.umap.system.ExceptionInImplementationException;
import com.sap.security.api.umap.system.ISystemLandscapeObject;
import com.sap.security.api.umap.system.ISystemLandscapeWrapper;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.umap.imp.UserMappingDataImp;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.SSOUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class UserMapping
implements IUserMapping {
    public static final String UMAP_REF_SYS_MAPPING_TYPE = "ume.usermapping.refsys.mapping.type";
    public static final String UMAP_ADMIN_PWD_PROTECTION = "ume.usermapping.admin.pwdprotection";
    public static final String UMAP_REF_SYS_MAPPING_TYPE_INTERNAL = "internal";
    public static final String UMAP_REF_SYS_MAPPING_TYPE_ATTRIBUTE = "attribute";
    public static final String DUMMY_MSG = "(dummy message)";
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/umap/imp/UserMapping.java#8 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static final String PARAM_WEAK_CRYPTO = "ume.usermapping.unsecure";
    protected static IUMTrace _trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/umap/imp/UserMapping.java#8 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    static boolean _weakCrypto = UMFactory.getProperties().getBoolean("ume.usermapping.unsecure", false);
    static ISystemLandscapeWrapper _islw = null;
    static SecretKey _key = null;
    private static final String UNKNOWN = "(unknown)";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final String ROLE = "role";
    private static final String M_GET_INV_MAPPING_SI = "UserMapping.getInverseMappingData(String, ISystemLandscapeObject)";
    private static final String M_GET_INV_MAPPING_SAI = "UserMapping.getInverseMappingData(String[], ISystemLandscapeObject)";
    private static final String M_GET_INV_MAPPING_SSB = "UserMapping.getInverseMappingData(String, String, byte)";
    private static final String M_GET_LANDSCAPE = "UserMapping.getLandscape()";
    private static final String M_GET_KEY = "UserMapping.getKey()";
    private static final String M_GET_MAPPING_II = "UserMapping.getUserMappingData(ISystemLandscapeObject system, IPrincipal principal)";
    private static final String M_GET_MAPPING_SIM = "UserMapping.getUserMappingData(String sysid, IPrincipal principal, Map sysAttrBag)";
    private static final String M_GET_MAPPING_SIML = "UserMapping.getUserMappingData(String sysid, IPrincipal principal, Map sysAttrBag, long lFlags)";
    private static final String M_GET_R3_USER_IIB = "UserMapping.getR3UserName(IUser, ISystemLandscapeObject, boolean)";
    private static final String M_GET_R3_USER_ISB = "UserMapping.getR3UserName(IUser, String, boolean)";
    private static final String M_GET_R3_USER_ISMB = "UserMapping.getR3UserName(IUser, String, Map, boolean)";
    private static final String M_SET_KEY = "UserMapping.setKey(SecretKey)";
    private static final String M_GET_SYSTEM_BY_ALIAS = "UserMapping.getSystemByAlias(String)";
    private static final String M_USER_MAPPING = "UserMapping.UserMapping()";
    private static final String MSG_UMAP_NOT_FUNCTIONAL = "\nNote: User Mapping will not be functional without the key, i.e. existing mapping data can't be decrypted and new mapping data can't be saved because encryption won't work.";

    public static void setKey(SecretKey key) {
        if (_key != null) {
            if (_trace.beWarning()) {
                _trace.warningT(M_SET_KEY, "Rejected attempt to set the user mapping key because it has already been set. This is absolutely legal during migration of the user mapping key from UME properties to J2EE Engine keystore.\nIf this message appears again after the next server restart, it seems there is some code trying to set the user mapping key although it should not. Please check the following stacktrace to determine the component that tried to set the key.", new Exception());
            }
        } else {
            _key = key;
            if (_trace.beInfo()) {
                _trace.infoT(M_USER_MAPPING, "User Mapping successfully initialized (via setKey()).");
            }
        }
    }

    private SecretKey getKey() {
        if (_weakCrypto) {
            return null;
        }
        if (_key != null) {
            return _key;
        }
        String value = UMFactory.getProperties().get("com.sap.security.core.umap.key", "");
        if (value == null || value.length() == 0) {
            if (_trace.beWarning()) {
                _trace.warningT(M_GET_KEY, "Could not retrieve user mapping master key from UME properties. If running in SAP J2EE Engine and the server is still starting up, please wait until startup has completed and try again. If SAP J2EE Engine is up and you still get this message, it's likely that either the IAIK cryptographic library or the JCE policy files have not been installed correctly.\nNote: User Mapping will not be functional without the key, i.e. existing mapping data can't be decrypted and new mapping data can't be saved because encryption won't work.");
            }
            throw new UserMappingNotAvailableException();
        }
        byte[] b = Base64.decode(value);
        if (b == null) {
            if (_trace.beError()) {
                _trace.errorT(M_GET_KEY, "Could not decode user mapping master key from (expected) Base64 encoded string provided with UME properties.\nNote: User Mapping will not be functional without the key, i.e. existing mapping data can't be decrypted and new mapping data can't be saved because encryption won't work.");
            }
            throw new UserMappingNotAvailableException();
        }
        _key = new SecretKeySpec(b, System.getProperties().getProperty("ume.umap.encryption.keytype", "3DES"));
        if (_key == null) {
            if (_trace.beError()) {
                _trace.errorT(M_GET_KEY, "Could not create SecretKeySpec object from user mapping master key data retrieved from UME properties.\nNote: User Mapping will not be functional without the key, i.e. existing mapping data can't be decrypted and new mapping data can't be saved because encryption won't work.");
            }
            throw new UserMappingNotAvailableException();
        }
        if (_trace.beInfo()) {
            _trace.infoT(M_GET_KEY, "User Mapping successfully initialized (from UME properties).");
        }
        return _key;
    }

    public IUserMappingData getUserMappingData(ISystemLandscapeObject system, IPrincipal principal) {
        if (_trace.beInfo()) {
            String msg = UserMapping.getTraceString("Trying to get user mapping data.", principal, system);
            _trace.infoT(M_GET_MAPPING_II, msg);
        }
        return new UserMappingDataImp(system, principal, this.getKey(), !_weakCrypto);
    }

    public IUserMappingData getUserMappingData(String sysid, IPrincipal principal, Map sysAttrBag) {
        if (_trace.beInfo()) {
            String msg = MessageFormat.format("Trying to get user mapping data; sysAttrBag = \"{0}\"", sysAttrBag);
            _trace.infoT(M_GET_MAPPING_SIM, UserMapping.getTraceString(msg, principal, sysid));
        }
        return new UserMappingDataImp(sysid, principal, sysAttrBag, this.getKey(), !_weakCrypto);
    }

    public IUserMappingData getUserMappingData(String sysid, IPrincipal principal, Map sysAttrBag, long lFlags) {
        if (_trace.beInfo()) {
            String msg = MessageFormat.format("Trying to get user mapping data; sysAttrBag = \"{0}\", lFlags = \"{1}\"", sysAttrBag, new Long(lFlags));
            _trace.infoT(M_GET_MAPPING_SIML, UserMapping.getTraceString(msg, principal, sysid));
        }
        return new UserMappingDataImp(sysid, principal, sysAttrBag, this.getKey(), !_weakCrypto);
    }

    public String getR3UserName(IUser user, String alias, Map sysAttrBag, boolean bGenerateId) throws UMException {
        if (_trace.beInfo()) {
            String msg = MessageFormat.format("Trying to get R/3 user name; sysAttrBag = \"{0}\", bGenerateId = \"{1}\"", sysAttrBag, new Boolean(bGenerateId));
            _trace.infoT(M_GET_R3_USER_ISMB, UserMapping.getTraceString(msg, (IPrincipal)user, alias));
        }
        return this.getR3UserName(user, alias, bGenerateId);
    }

    public String getR3UserName(IUser user, String alias, boolean bGenerateId) throws UMException {
        if (_trace.beInfo()) {
            String msg = MessageFormat.format("Trying to get R/3 user name; bGenerateId = \"{0}\"", new Boolean(bGenerateId));
            _trace.infoT(M_GET_R3_USER_ISB, UserMapping.getTraceString(msg, (IPrincipal)user, alias));
        }
        return this.getR3UserName(user, UserMapping.getSystemByAlias(alias), bGenerateId);
    }

    public String getR3UserName(IUser user, ISystemLandscapeObject system, boolean bGenerateId) throws UMException {
        String msg;
        if (_trace.beInfo()) {
            msg = MessageFormat.format("Trying to get R/3 user name; bGenerateId = \"{0}\"", new Boolean(bGenerateId));
            _trace.infoT(M_GET_R3_USER_ISB, UserMapping.getTraceString(msg, (IPrincipal)user, system));
        }
        if (user == null) {
            if (_trace.beWarning()) {
                msg = UserMapping.getTraceString("User object is null", (IPrincipal)user, system);
                _trace.warningT(M_GET_R3_USER_IIB, msg);
            }
            throw new NullPointerException("user is null");
        }
        String mastersystem = UMFactory.getProperties().get("ume.r3.mastersystem", "");
        int r3_uid_mode = UMFactory.getProperties().getNumber("ume.r3.mastersystem.uid.mode", 1);
        String logon_uid = user.getUserAccounts()[0].getLogonUid();
        if (system == null && (mastersystem == null || mastersystem.length() == 0)) {
            String msg2;
            if (_trace.beInfo()) {
                msg2 = UserMapping.getTraceString("System and mastersystem both empty, getR3UserName has nothing to compute.", (IPrincipal)user, system);
                _trace.infoT(M_GET_R3_USER_IIB, msg2);
            }
            switch (r3_uid_mode) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SSOUtils.filterUnallowedR3Users(logon_uid);
                }
                case 2: {
                    _trace.logWarningT("User mapping: Could not determine R/3 user for UME user \"{0}\". Cause: UME is configured to take R/3 user name from a master system, but there is no master system configured.", new Object[]{user.getDisplayName()});
                    if (_trace.beWarning()) {
                        msg2 = UserMapping.getTraceString("Cannot generate user id if no mastersystem in sight...", (IPrincipal)user, system);
                        _trace.warningT(M_GET_R3_USER_IIB, msg2);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("Wrong configuration of UME: ume.r3.mastersystem.uid.mode=" + r3_uid_mode);
        }
        HashMap m = new HashMap();
        String return_value = null;
        String lm = "SAPLOGONTICKET";
        if (system != null) {
            lm = system.getLogonMethod();
        }
        if (lm.equals("SAPLOGONTICKET")) {
            if (mastersystem != null && mastersystem.length() > 0) {
                try {
                    m.clear();
                    ISystemLandscapeObject islo2 = null;
                    islo2 = UserMapping.getSystemByAlias(mastersystem);
                    if (islo2 == null) {
                        throw new UMException("Couldn't get master system");
                    }
                    IUserMappingData iumd2 = this.getUserMappingData(islo2, (IPrincipal)user);
                    iumd2.enrich(m);
                    return_value = (String)m.get(USER);
                }
                catch (NoLogonDataAvailableException e) {
                    return_value = null;
                }
            }
            switch (r3_uid_mode) {
                case 0: {
                    return SSOUtils.filterUnallowedR3Users(return_value);
                }
                case 1: {
                    if (return_value == null) {
                        return_value = logon_uid;
                    }
                    return SSOUtils.filterUnallowedR3Users(return_value);
                }
                case 2: {
                    if (!bGenerateId) {
                        return null;
                    }
                    throw new UnsupportedOperationException("Cannot generate R/3 user id");
                }
            }
            throw new IllegalStateException("Wrong parameter: ume.r3.mastersystem.uid.mode = " + r3_uid_mode);
        }
        if ("UIDPW".equals(lm)) {
            Throwable exception = null;
            try {
                IUserMappingData iumd = this.getUserMappingData(system, (IPrincipal)user);
                iumd.enrich(m);
            }
            catch (NoLogonDataAvailableException e) {
                exception = e;
            }
            catch (UserMappingNotAvailableException e) {
                exception = e;
                String msg3 = DUMMY_MSG;
                if (_trace.beWarning()) {
                    msg3 = UserMapping.getTraceString("Can't determine R/3 user ID because  UserMapping is not available.", (IPrincipal)user, system);
                }
                _trace.warningT(M_GET_R3_USER_ISB, msg3, e);
            }
            if (exception == null && m.get(USER) != null) {
                return SSOUtils.filterUnallowedR3Users((String)m.get(USER));
            }
            return null;
        }
        if (_trace.beWarning()) {
            String msg4 = MessageFormat.format("Invalid logon method defined for system: \"{0}\"", lm);
            _trace.warningT(M_GET_R3_USER_IIB, UserMapping.getTraceString(msg4, (IPrincipal)user, system));
        }
        return null;
    }

    public String getInverseMappingData(String sysid, String userid, byte system_type) throws NoLogonDataAvailableException, UMException {
        if (_trace.beInfo()) {
            String msg = UserMapping.getTraceString(MessageFormat.format("Trying to get inverse user mapping data; ABAP user = \"{0}\"; system type = \"{1}\"", userid, new Byte(system_type)), null, sysid);
            _trace.infoT(M_GET_INV_MAPPING_SSB, msg);
        }
        switch (system_type) {
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + system_type);
            }
        }
        if (userid == null || sysid == null) {
            throw new NullPointerException("either userid or sysid is null");
        }
        return this.getInverseMappingData(userid, UserMapping.getSystemByAlias(sysid));
    }

    public String getInverseMappingData(String mappedUser, ISystemLandscapeObject system) throws NoLogonDataAvailableException, UMException {
        String msg;
        IUser user;
        int mode;
        String msg2;
        if (_trace.beInfo()) {
            msg2 = MessageFormat.format("Trying to get inverse user mapping data; ABAP user = \"{0}\"", mappedUser);
            _trace.infoT(M_GET_INV_MAPPING_SI, UserMapping.getTraceString(msg2, null, system));
        }
        if (mappedUser == null || mappedUser.equals("")) {
            if (_trace.beWarning()) {
                msg2 = UserMapping.getTraceString("Backend user is empty, can't determine mapped UME user.", null, system);
                _trace.warningT(M_GET_INV_MAPPING_SI, msg2);
            }
            throw new NoLogonDataAvailableException("No backend user ID provided for inverse user mapping!");
        }
        String mastersystem = UMFactory.getProperties().get("ume.r3.mastersystem");
        if (system == null && mastersystem != null && mastersystem.length() > 0) {
            system = UserMapping.getSystemByAlias(mastersystem);
        }
        boolean MODE_NOTHING = false;
        boolean MODE_INTERNAL = true;
        int MODE_ATTRIBUTE = 2;
        boolean refSysMappingViaAttribute = UMAP_REF_SYS_MAPPING_TYPE_ATTRIBUTE.equals(UMFactory.getProperties().get(UMAP_REF_SYS_MAPPING_TYPE));
        if (system == null) {
            mode = refSysMappingViaAttribute ? 2 : 0;
        } else {
            String systemAlias = system.getAlias();
            mode = refSysMappingViaAttribute && systemAlias != null && systemAlias.equals(mastersystem) ? 2 : 1;
        }
        String localUser = null;
        IUserFactory ufac = UMFactory.getUserFactory();
        if (mode != 0) {
            IUserSearchFilter iusf = ufac.getUserSearchFilter();
            switch (mode) {
                case 1: {
                    if (_trace.beInfo()) {
                        _trace.infoT(M_GET_INV_MAPPING_SI, UserMapping.getTraceString("User mapping persistence type: internal/proprietary", null, system));
                    }
                    String system_type_prefix = system.getStorageKeyPrefix();
                    iusf.setSearchAttribute("$inverse_usermapping$", system_type_prefix + ":" + system.getUniqueKey(), mappedUser, 0, false);
                    break;
                }
                case 2: {
                    _trace.infoT(M_GET_INV_MAPPING_SI, UserMapping.getTraceString("User mapping persistence type: user attribute", null, system));
                    iusf.setSearchAttribute("$usermapping$", "REFERENCE_SYSTEM_USER", mappedUser, 0, false);
                    break;
                }
                default: {
                    if (!_trace.beError()) break;
                    String msg3 = UserMapping.getTraceString("Unknown working mode detected: " + mode, null, system);
                    _trace.errorT(M_GET_INV_MAPPING_SI, msg3);
                }
            }
            ISearchResult isr = ufac.searchUsers(iusf);
            if (isr != null && isr.size() != 0) {
                if (isr.size() == 1) {
                    localUser = (String)isr.next();
                } else if (isr.size() > 1) {
                    String[] usernames = new String[isr.size()];
                    int ii = 0;
                    while (isr.hasNext()) {
                        usernames[ii++] = (String)isr.next();
                    }
                    if (_trace.beInfo()) {
                        String msg4 = MessageFormat.format("Search not successful, more than one user found: '{ {0} '} ", new Object[]{usernames});
                        _trace.infoT(M_GET_INV_MAPPING_SI, UserMapping.getTraceString(msg4, null, system));
                    }
                    throw new MultipleHitException("Too much hits found", usernames);
                }
            }
        }
        if (localUser == null && (system == null || "SAPLOGONTICKET".equals(system.getLogonMethod())) && 1 == UMFactory.getProperties().getNumber("ume.r3.mastersystem.uid.mode", 1) && (user = ufac.getUserByLogonID(mappedUser)) != null) {
            localUser = user.getUniqueID();
        }
        if (localUser == null) {
            if (_trace.beInfo()) {
                msg = UserMapping.getTraceString(MessageFormat.format("No inverse user mapping found for mapped user \"{0}\".", mappedUser), null, system);
                _trace.infoT(M_GET_INV_MAPPING_SI, msg);
            }
            return null;
        }
        if (_trace.beInfo()) {
            msg = MessageFormat.format("Found local user \"{0}\" being mapped to given backend user \"{1}\".", localUser, mappedUser);
            _trace.infoT(M_GET_INV_MAPPING_SI, UserMapping.getTraceString(msg, null, system));
        }
        return localUser;
    }

    public Map getInverseMappingData(String[] mappedUsers, ISystemLandscapeObject system) throws NoLogonDataAvailableException, UMException {
        HashSet<String> set_mapped_users = new HashSet<String>();
        HashMap<String, IUser> m = null;
        if (mappedUsers == null) {
            throw new NullPointerException("mappedUsers must not be null.");
        }
        int i = 0;
        while (i < mappedUsers.length) {
            set_mapped_users.add(mappedUsers[i]);
            ++i;
        }
        if (system == null) {
            String mastersystem = UMFactory.getProperties().get("ume.r3.mastersystem");
            if (mastersystem == null) {
                if (_trace.beWarning()) {
                    _trace.warningT(M_GET_INV_MAPPING_SAI, "system parameter null and no mastersystem maintained.");
                }
                return null;
            }
            system = UserMapping.getSystemByAlias(mastersystem);
            if (system == null) {
                if (_trace.beWarning()) {
                    _trace.warningT(M_GET_INV_MAPPING_SAI, "The value {0} of UME parameter {1} isn't alias of an existing system.", new Object[]{mastersystem, "ume.r3.mastersystem"});
                }
                return null;
            }
        }
        IUserFactory ufac = UMFactory.getUserFactory();
        IUserSearchFilter iusf = ufac.getUserSearchFilter();
        iusf.setSearchMethod(1);
        int i2 = 0;
        while (i2 < mappedUsers.length) {
            iusf.setSearchAttribute("$inverse_usermapping$", system.getStorageKeyPrefix() + ":" + system.getUniqueKey(), mappedUsers[i2].trim(), 0, false);
            ++i2;
        }
        ISearchResult isr = ufac.searchUsers(iusf);
        IUserMapping umap = UMFactory.getUserMapping();
        m = new HashMap<String, IUser>();
        while (isr.hasNext()) {
            String uid = (String)isr.next();
            String key_in_result_map = null;
            IUser user = ufac.getUser(uid);
            IUserMappingData iumd = umap.getUserMappingData(system, (IPrincipal)user);
            HashMap n = new HashMap();
            iumd.enrich(n);
            String muser = (String)n.get(USER);
            boolean bFound_user_in_input_map = set_mapped_users.contains(muser);
            if (!bFound_user_in_input_map) {
                if (muser.length() == 0) {
                    if (_trace.beError()) {
                        _trace.errorT(M_GET_INV_MAPPING_SAI, "User {0} mapped to empty string for system {1}.", new Object[]{user.getUniqueID(), system.getAlias()});
                    }
                } else if (Character.isLowerCase(muser.charAt(0))) {
                    bFound_user_in_input_map = set_mapped_users.contains(muser.toUpperCase());
                    if (bFound_user_in_input_map) {
                        key_in_result_map = muser.toUpperCase();
                    }
                } else if (Character.isUpperCase(muser.charAt(0)) && (bFound_user_in_input_map = set_mapped_users.contains(muser.toLowerCase()))) {
                    key_in_result_map = muser.toLowerCase();
                }
                if (!bFound_user_in_input_map) {
                    if (!_trace.beWarning()) continue;
                    _trace.warningT(M_GET_INV_MAPPING_SAI, "Inconsistency found! User {0} mapped to {1} for system {2} but {1} not in input array.", new Object[]{user.getUniqueID(), muser, system.getAlias()});
                    continue;
                }
                m.put(key_in_result_map, user);
                continue;
            }
            set_mapped_users.remove(muser);
        }
        if (1 == UMFactory.getProperties().getNumber("ume.r3.mastersystem.uid.mode", 1)) {
            IUserAccountFactory uaccfac = UMFactory.getUserAccountFactory();
            IUserAccountSearchFilter iuasf = uaccfac.getUserAccountSearchFilter();
            iuasf.setSearchMethod(1);
            Iterator it = set_mapped_users.iterator();
            while (it.hasNext()) {
                iuasf.setSearchAttribute("com.sap.security.core.usermanagement", "j_user", (String)it.next(), 0, false);
            }
            isr = uaccfac.search(iuasf);
            while (isr.hasNext()) {
                String uid = (String)isr.next();
                IUserAccount uacc = uaccfac.getUserAccount(uid);
                m.put(uacc.getLogonUid(), uacc.getAssignedUser());
            }
        }
        return m;
    }

    private static ISystemLandscapeWrapper getLandscape() {
        ArrayList al = UMFactory.getSystemLandscapeWrappers();
        if (al == null || al.size() == 0) {
            _trace.logErrorT("User mapping: Could not retrieve information from System Landscape Directory", null);
            if (_trace.beError()) {
                String msg = UserMapping.getTraceString("No landscape wrapper registered. Returning null.", null, (String)null);
                _trace.errorT(M_GET_LANDSCAPE, msg);
            }
            return null;
        }
        return (ISystemLandscapeWrapper)al.get(0);
    }

    static ISystemLandscapeObject getSystemByAlias(String alias) {
        if (alias == null || alias.length() == 0) {
            if (_trace.beWarning()) {
                String msg = UserMapping.getTraceString("Could not get system by alias because alias is empty", null, alias);
                _trace.warningT(M_GET_SYSTEM_BY_ALIAS, msg);
            }
            return null;
        }
        if (_islw == null && (_islw = UserMapping.getLandscape()) == null) {
            return null;
        }
        ISystemLandscapeObject islo = null;
        try {
            islo = _islw.getSystemByAlias(alias);
            return islo;
        }
        catch (ExceptionInImplementationException e) {
            _trace.logWarningT("User mapping: Could not retrieve information aboutsystem with alias \"{0}\" from System Landscape Directory.", new Object[]{alias});
            String msg = DUMMY_MSG;
            if (_trace.beWarning()) {
                msg = UserMapping.getTraceString("Could not get system object by alias.", null, alias);
            }
            _trace.warningT(M_GET_SYSTEM_BY_ALIAS, msg, e);
            return null;
        }
    }

    static String getTraceString(String message, IPrincipal principal, ISystemLandscapeObject system) {
        return UserMapping.getTraceString(message, principal, system != null ? system.getAlias() : null);
    }

    static String getTraceString(String message, IPrincipal principal, String system) {
        String principalType = UNKNOWN;
        String principalString = UNKNOWN;
        if (principal != null) {
            principalString = MessageFormat.format("{0} (ID: {1})", principal.getDisplayName(), principal.getUniqueID());
            if (principal instanceof IUser) {
                principalType = USER;
            } else if (principal instanceof IGroup) {
                principalType = GROUP;
            } else if (principal instanceof IRole) {
                principalType = ROLE;
            }
        }
        return MessageFormat.format("UserMapping: {0}\nContext:\nprincipal = {1}\nprincipal''s type: {2}\nsystem alias = {3}\n", message, principalString, principalType, system);
    }
}

