/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.umap.imp;

import com.sap.security.api.UMException;
import com.sap.security.core.umap.imp.AbstractEncryptedFieldBlob;
import com.sap.security.core.vault.SecretKeyGenerator;
import com.sap.security.core.vault.StringEncryptor;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTCTime;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedFieldBlob
extends AbstractEncryptedFieldBlob
implements ASN1Type {
    private static final String M_ENCR_FIELD_BLOB = "EncryptedFieldBlob.EncryptedFieldBlob(byte[], String, boolean)";
    private static final String M_DECODE = "EncryptedFieldBlob.decode(ASN1Object)";
    protected SecretKey _rndKey;
    protected byte[] _encrRndKey;
    protected byte[] _certifiedAttrs;

    public EncryptedFieldBlob(byte[] blobData, String plausiValue, boolean mode) {
        super(blobData, plausiValue, mode);
        if (!mode) {
            this._rndKey = null;
        } else {
            try {
                this._rndKey = SecretKeyGenerator.createRandom();
            }
            catch (NoSuchAlgorithmException e) {
                if (AbstractEncryptedFieldBlob._trace.beError()) {
                    AbstractEncryptedFieldBlob._trace.errorT(M_ENCR_FIELD_BLOB, "Could not generate key to encrypt user mapping information because security provider is not installed.");
                }
                AbstractEncryptedFieldBlob._trace.logErrorT("A user mapping could not be saved because the Java security provider library is missing.", null);
                throw new RuntimeException("Security provider not installed!");
            }
        }
        this._encrRndKey = null;
        this._certifiedAttrs = null;
    }

    public ASN1Object toASN1Object() {
        if (this._encrRndKey == null || this._certifiedAttrs == null) {
            throw new IllegalStateException("Object not properly created.");
        }
        SEQUENCE seq = new SEQUENCE();
        OCTET_STRING rndKey = new OCTET_STRING(this._encrRndKey);
        OCTET_STRING encVal = new OCTET_STRING(this._certifiedAttrs);
        seq.addComponent((ASN1Object)rndKey);
        seq.addComponent((ASN1Object)encVal);
        return seq;
    }

    byte[] encrypt(SecretKey masterKey) throws GeneralSecurityException {
        String algo = System.getProperties().getProperty("ume.umap.encryption.algo", "3DES/CBC/PKCS5Padding");
        StringEncryptor se = new StringEncryptor(algo, masterKey);
        this._encrRndKey = se.encryptRaw(this._rndKey.getEncoded());
        this._rndKey = new SecretKeySpec(se.decryptRaw(this._encrRndKey), System.getProperties().getProperty("ume.umap.encryption.keytype", "3DES"));
        se = new StringEncryptor(algo, this._rndKey);
        UTCTime time = new UTCTime(EncryptedFieldBlob.utcStringFromCalendar(this._lastEncryptionDate));
        INTEGER flags = new INTEGER(this._flags);
        OCTET_STRING encV = new OCTET_STRING(this._credentialsValue);
        PrintableString pstr = new PrintableString(this._plausibilityValue);
        SEQUENCE unencrCertAttrs = new SEQUENCE();
        unencrCertAttrs.addComponent((ASN1Object)time);
        unencrCertAttrs.addComponent((ASN1Object)flags);
        unencrCertAttrs.addComponent((ASN1Object)pstr);
        unencrCertAttrs.addComponent((ASN1Object)encV);
        this._certifiedAttrs = se.encryptRaw(DerCoder.encode((ASN1Object)unencrCertAttrs));
        this._encryptedData = DerCoder.encode((ASN1Object)this.toASN1Object());
        return this._encryptedData;
    }

    void decrypt(SecretKey masterKey) throws GeneralSecurityException, UMException {
        SEQUENCE seq;
        try {
            ASN1Object asn1Data = DerCoder.decode((byte[])this._encryptedData);
            this.decode(asn1Data);
            StringEncryptor se = new StringEncryptor(System.getProperties().getProperty("ume.umap.encryption.algo", "3DES/CBC/PKCS5Padding"), masterKey);
            this._rndKey = new SecretKeySpec(se.decryptRaw(this._encrRndKey), System.getProperties().getProperty("ume.umap.encryption.keytype", "3DES"));
            se = new StringEncryptor(System.getProperties().getProperty("ume.umap.encryption.algo", "3DES/CBC/PKCS5Padding"), this._rndKey);
            seq = (SEQUENCE)DerCoder.decode((byte[])se.decryptRaw(this._certifiedAttrs));
        }
        catch (CodingException e) {
            throw new UMException((Throwable)e);
        }
        UTCTime time = (UTCTime)seq.getComponentAt(0);
        INTEGER flags = (INTEGER)seq.getComponentAt(1);
        String plausiVal = (String)((PrintableString)seq.getComponentAt(2)).getValue();
        OCTET_STRING os = (OCTET_STRING)seq.getComponentAt(3);
        this._credentialsValue = (byte[])os.getValue();
        this._flags = ((BigInteger)flags.getValue()).intValue();
        this._lastEncryptionDate = EncryptedFieldBlob.utcStringToCalendar((String)time.getValue());
        this.checkPlausibilityValue(plausiVal);
    }

    public void decode(ASN1Object asn1) throws IllegalArgumentException {
        try {
            SEQUENCE seq = (SEQUENCE)asn1;
            OCTET_STRING rndKey = null;
            OCTET_STRING cAttrs = null;
            rndKey = (OCTET_STRING)seq.getComponentAt(0);
            cAttrs = (OCTET_STRING)seq.getComponentAt(1);
            this._encrRndKey = (byte[])rndKey.getValue();
            this._certifiedAttrs = (byte[])cAttrs.getValue();
        }
        catch (ClassCastException cce) {
            if (AbstractEncryptedFieldBlob._trace.beWarning()) {
                AbstractEncryptedFieldBlob._trace.warningT(M_DECODE, "Value is not a EncryptedFieldBlob");
            }
            throw new IllegalArgumentException("Value is not a EncryptedFieldBlob");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (AbstractEncryptedFieldBlob._trace.beWarning()) {
                AbstractEncryptedFieldBlob._trace.warningT(M_DECODE, "Value is not a EncryptedFieldBlob");
            }
            throw new IllegalArgumentException("Value is not a EncryptedFieldBlob");
        }
    }

    private static String utcStringFromCalendar(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumIntegerDigits(2);
        StringBuffer s = new StringBuffer("");
        s.append(nf.format(year %= 100));
        s.append(nf.format(month));
        s.append(nf.format(day));
        s.append(nf.format(hour));
        s.append(nf.format(minute));
        s.append(nf.format(second));
        s.append("Z");
        return s.toString();
    }

    private static Calendar utcStringToCalendar(String utcString) {
        try {
            int year = 2000 + Integer.parseInt(utcString.substring(0, 2));
            int month = -1 + Integer.parseInt(utcString.substring(2, 4));
            int day = Integer.parseInt(utcString.substring(4, 6));
            int hour = Integer.parseInt(utcString.substring(6, 8));
            int minute = Integer.parseInt(utcString.substring(8, 10));
            int second = Integer.parseInt(utcString.substring(10, 12));
            Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            return cal;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal string " + utcString + " provided");
        }
    }
}

