/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.umap.imp;

import com.sap.security.api.UMException;
import com.sap.security.core.umap.imp.AbstractEncryptedFieldBlob;
import com.sap.security.core.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import javax.crypto.SecretKey;

public class Base64EncodedFieldBlob
extends AbstractEncryptedFieldBlob {
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final byte BS_LEN_DATE = 8;
    public static final byte BS_LEN_FLAGS = 4;
    public static final byte BS_LEN_FIELD_LEN = 1;

    public Base64EncodedFieldBlob(byte[] blobData, String plausiValue, boolean mode) {
        super(blobData, plausiValue, mode);
    }

    byte[] toByteArray() {
        return this._encryptedData;
    }

    byte[] encrypt(SecretKey masterKey) throws GeneralSecurityException {
        byte[] plausibilityValueBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(this._lastEncryptionDate.getTime().getTime());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Could not serialize usermapping data." + e);
        }
        byte[] lastEncryptionDateBytes = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this._flags);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Could not serialize usermapping data." + e);
        }
        byte[] flagsBytes = baos.toByteArray();
        try {
            plausibilityValueBytes = this._plausibilityValue.getBytes(CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException("Could not serialize usermapping data." + e);
        }
        if (plausibilityValueBytes.length > 127) {
            throw new GeneralSecurityException("Plausibility value is too long. Maximum length is 127 characters.");
        }
        if (this._credentialsValue.length > 127) {
            throw new GeneralSecurityException("Credentials value is too long. Maximum length is 127 characters.");
        }
        byte plausibilityValueLength = (byte)plausibilityValueBytes.length;
        byte credentialsValueLength = (byte)this._credentialsValue.length;
        byte[] umapData = new byte[13 + plausibilityValueLength + 1 + credentialsValueLength];
        int destPosition = 0;
        System.arraycopy(lastEncryptionDateBytes, 0, umapData, destPosition, 8);
        System.arraycopy(flagsBytes, 0, umapData, destPosition += 8, 4);
        destPosition += 4;
        umapData[destPosition++] = plausibilityValueLength;
        System.arraycopy(plausibilityValueBytes, 0, umapData, destPosition, plausibilityValueLength);
        destPosition += plausibilityValueLength;
        umapData[destPosition++] = credentialsValueLength;
        System.arraycopy(this._credentialsValue, 0, umapData, destPosition, credentialsValueLength);
        try {
            this._encryptedData = Base64.encode(umapData).getBytes(CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException("Could not serialize usermapping data." + e);
        }
        return this._encryptedData;
    }

    void decrypt(SecretKey masterKey) throws GeneralSecurityException, UMException {
        String plausiValueRead;
        byte[] umapData;
        try {
            umapData = Base64.decode(new String(this._encryptedData, CHARACTER_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException("Could not deserialize usermapping data." + e);
        }
        byte[] lastEncryptionDateBytes = new byte[8];
        byte[] flagsBytes = new byte[4];
        int srcPosition = 0;
        System.arraycopy(umapData, srcPosition, lastEncryptionDateBytes, 0, 8);
        System.arraycopy(umapData, srcPosition += 8, flagsBytes, 0, 4);
        srcPosition += 4;
        byte plausibilityValueLength = umapData[srcPosition++];
        byte[] plausibilityValueBytes = new byte[plausibilityValueLength];
        System.arraycopy(umapData, srcPosition, plausibilityValueBytes, 0, plausibilityValueLength);
        srcPosition += plausibilityValueLength;
        byte credentialsValueLength = umapData[srcPosition++];
        this._credentialsValue = new byte[credentialsValueLength];
        System.arraycopy(umapData, srcPosition, this._credentialsValue, 0, credentialsValueLength);
        ByteArrayInputStream bais = new ByteArrayInputStream(lastEncryptionDateBytes);
        DataInputStream dis = new DataInputStream(bais);
        this._lastEncryptionDate = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        try {
            this._lastEncryptionDate.setTime(new Date(dis.readLong()));
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Could not deserialize usermapping data." + e);
        }
        bais = new ByteArrayInputStream(flagsBytes);
        dis = new DataInputStream(bais);
        try {
            this._flags = dis.readInt();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Could not deserialize usermapping data." + e);
        }
        try {
            plausiValueRead = new String(plausibilityValueBytes, CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException("Could not deserialize usermapping data." + e);
        }
        this.checkPlausibilityValue(plausiValueRead);
    }
}

