/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.umap.imp;

import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import javax.crypto.SecretKey;

abstract class AbstractEncryptedFieldBlob {
    public static final boolean MODE_ENCRYPT = true;
    public static final boolean MODE_DECRYPT = false;
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/umap/imp/AbstractEncryptedFieldBlob.java#2 $File$ $ from $DateTime: 2004/03/26 16:25:58 $DateTime$ $ ($Change: 15163 $Change$ $)";
    private static final String M_CHECK_PLAUSI_VAL = "AbstractEncryptedFieldBlob.checkPlausibilityValue(String)";
    protected static IUMTrace _trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/umap/imp/AbstractEncryptedFieldBlob.java#2 $File$ $ from $DateTime: 2004/03/26 16:25:58 $DateTime$ $ ($Change: 15163 $Change$ $)");
    protected static byte REFERENCE_SYSTEM_FLAG = 0;
    protected byte[] _encryptedData;
    protected byte[] _credentialsValue;
    protected Calendar _lastEncryptionDate;
    protected int _flags;
    protected String _plausibilityValue;

    AbstractEncryptedFieldBlob(byte[] blobData, String plausiValue, boolean mode) {
        if (!mode) {
            this._encryptedData = blobData;
            this._credentialsValue = null;
            this._lastEncryptionDate = null;
        } else {
            this._encryptedData = null;
            this._credentialsValue = blobData;
            this._lastEncryptionDate = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        }
        this._flags = 0;
        this._plausibilityValue = plausiValue == null || plausiValue.length() == 0 ? " " : plausiValue;
    }

    abstract byte[] encrypt(SecretKey var1) throws GeneralSecurityException;

    abstract void decrypt(SecretKey var1) throws GeneralSecurityException, UMException;

    byte[] getCredentialsValue() {
        return this._credentialsValue;
    }

    boolean getFlag(byte v) {
        return 0 != (this._flags & 1 << v);
    }

    void setFlag(byte v, boolean value) {
        this._flags = value ? (this._flags |= 1 << v) : (this._flags &= ~(1 << v));
    }

    Calendar getLastEncryptionDate() {
        return this._lastEncryptionDate;
    }

    protected void checkPlausibilityValue(String plausiVal) throws GeneralSecurityException {
        if (!this._plausibilityValue.equals(" ") && !plausiVal.equals(this._plausibilityValue)) {
            if (_trace.beWarning()) {
                _trace.warningT(M_CHECK_PLAUSI_VAL, "Plausibility check in EncryptedFieldBlob failed");
            }
            throw new GeneralSecurityException("Plausibility check in EncryptedFieldBlob failed");
        }
    }
}

