/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ticket.imp;

import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.ticket.TicketExpiredException;
import com.sap.security.api.ticket.TicketVerifier;
import com.sap.security.api.ticket.TicketVerifyException;
import com.sap.security.api.ticket.WrongTicketModeException;
import com.sap.security.core.ticket.imp.InvalidSignParameterException;
import com.sap.security.core.util.Base64;
import com.sap.tc.logging.Location;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.Vector;

public class Ticket
extends TicketVerifier {
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$ticket$imp$Ticket == null ? (class$com$sap$security$core$ticket$imp$Ticket = Ticket.class$("com.sap.security.core.ticket.imp.Ticket")) : class$com$sap$security$core$ticket$imp$Ticket));
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/ticket/imp/Ticket.java#6 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    public boolean debug = false;
    private int version;
    private String codepage = "";
    private String encoding = null;
    private String mTicket = null;
    private String keystoreFilename;
    private String keypairAlias;
    private char[] keystorePass;
    private int keystoreType;
    private boolean isTicketValidChecked = false;
    protected int mMode;
    private String user = "";
    private String sysID = "";
    private String sysClient = "";
    private String createTime = "000000000000";
    private int validTime = 0;
    private int validTimeMin = 0;
    private PrivateKey sKey;
    private X509Certificate mCert;
    protected Calendar startTime;
    protected Calendar endTime;
    protected byte[] derSignature = null;
    protected byte[] tbsData = null;
    protected Vector infoUnits = new Vector();
    private X509Certificate[] trustedCerts = null;
    protected X509Certificate signerCert = null;
    protected boolean includeOwnCert = false;
    protected boolean useNative = false;
    public static HashMap codepageEncoding;
    public static int MODE_UNDEFINED;
    public static int MODE_VERIFY;
    public static int MODE_CREATE;
    public static int MODE_CREATED;
    private static Method nativeSigner;
    private static boolean bNoNativeSigner;
    static /* synthetic */ Class class$com$sap$security$core$ticket$imp$Ticket;

    public Ticket() {
        this.mMode = MODE_UNDEFINED;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (nativeSigner == null && !bNoNativeSigner) {
                try {
                    byte[] pils = new byte[]{};
                    Class<?> clazz2 = Class.forName("com.sap.security.ticket.JNIUtils", true, ((Object)((Object)this)).getClass().getClassLoader());
                    nativeSigner = clazz2.getMethod("dsaNativeSign", pils.getClass(), Class.forName("java.security.PrivateKey"), Class.forName("java.security.PublicKey"));
                }
                catch (Throwable e) {
                    bNoNativeSigner = true;
                }
                nativeSigner = null;
            }
        }
    }

    public String getCodepage() {
        return this.encoding;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void useNative(boolean b) {
        this.useNative = b;
    }

    public void setTicket(String base64string) throws TicketException {
        byte[] data = base64string.getBytes();
        this.mTicket = base64string;
        this.setTicket(Base64.decode(base64string));
        this.mMode = MODE_VERIFY;
    }

    public void setTicket(byte[] ticket) throws TicketException {
        this.setTicket(new ByteArrayInputStream(ticket));
        this.mMode = MODE_VERIFY;
    }

    public void setIncludeOwnCert(boolean b) {
        this.includeOwnCert = b;
    }

    public void setTicket(InputStream in) throws TicketException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.infoUnits.clear();
        try {
            this.version = in.read();
            out.write(this.version);
            byte[] rawCodePage = InfoUnit.readRaw((InputStream)in, (int)4);
            this.codepage = InfoUnit.bytesToString((byte[])rawCodePage, null);
            out.write(rawCodePage);
            if (!codepageEncoding.containsKey(this.codepage)) {
                throw new TicketException("Unsupported codepage " + this.codepage + " in ticket.");
            }
            this.encoding = (String)codepageEncoding.get(this.codepage);
            InfoUnit unit = InfoUnit.readInfoUnit((InputStream)in);
            while (unit != null) {
                if (unit.getID() == 255) {
                    this.derSignature = unit.getContent();
                } else {
                    unit.writeTo((OutputStream)out);
                    switch (unit.getID()) {
                        case 1: {
                            this.user = unit.getString(this.encoding);
                            break;
                        }
                        case 3: {
                            this.sysID = unit.getString(this.encoding);
                            break;
                        }
                        case 2: {
                            this.sysClient = unit.getString(this.encoding);
                            break;
                        }
                        case 4: {
                            this.createTime = unit.getString(this.encoding);
                            break;
                        }
                        case 5: {
                            this.validTime = unit.getInt();
                            break;
                        }
                        case 7: {
                            this.validTimeMin = unit.getInt();
                            break;
                        }
                    }
                }
                this.infoUnits.addElement(unit);
                unit = InfoUnit.readInfoUnit((InputStream)in);
            }
            out.close();
            this.tbsData = out.toByteArray();
        }
        catch (Exception e) {
            throw new TicketException("" + e);
        }
        if (this.createTime.length() < 12) {
            throw new TicketException("Creation Time not set in Ticket (" + this.createTime + ")!");
        }
        int year = Integer.parseInt(this.createTime.substring(0, 4));
        int month = Integer.parseInt(this.createTime.substring(4, 6));
        int day = Integer.parseInt(this.createTime.substring(6, 8));
        int hour = Integer.parseInt(this.createTime.substring(8, 10));
        int min = Integer.parseInt(this.createTime.substring(10, 12));
        int sec = 0;
        this.startTime = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        this.startTime.set(year, month - 1, day, hour, min, sec);
        this.endTime = (Calendar)this.startTime.clone();
        this.endTime.add(10, this.validTime);
        this.endTime.add(12, this.validTimeMin);
        this.state = 1;
        this.mMode = MODE_VERIFY;
        if (this.debug) {
            System.out.println(this.toString());
        }
    }

    public String getUser() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.user;
    }

    public String getUser(String application) throws TicketException, UnsupportedEncodingException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        Enumeration e = this.infoUnits.elements();
        InfoUnit iu = null;
        while (e.hasMoreElements()) {
            String s;
            iu = (InfoUnit)e.nextElement();
            int id = iu.getID();
            if (id < 32 || id >= 64 || !(s = iu.getString("UTF8")).startsWith(application + ":")) continue;
            return s.substring(s.indexOf(58) + 1);
        }
        return null;
    }

    public String getSystemID() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.sysID;
    }

    public String getSystemClient() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.sysClient;
    }

    public InfoUnit getInfoUnit(int id) throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        Iterator i = ((AbstractList)this.infoUnits).iterator();
        while (i.hasNext()) {
            InfoUnit unit = (InfoUnit)i.next();
            if (unit.getID() != id) continue;
            return unit;
        }
        return null;
    }

    public Enumeration getInfoUnits() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.isEnforceVerify() && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.infoUnits.elements();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Ticket ");
        if (this.state == 0) {
            s.append("[not initialized]\n");
        } else {
            if (this.state == 2) {
                s.append("[verified]\n");
            } else {
                s.append("[initialized]\n");
            }
            s.append("  Ticket Version  = " + this.version + "\n");
            s.append("  Ticket Codepage = " + this.codepage + " (Encoding=" + this.encoding + ")\n");
            s.append("  User = " + this.user + "\n");
            s.append("  Issuing System ID     = " + this.sysID + "\n");
            s.append("  Issuing System Client = " + this.sysClient + "\n");
            s.append("  Creation Time = " + this.createTime + "\n");
            s.append("  Valid Time    = " + this.validTime + " h " + this.validTimeMin + " min\n");
            if (this.startTime != null && this.endTime != null) {
                s.append("  Valid from   " + this.startTime.getTime() + "   until   " + this.endTime.getTime() + "\n");
            }
            s.append("  Signature (length=" + this.derSignature.length + " bytes)\n");
            Iterator i = ((AbstractList)this.infoUnits).iterator();
            while (i.hasNext()) {
                InfoUnit unit = (InfoUnit)i.next();
                s.append("  InfoUnit " + unit.getID() + ", length=" + unit.getContent().length + "\n");
            }
        }
        return s.toString();
    }

    public static Ticket readTicket(InputStream in) throws Exception {
        Ticket ticket = new Ticket();
        ticket.setTicket(in);
        return ticket;
    }

    public void setCertificates(java.security.cert.X509Certificate[] certs) {
        this.trustedCerts = new X509Certificate[certs.length];
        int i = 0;
        while (i < certs.length) {
            if (certs[i] instanceof X509Certificate) {
                this.trustedCerts[i] = (X509Certificate)certs[i];
            } else {
                try {
                    this.trustedCerts[i] = new X509Certificate(certs[i].getEncoded());
                }
                catch (GeneralSecurityException gse) {
                    myLoc.traceThrowableT(500, "setCertificates", "Certificate {0} couldn't be encoded", new Object[]{certs[i].getSubjectDN().toString()}, (Throwable)gse);
                }
            }
            ++i;
        }
    }

    public void setCertificates(String keyStoreName, char[] pass) throws Exception {
        FileInputStream in = new FileInputStream(keyStoreName);
        KeyStore ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        ks.load(in, pass);
        this.setCertificates(this.getCertsFromKeyStore(ks));
        ((InputStream)in).close();
    }

    public void setCertificates(String keyStoreName, int keyStoreType, char[] pass) throws Exception {
        FileInputStream in = new FileInputStream(keyStoreName);
        this.setCertificates(in, keyStoreType, pass);
    }

    public void setCertificates(InputStream keyStoreInputStream, int keyStoreType, char[] pass) throws Exception {
        KeyStore ks = null;
        if (keyStoreType == 0) {
            ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        } else if (keyStoreType == 2) {
            ks = KeyStore.getInstance("JKS", "SUN");
        } else {
            throw new IllegalArgumentException("Unknown keystore type");
        }
        ks.load(keyStoreInputStream, pass);
        this.setCertificates(this.getCertsFromKeyStore(ks));
        keyStoreInputStream.close();
    }

    public X509Certificate getSignerCertificate() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.signerCert;
    }

    public void setPrivateKeyPair(PrivateKey key, X509Certificate cert) {
        this.sKey = key;
        this.mCert = cert;
    }

    public boolean isValid() {
        Calendar now = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        boolean isAlreadyValid = now.after(this.startTime);
        boolean isStillValid = now.before(this.endTime);
        if (myLoc.beWarning()) {
            if (!isAlreadyValid) {
                myLoc.warningT("Ticket not valid until " + this.startTime.getTime());
            }
            if (!isStillValid) {
                myLoc.warningT("Ticket expired on " + this.endTime.getTime());
            }
        }
        if (isAlreadyValid && isStillValid) {
            this.isTicketValidChecked = true;
        }
        return isAlreadyValid && isStillValid;
    }

    public boolean isValid(int tolerance) {
        Calendar now = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        Calendar calcTime = (Calendar)now.clone();
        now.roll(12, -tolerance);
        calcTime.add(12, tolerance);
        boolean isAlreadyValid = calcTime.after(this.startTime);
        boolean isStillValid = now.before(this.endTime);
        if (myLoc.beWarning()) {
            if (!isAlreadyValid) {
                myLoc.warningT("Ticket is not valid until " + this.startTime.getTime());
            }
            if (!isStillValid) {
                myLoc.warningT("Ticket has expired on " + this.endTime.getTime());
            }
        }
        if (isAlreadyValid && isStillValid) {
            this.isTicketValidChecked = true;
        }
        return isAlreadyValid && isStillValid;
    }

    public void verify() throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CodingException, PKCSParsingException, TicketException, Exception {
        int i;
        X509Certificate[] certs;
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        AlgorithmID[] algIDs = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
        SignedData signedData = new SignedData(this.tbsData, algIDs);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.derSignature);
        ContentInfo ci = new ContentInfo((InputStream)bais);
        if (!ci.getContentType().equals((Object)ObjectID.pkcs7_signedData)) {
            throw new SignatureException("SignedData expected as signature (got " + ci.getContentType() + ")");
        }
        try {
            signedData.decode(ci.getContentInputStream());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.debug) {
            System.out.println("\n--- SignedData Object ---\n" + signedData + "\n");
            System.out.println("\n--- Certificates ---\n");
            certs = signedData.getCertificates();
            if (certs != null) {
                int i2 = 0;
                while (i2 < certs.length) {
                    System.out.println(certs[i2]);
                    ++i2;
                }
            }
            System.out.println("\n--- Signers ---\n");
            SignerInfo[] signer = signedData.getSignerInfos();
            if (signer != null) {
                i = 0;
                while (i < signer.length) {
                    System.out.println(signer[i]);
                    ++i;
                }
            }
        }
        certs = signedData.getCertificates();
        SignerInfo[] signers = signedData.getSignerInfos();
        if (signers != null) {
            i = 0;
            while (i < signers.length) {
                this.signerCert = null;
                IssuerAndSerialNumber isn = signers[i].getIssuerAndSerialNumber();
                String encryptAlgoName = signers[i].getDigestEncryptionAlgorithm().getName();
                try {
                    this.signerCert = signedData.getCertificate(isn);
                }
                catch (PKCSException pe) {
                    this.signerCert = TicketVerifier.findCert((X509Certificate[])this.trustedCerts, (Name)isn.getIssuer(), (BigInteger)isn.getSerialNumber());
                }
                if (this.signerCert == null) {
                    throw new SignatureException("Certificate (Issuer=\"" + isn.getIssuer() + "\", S/N=" + isn.getSerialNumber() + ") not found.");
                }
                if (-1 != (encryptAlgoName = encryptAlgoName.toLowerCase()).indexOf("dsa") && -1 != encryptAlgoName.indexOf("sha")) {
                    MessageDigest md = MessageDigest.getInstance(signers[i].getDigestAlgorithm().getName());
                    md.update(this.tbsData);
                    byte[] digest_data = md.digest();
                    Attribute[] attr = signers[i].getAuthenticatedAttributes();
                    SEQUENCE msDigest = (SEQUENCE)attr[2].toASN1Object();
                    OCTET_STRING osDigest = (OCTET_STRING)((SET)msDigest.getComponentAt(1)).getComponentAt(0);
                    if (!CryptoUtils.equalsBlock((byte[])osDigest.getWholeValue(), (byte[])digest_data)) {
                        throw new TicketVerifyException("Ticket signature not ok. Message digest in authenticated attributes doesn't match.");
                    }
                    if (attr != null && attr.length > 0) {
                        SET set = new SET();
                        int j = 0;
                        while (j < attr.length) {
                            if (this.debug) {
                                System.out.print("attr[" + j + "] = " + attr[j]);
                            }
                            set.addComponent(attr[j].toASN1Object());
                            ++j;
                        }
                        digest_data = DerCoder.encode((ASN1Object)set);
                    }
                    md.reset();
                    md.update(digest_data);
                    byte[] digest = md.digest();
                    byte[] encrypt_digest = signers[i].getEncryptedDigest();
                    Signature dsa = Signature.getInstance("RawDSA");
                    dsa.initVerify(this.signerCert.getPublicKey());
                    dsa.update(digest);
                    boolean verify_ok = dsa.verify(encrypt_digest);
                    if (this.debug) {
                        System.out.println("\n>>> DSA-Verify = " + verify_ok + "\n");
                    }
                    if (!verify_ok) {
                        throw new SignatureException("DSA verify of signature failed.");
                    }
                } else {
                    signedData.verify(this.signerCert.getPublicKey(), i);
                }
                if (!TicketVerifier.verifyCertificate((X509Certificate[])this.trustedCerts, (X509Certificate)this.signerCert, (boolean)false)) {
                    throw new SignatureException("Signer-Certificate not trusted.");
                }
                ++i;
            }
        }
        if (!this.isTicketValidChecked) {
            Calendar currentTime = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
            if (currentTime.before(this.startTime)) {
                throw new TicketExpiredException("Ticket not valid until " + this.startTime.getTime());
            }
            if (currentTime.after(this.endTime)) {
                throw new TicketExpiredException("Ticket expired " + this.endTime.getTime());
            }
        }
        this.state = 2;
        if ("GMT".equals("")) {
            throw new CertificateNotYetValidException("");
        }
    }

    public void setInfoUnit(InfoUnit id) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.infoUnits.add(id);
    }

    public void setUser(String strUser) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.user = strUser;
    }

    public void setUserIdent(String strUser) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.user = strUser;
    }

    public void setSystemID(String sysID) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.sysID = sysID;
    }

    public void setSystemClient(String sysClient) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.sysClient = sysClient;
    }

    public void setValidTime(int hours) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.validTime = hours;
    }

    public void setValidTimeMin(int min) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        if (min < 0 || min > 59) {
            throw new TicketException("Invalid argument format. Minutes must be between 0 and 59.");
        }
        this.validTimeMin = min;
    }

    public void setKeystoreType(int type) {
        this.keystoreType = type;
    }

    public void setKeystore(String Filename) throws IOException {
        this.keystoreFilename = Filename;
    }

    public void setKeystorePass(char[] passwd) {
        this.keystorePass = new char[passwd.length];
        System.arraycopy(passwd, 0, this.keystorePass, 0, passwd.length);
    }

    public void setKeyPairAlias(String alias) {
        this.keypairAlias = alias;
    }

    public void create() throws TicketException, UnsupportedEncodingException, IOException {
        String jencoding = null;
        int i = 0;
        int iIuLen = 0;
        byte[] iuLen = new byte[2];
        byte[] InfoUnitContent = null;
        Object it = null;
        InfoUnit infoUnit = null;
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        ByteArrayOutputStream ticketStream = new ByteArrayOutputStream();
        ticketStream.write(2);
        this.encoding = System.getProperty("com.sap.security.ticket.codepage");
        if (null == this.encoding) {
            this.encoding = "1100";
        }
        if (null == (jencoding = (String)codepageEncoding.get(this.encoding))) {
            throw new UnsupportedEncodingException("SAP codepage " + this.encoding + " is unknonwn or not supported.");
        }
        OutputStreamWriter cpwriter = new OutputStreamWriter((OutputStream)ticketStream, "ISO8859_1");
        cpwriter.write(this.encoding);
        cpwriter.flush();
        this.encodeInfoUnits();
        Enumeration e = this.infoUnits.elements();
        Object[] ius = this.infoUnits.toArray();
        i = 0;
        while (i < ius.length) {
            infoUnit = (InfoUnit)ius[i];
            InfoUnitContent = infoUnit.getContent();
            iIuLen = InfoUnitContent.length;
            iuLen[1] = (byte)(iIuLen % 256);
            iuLen[0] = (byte)((iIuLen /= 256) % 256);
            ticketStream.write(infoUnit.getID());
            ticketStream.write(iuLen);
            ticketStream.write(InfoUnitContent);
            ++i;
        }
        ticketStream.flush();
        try {
            this.tbsData = ticketStream.toByteArray();
            this.signTicket();
        }
        catch (InvalidSignParameterException ispe) {
            System.out.println("Ticket signing failed with Exception \"InvalidSignParameterException\".\nThis indicates incorrect parameters that this instance of class Ticket \nhas been initialized with. Please check the following parameters:\nSystem.property \"com.sap.security.ticket.keystore\"=" + System.getProperty("com.sap.security.ticket.keystore"));
            System.out.println("" + (Object)((Object)ispe));
            ((Throwable)((Object)ispe)).printStackTrace();
            throw ispe;
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("One of the algorithms used in the ticket signing facility is not supported\nby the underlying Security Provider.\n");
            System.out.println("" + nsae);
            nsae.printStackTrace();
            throw new TicketException("Signing failed.");
        }
        catch (CertificateException ce) {
            System.out.println("The certificate couldn't be parsed.");
            System.out.println("" + ce);
            ce.printStackTrace();
            throw new TicketException("Certificate parsing error.");
        }
        catch (InvalidKeyException ike) {
            System.out.println("The private key couldn't be parsed.");
            System.out.println("" + ike);
            ike.printStackTrace();
            throw new TicketException("Private key parsing error.");
        }
        catch (NoSuchProviderException nspe) {
            System.out.println("Unknown provider.");
            System.out.println("" + nspe);
            nspe.printStackTrace();
            throw new TicketException("Security provider not configured.");
        }
        catch (CodingException ce) {
            System.out.println("Encoding error.");
            System.out.println("" + (Object)((Object)ce));
            ce.printStackTrace();
            throw new TicketException("Encoding error.");
        }
        catch (PKCSException ce) {
            System.out.println("Encoding error.");
            System.out.println("" + (Object)((Object)ce));
            ce.printStackTrace();
            throw new TicketException("Encoding error.");
        }
        ticketStream.write(255);
        iIuLen = this.derSignature.length;
        iuLen[1] = (byte)(iIuLen % 256);
        iuLen[0] = (byte)((iIuLen /= 256) % 256);
        ticketStream.write(iuLen);
        ticketStream.write(this.derSignature);
        byte[] rawTicket = ticketStream.toByteArray();
        this.mTicket = Base64.encode(rawTicket);
        this.state = MODE_CREATED;
    }

    private char[] getKeyStorePass() {
        String pass = System.getProperty("mysapDefault.keystorepass");
        if (pass == null) {
            pass = "default";
        }
        return pass.toCharArray();
    }

    protected void signTicket() throws InvalidSignParameterException, TicketException, IOException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, NoSuchProviderException, PKCSException, CodingException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        String keystoreIS = null;
        KeyStore keystore = null;
        Object kbPrivKey = null;
        Object cbCert = null;
        IssuerAndSerialNumber ias = null;
        SignerInfo sinfo = null;
        Object algID = null;
        Object strAlgID = null;
        Object KsFile = null;
        Attribute[] authAttribs = null;
        ChoiceOfTime cot = null;
        Object ci = null;
        if (this.mCert == null || this.sKey == null) {
            keystoreIS = this.keystoreFilename;
            if (keystoreIS == null) {
                keystoreIS = "mysapDefault.iks";
            }
            try {
                java.security.cert.X509Certificate sunCert = null;
                if (this.keystoreType == 0) {
                    keystore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
                } else if (this.keystoreType == 2) {
                    keystore = KeyStore.getInstance("JKS", "SUN");
                } else {
                    throw new IllegalStateException("This is not an allowed keystore: " + this.keystoreType);
                }
                keystore.load(new FileInputStream(keystoreIS), this.keystorePass);
                sunCert = (java.security.cert.X509Certificate)keystore.getCertificate(this.keypairAlias);
                if (this.keystoreType == 0) {
                    this.mCert = (X509Certificate)sunCert;
                } else if (this.keystoreType == 2) {
                    this.mCert = new X509Certificate(sunCert.getEncoded());
                }
                this.sKey = (PrivateKey)keystore.getKey(this.keypairAlias, this.keystorePass);
            }
            catch (KeyStoreException kse) {
                System.out.println("Exception text is: " + kse);
                throw new InvalidSignParameterException("" + kse);
            }
            catch (UnrecoverableKeyException uke) {
                System.out.println("Key exception");
                throw new InvalidSignParameterException("" + uke);
            }
        }
        if (this.sKey == null) {
            throw new TicketException("Private key for signing with alias '" + this.keypairAlias + "' couldn't be retrieved from keystore " + keystoreIS + ".");
        }
        if (this.mCert == null) {
            throw new TicketException("certificate for signing with alias '" + this.keypairAlias + "' couldn't be retrieved from keystore " + keystoreIS + ".");
        }
        ias = new IssuerAndSerialNumber((java.security.cert.X509Certificate)this.mCert);
        sinfo = new SignerInfo(ias, AlgorithmID.sha, this.sKey);
        authAttribs = new Attribute[3];
        cot = new ChoiceOfTime();
        authAttribs[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data});
        authAttribs[1] = new Attribute(ObjectID.signingTime, new ASN1Object[]{cot.toASN1Object()});
        if ("DSA".equals(this.sKey.getAlgorithm())) {
            MessageDigest md = null;
            byte[] firstDigest = null;
            byte[] secondDigest = null;
            byte[] signedRawData = null;
            ObjectID objID = null;
            Signature dsa = null;
            ConstructedType asnSignedInfoCpy = null;
            md = MessageDigest.getInstance("SHA");
            SEQUENCE signedData = new SEQUENCE(false);
            md.update(this.tbsData);
            firstDigest = md.digest();
            authAttribs[2] = new Attribute(ObjectID.messageDigest, new ASN1Object[]{new OCTET_STRING(firstDigest)});
            sinfo.setAuthenticatedAttributes(authAttribs);
            secondDigest = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])authAttribs));
            md.reset();
            md.update(secondDigest);
            if (!this.useNative) {
                dsa = Signature.getInstance("RawDSA");
            }
            try {
                byte[] b = md.digest();
                if (!this.useNative || nativeSigner == null) {
                    dsa.initSign(this.sKey);
                    dsa.update(b);
                    signedRawData = dsa.sign();
                } else {
                    signedRawData = (byte[])nativeSigner.invoke(null, b, this.sKey, this.mCert.getPublicKey());
                }
            }
            catch (SignatureException se) {
                throw new TicketException(se.toString());
            }
            catch (InvalidKeyException ike) {
                throw new TicketException(ike.toString());
            }
            catch (Exception e) {
                throw new TicketException(e.toString());
            }
            sinfo.setEncryptedDigest(signedRawData);
            objID = new ObjectID("1.2.840.10040.4.3", "DSAwithSHA1");
            asnSignedInfoCpy = (ConstructedType)sinfo.toASN1Object();
            OCTET_STRING osSignature = new OCTET_STRING(signedRawData);
            if (asnSignedInfoCpy instanceof ConstructedType) {
                ConstructedType ctSignedInfo = asnSignedInfoCpy;
                ctSignedInfo.setIndefiniteLength(false);
                SEQUENCE digestAlgorithmIdentifier = new SEQUENCE(false);
                digestAlgorithmIdentifier.addComponent((ASN1Object)objID);
                digestAlgorithmIdentifier.setIndefiniteLength(false);
                ctSignedInfo.setComponent(4, (ASN1Object)digestAlgorithmIdentifier);
                ctSignedInfo.setComponent(5, (ASN1Object)osSignature);
            } else {
                System.out.println("asnSI nicht konstruiert");
            }
            ContentInfo content_info = new ContentInfo(ObjectID.pkcs7_data);
            try {
                SET oneSigner = new SET();
                signedData.addComponent((ASN1Object)new INTEGER(1));
                signedData.addComponent(ASN.createSetOf((ASN1Type[])new AlgorithmID[]{AlgorithmID.sha1}));
                signedData.addComponent(content_info.toASN1Object());
                if (this.includeOwnCert) {
                    System.out.println("Certificate included.");
                    CON_SPEC myCerts = new CON_SPEC(0, this.mCert.toASN1Object());
                    signedData.addComponent((ASN1Object)myCerts);
                }
                oneSigner.addComponent((ASN1Object)asnSignedInfoCpy);
                signedData.addComponent((ASN1Object)oneSigner);
            }
            catch (CodingException ex) {
                throw new PKCSException(ex.toString());
            }
            SEQUENCE sqContentInfo = new SEQUENCE(false);
            sqContentInfo.addComponent((ASN1Object)ObjectID.pkcs7_signedData);
            CON_SPEC cs = new CON_SPEC(0, (ASN1Object)signedData);
            cs.setIndefiniteLength(false);
            sqContentInfo.addComponent((ASN1Object)cs);
            this.derSignature = DerCoder.encode((ASN1Object)sqContentInfo);
        }
    }

    protected void encodeInfoUnits() throws IOException, TicketException {
        byte[] validity;
        InfoUnit iuUser = null;
        InfoUnit iuClient = null;
        InfoUnit iuSysid = null;
        InfoUnit iuCreationTime = null;
        InfoUnit iuValidity = null;
        InfoUnit iuValidityMin = null;
        InfoUnit uiUTF8Stuff = null;
        Calendar utcCalendar = null;
        long lMilliSecs = 0L;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter CpWriter = new OutputStreamWriter((OutputStream)baos, (String)codepageEncoding.get(this.encoding));
        StringBuffer utcCreationTime = null;
        MessageFormat mf = null;
        Object[] objs = null;
        CpWriter.write(this.user);
        CpWriter.flush();
        iuUser = new InfoUnit(1, baos.toByteArray());
        this.infoUnits.add(iuUser);
        baos.reset();
        CpWriter.write(this.sysClient);
        CpWriter.flush();
        iuClient = new InfoUnit(2, baos.toByteArray());
        this.infoUnits.add(iuClient);
        baos.reset();
        CpWriter.write(this.sysID);
        CpWriter.flush();
        iuSysid = new InfoUnit(3, baos.toByteArray());
        this.infoUnits.add(iuSysid);
        baos.reset();
        utcCalendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        if (this.debug) {
            System.out.println("Measured date using new Calendar.getInstance (): " + utcCalendar.toString());
        }
        utcCreationTime = new StringBuffer("");
        utcCreationTime.append(utcCalendar.get(1));
        mf = new MessageFormat("{0,number,00}");
        objs = new Object[]{new Integer(utcCalendar.get(2) + 1)};
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(5));
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(11));
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(12));
        utcCreationTime.append(mf.format(objs));
        if (this.debug) {
            System.out.println("Created utcCreationTime string is " + utcCreationTime.toString());
        }
        CpWriter.write(utcCreationTime.toString());
        CpWriter.flush();
        iuCreationTime = new InfoUnit(4, baos.toByteArray());
        this.infoUnits.add(iuCreationTime);
        baos.reset();
        if (this.validTime > 0) {
            validity = InfoUnit.IntToBytes((int)this.validTime);
            iuValidity = new InfoUnit(5, validity);
            this.infoUnits.add(iuValidity);
        }
        if (this.validTimeMin > 0) {
            validity = InfoUnit.IntToBytes((int)this.validTimeMin);
            iuValidityMin = new InfoUnit(7, validity);
            this.infoUnits.add(iuValidityMin);
        }
        uiUTF8Stuff = new InfoUnit(10, InfoUnit.jcharToUTF8((String)this.user));
        this.infoUnits.add(uiUTF8Stuff);
    }

    public void addInfoUnit(InfoUnit iu) throws TicketException {
        if (this.mMode != MODE_CREATE) {
            throw new WrongTicketModeException("This instance is not in create mode.");
        }
        this.infoUnits.add(iu);
    }

    public String getTicket() throws TicketException {
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        return this.mTicket;
    }

    public Calendar getStartValidDate() {
        return this.startTime;
    }

    public Calendar getExpirationDate() {
        return this.endTime;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java Ticket create|verify props=<properties file>");
            System.out.println(" Syntax of the properties file:");
            System.out.println(" Ticketfile=<file storing the ticket>");
            System.out.println(" keystore  =<keystore storing certificates for verification>");
            System.out.println(" password  =<keystore password>");
            System.exit(0);
        }
        Properties funcArgs = new Properties();
        String ticketFile = null;
        if (args[0].equalsIgnoreCase("verify")) {
            try {
                String keystorePass;
                String keystoreFile;
                funcArgs.load(new FileInputStream(args[1]));
                ticketFile = funcArgs.getProperty("Ticketfile");
                if (ticketFile == null) {
                    System.out.println("ticket file in program arguments needed.");
                    System.exit(1);
                }
                if ((keystoreFile = funcArgs.getProperty("keystore")) == null) {
                    System.out.println("keystore file in program arguments needed.");
                    System.exit(1);
                }
                if ((keystorePass = funcArgs.getProperty("password")) == null) {
                    System.out.println("keystore password in program arguments needed.");
                    System.exit(1);
                }
                Security.addProvider((Provider)new IAIK());
                Ticket SAPLogonTicket = new Ticket();
                if (funcArgs.getProperty("debug") != null && funcArgs.getProperty("debug").equalsIgnoreCase("1")) {
                    SAPLogonTicket.debug = true;
                }
                SAPLogonTicket.setCertificates(keystoreFile, funcArgs.getProperty("keystore_type", "SUN").equalsIgnoreCase("SUN") ? 2 : 0, keystorePass.toCharArray());
                throw new RuntimeException("Currently not working (please fix.)");
            }
            catch (Exception e) {
                System.out.println("Exception " + e + " in main catched.");
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args[0].equalsIgnoreCase("create")) {
            Ticket SAPLogonTicket = null;
            String strValid = null;
            String strValidMin = null;
            boolean bUseNative = false;
            funcArgs = new Properties();
            try {
                String ksAlias;
                String strKeyStore;
                Security.addProvider((Provider)new IAIK());
                funcArgs.load(new FileInputStream(args[1]));
                String strpw = funcArgs.getProperty("password");
                if (strpw != null) {
                    System.setProperty("mysapDefault.keystorepass", strpw);
                }
                if ((strKeyStore = funcArgs.getProperty("keystore")) != null) {
                    System.setProperty("com.sap.security.ticket.keystore", strKeyStore);
                }
                if ((ksAlias = funcArgs.getProperty("defaultKeyAlias")) != null) {
                    System.setProperty("defaultKeyAlias", ksAlias);
                }
                if (funcArgs.getProperty("usenative") != null) {
                    bUseNative = "1".equals(funcArgs.getProperty("usenative"));
                }
                SAPLogonTicket = new Ticket();
                SAPLogonTicket.useNative(bUseNative);
                SAPLogonTicket.setKeystore(strKeyStore);
                SAPLogonTicket.setKeyPairAlias(ksAlias);
                SAPLogonTicket.setKeystorePass(strpw.toCharArray());
                SAPLogonTicket.setKeystoreType(funcArgs.getProperty("keystore_type", "SUN").equalsIgnoreCase("SUN") ? 2 : 0);
                SAPLogonTicket.setMode(MODE_CREATE);
                SAPLogonTicket.setUser(funcArgs.getProperty("user"));
                SAPLogonTicket.setSystemClient(funcArgs.getProperty("client"));
                SAPLogonTicket.setSystemID(funcArgs.getProperty("system"));
                strValid = funcArgs.getProperty("validity");
                strValidMin = funcArgs.getProperty("validityMin");
                if (strValid == null && strValidMin == null) {
                    strValid = "6";
                }
                if (funcArgs.getProperty("inclcert") != null) {
                    SAPLogonTicket.setIncludeOwnCert(funcArgs.getProperty("inclcert").equals("1"));
                }
                if (null != strValid) {
                    SAPLogonTicket.setValidTime(Integer.parseInt(strValid));
                }
                if (null != strValidMin) {
                    SAPLogonTicket.setValidTimeMin(Integer.parseInt(strValidMin));
                }
                SAPLogonTicket.create();
                System.out.println("Dies ist das Ticket:");
                System.out.println(SAPLogonTicket.getTicket());
                ticketFile = funcArgs.getProperty("Ticketfile");
                if (ticketFile != null) {
                    PrintWriter pw = new PrintWriter(new FileOutputStream(ticketFile));
                    pw.write(SAPLogonTicket.getTicket());
                    pw.close();
                }
            }
            catch (Exception e) {
                myLoc.traceThrowableT(500, "main", (Throwable)e);
                System.out.println("Exception " + e + " occured.");
                e.printStackTrace();
            }
        } else {
            System.out.println("Unbekannte Aekktion.");
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MODE_UNDEFINED = -1;
        MODE_VERIFY = 0;
        MODE_CREATE = 1;
        MODE_CREATED = 3;
        nativeSigner = null;
        bNoNativeSigner = false;
        codepageEncoding = new HashMap();
        codepageEncoding.put("4110", "UTF8");
        codepageEncoding.put("1100", "ISO8859_1");
        codepageEncoding.put("1140", "ISO8859_1");
        codepageEncoding.put("1401", "ISO8859_2");
        codepageEncoding.put("1500", "ISO8859_5");
        codepageEncoding.put("1610", "ISO8859_9");
        codepageEncoding.put("1700", "ISO8859_7");
        codepageEncoding.put("1800", "ISO8859_8");
        codepageEncoding.put("1900", "ISO8859_4");
        codepageEncoding.put("8200", "ISO2022JP");
        codepageEncoding.put("8700", "ISO8859_4");
        codepageEncoding.put("0120", "Cp500");
        codepageEncoding.put("1103", "Cp850");
        codepageEncoding.put("1404", "Cp1250");
        codepageEncoding.put("1504", "Cp1251");
        codepageEncoding.put("1614", "Cp1254");
        codepageEncoding.put("1704", "Cp1253");
        codepageEncoding.put("1804", "Cp1255");
        codepageEncoding.put("1904", "Cp1257");
        codepageEncoding.put("8604", "Cp874");
        codepageEncoding.put("8704", "Cp1256");
        codepageEncoding.put("8000", "SJIS");
        codepageEncoding.put("8100", "EUC_JP");
        codepageEncoding.put("8300", "Big5");
        codepageEncoding.put("8600", "TIS620");
        codepageEncoding.put("8400", "ISO2022CN_GB");
        codepageEncoding.put("8500", "EUC_KR");
        codepageEncoding.put("4103", "UnicodeLittleUnmarked");
        codepageEncoding.put("4102", "UTF-16BE");
    }
}

