/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ticket.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.ticket.imp.Ticket;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Location;
import iaik.asn1.structures.AlgorithmID;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InitialContext;

public class BufferingTicket
extends Ticket {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/ticket/imp/BufferingTicket.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/ticket/imp/BufferingTicket.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$ticket$imp$BufferingTicket == null ? (class$com$sap$security$core$ticket$imp$BufferingTicket = BufferingTicket.class$("com.sap.security.core.ticket.imp.BufferingTicket")) : class$com$sap$security$core$ticket$imp$BufferingTicket));
    protected static PrivateKey _s_skey = null;
    protected static X509Certificate _s_mycert = null;
    protected static String _s_keystore_type = null;
    private static boolean _s_isInitialized = false;
    protected static String _s_keystore = null;
    protected static String _s_keyalias = null;
    protected static String _s_keypass = null;
    protected static String _s_iss = null;
    protected static String _s_cli = null;
    protected static int _s_validity = 0;
    protected static int _s_validmin = 0;
    protected static boolean _s_includeowncert = false;
    private static X509Certificate[] _s_trustedCerts = null;
    private static AlgorithmID[] _s_algIDs = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
    private static final String SM_CLASSNAME = (class$com$sap$security$core$ticket$imp$BufferingTicket == null ? (class$com$sap$security$core$ticket$imp$BufferingTicket = BufferingTicket.class$("com.sap.security.core.ticket.imp.BufferingTicket")) : class$com$sap$security$core$ticket$imp$BufferingTicket).getName();
    private static final String SM_METH_CREATE = "createLogonTicket";
    static /* synthetic */ Class class$com$sap$security$core$ticket$imp$BufferingTicket;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized void init(InputStream keystoreInputStream, char[] keypass, String keyalias, String storetype, String iss, String cli, int validity, int validmin, boolean includeowncert) {
        if (_s_isInitialized) {
            return;
        }
        _s_isInitialized = true;
        _s_iss = iss;
        _s_cli = cli;
        _s_validity = validity;
        _s_validmin = validmin;
        _s_includeowncert = includeowncert;
        _s_keystore_type = storetype;
        try {
            KeyStore keystore = null;
            Certificate cert = null;
            keystore = KeyStore.getInstance(null == _s_keystore_type ? "JKS" : "IAIKKeyStore", null == _s_keystore_type ? "SUN" : "IAIK");
            keystore.load(keystoreInputStream, keypass);
            cert = keystore.getCertificate(keyalias);
            _s_mycert = cert instanceof X509Certificate ? (X509Certificate)cert : new X509Certificate(cert.getEncoded());
            _s_skey = (PrivateKey)keystore.getKey(keyalias, keypass);
            BufferingTicket.setTrustedCertificates(BufferingTicket.getTrustedCertsFromKeyStore(keystore));
        }
        catch (KeyStoreException kse) {
            trace.fatalT("init", kse);
        }
        catch (UnrecoverableKeyException uke) {
            trace.fatalT("init", uke);
        }
        catch (Exception e) {
            trace.fatalT("init", e);
        }
    }

    public static synchronized void init(String iss, String cli, int validity, int validmin, boolean includeowncert) {
        if (_s_isInitialized) {
            return;
        }
        if (_s_iss == null) {
            String sysID;
            _s_iss = iss == null || 0 == iss.length() ? ((sysID = (String)InternalUMFactory.getEngineResourceHelper().getObject((byte)0)) != null && sysID.length() > 0 ? sysID : "WP3") : iss;
        }
        _s_cli = cli;
        _s_validity = validity;
        _s_validmin = validmin;
        _s_includeowncert = includeowncert;
        KeyStore keystore = null;
        String keystorename = UMFactory.getProperties().get("login.ticket_keystore", "TicketKeystore");
        String keyalias = UMFactory.getProperties().get("login.ticket_keyalias", "SAPLogonTicketKeypair");
        try {
            keystore = BufferingTicket.getKeyStore(keystorename);
            if (keystore == null) {
                throw new Exception("KeyStore object is null");
            }
        }
        catch (Exception e1) {
            trace.errorT("init", "initialization of buffering ticket failed", e1);
            return;
        }
        Certificate cert = null;
        try {
            final String fkeyalias = keyalias;
            final KeyStore fkeystore = keystore;
            cert = (Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return fkeystore.getCertificate(fkeyalias);
                }
            });
            _s_mycert = cert instanceof X509Certificate ? (X509Certificate)cert : new X509Certificate(cert.getEncoded());
            _s_skey = (PrivateKey)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return fkeystore.getKey(fkeyalias, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            trace.errorT("init", "initialization of buffering ticket failed", e.getException());
        }
        catch (CertificateException ee) {
            trace.errorT("init", "initialization of buffering ticket failed", ee);
        }
        _s_isInitialized = true;
    }

    private static java.security.cert.X509Certificate[] getTrustedCertsFromKeyStore(KeyStore store) throws KeyStoreException {
        Vector<Certificate> certs = new Vector<Certificate>();
        Enumeration<String> enumeration = store.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (store.isCertificateEntry(alias)) {
                certs.add(store.getCertificate(alias));
            }
            if (!store.isKeyEntry(alias)) continue;
            Certificate[] certs__ = store.getCertificateChain(alias);
            int i = 0;
            while (i < certs__.length) {
                certs.add(certs__[i]);
                ++i;
            }
        }
        return certs.toArray(new java.security.cert.X509Certificate[0]);
    }

    private static void setTrustedCertificates(Certificate[] certs) {
        _s_trustedCerts = new X509Certificate[certs.length];
        int i = 0;
        while (i < certs.length) {
            try {
                BufferingTicket._s_trustedCerts[i] = new X509Certificate(certs[i].getEncoded());
            }
            catch (GeneralSecurityException gse) {
                trace.errorT("init", "Certificate " + certs[i].toString() + " couldn't be encoded", gse);
            }
            ++i;
        }
    }

    public BufferingTicket() {
        if (_s_skey == null || _s_mycert == null) {
            throw new IllegalStateException("BufferingTicket has not been initialized.");
        }
        try {
            super.setMode(Ticket.MODE_CREATE);
            super.setSystemID(_s_iss);
            super.setSystemClient(_s_cli);
            super.setIncludeOwnCert(_s_includeowncert);
            super.setValidTime(_s_validity);
            super.setValidTimeMin(_s_validmin);
            if (_s_trustedCerts != null) {
                this.setCertificates((java.security.cert.X509Certificate[])_s_trustedCerts);
            }
            super.setPrivateKeyPair(_s_skey, _s_mycert);
        }
        catch (Exception e) {
            myLoc.traceThrowableT(500, "Initialising of BufferingTicket failed", (Throwable)e);
            trace.logFatalT("Initialising of Buffering Ticket failed", null);
        }
    }

    public void create() throws TicketException, UnsupportedEncodingException, IOException {
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission sp = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_CREATE);
            sm.checkPermission((Permission)sp);
        }
        super.create();
    }

    private static KeyStore getKeyStore(String name) throws Exception {
        KeyStore ks = null;
        InitialContext ctx = null;
        ctx = new InitialContext();
        final Object o = ctx.lookup("keystore");
        final Method m = o.getClass().getMethod("getKeystore", class$java$lang$String == null ? (class$java$lang$String = BufferingTicket.class$("java.lang.String")) : class$java$lang$String);
        final String fname = name;
        try {
            ks = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return m.invoke(o, fname);
                }
            });
        }
        catch (PrivilegedActionException e) {
            trace.errorT("getKeyStore", e);
            throw e.getException();
        }
        return ks;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

