/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.test;

import com.sap.security.api.IRole;
import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.ILogonAuthentication;
import com.sap.security.api.logon.ILogonFrontend;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.imp.PermissionRoles;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestUM
extends HttpServlet {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/test/TestUM.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace trace = null;

    public String getServletInfo() {
        return "Simple Test to verify UM installation";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        trace.entering("doGet servlet started");
        if (!UMFactory.getProperties().getBoolean("ume.testum", false)) {
            res.sendError(404);
            return;
        }
        String cmd = req.getParameter("cmd");
        if (cmd == null || "0".equals(cmd)) {
            this.doGet0(req, res);
        } else if ("1".equals(cmd)) {
            this.doGet1(req, res);
        } else if ("2".equals(cmd)) {
            this.doGetLogoff(req, res);
        } else if ("3".equals(cmd)) {
            this.doGetLogoffLogon(req, res);
        } else if ("4".equals(cmd)) {
            this.checkJUM(req, res);
        } else {
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            try {
                TestUM.showHeader(req, out);
                out.println("<H3>Wrong parameter for cmd</H3>");
                TestUM.showFooter(out);
            }
            catch (Exception e) {
                trace.errorT("doGet", "Error during printout", e);
            }
            out.close();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet0(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block7: {
            res.setContentType("text/html");
            out = res.getWriter();
            try {
                try {
                    TestUM.showHeader(req, out);
                    out.println("<H3>UserManagement Test - public area</H3>");
                    IUser user = UMFactory.getAuthenticator().getLoggedInUser(req, res);
                    if (user == null || user.getDisplayName() == null) {
                        out.println("No user logged in.");
                    } else {
                        out.println("<b>Logged in User: </b>" + user.getDisplayName() + "(" + user.getUniqueID() + ")");
                        this.printUser(req, user, out);
                    }
                }
                catch (Throwable e) {
                    trace.errorT("doGet0", "Error during printout", e);
                    out.println("<br><b>There seems to be a problem in the installation and/or configuration. Please see the trace file for more details.<br> Error Message :" + e.getMessage());
                    Object var6_7 = null;
                    TestUM.showFooter(out);
                    break block7;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                TestUM.showFooter(out);
                throw throwable;
            }
            TestUM.showFooter(out);
        }
        out.close();
    }

    public void doGet1(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        IUser user = null;
        trace.entering("doGet1 and Calling forceLoggedInUser");
        user = UMFactory.getAuthenticator().forceLoggedInUser(req, res);
        if (user == null) {
            return;
        }
        trace.debugT("doGet1", "user: " + user.getUniqueID());
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        try {
            TestUM.showHeader(req, out);
            out.println("<H3>UserManagement Test - Logon required</H3>");
            out.println("<b>Logged in User: </b>" + user.getDisplayName() + "(" + user.getUniqueID() + ")");
            this.printUser(req, user, out);
            TestUM.showFooter(out);
        }
        catch (Throwable e) {
            trace.errorT("doGet1", "Error during printout:", e);
            out.println("<br><b>There seems to be a problem in the installation and/or configuration. Please see the trace file for more details.<br> Error Message :" + e.getMessage());
        }
        out.close();
    }

    public void doGetLogoff(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        trace.debugT("doGetLogoff", "Logging off");
        UMFactory.getAuthenticator().logout(req, res);
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        try {
            TestUM.showHeader(req, out);
            out.println("<H3>UserManagement Logoff</H3>");
            TestUM.showFooter(out);
        }
        catch (Exception e) {
            trace.errorT("doGet", "Error during printout:", e);
        }
        out.close();
    }

    public void doGetLogoffLogon(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UMFactory.getAuthenticator().forceLogoffUser(req, res, "/logon/TestUM");
    }

    private void printUser(HttpServletRequest req, IUser user, PrintWriter out) {
        out.println("<br><hr><br>");
        out.println("<b>Display Name</B> " + user.getDisplayName() + "<br>");
        out.println("<b>UniqueID</B> " + user.getUniqueID() + "<br>");
        out.println("<b>Unique Name</B> " + user.getUniqueName() + "<br>");
        out.println("<B>First name</B> " + user.getFirstName() + "<br>");
        out.println("<B>Last name</B> " + user.getLastName() + "<br>");
        out.println("<B>Email </B>" + user.getEmail() + "<br>");
        if (user.isCompanyUser()) {
            out.println("<B>Company Name </B>" + user.getCompany() + "<br>");
        } else {
            out.println("<B>Guest User</B> <br>");
        }
        out.println("<B>Tel</B>  " + user.getTelephone() + "<br>");
        out.println("<B>Fax</B> " + user.getFax() + "<br>");
        out.println("<B>City</B> " + user.getCity() + "<br>");
        out.println("<B>State</B> " + user.getState() + "<br>");
        out.println("<B>Country</B> " + user.getCountry() + "<br>");
        out.println("<B>Currency</B> " + user.getCurrency() + "<br>");
        out.println("<B>Address</B> " + user.getStreet() + "<br>");
        out.println("<B>Locale </B>" + user.getLocale() + "<br>");
        out.println("<B>Timezone </B>" + user.getTimeZone() + "<br><br>");
        try {
            Iterator roles = user.getRoles(true);
            if (roles != null) {
                while (roles.hasNext()) {
                    out.println("<B>User Role: </B>");
                    String uniqueID = (String)roles.next();
                    IRole role = UMFactory.getRoleFactory().getRole(uniqueID);
                    String name = role.getDisplayName();
                    String description = role.getDescription();
                    out.println(name + " (" + description + ", " + uniqueID + ")<br>");
                    Iterator serviceActions = PermissionRoles.getActions(role);
                    while (serviceActions.hasNext()) {
                        out.println("<B>-- Role Action: </B>");
                        IServiceAction serviceAction = (IServiceAction)serviceActions.next();
                        String sAID = serviceAction.getUniqueID();
                        String sAName = serviceAction.getName();
                        out.println(sAID + " (" + sAName + ")" + "<br>");
                        Iterator permissions = serviceAction.getPermissions();
                        while (permissions.hasNext()) {
                            out.println("<B>---- Java Permission: </B>");
                            out.println(permissions.next() + "<br>");
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            trace.errorT("printUser(...)", "Error retrieving roles", ex);
            out.println("<br><B>Error retrieving roles:</B> " + ex.getMessage());
        }
        out.println("<br><br>");
    }

    private static void showHeader(HttpServletRequest req, PrintWriter out) throws IOException {
        out.println("<!doctype html public \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>User Management Engine</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"#FFFFFF\">");
        out.println("Test of basic user management functionality.<p>");
        out.println("<p>There are different pages for:");
        out.println("<ul>");
        String url = req.getRequestURI();
        out.println("<li>" + TestUM.thislink(url, "No login required", "0"));
        out.println("<li>" + TestUM.thislink(url, "Login required", "1"));
        out.println("<li>" + TestUM.thislink(url, "Logoff", "2"));
        out.println("<li>" + TestUM.thislink(url, "Go to logoff page", "3"));
        out.println("<li>" + TestUM.thislink(url, "Check other LogonAuthenticator func", "4"));
        out.println("</ul>");
        out.println("<p>Additional parameters you can set:");
        out.println("<ul>");
        out.println("<li>" + TestUM.thislink(url, "version", "1&version=1"));
        out.println("<li>" + TestUM.thislink(url, "header", "1&header=1"));
        out.println("<li>" + TestUM.thislink(url, "usernum", "1&usernum=1"));
        out.println("</ul>");
        if (req.getParameter("header") != null) {
            out.println("<p><hr>all_http=" + req.getHeader("all_http"));
            out.println("<hr>");
            Enumeration en = req.getHeaderNames();
            while (en.hasMoreElements()) {
                String hn = (String)en.nextElement();
                out.println("<p>" + hn + "=" + req.getHeader(hn));
            }
            out.println("<p>RemoteUser=" + req.getRemoteUser());
            out.println("<hr>");
        }
    }

    private static void showFooter(PrintWriter out) throws IOException {
        out.println("</BODY></HTML>");
    }

    private static final String thislink(String thisurl, String t, String a) {
        return "<a href=" + thisurl + "?cmd=" + a + ">" + t + "</a>";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkJUM(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block6: {
            res.setContentType("text/html");
            out = res.getWriter();
            try {
                try {
                    TestUM.showHeader(req, out);
                    out.println("<H3>UserManagement Test - public area</H3>");
                    ILogonAuthentication jum = UMFactory.getLogonAuthenticator();
                    IUser user = jum.getLoggedInUser(req, res);
                    if (user == null) {
                        out.println("No user logged in.");
                    } else {
                        out.println("<b>Logged in User: </b>" + user.getDisplayName() + "(" + user.getUniqueID() + ")");
                    }
                    String lfeName = "test";
                    ILogonFrontend lfe = jum.getLogonFrontend(lfeName);
                    out.println("<br><b>LogonFrontend " + lfeName + ": </b>" + lfe);
                    String asName = "default";
                    boolean isSuf = jum.isAuthSchemeSufficient(user, asName);
                    out.println("<br>The user's authscheme is " + (isSuf ? "" : "NOT") + " sufficient to authscheme " + asName + ".");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    trace.errorT("checkJum", "Error during printout", e);
                    out.println("<br><b>There seems to be a problem in the installation and/or configuration. Please see the trace file for more details.<br> Error Message :" + e.getMessage());
                    Object var11_12 = null;
                    TestUM.showFooter(out);
                    break block6;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                TestUM.showFooter(out);
                throw throwable;
            }
            TestUM.showFooter(out);
        }
        out.close();
    }

    static {
        try {
            trace = InternalUMFactory.getTrace(VERSIONSTRING);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

