/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.srvUser.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.srvUser.IServiceUserFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.imp.ServiceUserWrapper;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.datasource.IDataSourceMetaData;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.security.Permission;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ServiceUserFactory
implements IServiceUserFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/srvUser/imp/ServiceUserFactory.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    public static IUMTrace mTrace = null;
    public static final String SM_CLASSNAME = (class$com$sap$security$core$srvUser$imp$ServiceUserFactory == null ? (class$com$sap$security$core$srvUser$imp$ServiceUserFactory = ServiceUserFactory.class$("com.sap.security.core.srvUser.imp.ServiceUserFactory")) : class$com$sap$security$core$srvUser$imp$ServiceUserFactory).getName();
    public static final String SM_METH_GETSERVICEUSER = "getServiceUser";
    private IUserFactory mUserFactory = UMFactory.getUserFactory();
    private IUserAccountFactory mUserAccountFactory = UMFactory.getUserAccountFactory();
    private static Hashtable mMappingCaches = new Hashtable();
    public static AttributeList SERVICEUSER_DEFAULT_ATTRIBUTES = new AttributeList(false);
    static /* synthetic */ Class class$com$sap$security$core$srvUser$imp$ServiceUserFactory;

    private static String getUniqueNameMapping(String uniqueName, String[] datasources) {
        ICache cache = (ICache)mMappingCaches.get(ServiceUserFactory.calculateCacheKey(datasources));
        if (cache != null) {
            return (String)cache.get(uniqueName);
        }
        return null;
    }

    private static String calculateCacheKey(String[] datasources) {
        StringBuffer cacheKey = new StringBuffer(20);
        if (datasources != null) {
            int size = datasources.length;
            int i = 0;
            while (i < size) {
                cacheKey.append(datasources[i]);
                cacheKey.append("_");
                ++i;
            }
        } else {
            cacheKey.append("ALL_DATASOURCES_");
        }
        return cacheKey.toString();
    }

    private static void addUniqueNameMapping(String uniqueName, String uniqueID, String[] datasources) {
        String cacheKey = ServiceUserFactory.calculateCacheKey(datasources);
        ICache cache = (ICache)mMappingCaches.get(cacheKey);
        if (cache == null) {
            IUMParameters props = UMFactory.getProperties();
            int maxLifeTime = props.getNumber("ume.cache.user.default_caching_time", 28800);
            int initialSize = props.getNumber("ume.cache.user.initial_cache_size", 500);
            cache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$srvUser$imp$ServiceUserFactory == null ? (class$com$sap$security$core$srvUser$imp$ServiceUserFactory = ServiceUserFactory.class$("com.sap.security.core.srvUser.imp.ServiceUserFactory")) : class$com$sap$security$core$srvUser$imp$ServiceUserFactory).getName() + "_mMappingCaches(" + cacheKey + ")");
        }
        cache.put(uniqueName, uniqueID);
        mMappingCaches.put(cacheKey, cache);
    }

    public static synchronized void invalidateCache() {
        mMappingCaches.clear();
    }

    public static synchronized void invalidateUniqueNameMapping(String uniqueName) {
        boolean allDone = false;
        while (!allDone) {
            try {
                Enumeration en = mMappingCaches.keys();
                while (en.hasMoreElements()) {
                    String cacheKey = (String)en.nextElement();
                    ICache dummy = (ICache)mMappingCaches.get(cacheKey);
                    dummy.invalidate(uniqueName);
                }
                allDone = true;
            }
            catch (ConcurrentModificationException cmex) {
                allDone = false;
                if (!mTrace.beDebug()) continue;
                mTrace.debugT("invalidateUniqueNameMapping", cmex);
            }
        }
    }

    public synchronized void initialize(Properties properties) throws UMException {
    }

    public ServiceUserFactory() throws PersistenceException {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
    }

    public IUser getServiceUser(String uniqueName) throws UMException {
        return this.getServiceUser(uniqueName, true);
    }

    public IUser getServiceUser(String uniqueName, boolean bCreateTicket) throws UMException {
        IUser serviceUser;
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission p = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_GETSERVICEUSER);
            sm.checkPermission((Permission)p);
        }
        if ((serviceUser = this.checkForServiceUser(uniqueName)) == null) {
            throw new NoSuchUserException("Service user " + uniqueName + " does not exist.");
        }
        return serviceUser;
    }

    public void deleteUser(String uniqueID) throws UMException {
        this.mUserFactory.deleteUser(uniqueID);
    }

    public void createServiceUser(String uniqueName) throws UMException {
        IUserMaint newUser = this.mUserFactory.newUser(uniqueName);
        String[] value = new String[]{"IS_SERVICEUSER"};
        newUser.setAttribute("$serviceUser$", "SERVICEUSER_ATTRIBUTE", value);
        newUser.save();
        newUser.commit();
        mTrace.infoT("createServiceUser", "New user " + uniqueName + " created successfully.");
        try {
            IUserAccount newAccount = ((UserAccountFactory)this.mUserAccountFactory).newServiceUserAccount(uniqueName, newUser.getUniqueID());
            newAccount.setAttribute("$serviceUser$", "SERVICEUSER_ATTRIBUTE", value);
            newAccount.save();
            newAccount.commit();
            mTrace.infoT("createServiceUser", "New account " + uniqueName + " created successfully.");
        }
        catch (UMException umex) {
            this.mUserFactory.deleteUser(newUser.getUniqueID());
            mTrace.infoT("createServiceUser", "New user " + uniqueName + " deleted because something went wrong while creating the account.");
            throw umex;
        }
    }

    public boolean isServiceUser(IUser user) throws UMException {
        boolean found = false;
        if (user != null) {
            found = this.attributeCheck(user);
        }
        return found;
    }

    public boolean isServiceUser(String uniqueIdOfUser) throws UMException {
        boolean rc;
        block3: {
            rc = false;
            try {
                IUser serviceUser = this.checkForServiceUserId(uniqueIdOfUser);
                if (serviceUser != null) {
                    rc = true;
                }
            }
            catch (NoSuchUserException ex) {
                rc = false;
                if (!mTrace.beDebug()) break block3;
                mTrace.debugT("isServiceUser", ex);
            }
        }
        return rc;
    }

    private IUser checkForServiceUserId(String uniqueIdOfUser) throws UMException {
        IUser serviceUser = ((UserFactory)this.mUserFactory).getReadonlyUser(uniqueIdOfUser, SERVICEUSER_DEFAULT_ATTRIBUTES);
        boolean found = this.attributeCheck(serviceUser);
        if (!found) {
            throw new NoSuchUserException("Service user " + uniqueIdOfUser + " does not exist.");
        }
        return new ServiceUserWrapper(serviceUser, SERVICEUSER_DEFAULT_ATTRIBUTES);
    }

    private boolean attributeCheck(IUser serviceUser) {
        boolean found = false;
        String[] strArr = serviceUser.getAttribute("$serviceUser$", "SERVICEUSER_ATTRIBUTE");
        if (strArr != null) {
            int i = 0;
            while (i < strArr.length) {
                if (strArr[i].equals("IS_SERVICEUSER")) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    private IUser checkForServiceUser(String uniqueNameOfUser) throws UMException {
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IDataSourceMetaData[] dsmd = mFactory.getDataSourceMetaData();
        Vector<String> dataSourcesToSearch = new Vector<String>();
        int size = dsmd.length;
        int i = 0;
        while (i < size) {
            if ("com.sap.security.core.persistence.datasource.imp.DataBasePersistence".equals(dsmd[i].getClassName())) {
                dataSourcesToSearch.add(dsmd[i].getDataSourceID());
            }
            ++i;
        }
        size = dataSourcesToSearch.size();
        String[] dataSources = dataSourcesToSearch.toArray(new String[size]);
        String uniqueID = ServiceUserFactory.getUniqueNameMapping(uniqueNameOfUser, dataSources);
        IUser daUser = null;
        if (uniqueID == null) {
            Vector searchResult;
            SearchCriteria sc = new SearchCriteria("USER");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueNameOfUser, true);
            if (size != 0) {
                sc.setDataSourcesToSearch(dataSources);
            }
            if ((searchResult = mFactory.searchPrincipalDatabags(sc)) == null || searchResult.size() == 0) {
                throw new NoSuchUserException("Service user " + uniqueNameOfUser + " does not exist.");
            }
            if (searchResult.size() > 1) {
                throw new UMException("Unique name of service user " + uniqueNameOfUser + " is not unique.");
            }
            uniqueID = (String)searchResult.elementAt(0);
            daUser = this.checkForServiceUserId(uniqueID);
            if (!this.attributeCheck(daUser)) {
                throw new UMException("User " + uniqueNameOfUser + " is not a service user.");
            }
            ServiceUserFactory.addUniqueNameMapping(uniqueNameOfUser, uniqueID, dataSources);
        } else {
            daUser = this.checkForServiceUserId(uniqueID);
        }
        return daUser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SERVICEUSER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "uniquename", 1);
        SERVICEUSER_DEFAULT_ATTRIBUTES.addAttribute("$serviceUser$", "SERVICEUSER_ATTRIBUTE", 1);
    }
}

