/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.session.imp;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.CacheNotAvailableException;
import com.sap.ip.basecomps.cache.ObjectExistsException;
import com.sap.ip.basecomps.cache.ObjectNotFoundException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.session.ITicketCacheInfo;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.session.imp.ICTImpl;
import com.sap.security.core.session.imp.ICachedTicket;
import com.sap.security.core.session.imp.TCIImpl;
import com.sap.security.core.ticket.imp.Ticket;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Calendar;
import java.util.Properties;
import java.util.SimpleTimeZone;

class TicketCache {
    static final String TICKET_CACHE_ID = "com.sap.security.ticket.cache";
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/session/imp/TicketCache.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static final String LIFETIME_ATTR = "lifetime";
    private static final String MAXWEIGHT_ATTR = "maxweight";
    private static final String WEIGHT_ATTR = "weight";
    static TicketCache _s_instance = null;
    IUMTrace _trace;
    CacheAccess _cache;

    private TicketCache() {
        block6: {
            this._trace = null;
            this._cache = null;
            Properties p = new Properties();
            this._trace = InternalUMFactory.getTrace(VERSIONSTRING);
            p.setProperty("consistency-domain.class", "com.sap.ip.basecomps.impl.None");
            long iMaxLifetime = this.getMaxLifetime();
            p.setProperty(LIFETIME_ATTR, "" + iMaxLifetime);
            int maxweight = UMFactory.getProperties().getNumber("ume.cache.ticket_cache.maxweight", 1000);
            p.setProperty(MAXWEIGHT_ATTR, "" + maxweight);
            try {
                CacheAccess.defineRegion((String)TICKET_CACHE_ID, (Attributes)new Attributes(p));
                this._cache = CacheAccess.getAccess((String)TICKET_CACHE_ID);
            }
            catch (ObjectExistsException e) {
                if (this._trace.beError()) {
                    this._trace.errorT("<init>", "bad cache initialization", e);
                }
            }
            catch (CacheNotAvailableException e) {
                if (this._trace.beError()) {
                    this._trace.errorT("<init>", "cache implementation not available", e);
                }
            }
            catch (CacheException e) {
                if (!this._trace.beError()) break block6;
                this._trace.errorT("<init>", "Cannot get cache object", e);
            }
        }
    }

    private long getMaxLifetime() {
        String strLifetime = UMFactory.getProperties().get("login.ticket_lifetime");
        if (strLifetime == null) {
            return 28800000L;
        }
        try {
            return Integer.parseInt(strLifetime) * 3600 * 1000;
        }
        catch (NumberFormatException e) {
            return 28800000L;
        }
    }

    static synchronized TicketCache getInstance() {
        if (_s_instance == null) {
            _s_instance = new TicketCache();
        }
        return _s_instance;
    }

    ICachedTicket putTicket(Ticket ticket) {
        String ticket_string = null;
        try {
            ticket_string = ticket.getTicket();
        }
        catch (TicketException e) {
            e.printStackTrace();
            return null;
        }
        String key = null;
        key = ticket_string;
        long lSecondsToLive = ticket.getExpirationDate().getTime().getTime() - System.currentTimeMillis();
        if (lSecondsToLive < 0L) {
            this._trace.warningT("putTicket", "Attempt to add an expired ticket (" + ticket_string.substring(0, 25) + "...) to the cache.");
            return null;
        }
        ICTImpl item = null;
        try {
            item = new ICTImpl(ticket);
        }
        catch (TicketException e2) {
            e2.printStackTrace();
            return null;
        }
        Properties p = new Properties();
        p.setProperty(LIFETIME_ATTR, "" + lSecondsToLive);
        p.setProperty(WEIGHT_ATTR, "1");
        try {
            this._cache.put((Object)key, new Attributes(p), (Object)item);
        }
        catch (CacheException e3) {
            this._trace.warningT("putTicket(Ticket)", "Unexpected error while adding ticket to cache", e3);
            return null;
        }
        return item;
    }

    void removeTicket(String ticket_string) {
        block2: {
            String key = null;
            key = ticket_string;
            try {
                this._cache.destroy((Object)key);
            }
            catch (CacheException e) {
                if (!this._trace.beError()) break block2;
                this._trace.errorT("removeTicket", "Unexpected cache exception", e);
            }
        }
    }

    ICachedTicket getTicket(String ticket_string) {
        String key = ticket_string;
        ICachedTicket ict = null;
        try {
            ict = (ICachedTicket)this._cache.get((Object)key);
        }
        catch (ObjectNotFoundException e) {
        }
        catch (Exception e) {
            this._trace.errorT("getTicket", "Unexpected exception caught", e);
        }
        if (this._trace.beInfo()) {
            this._trace.infoT("getTicket", "lookup for item " + new String(key) + " is " + ict);
        }
        if (ict == null) {
            return null;
        }
        if (System.currentTimeMillis() > ict.getExpiryTime()) {
            this.removeTicket(ticket_string);
            ict = null;
        }
        return ict;
    }

    ICachedTicket putTicket(String ticket_string) {
        Ticket ticket = new Ticket();
        ticket.setEnforceVerify(false);
        try {
            ticket.setTicket(ticket_string);
        }
        catch (TicketException e) {
            this._trace.warningT("putTicket", "Ticket incorrect. putTicket returns.", e);
            return null;
        }
        return this.putTicket(ticket);
    }

    public ITicketCacheInfo getCacheStatistics() {
        return new TCIImpl(this);
    }

    public static void main(String[] pils) {
        System.out.println(System.currentTimeMillis() / 1000L);
        Calendar c = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        System.out.println(Util.getSecondsFromCalendar(c));
    }
}

