/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.session.imp;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.session.ISSOSession;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.session.imp.DefaultSAPSessionFactory;
import com.sap.security.core.ticket.imp.Ticket;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.SSOUtils;
import com.sap.security.core.util.imp.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionContext;

public class SSOSession
implements ISSOSession {
    public static final String SSOTICKET_ALIAS = "MYSAPSSO2";
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/session/imp/SSOSession.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static final String DEF_CERTIFICATE_ATTR = "javax.servlet.request.X509Certificate";
    private static final byte TICKET_FROM_COOKIES = 2;
    private static final byte TICKET_FROM_EVERYWHERE = -1;
    private static final byte TICKET_FROM_REQUEST = 1;
    private static final byte TICKET_FROM_REQUEST_ATTRIBUTES = 4;
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/session/imp/SSOSession.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private Hashtable attributes;
    private long creationTime;
    private int maxInactiveInterval;
    private HttpServletRequest req = null;
    private HttpServletResponse resp = null;
    private DefaultSAPSessionFactory sess_fac = null;
    private boolean mTryR3User = true;
    private Ticket ticket = null;
    private String ticketString = null;
    private String domain = null;
    static /* synthetic */ Class class$com$sap$security$api$IUser;

    public SSOSession(HttpServletRequest req, HttpServletResponse resp) {
        this.setRequest(req);
        this.setResponse(resp);
        this.creationTime = System.currentTimeMillis();
        this.attributes = new Hashtable();
        this.mTryR3User = UMFactory.getProperties().getBoolean("login.try_r3_user", true);
        this.sess_fac = (DefaultSAPSessionFactory)DefaultSAPSessionFactory.getInstance(null);
    }

    SSOSession cloneThis() {
        SSOSession nsess = new SSOSession(null, null);
        nsess.creationTime = this.creationTime;
        nsess.attributes = this.attributes;
        nsess.ticket = this.getVerifiedTicket();
        nsess.ticketString = this.ticketString;
        return nsess;
    }

    public Object getAttribute(String name) {
        String functionname = "getAttribute";
        String rc = null;
        rc = (String)this.attributes.get(name);
        if ("com.sap.security.user_id".equals(name)) {
            this.ticket = this.getVerifiedTicket();
            if (this.ticket == null) {
                return null;
            }
            Date current = new Date();
            Calendar expDate = this.ticket.getExpirationDate();
            if (current.compareTo(expDate.getTime()) > 0) {
                return null;
            }
            rc = this.getUserIDFromTicket(this.ticket);
        } else if ("j_authscheme".equals(name)) {
            if (rc == null) {
                this.ticket = this.getVerifiedTicket();
                if (this.ticket == null) {
                    return null;
                }
                String authSchemeName = this.getAuthschemeFromTicket(this.ticket);
                IAuthScheme authScheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authSchemeName);
                if (authScheme == null) {
                    trace.errorT(functionname, "Authscheme in ticket " + authSchemeName + " cannot be found!");
                } else {
                    rc = authScheme.getName();
                }
                if (rc != null) {
                    this.attributes.put(name, rc);
                }
            }
        } else if ("$MYSAPSSO$".equals(name)) {
            return this.ticketString;
        }
        return rc;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void setAttributes(Map map) {
        String userID = null;
        String userIDR3 = null;
        String authschemeName = null;
        IUser user = null;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey().equals(class$com$sap$security$api$IUser == null ? SSOSession.class$("com.sap.security.api.IUser") : class$com$sap$security$api$IUser)) {
                user = (IUser)entry.getValue();
            } else {
                this.attributes.put(entry.getKey(), entry.getValue());
            }
            if (entry.getKey().equals("com.sap.security.user_id")) {
                userID = (String)entry.getValue();
                continue;
            }
            if (!entry.getKey().equals("j_authscheme")) continue;
            authschemeName = (String)entry.getValue();
        }
        try {
            userIDR3 = UMFactory.getUserMapping().getR3UserName(user, null, null, false);
        }
        catch (UMException umex) {
            trace.warningT("setAttributes", "", umex);
        }
        this.setSSOCookie(userID, authschemeName, userIDR3);
    }

    public void setAttribute(String name, Object value) {
        if ("com.sap.security.user_id".equals(name)) {
            String userID = (String)value;
            String oldUID = (String)this.getAttribute("com.sap.security.user_id");
            if (value != null && !value.equals(oldUID)) {
                trace.warningT("setAttribute", "trying to set user which is different from user that is already set. Old user: " + oldUID + ", new User: " + userID);
            }
            trace.warningT("setAttribute", "trying to set user without authscheme or R3 user.");
            this.setSSOCookie(userID, (String)this.getAttribute("j_authscheme"), null);
        }
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if ("com.sap.security.user_id".equals(name)) {
            this.deleteCookie();
        }
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.removeAttribute("com.sap.security.user_id");
        this.removeAttribute("j_authscheme");
        this.attributes.clear();
    }

    public boolean isNew() {
        return this.getId() == null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    private static String getSSOTicket(HttpServletRequest req, byte origin) {
        String str;
        String s;
        Cookie[] cookies = req.getCookies();
        Object ticketCookie = null;
        String strTicket = null;
        StringBuffer bufTicket = null;
        if ((origin & 1) == 1 && (s = req.getParameter(SSOTICKET_ALIAS)) != null) {
            bufTicket = new StringBuffer(s);
        }
        if (cookies != null && bufTicket == null && (origin & 2) == 2) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(SSOTICKET_ALIAS)) {
                    String __value = cookies[i].getValue();
                    if (null != __value && !__value.trim().equals("")) {
                        bufTicket = new StringBuffer(__value);
                    } else {
                        return null;
                    }
                }
                ++i;
            }
        }
        if (bufTicket == null && (origin & 4) == 4 && (str = (String)req.getAttribute(SSOTICKET_ALIAS)) != null) {
            bufTicket = new StringBuffer(str);
        }
        if (bufTicket != null) {
            while (bufTicket.length() > 0 && ' ' == bufTicket.charAt(0)) {
                bufTicket.delete(0, 1);
            }
        }
        if (bufTicket != null && bufTicket.length() > 0) {
            int i = 0;
            while (i < bufTicket.length()) {
                if (bufTicket.charAt(i) == '%') {
                    int c = Integer.parseInt(bufTicket.substring(i + 1, i + 3), 16);
                    String s2 = new String(new byte[]{(byte)c});
                    bufTicket.replace(i, i + 3, s2);
                }
                ++i;
            }
            strTicket = bufTicket.toString();
        }
        return strTicket;
    }

    private Ticket getVerifiedTicket() {
        if (this.ticket == null && this.ticketString != null) {
            try {
                this.ticket = (Ticket)UMFactory.getInstance().getTicketVerifier();
                this.ticket.setMode(Ticket.MODE_VERIFY);
                this.ticket.setTicket(this.ticketString);
                this.ticket.verify();
            }
            catch (Exception te) {
                trace.errorT("getVerifiedBufferingTicket", "Ticket authentication failed.", te);
                this.ticket = null;
            }
        }
        return this.ticket;
    }

    public static String getSSOTicket(HttpServletRequest req) {
        return SSOSession.getSSOTicket(req, (byte)2);
    }

    private void deleteCookie() {
        Cookie[] cookies;
        if (this.req != null && (cookies = this.req.getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(SSOTICKET_ALIAS)) {
                    cookies[i].setMaxAge(-1);
                    cookies[i].setValue("");
                    if (this.domain != null) {
                        cookies[i].setDomain(this.domain);
                    }
                    cookies[i].setPath("/");
                    this.resp.addCookie(cookies[i]);
                }
                ++i;
            }
        }
    }

    private void setSSOCookie(String userID, String authschemeName, String userIDR3) {
        try {
            Ticket t;
            if (userID != null && !"".equals(userID)) {
                t = (Ticket)UMFactory.getInstance().getTicketVerifier();
                t.setMode(Ticket.MODE_CREATE);
                if (userIDR3 != null) {
                    t.setUser(userIDR3);
                }
                InfoUnit iuUserID = new InfoUnit(32, InfoUnit.jcharToUTF8((String)("portal:" + userID)));
                t.addInfoUnit(iuUserID);
                if (authschemeName != null) {
                    InfoUnit iuAuthscheme = new InfoUnit(136, InfoUnit.jcharToUTF8((String)authschemeName));
                    t.addInfoUnit(iuAuthscheme);
                }
                try {
                    final Ticket _t = t;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws TicketException, UnsupportedEncodingException, IOException {
                            _t.create();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception exc = pae.getException();
                    if (exc instanceof TicketException) {
                        throw (TicketException)((Object)exc);
                    }
                    if (exc instanceof UnsupportedEncodingException) {
                        throw (UnsupportedEncodingException)exc;
                    }
                    if (exc instanceof IOException) {
                        throw (IOException)exc;
                    }
                    throw new RuntimeException(exc.toString());
                }
            } else {
                this.ticketString = "";
                this.ticket = null;
                trace.infoT("setSSOCookie", "Remove SSO cookie.");
                this.deleteCookie();
                return;
            }
            this.ticketString = t.getTicket();
            this.ticket = this.getThisTicketAsVerifiedTicket(this.ticketString);
            this.ticketString = this.ticket.getTicket();
            StringBuffer replaced_cookie = new StringBuffer(this.ticket.getTicket());
            int i = 0;
            while (i < replaced_cookie.length()) {
                if (replaced_cookie.charAt(i) == '+') {
                    replaced_cookie.replace(i, i + 1, "%2B");
                } else if (replaced_cookie.charAt(i) == '/') {
                    replaced_cookie.replace(i, i + 1, "%2F");
                } else if (replaced_cookie.charAt(i) == '=') {
                    replaced_cookie.replace(i, i + 1, "%3D");
                }
                ++i;
            }
            if (UMFactory.getProperties().getBoolean("ume.logon.httponlycookie", true)) {
                replaced_cookie.append("; HttpOnly");
            }
            Cookie cookie = new Cookie(SSOTICKET_ALIAS, replaced_cookie.toString());
            cookie.setPath("/");
            String domain = UMFactory.getProperties().get("ume.logon.security.cookie_domain", SSOUtils.getSSOCookieDomain(this.req));
            if (domain != null) {
                cookie.setDomain(domain);
            }
            cookie.setSecure(UMFactory.getProperties().getBoolean("ume.logon.security.enforce_secure_cookie", false));
            cookie.setMaxAge(-1);
            this.resp.addCookie(cookie);
        }
        catch (TicketException te) {
            trace.errorT("setSSOCookie", "Ticket creation failed for the following reason: ", te);
        }
        catch (UnsupportedEncodingException uee) {
            trace.errorT("setSSOCookie", "Ticket creation failed for the following reason: ", uee);
        }
        catch (IOException ie) {
            trace.errorT("setSSOCookie", "Ticket creation failed for the following reason: ", ie);
        }
    }

    private Ticket getThisTicketAsVerifiedTicket(String ticketString) {
        Ticket t = (Ticket)UMFactory.getInstance().getTicketVerifier();
        try {
            t.setTicket(ticketString);
        }
        catch (Exception e) {
            trace.errorT("getThisTicketAsVerifiedTicket", "Ticket creation failed for the following reason: ", e);
        }
        t.setEnforceVerify(false);
        return t;
    }

    private String getUserIDFromTicket(Ticket t) {
        String function_name = "getUserIDFromTicket";
        String userID = null;
        if (this.ticket != null) {
            try {
                userID = t.getUser("portal");
                if (userID == null && this.mTryR3User) {
                    trace.infoT(function_name, "Portal user empty. Trying R/3 user.");
                    userID = t.getUser();
                }
                if (userID == null) {
                    trace.errorT(function_name, "Portal user in ticket is null.");
                    throw new UMException("Incorrect ticket received (without a user in it).");
                }
            }
            catch (Exception te) {
                trace.errorT(function_name, "Ticket authentication failed.", te);
                userID = null;
            }
        }
        return userID;
    }

    private String getAuthschemeFromTicket(Ticket t) {
        String function_name = "getAuthschemeFromTicket";
        String authscheme = UMFactory.getProperties().get("ume.logon.authscheme.empty", "default");
        try {
            InfoUnit iu = t.getInfoUnit(136);
            if (iu != null) {
                authscheme = iu.getString("UTF8");
            } else {
                trace.warningT(function_name, "No Authscheme found in ticket. Using default for backward-compatability to EP5 tickets.");
            }
        }
        catch (Exception te) {
            trace.errorT(function_name, "Ticket authentication failed. Error " + te + "reported.");
        }
        return authscheme;
    }

    public String getId() {
        return Util.createMD5HashValue(this.ticketString);
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public String[] getValueNames() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SSOSession) {
            SSOSession otherSession = (SSOSession)other;
            return this.getId().equals(otherSession.getId());
        }
        return false;
    }

    void setResponse(HttpServletResponse resp) {
        this.resp = resp;
    }

    void setRequest(HttpServletRequest req) {
        if (req != null) {
            this.req = req;
            String newTicketString = SSOSession.getSSOTicket(req);
            if (this.ticketString == null || !this.ticketString.equals(newTicketString)) {
                this.ticketString = newTicketString;
                this.ticket = null;
            }
            this.domain = SSOUtils.getSSOCookieDomain(req);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

