/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.session.imp;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.session.ISSOSession;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.umap.IUserMapping;
import com.sap.security.api.umap.NoLogonDataAvailableException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.session.imp.ICachedTicket;
import com.sap.security.core.session.imp.SSOSession;
import com.sap.security.core.session.imp.TicketCache;
import com.sap.security.core.ticket.imp.Ticket;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.SSOUtils;
import com.sap.security.core.util.imp.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionContext;

public class ImprSSOSession
implements ISSOSession {
    HttpServletRequest _request;
    HttpServletResponse _response;
    String _userid;
    String _ticket_string;
    Ticket _ticket;
    Map _attrs;
    String _authscheme;
    long _creationTime;
    long _lastAccessed;
    TicketCache _cache;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/session/imp/ImprSSOSession.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    static IUMTrace _s_trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/session/imp/ImprSSOSession.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    static /* synthetic */ Class class$com$sap$security$api$IUser;

    public ImprSSOSession(HttpServletRequest req, HttpServletResponse resp) {
        this._request = req;
        this._response = resp;
        this._userid = null;
        this._ticket_string = null;
        this._ticket = null;
        this._attrs = new HashMap();
        this._authscheme = null;
        this._lastAccessed = this._creationTime = System.currentTimeMillis();
        this._cache = TicketCache.getInstance();
        this.init();
    }

    private void init() {
        this._ticket_string = SSOSession.getSSOTicket(this._request);
        if (this._ticket_string != null) {
            InfoUnit iu;
            ICachedTicket ict = this._cache.getTicket(this._ticket_string);
            if (ict == null) {
                this._ticket = (Ticket)UMFactory.getInstance().getTicketVerifier();
                try {
                    this._ticket.setTicket(this._ticket_string);
                    this._ticket.verify();
                    this._userid = this._ticket.getUser("portal");
                    if (this._userid == null && !this.readReverseMapping()) {
                        this._ticket = null;
                        this._ticket_string = null;
                        return;
                    }
                }
                catch (Exception e) {
                    _s_trace.errorT("init", "Ticket decoding/verification failed.", e);
                    this._ticket = null;
                    this._ticket_string = null;
                    return;
                }
                ict = this._cache.putTicket(this._ticket);
                if (ict == null) {
                    this._ticket_string = null;
                    return;
                }
            }
            if (this._userid == null) {
                this._userid = ict.getUser();
            }
            if ((iu = ict.getInfoUnit(136)) != null) {
                try {
                    this._authscheme = iu.getString("UTF8");
                    this._creationTime = ict.getCreationTime();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean readReverseMapping() {
        IUserMapping imap = UMFactory.getUserMapping();
        String msys = UMFactory.getProperties().get("ume.r3.mastersystem", "");
        String r3user = null;
        String user = null;
        try {
            r3user = this._ticket.getUser();
            user = imap.getInverseMappingData(msys, r3user, (byte)1);
            IUser iuser = UMFactory.getUserFactory().getUser(user);
            if (iuser == null) {
                throw new IllegalStateException("No iuser object for user " + user);
            }
            user = iuser.getUserAccounts()[0].getLogonUid();
        }
        catch (NoLogonDataAvailableException e) {
            _s_trace.errorT("readReverseMapping", "Error during computation of inverse mapping. R3User is " + r3user + ", Ticket is: " + this._ticket_string.substring(0, 45), e);
        }
        catch (TicketException e) {
            _s_trace.errorT("readReverseMapping", "Error during computation of inverse mapping. R3User is " + r3user + ", Ticket is: " + this._ticket_string.substring(0, 45), e);
        }
        catch (UMException e) {
            _s_trace.errorT("readReverseMapping", "Error during computation of inverse mapping. R3User is " + r3user + ", Ticket is: " + this._ticket_string.substring(0, 45), e);
        }
        this._userid = user;
        this._authscheme = "default";
        return this._userid != null;
    }

    public void setAttributes(Map map) {
        Iterator it = map.keySet().iterator();
        Throwable ee = null;
        while (it.hasNext()) {
            Object o = it.next();
            this.internalSetAttribute(o, map.get(o));
        }
        if (this.isTicketGenerationReady()) {
            try {
                this.generateTicket();
            }
            catch (UnsupportedEncodingException e) {
                ee = e;
            }
            catch (IOException e) {
                ee = e;
            }
            catch (TicketException e) {
                ee = e;
            }
            if (ee != null) {
                _s_trace.errorT("setAttribute", "Ticket creation failed...", ee);
                throw new RuntimeException("Unexpected exception: Ticket creation failed");
            }
        }
    }

    public void setAttribute(String key, Object value) {
        this.internalSetAttribute(key, value);
        Throwable ee = null;
        if (this.isTicketGenerationReady()) {
            try {
                this.generateTicket();
            }
            catch (UnsupportedEncodingException e) {
                ee = e;
            }
            catch (IOException e) {
                ee = e;
            }
            catch (TicketException e) {
                ee = e;
            }
            if (ee != null) {
                _s_trace.errorT("setAttribute", "Ticket creation failed...", ee);
                throw new RuntimeException("Unexpected exception: Ticket creation failed");
            }
        }
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public String getId() {
        try {
            if (this._ticket != null) {
                return Util.createMD5HashValue(this._ticket.getTicket());
            }
        }
        catch (TicketException e) {
            _s_trace.warningT("getId()", "Unexpected exception occured.", e);
            return null;
        }
        return "" + System.identityHashCode(this);
    }

    public long getLastAccessedTime() {
        return this._lastAccessed;
    }

    public void setMaxInactiveInterval(int arg0) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public Object getAttribute(String key) {
        if ("com.sap.security.user_id".equals(key)) {
            return this._userid;
        }
        if ("j_authscheme".equals(key)) {
            return this._authscheme;
        }
        if ("$MYSAPSSO$".equals(key)) {
            return this._ticket_string;
        }
        return this._attrs.get(key);
    }

    public Enumeration getAttributeNames() {
        final Iterator it = this._attrs.keySet().iterator();
        final String user = new String(this._userid);
        final String authsc = new String(this._authscheme);
        return new Enumeration(){
            boolean _bHadUser = false;
            boolean _bHadAuthscheme = false;

            public boolean hasMoreElements() {
                if (it.hasNext()) {
                    return true;
                }
                if (!this._bHadUser) {
                    return true;
                }
                return !this._bHadAuthscheme;
            }

            public Object nextElement() {
                if (it.hasNext()) {
                    return it.next();
                }
                if (!this._bHadUser) {
                    this._bHadUser = true;
                    return user;
                }
                if (!this._bHadAuthscheme) {
                    this._bHadAuthscheme = true;
                    return authsc;
                }
                return null;
            }
        };
    }

    private void internalSetAttribute(Object key, Object value) {
        if ("com.sap.security.user_id".equals(key)) {
            this._userid = (String)value;
        } else if ("j_authscheme".equals(key)) {
            this._authscheme = (String)value;
        } else {
            this._attrs.put(key, value);
        }
    }

    private void generateTicket() throws UnsupportedEncodingException, IOException, TicketException {
        this._ticket = (Ticket)UMFactory.getInstance().getTicketVerifier();
        this._ticket.setMode(Ticket.MODE_CREATE);
        IUser user = (IUser)this._attrs.get(class$com$sap$security$api$IUser == null ? (class$com$sap$security$api$IUser = ImprSSOSession.class$("com.sap.security.api.IUser")) : class$com$sap$security$api$IUser);
        String userR3 = null;
        try {
            userR3 = UMFactory.getUserMapping().getR3UserName(user, null, null, false);
        }
        catch (UMException e) {
            _s_trace.errorT("generateTicket", "Couldn't get R/3 user name", e);
        }
        if (userR3 != null) {
            this._ticket.setUser(userR3);
        }
        InfoUnit iuUserID = new InfoUnit(32, InfoUnit.jcharToUTF8((String)("portal:" + this._userid)));
        this._ticket.addInfoUnit(iuUserID);
        if (this._authscheme != null) {
            InfoUnit iuAuthscheme = new InfoUnit(136, InfoUnit.jcharToUTF8((String)this._authscheme));
            this._ticket.addInfoUnit(iuAuthscheme);
        }
        try {
            final Ticket _t = this._ticket;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws TicketException, UnsupportedEncodingException, IOException {
                    _t.create();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception exc = pae.getException();
            if (exc instanceof TicketException) {
                throw (TicketException)((Object)exc);
            }
            if (exc instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)exc;
            }
            if (exc instanceof IOException) {
                throw (IOException)exc;
            }
            throw new RuntimeException(exc.toString());
        }
        this._ticket_string = this._ticket.getTicket();
        this._ticket.setTicket(this._ticket_string);
        this._cache.putTicket(this._ticket);
        this.addCookieToResponse();
    }

    private void addCookieToResponse() {
        StringBuffer replaced_cookie = new StringBuffer(this._ticket_string);
        int i = 0;
        while (i < replaced_cookie.length()) {
            if (replaced_cookie.charAt(i) == '+') {
                replaced_cookie.replace(i, i + 1, "%2B");
            } else if (replaced_cookie.charAt(i) == '/') {
                replaced_cookie.replace(i, i + 1, "%2F");
            } else if (replaced_cookie.charAt(i) == '=') {
                replaced_cookie.replace(i, i + 1, "%3D");
            }
            ++i;
        }
        if (UMFactory.getProperties().getBoolean("ume.logon.httponlycookie", true)) {
            replaced_cookie.append("; HttpOnly");
        }
        Cookie cookie = new Cookie("MYSAPSSO2", replaced_cookie.toString());
        cookie.setPath("/");
        String domain = UMFactory.getProperties().get("ume.logon.security.cookie_domain", SSOUtils.getSSOCookieDomain(this._request));
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(UMFactory.getProperties().getBoolean("ume.logon.security.enforce_secure_cookie", false));
        cookie.setMaxAge(-1);
        this._response.addCookie(cookie);
    }

    private boolean isTicketGenerationReady() {
        return this._userid != null && this._authscheme != null;
    }

    public void removeAttribute(String key) {
        if ("com.sap.security.user_id".equals(key)) {
            this._userid = null;
        } else if ("j_authscheme".equals(key)) {
            this._authscheme = null;
        } else {
            this._attrs.remove(key);
        }
    }

    public void invalidate() {
        this.removeCookie();
        this._cache.removeTicket(this._ticket_string);
        this._request = null;
        this._response = null;
        this._userid = null;
        this._ticket_string = null;
        this._ticket = null;
        this._attrs.clear();
        this._authscheme = null;
        this._lastAccessed = this._creationTime = System.currentTimeMillis();
    }

    private void removeCookie() {
        if (this._request != null) {
            Cookie[] cookies = this._request.getCookies();
            String domain = SSOUtils.getSSOCookieDomain(this._request);
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].getName().equals("MYSAPSSO2")) {
                        cookies[i].setMaxAge(-1);
                        cookies[i].setValue("");
                        if (domain != null) {
                            cookies[i].setDomain(domain);
                        }
                        cookies[i].setPath("/");
                        this._response.addCookie(cookies[i]);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isNew() {
        return this._ticket_string == null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return null;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

