/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.session.imp;

import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.session.imp.ICachedTicket;
import com.sap.security.core.ticket.imp.Ticket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

class ICTImpl
implements ICachedTicket {
    String _user;
    HashMap _infoUnits = new HashMap();
    long _creationTime = 0L;
    long _expiryTime = 0L;

    ICTImpl(Ticket ticket) throws TicketException {
        Enumeration e = ticket.getInfoUnits();
        while (e.hasMoreElements()) {
            InfoUnit iu = (InfoUnit)e.nextElement();
            int iIuId = iu.getID();
            if (iIuId == 255) continue;
            this._infoUnits.put("" + iIuId, iu);
        }
        try {
            this._user = ticket.getUser("portal");
            int valid_time = ticket.getInfoUnit(5).getInt();
            int valid_time_min = 0;
            if (ticket.getInfoUnit(7) != null) {
                valid_time_min = ticket.getInfoUnit(7).getInt();
            }
            int valid_time_millis = valid_time_min * 60 * 1000 + valid_time * 60 * 60 * 1000;
            this._creationTime = ticket.getExpirationDate().getTime().getTime();
            this._expiryTime = this._creationTime + (long)valid_time_millis;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new TicketException("Exception in getUser (String).");
        }
    }

    public String getUser() {
        return this._user;
    }

    public InfoUnit getInfoUnit(int id) {
        return (InfoUnit)this._infoUnits.get("" + id);
    }

    public Iterator getInfoUnits() {
        return this._infoUnits.entrySet().iterator();
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }
}

