/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.permissions;

import java.security.Permission;

public class CompanyPermission
extends Permission {
    private String _action = null;
    private String _subaction = null;

    public CompanyPermission(String companyid, String actions) {
        super(companyid);
        if (actions.indexOf(".") < 0) {
            this._action = actions;
            this._subaction = "*";
        } else {
            this._action = actions.substring(0, actions.indexOf("."));
            this._subaction = actions.substring(actions.indexOf(".") + 1);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof CompanyPermission)) {
            return false;
        }
        CompanyPermission that = (CompanyPermission)permission;
        if (!"*".equals(this.getName()) && !this.getName().equals(that.getName())) {
            return false;
        }
        if (!"*".equals(this._action) && !this._action.equals(that._action)) {
            return false;
        }
        return "*".equals(this._subaction) || this._subaction.equals(that._subaction);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompanyPermission that = (CompanyPermission)obj;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this._action.equals(that._action)) {
            return false;
        }
        return this._subaction.equals(that._subaction);
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this._action.hashCode();
    }

    public String getActions() {
        return this._action + "." + this._subaction;
    }
}

