/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.permissions;

import com.sap.security.core.role.permissions.NamePermission;
import java.security.Permission;

public class ActionPermission
extends NamePermission {
    private String _actions = null;

    public ActionPermission(String name, String actions) {
        super(name, null);
        this._actions = actions;
        if (this._actions != null && this._actions.startsWith("*")) {
            this._actions = "*";
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ActionPermission)) {
            return false;
        }
        if (!super.implies(permission)) {
            return false;
        }
        ActionPermission that = (ActionPermission)permission;
        if (that._actions == null) {
            return true;
        }
        if (this._actions == null) {
            return false;
        }
        if (this._actions.equals("*")) {
            return true;
        }
        int i = this._actions.indexOf(that._actions);
        if (i < 0) {
            return false;
        }
        if (i > 0 && this._actions.charAt(i - 1) != ',') {
            return false;
        }
        return (i += that._actions.length()) >= this._actions.length() || this._actions.charAt(i) == ',';
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ActionPermission ap = (ActionPermission)obj;
        if (this.getActions() != null) {
            return this.getActions().equals(ap.getActions());
        }
        return ap.getActions() == null;
    }

    public int hashCode() {
        if (this._actions == null) {
            return this.getName().hashCode();
        }
        return this.getName().hashCode() + this._actions.hashCode();
    }

    public String getActions() {
        return this._actions;
    }
}

