/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IAction;
import com.sap.security.core.role.IGroupDefinition;
import com.sap.security.core.role.IScopeDefinition;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.NoSuchServiceException;
import com.sap.security.core.role.imp.AllScope;
import com.sap.security.core.role.imp.GroupDefinition;
import com.sap.security.core.role.imp.RoleTemplate;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.ServiceAction;
import com.sap.security.core.role.imp.ServiceRepository;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.role.imp.xml.XMLGroupDefinition;
import com.sap.security.core.role.imp.xml.XMLRoleTemplate;
import com.sap.security.core.role.imp.xml.XMLService;
import com.sap.security.core.role.imp.xml.XMLServiceAction;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class XMLServiceRepository
extends ServiceRepository {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLServiceRepository.java#7 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLServiceRepository.java#7 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    private static final String DOM_SERVICE_ELEM = "BUSINESSSERVICE";
    private static final String DOM_CLASS_ATTR = "CLASS";
    private static final String UPTODATE_FLAG = "uptodate";
    protected static final String ROLE_FILES_FOLDER = "permission_files/";
    private static final String MULTIVALUE_SEPARATOR = ",";
    private static Map serviceMap = new HashMap();
    private static Map serviceActionMap = new HashMap();
    private static Map groupDefinitionMap = new HashMap();
    private static Map scopeDefinitionMap = new HashMap();
    private static Map initServiceMap;
    private static Map initServiceActionMap;
    private static Map initGroupDefinitionMap;
    private static Map initScopeDefinitionMap;
    private static ICache refreshCache;
    static /* synthetic */ Class class$com$sap$security$core$role$imp$xml$XMLServiceRepository;

    public IService getService(String serviceName) throws NoSuchServiceException {
        this.checkUpdateXMLFiles();
        Service service = (Service)serviceMap.get(serviceName.toLowerCase());
        if (null == service) {
            throw new NoSuchServiceException(serviceName);
        }
        return service;
    }

    public Iterator getAllServices() {
        this.checkUpdateXMLFiles();
        return serviceMap.values().iterator();
    }

    public IServiceAction getServiceActionById(String uniqueId) throws NoSuchActionException {
        this.checkUpdateXMLFiles();
        IServiceAction action = (IServiceAction)serviceActionMap.get(uniqueId);
        if (null == action) {
            throw new NoSuchActionException(uniqueId);
        }
        return action;
    }

    public IGroupDefinition getGroupDefinitionByName(String name) {
        this.checkUpdateXMLFiles();
        return (IGroupDefinition)groupDefinitionMap.get(name.toLowerCase());
    }

    public IScopeDefinition getScopeDefinitionByName(String name) {
        this.checkUpdateXMLFiles();
        return (IScopeDefinition)scopeDefinitionMap.get(name.toLowerCase());
    }

    private static Service getServiceInstance(String xmlFileName, Element rootElement, ClassLoader descriptionResourceClassLoader) throws ServiceInstantiationException {
        String className = rootElement.getAttribute(DOM_CLASS_ATTR);
        if (null == className || "".equals(className)) {
            return new XMLService(xmlFileName, rootElement, descriptionResourceClassLoader);
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (Service)clazz.newInstance();
        }
        catch (Exception ex) {
            trace.errorT("getServiceInstance(Element)", ex);
            throw new ServiceInstantiationException(className, ex);
        }
    }

    private static String[] scanDirectory(String directoryName) {
        String methodName = "scanDirectory(String)";
        trace.entering("scanDirectory(String)", new Object[]{directoryName});
        if (directoryName == null) {
            trace.warningT("scanDirectory(String)", "Directory name is null!");
            return null;
        }
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            trace.infoT("scanDirectory(String)", "Roles directory " + directoryName + " doesn't exist!");
            return null;
        }
        return directory.list();
    }

    private static String[] getXMLFileNames() {
        String methodName = "getXMLFileNames()";
        trace.entering("getXMLFileNames()");
        String xmlFileList = UMFactory.getProperties().get("ume.roles.xml_files", "*role.xml");
        if (xmlFileList == null || "".equals(xmlFileList)) {
            trace.warningT("getXMLFileNames()", "No role xml files specified!");
            return null;
        }
        StringTokenizer strt = new StringTokenizer(xmlFileList, MULTIVALUE_SEPARATOR);
        String[] allFileNames = null;
        try {
            allFileNames = UMFactory.getUMFileIO().getFiles();
        }
        catch (IOException exc) {
            trace.warningT("getXMLFileNames()", "Couldn't get the configuration files!", exc);
        }
        if (trace.beInfo()) {
            trace.infoT("getXMLFileNames()", (allFileNames != null ? allFileNames.length : 0) + " configuration files found");
        }
        HashSet<String> xmlFiles = new HashSet<String>();
        while (strt.hasMoreTokens()) {
            String fileName = strt.nextToken().trim();
            if (fileName.startsWith("*")) {
                if (allFileNames == null) continue;
                fileName = fileName.substring(1).toLowerCase();
                int i = 0;
                while (i < allFileNames.length) {
                    if (allFileNames[i].toLowerCase().endsWith(fileName)) {
                        xmlFiles.add(allFileNames[i]);
                    }
                    ++i;
                }
                continue;
            }
            xmlFiles.add(fileName);
        }
        int i = 0;
        while (i < allFileNames.length) {
            if (allFileNames[i].toLowerCase().startsWith(ROLE_FILES_FOLDER)) {
                trace.infoT("getXMLFileNames()", "found role XML file: " + allFileNames[i]);
                xmlFiles.add(allFileNames[i]);
            }
            ++i;
        }
        int size = xmlFiles.size();
        trace.exiting("getXMLFileNames()", size + " role XML files found");
        return xmlFiles.toArray(new String[size]);
    }

    private static void parseXMLFile(String directory, String xmlFileName, ClassLoader descriptionResourceClassLoader) throws UMException {
        String methodName = "parseXMLFile(String,String,ClassLoader)";
        String xmlExtension = ".xml";
        int index = xmlFileName.length() - ".xml".length();
        if (index <= 0 || !xmlFileName.substring(index).equalsIgnoreCase(".xml")) {
            return;
        }
        try {
            DocumentBuilderFactory factory;
            InputStream xmlStream = null;
            if (directory != null) {
                xmlStream = new FileInputStream(new File(directory, xmlFileName));
                if (trace.beDebug()) {
                    trace.debugT("parseXMLFile(String,String,ClassLoader)", "Found file: " + directory + '/' + xmlFileName);
                }
            } else {
                xmlStream = UMFactory.getUMFileIO().readFile(xmlFileName);
                if (xmlStream == null) {
                    throw new UMRuntimeException(xmlFileName + " not found!");
                }
                if (trace.beDebug()) {
                    trace.debugT("parseXMLFile(String,String,ClassLoader)", "Got file " + xmlFileName + " from persistence folder");
                }
            }
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            ClassLoader mine = (class$com$sap$security$core$role$imp$xml$XMLServiceRepository == null ? (class$com$sap$security$core$role$imp$xml$XMLServiceRepository = XMLServiceRepository.class$("com.sap.security.core.role.imp.xml.XMLServiceRepository")) : class$com$sap$security$core$role$imp$xml$XMLServiceRepository).getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(mine);
                factory = DocumentBuilderFactory.newInstance();
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(current);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                Thread.currentThread().setContextClassLoader(current);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document domDocument = builder.parse(xmlStream);
            Element rootElement = domDocument.getDocumentElement();
            if (null == rootElement || !DOM_SERVICE_ELEM.equals(rootElement.getNodeName())) {
                trace.warningT("parseXMLFile(String,String,ClassLoader)", "File \"" + xmlFileName + "\" is not a proper access control file!");
                return;
            }
            Service service = XMLServiceRepository.getServiceInstance(xmlFileName, rootElement, descriptionResourceClassLoader);
            if (initServiceMap.containsKey(service.getName().toLowerCase())) {
                throw new UMException("Service \"" + service + "\" already exists!");
            }
            initServiceMap.put(service.getName().toLowerCase(), service);
            Iterator groupDefinitionIter = service.getGroupDefinitions();
            while (groupDefinitionIter.hasNext()) {
                IGroupDefinition groupDef = (IGroupDefinition)groupDefinitionIter.next();
                IGroupDefinition oldGroupDef = initGroupDefinitionMap.put(groupDef.getName().toLowerCase(), groupDef);
                if (null == oldGroupDef) continue;
                throw new UMException("Group definition with name \"" + groupDef.getName() + "\" already exists!");
            }
            Iterator scopeDefinitionIter = service.getScopeDefinitions();
            while (scopeDefinitionIter.hasNext()) {
                IScopeDefinition scopeDef = (IScopeDefinition)scopeDefinitionIter.next();
                IScopeDefinition oldScopeDef = initScopeDefinitionMap.put(scopeDef.getName().toLowerCase(), scopeDef);
                if (null == oldScopeDef) continue;
                throw new UMException("Scope definition with name \"" + scopeDef.getName() + "\" already exists!");
            }
            Iterator actionIter = service.getServiceActions();
            while (actionIter.hasNext()) {
                IAction action = (IAction)actionIter.next();
                IAction oldAction = initServiceActionMap.put(action.getUniqueID(), action);
                if (null == oldAction) continue;
                throw new UMException("Service action with id \"" + action.getUniqueID() + "\" already exists!");
            }
            xmlStream.close();
        }
        catch (SAXParseException ex) {
            trace.errorT("parseXMLFile(String,String,ClassLoader)", "SAX parse error in file " + xmlFileName + " at line " + ex.getLineNumber() + ", col " + ex.getColumnNumber() + "!", ex);
        }
        catch (Exception ex) {
            trace.errorT("parseXMLFile(String,String,ClassLoader)", "Scaning file \"" + xmlFileName + "\" failed!", ex);
        }
    }

    private static void checkXMLFile(String xmlFileName, InputStream xmlStream) throws UMException {
        String methodName = "checkXMLFile(String,InputStream)";
        trace.entering("checkXMLFile(String,InputStream)");
        try {
            DocumentBuilderFactory factory;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            ClassLoader mine = (class$com$sap$security$core$role$imp$xml$XMLServiceRepository == null ? (class$com$sap$security$core$role$imp$xml$XMLServiceRepository = XMLServiceRepository.class$("com.sap.security.core.role.imp.xml.XMLServiceRepository")) : class$com$sap$security$core$role$imp$xml$XMLServiceRepository).getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(mine);
                factory = DocumentBuilderFactory.newInstance();
                Object var7_10 = null;
                Thread.currentThread().setContextClassLoader(current);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                Thread.currentThread().setContextClassLoader(current);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document domDocument = builder.parse(xmlStream);
            Element rootElement = domDocument.getDocumentElement();
            if (null == rootElement || !DOM_SERVICE_ELEM.equals(rootElement.getNodeName())) {
                throw new UMException("The file \"" + xmlFileName + "\" is not a proper access control file!");
            }
            Service service = XMLServiceRepository.getServiceInstance(ROLE_FILES_FOLDER + xmlFileName, rootElement, null);
            if (initServiceMap.containsKey(service.getName().toLowerCase())) {
                String[] filenames = UMFactory.getUMFileIO().getFiles();
                int i = 0;
                while (i < filenames.length) {
                    if (filenames[i].equals(xmlFileName)) {
                        trace.infoT("checkXMLFile(String,InputStream)", "Actions XML file already exists -> will be overwritten!");
                        return;
                    }
                    if (filenames[i].equalsIgnoreCase(service.getName() + "role.xml")) {
                        UMFactory.getUMFileIO().deleteFile(filenames[i]);
                        trace.infoT("checkXMLFile(String,InputStream)", "Old role XML file with the same service name existed -> was removed!");
                        return;
                    }
                    ++i;
                }
                throw new UMException("Service \"" + service + "\" already exists!");
            }
            Iterator groupDefinitionIter = service.getGroupDefinitions();
            while (groupDefinitionIter.hasNext()) {
                IGroupDefinition groupDef = (IGroupDefinition)groupDefinitionIter.next();
                if (!initGroupDefinitionMap.containsKey(groupDef.getName().toLowerCase())) continue;
                throw new UMException("Group definition with name \"" + groupDef.getName() + "\" already exists!");
            }
            Iterator scopeDefinitionIter = service.getScopeDefinitions();
            while (scopeDefinitionIter.hasNext()) {
                IScopeDefinition scopeDef = (IScopeDefinition)scopeDefinitionIter.next();
                if (!initScopeDefinitionMap.containsKey(scopeDef.getName().toLowerCase())) continue;
                throw new UMException("Scope definition with name \"" + scopeDef.getName() + "\" already exists!");
            }
            Iterator actionIter = service.getServiceActions();
            while (actionIter.hasNext()) {
                IAction action = (IAction)actionIter.next();
                if (!initServiceActionMap.containsKey(action.getUniqueID())) continue;
                throw new UMException("Service action with id \"" + action.getUniqueID() + "\" already exists!");
            }
        }
        catch (SAXParseException ex) {
            String msg = "SAX parse error in file " + xmlFileName + " at line " + ex.getLineNumber() + ", col " + ex.getColumnNumber() + "!";
            trace.errorT("checkXMLFile(String,InputStream)", msg, ex);
            throw new UMException((Throwable)ex, msg);
        }
        catch (Exception ex) {
            String msg = "Scaning file \"" + xmlFileName + "\" failed!";
            trace.errorT("checkXMLFile(String,InputStream)", msg, ex);
            throw new UMException((Throwable)ex, msg);
        }
    }

    protected static void createDescriptionFile(File directory, String descriptionResourceBaseName, IService service) throws Exception {
        Locale enlocale = new Locale("en", "");
        File propFile = new File(directory, descriptionResourceBaseName + ".properties");
        propFile.createNewFile();
        FileOutputStream stream = new FileOutputStream(propFile);
        PrintWriter writer = new PrintWriter(stream);
        if (service instanceof XMLService) {
            XMLService xmlService = (XMLService)service;
            writer.println(xmlService.getResourceKey() + "=" + xmlService.getDescription(enlocale));
            Iterator iter = service.getGroupDefinitions();
            while (iter.hasNext()) {
                GroupDefinition group = (GroupDefinition)iter.next();
                if (!(group instanceof XMLGroupDefinition)) continue;
                XMLGroupDefinition xmlGroup = (XMLGroupDefinition)group;
                writer.println(xmlGroup.getResourceKey() + "=" + xmlGroup.getDescription(enlocale));
            }
            iter = service.getRoleTemplates();
            while (iter.hasNext()) {
                RoleTemplate role = (RoleTemplate)iter.next();
                if (!(role instanceof XMLRoleTemplate)) continue;
                XMLRoleTemplate xmlRole = (XMLRoleTemplate)role;
                writer.println(xmlRole.getResourceKey() + "=" + xmlRole.getDescription(enlocale));
            }
            iter = service.getServiceActions();
            while (iter.hasNext()) {
                ServiceAction action = (ServiceAction)iter.next();
                if (!(action instanceof XMLServiceAction)) continue;
                XMLServiceAction xmlAction = (XMLServiceAction)action;
                writer.println(xmlAction.getResourceKey() + "=" + xmlAction.getDescription(enlocale));
            }
        }
        writer.flush();
        writer.close();
    }

    private void checkUpdateXMLFiles() {
        if (refreshCache != null && refreshCache.get(UPTODATE_FLAG) == null) {
            trace.infoT("checkUpdateXMLFiles()", "Role XML files need to be reloaded!");
            XMLServiceRepository.loadXMLFiles(false);
            refreshCache.put(UPTODATE_FLAG, new Boolean(true));
        }
    }

    public void deployXMLFile(String name, InputStream xmlFileStream) {
        String methodName = "deployXMLFile(String,InputStream)";
        try {
            trace.infoT("deployXMLFile(String,InputStream)", "Deploying role XML file " + name);
            UMFactory.getUMFileIO().writeFile(name, xmlFileStream);
            XMLServiceRepository.loadXMLFiles();
        }
        catch (IOException exc) {
            trace.errorT("deployXMLFile(String,InputStream)", "Deployment of XML file wasn't successful!", exc);
        }
    }

    public void undeployXMLFile(String name) {
        String methodName = "undeployXMLFile(String)";
        try {
            trace.infoT("undeployXMLFile(String)", "Undeploying role XML file " + name);
            UMFactory.getUMFileIO().deleteFile(name);
            XMLServiceRepository.loadXMLFiles();
        }
        catch (IOException exc) {
            trace.errorT("undeployXMLFile(String)", "Undeployment of XML file wasn't successful!", exc);
        }
    }

    public static void deployActionsFile(String componentName, InputStream xmlFileStream) {
        String methodName = "deployXMLFile(String,InputStream)";
        if (componentName == null || xmlFileStream == null) {
            return;
        }
        try {
            trace.infoT("deployXMLFile(String,InputStream)", "Deploying Actions XML file for application " + componentName);
            if (!componentName.toLowerCase().endsWith(".xml")) {
                componentName = componentName + ".xml";
            }
            UMFactory.getUMFileIO().writeFile(ROLE_FILES_FOLDER + componentName, xmlFileStream);
            XMLServiceRepository.loadXMLFiles();
        }
        catch (IOException exc) {
            trace.errorT("deployXMLFile(String,InputStream)", "Deployment of XML file wasn't successful!", exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deployActionsXMLFile(String componentName, InputStream xmlFileStream) throws UMException {
        String methodName = "deployXMLFile(String,InputStream)";
        if (componentName == null || xmlFileStream == null) {
            throw new UMException("componentName and xmlFileStream must not be null!");
        }
        try {
            int element;
            trace.infoT("deployXMLFile(String,InputStream)", "Deploying Actions XML file for application " + componentName);
            if (!componentName.toLowerCase().endsWith(".xml")) {
                componentName = componentName + ".xml";
            }
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            while ((element = xmlFileStream.read()) != -1) {
                void var4_5;
                oStream.write((int)var4_5);
            }
            byte[] xmlFileArray = oStream.toByteArray();
            XMLServiceRepository.checkXMLFile(ROLE_FILES_FOLDER + componentName, new ByteArrayInputStream(xmlFileArray));
            UMFactory.getUMFileIO().writeFile(ROLE_FILES_FOLDER + componentName, (InputStream)new ByteArrayInputStream(xmlFileArray));
            XMLServiceRepository.loadXMLFiles();
        }
        catch (IOException exc) {
            trace.errorT("deployXMLFile(String,InputStream)", "Deployment of XML file wasn't successful!", exc);
            throw new UMException((Throwable)exc, "Deployment of XML file wasn't successful!");
        }
    }

    public static void undeployActionsFile(String componentName) {
        String methodName = "undeployXMLFile(String)";
        try {
            trace.infoT("undeployXMLFile(String)", "Undeploying Actions XML file for application " + componentName);
            if (!componentName.toLowerCase().endsWith(".xml")) {
                componentName = componentName + ".xml";
            }
            UMFactory.getUMFileIO().deleteFile(ROLE_FILES_FOLDER + componentName);
            XMLServiceRepository.loadXMLFiles();
        }
        catch (IOException exc) {
            trace.errorT("undeployXMLFile(String)", "Undeployment of XML file wasn't successful!", exc);
        }
    }

    public static boolean loadXMLFiles() {
        boolean success = XMLServiceRepository.loadXMLFiles(false);
        if (success && refreshCache != null) {
            refreshCache.put(UPTODATE_FLAG, new Boolean(true));
            trace.infoT("loadXMLFiles()", "Updated cache entry -> send notification");
        }
        return success;
    }

    private static boolean loadXMLFiles(boolean initialLoading) {
        String methodName = "loadXMLFiles(boolean)";
        if (trace.bePath()) {
            trace.entering("loadXMLFiles(boolean)", new Object[]{new Boolean(initialLoading)});
        }
        initServiceMap = new HashMap();
        initServiceActionMap = new HashMap();
        initGroupDefinitionMap = new HashMap();
        initScopeDefinitionMap = new HashMap();
        initScopeDefinitionMap.put(AllScope.getInstance().getName().toLowerCase(), AllScope.getInstance());
        boolean status = true;
        String rolesDir = null;
        String[] filenames = null;
        filenames = XMLServiceRepository.getXMLFileNames();
        if (null == filenames && null == (filenames = XMLServiceRepository.scanDirectory(rolesDir = UMFactory.getProperties().getFile("ume.roles.directory", "roles")))) {
            if (initialLoading) {
                trace.logFatalT("No UME role XML files found, No Java Permissions will be available!", null);
            } else {
                trace.errorT("loadXMLFiles(boolean)", "No role XML files found -> Old action and role definitions will be kept!");
            }
        }
        ClassLoader descriptionResourceClassLoader = null;
        if (filenames != null && filenames.length > 0) {
            int i = 0;
            while (i < filenames.length) {
                try {
                    XMLServiceRepository.parseXMLFile(rolesDir, filenames[i], descriptionResourceClassLoader);
                }
                catch (UMException ex) {
                    if (initialLoading) {
                        trace.errorT("loadXMLFiles(boolean)", "Initialization failed for file : " + filenames[i], ex);
                    } else {
                        trace.errorT("loadXMLFiles(boolean)", "Reload of role xml files failed for: " + filenames[i], ex);
                    }
                    trace.logErrorT("The role XML file {0} is not valid!", new Object[]{filenames[i]});
                    status = false;
                }
                ++i;
            }
            serviceMap = initServiceMap;
            serviceActionMap = initServiceActionMap;
            groupDefinitionMap = initGroupDefinitionMap;
            scopeDefinitionMap = initScopeDefinitionMap;
        }
        trace.exiting("loadXMLFiles(boolean)", new Boolean(status));
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            refreshCache = InternalUMFactory.getCache(0, 1, -1, (class$com$sap$security$core$role$imp$xml$XMLServiceRepository == null ? (class$com$sap$security$core$role$imp$xml$XMLServiceRepository = XMLServiceRepository.class$("com.sap.security.core.role.imp.xml.XMLServiceRepository")) : class$com$sap$security$core$role$imp$xml$XMLServiceRepository).getName());
            refreshCache.put(UPTODATE_FLAG, new Boolean(true));
            trace.infoT("static{}", "Initialization of refreshCache successful");
        }
        catch (UMRuntimeException exc) {
            refreshCache = null;
            trace.errorT("static{}", "Initialization of refreshCache failed. No notification for XML files refresh will be available!", exc);
        }
        XMLServiceRepository.loadXMLFiles(true);
    }
}

