/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.PermissionData;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.ServiceAction;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.role.imp.xml.XMLDescriptionElement;
import com.sap.security.core.role.imp.xml.XMLDescriptionLocaleString;
import com.sap.security.core.role.imp.xml.XMLService;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.LocaleString;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLServiceAction
extends ServiceAction
implements XMLDescriptionElement {
    private String name;
    private String uniqueId;
    private String accessScope;
    private LocaleString description;
    private List permissionData = new ArrayList();
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLServiceAction.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLServiceAction.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private static final String DOM_NAME_ATTR = "NAME";
    private static final String DOM_ID_ATTR = "ID";
    private static final String DOM_SCOPE_ATTR = "SCOPE";
    private static final String DOM_PERMISSION_ELEM = "PERMISSION";
    private static final String DOM_CLASS_ATTR = "CLASS";
    private static final String DOM_VALUE_ATTR = "VALUE";
    private static final Class[] SERVICEACTION_ARGS = new Class[]{class$com$sap$security$core$role$imp$Service == null ? (class$com$sap$security$core$role$imp$Service = XMLServiceAction.class$("com.sap.security.core.role.imp.Service")) : class$com$sap$security$core$role$imp$Service};
    static /* synthetic */ Class class$com$sap$security$core$role$imp$Service;

    private XMLServiceAction(Service service, Element xmlElement) throws ServiceInstantiationException {
        super(service);
        String optionalId;
        this.name = xmlElement.getAttribute(DOM_NAME_ATTR);
        if (null == this.name || "".equals(this.name)) {
            throw new ServiceInstantiationException(service, "Service action name missing");
        }
        this.accessScope = xmlElement.getAttribute(DOM_SCOPE_ATTR);
        if (null == this.accessScope || "".equals(this.accessScope)) {
            this.accessScope = "all";
        }
        this.uniqueId = null == (optionalId = xmlElement.getAttribute(DOM_ID_ATTR)) || "".equals(optionalId) ? this.getDefaultUniqueID() : optionalId;
        this.description = new XMLDescriptionLocaleString(this, xmlElement);
        NodeList nodeList = xmlElement.getElementsByTagName(DOM_PERMISSION_ELEM);
        int k = 0;
        while (k < nodeList.getLength()) {
            this.addPermission((Element)nodeList.item(k));
            ++k;
        }
        trace.infoT("XMLServiceAction(Service,Element)", this.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getAccessScope() {
        return this.accessScope;
    }

    public String getUniqueID() {
        return this.uniqueId;
    }

    public String getDescription(Locale locale) {
        return ((XMLService)this.getService()).getDescription(this, locale);
    }

    public final LocaleString getLocaleString() {
        return this.description;
    }

    public final String getResourceKey() {
        return "ACTION." + this.getName().replace(' ', '_');
    }

    public Iterator getPermissions() {
        trace.entering("getPermissions()", new Object[]{this});
        return this.permissionData.iterator();
    }

    private void addPermission(Element element) throws ServiceInstantiationException {
        String clazz = element.getAttribute(DOM_CLASS_ATTR);
        if (null == clazz || "".equals(clazz)) {
            throw new ServiceInstantiationException(this, "Permission class missing");
        }
        String name = element.getAttribute(DOM_NAME_ATTR);
        if (null == name || "".equals(name)) {
            throw new ServiceInstantiationException(this, "Permission name missing");
        }
        String value = element.getAttribute(DOM_VALUE_ATTR);
        this.permissionData.add(new PermissionData(clazz, name, value));
    }

    protected static ServiceAction getInstance(Service service, Element xmlElement) throws ServiceInstantiationException {
        String className = xmlElement.getAttribute(DOM_CLASS_ATTR);
        if (null == className || "".equals(className)) {
            return new XMLServiceAction(service, xmlElement);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(SERVICEACTION_ARGS);
            return (ServiceAction)constructor.newInstance(service);
        }
        catch (Exception ex) {
            trace.errorT("getInstance(Service,Element)", ex);
            throw new ServiceInstantiationException(className, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

