/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.imp.GroupDefinition;
import com.sap.security.core.role.imp.RoleTemplate;
import com.sap.security.core.role.imp.ScopeDefinition;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.ServiceAction;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.role.imp.xml.XMLDescriptionElement;
import com.sap.security.core.role.imp.xml.XMLDescriptionLocaleString;
import com.sap.security.core.role.imp.xml.XMLGroupDefinition;
import com.sap.security.core.role.imp.xml.XMLRoleTemplate;
import com.sap.security.core.role.imp.xml.XMLScopeDefinition;
import com.sap.security.core.role.imp.xml.XMLServiceAction;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.LocaleString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLService
extends Service
implements XMLDescriptionElement {
    private String name;
    private Map serviceActionMap;
    private Map roleTemplateMap;
    private Map groupDefinitionMap;
    private Map scopeDefinitionMap;
    private LocaleString descriptionLocaleString;
    private ClassLoader descriptionResourceClassLoader;
    private String descriptionResourceBaseName;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLService.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLService.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private static final String DOM_NAME_ATTR = "NAME";
    private static final String DOM_DESCRIPTION_ATTR = "DESCRIPTION_RESOURCE_BASE_NAME";
    private static final String DOM_ACTION_ELEM = "ACTION";
    private static final String DOM_ROLE_ELEM = "ROLE";
    private static final String DOM_GROUP_ELEM = "GROUP";
    private static final String DOM_SCOPE_ELEM = "SCOPE";

    public XMLService(Element xmlElement) throws ServiceInstantiationException {
        this.init(null, xmlElement, null);
        trace.infoT("XMLService(Element)", this.toString());
    }

    public XMLService(String xmlFileName, Element xmlElement, ClassLoader descriptionResourceClassLoader) throws ServiceInstantiationException {
        this.init(xmlFileName, xmlElement, descriptionResourceClassLoader);
        trace.infoT("XMLService(Element,ResourceBundle)", this.toString());
    }

    public String getName() {
        return this.name;
    }

    public final LocaleString getLocaleString() {
        return this.descriptionLocaleString;
    }

    public final String getResourceKey() {
        return "SERVICE";
    }

    public String getDescription(Locale locale) {
        return this.getDescription(this, locale);
    }

    public IServiceAction getServiceAction(String actionName) throws NoSuchActionException {
        ServiceAction action = (ServiceAction)this.serviceActionMap.get(actionName.toLowerCase());
        if (null == action) {
            throw new NoSuchActionException(this, actionName);
        }
        return action;
    }

    public Iterator getServiceActions() {
        return this.serviceActionMap.values().iterator();
    }

    public Iterator getGroupDefinitions() {
        return this.groupDefinitionMap.values().iterator();
    }

    public Iterator getScopeDefinitions() {
        return this.scopeDefinitionMap.values().iterator();
    }

    public Iterator getRoleTemplates() {
        return this.roleTemplateMap.values().iterator();
    }

    protected String getDescription(XMLDescriptionElement descriptionElement, Locale locale) {
        try {
            if (null != this.descriptionResourceBaseName) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.descriptionResourceBaseName, locale, this.descriptionResourceClassLoader);
                return resourceBundle.getString(descriptionElement.getResourceKey());
            }
            return descriptionElement.getLocaleString().get(locale);
        }
        catch (MissingResourceException ex) {
            trace.debugT("getDescription", ex);
            return descriptionElement.getName();
        }
    }

    private void init(String xmlFileName, Element xmlElement, ClassLoader descriptionResourceClassLoader) throws ServiceInstantiationException {
        String methodName = "init(Element,ClassLoader)";
        this.name = xmlElement.getAttribute(DOM_NAME_ATTR);
        if (null == this.name || "".equals(this.name)) {
            this.name = this.getServiceName(xmlFileName);
            if (null == this.name) {
                throw new ServiceInstantiationException(this, "Service name missing");
            }
            trace.infoT("init(Element,ClassLoader)", "Got BS name from xml file name: " + this.name);
        }
        this.descriptionResourceBaseName = xmlElement.getAttribute(DOM_DESCRIPTION_ATTR);
        if (null == this.descriptionResourceBaseName || "".equals(this.descriptionResourceBaseName)) {
            this.descriptionResourceBaseName = null;
            trace.infoT("init(Element,ClassLoader)", "No description resource base name defined", new Object[]{this});
        }
        this.descriptionResourceClassLoader = null == descriptionResourceClassLoader ? this.getClass().getClassLoader() : descriptionResourceClassLoader;
        this.descriptionLocaleString = new XMLDescriptionLocaleString(this, xmlElement);
        NodeList nodeList = xmlElement.getElementsByTagName(DOM_ACTION_ELEM);
        this.serviceActionMap = new HashMap(nodeList.getLength());
        int k = 0;
        while (k < nodeList.getLength()) {
            ServiceAction serviceAction = XMLServiceAction.getInstance(this, (Element)nodeList.item(k));
            if (this.serviceActionMap.containsKey(serviceAction.getName().toLowerCase())) {
                throw new ServiceInstantiationException(serviceAction, "Service action already exists!");
            }
            this.serviceActionMap.put(serviceAction.getName().toLowerCase(), serviceAction);
            ++k;
        }
        nodeList = xmlElement.getElementsByTagName(DOM_GROUP_ELEM);
        this.groupDefinitionMap = new HashMap(nodeList.getLength());
        int k2 = 0;
        while (k2 < nodeList.getLength()) {
            Element groupDefinitionElement = (Element)nodeList.item(k2);
            XMLGroupDefinition groupDefinition = new XMLGroupDefinition(this, groupDefinitionElement);
            if (this.groupDefinitionMap.containsKey(((GroupDefinition)groupDefinition).getName().toLowerCase())) {
                throw new ServiceInstantiationException(groupDefinition, "Group definition already exists!");
            }
            this.groupDefinitionMap.put(((GroupDefinition)groupDefinition).getName().toLowerCase(), groupDefinition);
            ++k2;
        }
        nodeList = xmlElement.getElementsByTagName(DOM_SCOPE_ELEM);
        this.scopeDefinitionMap = new HashMap(nodeList.getLength());
        int k3 = 0;
        while (k3 < nodeList.getLength()) {
            Element scopeDefinitionElement = (Element)nodeList.item(k3);
            XMLScopeDefinition scopeDefinition = new XMLScopeDefinition(this, scopeDefinitionElement);
            if (this.scopeDefinitionMap.containsKey(((ScopeDefinition)scopeDefinition).getName().toLowerCase())) {
                throw new ServiceInstantiationException(scopeDefinition, "Scope definition already exists!");
            }
            this.scopeDefinitionMap.put(((ScopeDefinition)scopeDefinition).getName().toLowerCase(), scopeDefinition);
            ++k3;
        }
        nodeList = xmlElement.getElementsByTagName(DOM_ROLE_ELEM);
        this.roleTemplateMap = new HashMap(nodeList.getLength());
        int k4 = 0;
        while (k4 < nodeList.getLength()) {
            RoleTemplate roleTemplate = XMLRoleTemplate.getInstance(this, (Element)nodeList.item(k4));
            if (this.roleTemplateMap.containsKey(roleTemplate.getName().toLowerCase())) {
                throw new ServiceInstantiationException(roleTemplate, "Role template already exists!");
            }
            this.roleTemplateMap.put(roleTemplate.getName().toLowerCase(), roleTemplate);
            ++k4;
        }
    }

    private String getServiceName(String xmlFileName) {
        int index;
        if (xmlFileName != null && (index = xmlFileName.length() - 4) > 0 && xmlFileName.startsWith("permission_files/")) {
            return xmlFileName.substring("permission_files/".length(), index);
        }
        return null;
    }
}

