/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IGroupDefinition;
import com.sap.security.core.role.imp.ScopeDefinition;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.util.IUMTrace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLScopeDefinition
extends ScopeDefinition {
    private String name;
    private Set groupNames;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLScopeDefinition.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLScopeDefinition.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final String DOM_NAME_ATTR = "NAME";
    private static final String DOM_ASSIGNEDGROUP_ELEM = "ASSIGNEDGROUP";

    public XMLScopeDefinition(Service service, Element xmlElement) throws ServiceInstantiationException {
        this.name = xmlElement.getAttribute(DOM_NAME_ATTR);
        if (null == this.name || "".equals(this.name)) {
            throw new ServiceInstantiationException(service, "Scope name missing");
        }
        NodeList nodeList = xmlElement.getElementsByTagName(DOM_ASSIGNEDGROUP_ELEM);
        this.groupNames = new HashSet();
        int k = 0;
        while (k < nodeList.getLength()) {
            Element groupNameElement = (Element)nodeList.item(k);
            String groupName = groupNameElement.getAttribute(DOM_NAME_ATTR);
            if (null == groupName || "".equals(groupName)) {
                throw new ServiceInstantiationException(this, "Assigned group name missing");
            }
            if (!this.groupNames.add(groupName.toLowerCase())) {
                trace.warningT("XMLScopeDefinition(Service,Element)", "Group already assigned", new Object[]{this, groupName});
            }
            ++k;
        }
        trace.infoT("XMLScopeDefinition(Service,Element)", this.toString());
    }

    public String getName() {
        return this.name;
    }

    public boolean impliesGroup(IGroupDefinition group) {
        trace.entering("impliesGroup(IGroupDefinition)", new Object[]{this, group});
        if (null == group) {
            return false;
        }
        return this.groupNames.contains(group.getName().toLowerCase());
    }

    public void print() {
        System.out.println("ScopeDefinition: " + this.getName());
        Iterator iter = this.groupNames.iterator();
        if (iter.hasNext()) {
            System.out.print("  assigned groups:");
            while (iter.hasNext()) {
                System.out.print(" " + iter.next());
            }
            System.out.println();
        }
    }
}

