/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.imp.RoleTemplate;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.role.imp.xml.XMLDescriptionElement;
import com.sap.security.core.role.imp.xml.XMLDescriptionLocaleString;
import com.sap.security.core.role.imp.xml.XMLService;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.LocaleString;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLRoleTemplate
extends RoleTemplate
implements XMLDescriptionElement {
    private String name;
    private String accessScope;
    private LocaleString description;
    private Set serviceActionSet;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLRoleTemplate.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLRoleTemplate.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private static final String DOM_NAME_ATTR = "NAME";
    private static final String DOM_SCOPE_ATTR = "SCOPE";
    private static final String DOM_CLASS_ATTR = "CLASS";
    private static final String DOM_ASSIGNEDACTION_ELEM = "ASSIGNEDACTION";

    public XMLRoleTemplate(Service service, Element xmlElement) throws ServiceInstantiationException {
        super(service);
        this.name = xmlElement.getAttribute(DOM_NAME_ATTR);
        if (null == this.name || "".equals(this.name)) {
            throw new ServiceInstantiationException(service, "Role template name missing");
        }
        this.accessScope = xmlElement.getAttribute(DOM_SCOPE_ATTR);
        if (null == this.accessScope || "".equals(this.accessScope)) {
            this.accessScope = "all";
        }
        this.description = new XMLDescriptionLocaleString(this, xmlElement);
        NodeList nodeList = xmlElement.getElementsByTagName(DOM_ASSIGNEDACTION_ELEM);
        this.serviceActionSet = new HashSet(nodeList.getLength());
        int k = 0;
        while (k < nodeList.getLength()) {
            Element actionElement = (Element)nodeList.item(k);
            String actionName = actionElement.getAttribute(DOM_NAME_ATTR);
            if (null == actionName || "".equals(actionName)) {
                throw new ServiceInstantiationException(this, "Action name missing");
            }
            try {
                IServiceAction serviceAction = this.getService().getServiceAction(actionName);
                this.serviceActionSet.add(serviceAction);
            }
            catch (NoSuchActionException ex) {
                throw new ServiceInstantiationException(this, "Action " + actionName + " not existing");
            }
            ++k;
        }
        trace.infoT("XMLRoleTemplate(Service,Element)", this.toString());
    }

    public String getName() {
        return this.name;
    }

    public Iterator getServiceActions() {
        return this.serviceActionSet.iterator();
    }

    public final LocaleString getLocaleString() {
        return this.description;
    }

    public final String getResourceKey() {
        return "ROLE." + this.getName().replace(' ', '_');
    }

    public String getDescription(Locale locale) {
        return ((XMLService)this.getService()).getDescription(this, locale);
    }

    public String getAccessScope() {
        return this.accessScope;
    }

    protected static RoleTemplate getInstance(Service service, Element xmlElement) throws ServiceInstantiationException {
        String className = xmlElement.getAttribute(DOM_CLASS_ATTR);
        if (null == className || "".equals(className)) {
            return new XMLRoleTemplate(service, xmlElement);
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (RoleTemplate)clazz.newInstance();
        }
        catch (Exception ex) {
            trace.errorT("getInstance(Service,Element)", ex);
            throw new ServiceInstantiationException(className, ex);
        }
    }
}

