/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp.xml;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.imp.GroupDefinition;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.role.imp.xml.ServiceInstantiationException;
import com.sap.security.core.role.imp.xml.XMLDescriptionElement;
import com.sap.security.core.role.imp.xml.XMLDescriptionLocaleString;
import com.sap.security.core.role.imp.xml.XMLService;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.LocaleString;
import java.util.Locale;
import org.w3c.dom.Element;

public class XMLGroupDefinition
extends GroupDefinition
implements XMLDescriptionElement {
    private final String name;
    private final LocaleString description;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLGroupDefinition.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/xml/XMLGroupDefinition.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final String DOM_NAME_ATTR = "NAME";

    public XMLGroupDefinition(Service service, Element xmlElement) throws ServiceInstantiationException {
        super(service);
        this.name = xmlElement.getAttribute(DOM_NAME_ATTR);
        if (null == this.name || "".equals(this.name)) {
            throw new ServiceInstantiationException(service, "Group name missing");
        }
        this.description = new XMLDescriptionLocaleString(this, xmlElement);
        trace.infoT("XMLGroupDefinition(Service,Element)", this.toString());
    }

    public String getName() {
        return this.name;
    }

    public final LocaleString getLocaleString() {
        return this.description;
    }

    public final String getResourceKey() {
        return "GROUP." + this.getName().replace(' ', '_');
    }

    public String getDescription(Locale locale) {
        return ((XMLService)this.getService()).getDescription(this, locale);
    }
}

