/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp;

import com.sap.security.api.IUser;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IGroupDefinition;
import com.sap.security.core.role.IScopeDefinition;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.IServiceRepository;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.NoSuchServiceException;
import com.sap.security.core.role.imp.AllScope;
import com.sap.security.core.role.imp.ServiceActionIterator;
import com.sap.security.core.util.IUMTrace;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ServiceRepository
implements IServiceRepository {
    private Map companyIdGroupDefinitionMap;
    private Map groupDefinitionMap;
    private Map scopeDefinitionMap;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/ServiceRepository.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    public static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/ServiceRepository.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");

    public final Iterator getAllServiceActions() {
        return new ServiceActionIterator(this.getAllServices());
    }

    public final Iterator getAllGroupDefinitions() {
        return new GroupDefinitionIterator(this.getAllServices());
    }

    public IGroupDefinition getGroupDefinitionByName(String name) {
        if (trace.bePath()) {
            trace.entering("getGroupDefinitionByName(String)", new Object[]{name});
        }
        if (null == this.groupDefinitionMap) {
            trace.debugT("getGroupDefinitionByName(String)", "Initialzing map");
            this.groupDefinitionMap = new HashMap();
            Iterator serviceIter = this.getAllServices();
            while (serviceIter.hasNext()) {
                IService service = (IService)serviceIter.next();
                Iterator groupIter = service.getGroupDefinitions();
                while (groupIter.hasNext()) {
                    IGroupDefinition group = (IGroupDefinition)groupIter.next();
                    this.groupDefinitionMap.put(group.getName().toLowerCase(), group);
                }
            }
        }
        return (IGroupDefinition)this.groupDefinitionMap.get(name.toLowerCase());
    }

    public IScopeDefinition getScopeDefinitionByName(String name) {
        if (trace.bePath()) {
            trace.entering("getScopeDefinitionByName(String)", new Object[]{name});
        }
        if (null == this.scopeDefinitionMap) {
            trace.debugT("getScopeDefinitionByName(String)", "Initialzing map");
            this.scopeDefinitionMap = new HashMap();
            Iterator serviceIter = this.getAllServices();
            while (serviceIter.hasNext()) {
                IService service = (IService)serviceIter.next();
                Iterator scopeIter = service.getScopeDefinitions();
                while (scopeIter.hasNext()) {
                    IScopeDefinition scope = (IScopeDefinition)scopeIter.next();
                    this.scopeDefinitionMap.put(scope.getName().toLowerCase(), scope);
                }
            }
            this.scopeDefinitionMap.put(AllScope.getInstance().getName().toLowerCase(), AllScope.getInstance());
        }
        return (IScopeDefinition)this.scopeDefinitionMap.get(name.toLowerCase());
    }

    public final IGroupDefinition getDefinitionOfAssignedGroup(TradingPartnerInterface company, boolean deriveFromExternal) {
        IGroupDefinition groupDefintion = this.getGroupDefinitionFromCache(company);
        return groupDefintion;
    }

    public final IGroupDefinition getDefinitionOfExternalGroup(TradingPartnerInterface company) {
        return null;
    }

    public final boolean belongsToScope(TradingPartnerInterface company, IScopeDefinition scope) {
        if (trace.bePath()) {
            trace.entering("belongsToScope(TradingPartnerInterface,IScopeDefinition)", new Object[]{company, scope});
        }
        IGroupDefinition group = this.getDefinitionOfAssignedGroup(company, true);
        boolean result = scope.impliesGroup(group);
        if (trace.bePath()) {
            trace.exiting("belongsToScope(TradingPartnerInterface,IScopeDefinition)", result ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }

    public final boolean hasAccess(TradingPartnerInterface company, IServiceAction action) {
        String methodName = "hasAccess(TradingPartnerInterface,IServiceAction)";
        if (trace.bePath()) {
            trace.entering("hasAccess(TradingPartnerInterface,IServiceAction)", new Object[]{company, action});
        }
        boolean result = this.hasAccess(this.getDefinitionOfAssignedGroup(company, true), action);
        if (trace.bePath()) {
            trace.exiting("hasAccess(TradingPartnerInterface,IServiceAction)", result ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }

    public void assignGroupToCompany(IUser actor, IGroupDefinition group, TradingPartnerInterface company) {
    }

    protected final IGroupDefinition getGroupDefinitionFromCache(TradingPartnerInterface company) {
        String companyPrincipalId;
        if (null == this.companyIdGroupDefinitionMap) {
            this.companyIdGroupDefinitionMap = new HashMap();
        }
        if (this.companyIdGroupDefinitionMap.containsKey(companyPrincipalId = "CPY_INDIVIDUAL_USERS")) {
            return (IGroupDefinition)this.companyIdGroupDefinitionMap.get(companyPrincipalId);
        }
        IGroupDefinition groupDefinition = this.fetchGroupDefinition(company);
        this.companyIdGroupDefinitionMap.put(companyPrincipalId, groupDefinition);
        return groupDefinition;
    }

    private final boolean hasAccess(IGroupDefinition group, IServiceAction action) {
        String methodName = "hasAccess(IGroupDefinition,IServiceAction)";
        String accessScope = action.getAccessScope();
        IScopeDefinition scope = this.getScopeDefinitionByName(accessScope);
        if (null == scope) {
            trace.warningT("hasAccess(IGroupDefinition,IServiceAction)", "Unknown scope " + accessScope + " defined by service action " + action);
            return true;
        }
        return scope.impliesGroup(group);
    }

    private IGroupDefinition fetchGroupDefinition(TradingPartnerInterface company) {
        String groupName;
        IGroupDefinition groupDefinition;
        String methodName = "fetchGroupDefinition(TradingPartnerInterface)";
        if (trace.bePath()) {
            trace.entering("fetchGroupDefinition(TradingPartnerInterface)", new Object[]{company});
        }
        if (null == (groupDefinition = this.getGroupDefinitionByName(groupName = "default"))) {
            trace.warningT("fetchGroupDefinition(TradingPartnerInterface)", "Group definition not found (most likely old group data in database)!", new Object[]{groupName});
        }
        if (trace.bePath()) {
            trace.exiting("fetchGroupDefinition(TradingPartnerInterface)", groupDefinition);
        }
        return groupDefinition;
    }

    public abstract IServiceAction getServiceActionById(String var1) throws NoSuchActionException;

    public abstract Iterator getAllServices();

    public abstract IService getService(String var1) throws NoSuchServiceException;

    private static class GroupDefinitionIterator
    implements Iterator {
        private Iterator serviceIter;
        private Iterator groupDefinitionIter;
        private IGroupDefinition groupDefinition;

        public GroupDefinitionIterator(Iterator serviceIter) {
            this.serviceIter = serviceIter;
            if (this.serviceIter.hasNext()) {
                this.groupDefinitionIter = ((IService)this.serviceIter.next()).getGroupDefinitions();
                this.iterate();
            } else {
                this.groupDefinition = null;
            }
        }

        public boolean hasNext() {
            return this.groupDefinition != null;
        }

        public Object next() {
            IGroupDefinition result = this.groupDefinition;
            this.iterate();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void iterate() {
            while (!this.groupDefinitionIter.hasNext()) {
                if (!this.serviceIter.hasNext()) {
                    this.groupDefinition = null;
                    return;
                }
                this.groupDefinitionIter = ((IService)this.serviceIter.next()).getGroupDefinitions();
            }
            this.groupDefinition = (IGroupDefinition)this.groupDefinitionIter.next();
        }
    }
}

