/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.PermissionData;
import com.sap.security.core.role.imp.Service;
import com.sap.security.core.util.IUMTrace;
import java.util.Iterator;
import java.util.Locale;

public abstract class ServiceAction
implements IServiceAction {
    private final Service service;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/ServiceAction.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/ServiceAction.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");

    public ServiceAction(Service service) {
        this.service = service;
    }

    public final IService getService() {
        return this.service;
    }

    public String getUniqueID() {
        return this.getDefaultUniqueID();
    }

    public void print(Locale locale) {
        System.out.println("ServiceAction: " + this.getName() + "; ID: " + this.getUniqueID() + "; SCOPE: " + this.getAccessScope() + "; Description: " + this.getDescription(locale));
        Iterator permissions = this.getPermissions();
        while (permissions.hasNext()) {
            PermissionData perm = (PermissionData)permissions.next();
            System.out.println("  Permission: " + perm.toString());
        }
    }

    public String toString() {
        String actionName = this.getDefaultUniqueID();
        if (actionName.startsWith("sap.com_")) {
            actionName = actionName.substring(8);
        }
        return actionName;
    }

    protected final String getDefaultUniqueID() {
        return this.service.getName() + "." + this.getName();
    }

    public abstract String getAccessScope();

    public abstract Iterator getPermissions();

    public abstract String getDescription(Locale var1);

    public abstract String getName();
}

