/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.permissions.UMAdminPermissions;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.IServiceRepository;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.imp.PermissionRoles;
import com.sap.security.core.util.IUMTrace;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RoleUtils {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/RoleUtils.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/RoleUtils.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");

    public static Set getUsersWithPermission(Permission perm, TradingPartnerInterface tp) throws UMException {
        String methodName = "getUsersWithPermission(Permission,TPI)";
        if (trace.bePath()) {
            trace.entering(methodName, new Object[]{perm, tp});
        }
        String companyID = null;
        if (tp != null) {
            companyID = tp.getPartnerID().toString();
        }
        Set users = RoleUtils.getUsersWithPermission(perm, companyID);
        if (trace.bePath()) {
            trace.exiting(methodName, users.size() + " users");
        }
        return users;
    }

    public static Set getUsersWithPermission(Set perms, TradingPartnerInterface tp, boolean allPerms) throws UMException {
        String methodName = "getUsersWithPermission(Set,TradingPartner,boolean)";
        if (trace.bePath()) {
            trace.entering(methodName, new Object[]{perms, tp});
        }
        if (perms.isEmpty() || null == perms) {
            return new HashSet();
        }
        String companyID = null;
        if (tp != null) {
            companyID = tp.getPartnerID().toString();
        }
        Set userSet = null;
        userSet = allPerms ? RoleUtils.getUsersWithAllPermissions(perms, companyID) : RoleUtils.getUsersWithOnePermission(perms, companyID);
        if (trace.bePath()) {
            trace.exiting(methodName, userSet.size() + " users");
        }
        return userSet;
    }

    public static void main(String[] args) throws UMException {
        IPrincipal user;
        HashSet<UMAdminPermissions> permSet = new HashSet<UMAdminPermissions>();
        UMAdminPermissions perm = null;
        String permName = null;
        perm = new UMAdminPermissions("USER_VIEWPROFILE");
        permSet.add(perm);
        perm = new UMAdminPermissions("MANAGE_ALL_COMPANIES");
        permSet.add(perm);
        perm = new UMAdminPermissions("USERS_ASSIGN_TO_COMPANY");
        permSet.add(perm);
        perm = new UMAdminPermissions("ROLES_ADMIN");
        permSet.add(perm);
        permName = perm.getName();
        Set userList = RoleUtils.getUsersWithPermission((Permission)perm, (TradingPartnerInterface)null);
        System.out.println("getUsersWithPermission(perm,null) where perm = " + permName);
        System.out.println(userList.size() + " users found");
        Iterator userIter = userList.iterator();
        while (userIter.hasNext()) {
            user = (IPrincipal)userIter.next();
            System.out.print(user.getDisplayName() + ", ");
        }
        System.out.println();
        System.out.println("getUsersWithPermission(perm,null,false)");
        userList = RoleUtils.getUsersWithPermission(permSet, null, false);
        System.out.println(userList.size() + " users found");
        userIter = userList.iterator();
        while (userIter.hasNext()) {
            user = (IPrincipal)userIter.next();
            System.out.print(user.getDisplayName() + ", ");
        }
        System.out.println();
        System.out.println("getUsersWithPermission(perm,null,true)");
        userList = RoleUtils.getUsersWithPermission(permSet, null, true);
        System.out.println(userList.size() + " users found");
        userIter = userList.iterator();
        while (userIter.hasNext()) {
            user = (IPrincipal)userIter.next();
            System.out.print(user.getDisplayName() + ", ");
        }
        System.out.println();
    }

    private static Set getUsersWithPermission(Permission perm, String companyID) throws UMException {
        String methodName = "getUsersWithPermission(Permission,String)";
        trace.entering(methodName);
        IRoleFactory rolefactory = UMFactory.getRoleFactory();
        ISearchResult rolesIter = rolefactory.searchRoles(rolefactory.getRoleSearchFilter());
        HashSet<IUser> userSet = new HashSet<IUser>();
        while (rolesIter.hasNext()) {
            IUserFactory userFactory = UMFactory.getUserFactory();
            IRole role = rolefactory.getRole((String)rolesIter.next());
            if (trace.beDebug()) {
                trace.debugT(methodName, "Getting the role: " + role.getUniqueName());
            }
            if (!PermissionRoles.implies(role, perm)) continue;
            if (trace.beDebug()) {
                trace.debugT(methodName, "adding role " + role.getUniqueName());
            }
            Iterator users = role.getUserMembers(true);
            while (users.hasNext()) {
                IUser user = userFactory.getUser((String)users.next());
                if (companyID != null && !companyID.equals(user.getCompany()) && (companyID.length() != 0 || user.getCompany() != null)) continue;
                if (trace.beDebug()) {
                    trace.debugT(methodName, "adding user " + user.getUniqueName());
                }
                userSet.add(user);
            }
        }
        trace.exiting(methodName);
        return userSet;
    }

    private static Set getUsersWithOnePermission(Set perms, String companyID) throws UMException {
        String methodName = "getUsersWithOnePermission(Set,String)";
        trace.entering(methodName);
        HashSet userlist = new HashSet();
        Iterator perIter = perms.iterator();
        while (perIter.hasNext()) {
            Permission perm = (Permission)perIter.next();
            trace.infoT(methodName, "Getting Users having Permission: " + perm.getName());
            Set newlist = RoleUtils.getUsersWithPermission(perm, companyID);
            userlist.addAll(newlist);
        }
        trace.exiting(methodName);
        return userlist;
    }

    private static Set getUsersWithAllPermissions(Set perms, String companyID) throws UMException {
        String methodName = "getUsersWithOnePermission(Set,String)";
        trace.entering(methodName);
        Set userlist = null;
        Iterator perIter = perms.iterator();
        while (perIter.hasNext()) {
            Permission perm = (Permission)perIter.next();
            trace.infoT(methodName, "Getting Users having Permission: " + perm.getName());
            Set newlist = RoleUtils.getUsersWithPermission(perm, companyID);
            if (newlist.isEmpty()) {
                trace.exiting(methodName);
                return new HashSet();
            }
            if (null == userlist) {
                userlist = newlist;
                continue;
            }
            userlist.retainAll(newlist);
        }
        if (null == userlist) {
            userlist = new HashSet();
        }
        trace.exiting(methodName);
        return userlist;
    }

    public static Iterator heuristicActionsToRolesMapper(Iterator actionIDs, TradingPartnerInterface tp, boolean ignoreNoSuchActionException) throws NoSuchActionException, UMException {
        IRoleFactory rfactory = UMFactory.getRoleFactory();
        IServiceRepository repository = InternalUMFactory.getServiceRepository();
        HashSet<IServiceAction> actions = new HashSet<IServiceAction>();
        IService service = null;
        while (actionIDs.hasNext()) {
            String actionIDstring = (String)actionIDs.next();
            try {
                IServiceAction sa = repository.getServiceActionById(actionIDstring);
                IService tempService = sa.getService();
                if (service == null) {
                    service = tempService;
                } else if (!service.equals(tempService)) {
                    throw new UMException("All action ids must be from the same service");
                }
                actions.add(sa);
            }
            catch (NoSuchActionException e) {
                if (ignoreNoSuchActionException) {
                    trace.warningT("heuristicActionsToRolesMapper", "Action " + actionIDstring + " not found!");
                    continue;
                }
                throw new NoSuchActionException(actionIDstring);
            }
        }
        ISearchResult allRoles = rfactory.searchRoles(rfactory.getRoleSearchFilter());
        HashSet<IRole> assignedRoles = new HashSet<IRole>();
        while (allRoles.hasNext()) {
            IRole role = (IRole)allRoles.next();
            Iterator roleActions = PermissionRoles.getActions(role);
            boolean includeRole = false;
            while (roleActions.hasNext()) {
                IServiceAction roleAction = (IServiceAction)roleActions.next();
                if (!roleAction.getService().equals(service)) continue;
                if (actions.contains(roleAction)) {
                    includeRole = true;
                    continue;
                }
                includeRole = false;
                break;
            }
            if (!includeRole) continue;
            assignedRoles.add(role);
        }
        return assignedRoles.iterator();
    }
}

