/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.imp;

import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IRoleSearchFilter;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.RoleSearchFilter;
import com.sap.security.core.role.IRoleTemplate;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.PermissionData;
import com.sap.security.core.role.imp.RoleServiceActionIterator;
import com.sap.security.core.util.IUMTrace;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class PermissionRoles {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/PermissionRoles.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/imp/PermissionRoles.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final String ROLE_NAMESPACE = "com.sap.security.core.role";
    public static final String ACTIONS = "actions";

    public static boolean addAction(IRole role, IServiceAction action) {
        String[] actions;
        if (trace.bePath()) {
            trace.entering("addAction(IRole, IServiceAction)", new Object[]{role, action});
        }
        int nrOfActions = (actions = role.getAttribute(ROLE_NAMESPACE, ACTIONS)) != null ? actions.length : 0;
        int i = 0;
        while (i < nrOfActions) {
            if (actions[i].equals(action.getUniqueID())) {
                return false;
            }
            ++i;
        }
        String[] newActions = new String[nrOfActions + 1];
        int i2 = 0;
        while (i2 < nrOfActions) {
            newActions[i2] = actions[i2];
            ++i2;
        }
        newActions[nrOfActions] = action.getUniqueID();
        return role.setAttribute(ROLE_NAMESPACE, ACTIONS, newActions);
    }

    public static Iterator getActions(IRole role) {
        String[] actions;
        if (trace.bePath()) {
            trace.entering("getActions(IRole)", new Object[]{role});
        }
        int nrOfActions = (actions = role.getAttribute(ROLE_NAMESPACE, ACTIONS)) != null ? actions.length : 0;
        ArrayList<String> actionList = new ArrayList<String>(nrOfActions);
        int i = 0;
        while (i < nrOfActions) {
            actionList.add(actions[i]);
            ++i;
        }
        return new RoleServiceActionIterator(actionList.iterator());
    }

    public static String[] getUnavailableActions(IRole role) {
        String[] actions;
        String methodName = "getUnavailableActions(IRole)";
        if (trace.bePath()) {
            trace.entering("getUnavailableActions(IRole)", new Object[]{role});
        }
        int nrOfActions = (actions = role.getAttribute(ROLE_NAMESPACE, ACTIONS)) != null ? actions.length : 0;
        ArrayList<String> actionList = new ArrayList<String>();
        int i = 0;
        while (i < nrOfActions) {
            try {
                InternalUMFactory.getServiceRepository().getServiceActionById(actions[i]);
            }
            catch (NoSuchActionException ex) {
                trace.infoT("getUnavailableActions(IRole)", "Found unavailable action: " + actions[i]);
                actionList.add(actions[i]);
            }
            ++i;
        }
        String[] unavActions = new String[actionList.size()];
        return actionList.toArray(unavActions);
    }

    public static boolean implies(IRole role, Permission permission) {
        if (trace.bePath()) {
            trace.entering("implies(IRole, IServiceAction)", new Object[]{role, permission});
        }
        ClassLoader loaderToUse = permission.getClass().getClassLoader();
        Permissions permissions = new Permissions();
        Iterator actionIter = PermissionRoles.getActions(role);
        while (actionIter.hasNext()) {
            IServiceAction action = (IServiceAction)actionIter.next();
            Iterator permIter = action.getPermissions();
            while (permIter.hasNext()) {
                PermissionData permData = (PermissionData)permIter.next();
                Permission perm = permData.get(loaderToUse);
                if (null == perm) continue;
                permissions.add(perm);
            }
        }
        return permissions.implies(permission);
    }

    public static boolean isAssignedAction(IRole role, IServiceAction action) {
        String[] actions;
        if (trace.bePath()) {
            trace.entering("isAssignedAction(IRole, IServiceAction)", new Object[]{role, action});
        }
        int nrOfActions = (actions = role.getAttribute(ROLE_NAMESPACE, ACTIONS)) != null ? actions.length : 0;
        int i = 0;
        while (i < nrOfActions) {
            if (actions[i].equals(action.getUniqueID())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean removeAction(IRole role, IServiceAction action) {
        String[] actions;
        if (trace.bePath()) {
            trace.entering("removeAction(IRole, IServiceAction)", new Object[]{role, action});
        }
        int nrOfActions = (actions = role.getAttribute(ROLE_NAMESPACE, ACTIONS)) != null ? actions.length : 0;
        boolean found = false;
        int i = 0;
        while (i < nrOfActions) {
            if (actions[i].equals(action.getUniqueID())) {
                actions[i] = null;
                found = true;
            }
            ++i;
        }
        if (found) {
            return role.setAttribute(ROLE_NAMESPACE, ACTIONS, actions);
        }
        return false;
    }

    public static void removeActions(IRole role) {
        if (trace.bePath()) {
            trace.entering("removeActions(IRole)", new Object[]{role});
        }
        role.setAttribute(ROLE_NAMESPACE, ACTIONS, null);
    }

    public static void setActions(IRole role, Set actions) {
        PermissionRoles.setActions(role, actions, null);
    }

    public static void setActions(IRole role, Set actions, Set unavailableActions) {
        int i;
        String methodName = "setActions(IRole, Set, Set)";
        if (trace.bePath()) {
            trace.entering("setActions(IRole, Set, Set)", new Object[]{role});
        }
        int actionSize = actions != null ? actions.size() : 0;
        int unavActionSize = unavailableActions != null ? unavailableActions.size() : 0;
        String[] newActions = new String[actionSize + unavActionSize];
        if (actionSize > 0) {
            Iterator actionIter = actions.iterator();
            i = 0;
            while (i < actionSize) {
                IServiceAction serviceAction = (IServiceAction)actionIter.next();
                newActions[i] = serviceAction.getUniqueID();
                ++i;
            }
        }
        if (unavActionSize > 0) {
            Iterator unavActionIter = unavailableActions.iterator();
            i = 0;
            while (i < unavActionSize) {
                newActions[actionSize + i] = (String)unavActionIter.next();
                ++i;
            }
        }
        role.setAttribute(ROLE_NAMESPACE, ACTIONS, newActions);
        if (trace.bePath()) {
            trace.exiting("setActions(IRole, Set, Set)", actionSize + "actions and " + unavActionSize + "unavailable actions set");
        }
    }

    public static void createDefaultRoles() {
        trace.entering("createDefaultRoles()");
        PermissionRoles.createDefaultRoles(InternalUMFactory.getServiceRepository().getAllServices(), false, false);
    }

    public static void createDefaultRoles(Iterator servicesUsed, boolean reset, boolean deleteManualCreatedRoles) {
        IServiceAction action;
        Iterator actionIter;
        String roleID;
        String methodName = "createDefaultRoles(Iterator,boolean,boolean)";
        IRoleFactory roleFactory = UMFactory.getRoleFactory();
        HashMap actionsToRemove = null;
        HashSet<String> manualCreatedRoles = null;
        if (reset) {
            try {
                actionsToRemove = new HashMap();
                manualCreatedRoles = new HashSet<String>();
                ISearchResult roleIter = roleFactory.searchRoles((IRoleSearchFilter)new RoleSearchFilter());
                while (roleIter.hasNext()) {
                    roleID = (String)roleIter.next();
                    try {
                        IRole role = roleFactory.getRole(roleID);
                        HashSet<IServiceAction> roleActions = new HashSet<IServiceAction>();
                        actionIter = PermissionRoles.getActions(role);
                        while (actionIter.hasNext()) {
                            action = (IServiceAction)actionIter.next();
                            roleActions.add(action);
                        }
                        actionsToRemove.put(roleID, roleActions);
                        manualCreatedRoles.add(roleID);
                    }
                    catch (UMException exc) {
                        trace.warningT("createDefaultRoles(Iterator,boolean,boolean)", "Role with ID " + roleID + " not found!", exc);
                    }
                }
            }
            catch (UMException exc) {
                trace.errorT("createDefaultRoles(Iterator,boolean,boolean)", "Search for all roles caused an error!", exc);
            }
        }
        while (servicesUsed.hasNext()) {
            IService service = (IService)servicesUsed.next();
            trace.debugT("createDefaultRoles(Iterator,boolean,boolean)", "Looking up for role templates of service " + service);
            Iterator roleTempIter = service.getRoleTemplates();
            while (roleTempIter.hasNext()) {
                IRoleTemplate roleTemplate = (IRoleTemplate)roleTempIter.next();
                IRole role = PermissionRoles.forceGetRole(roleTemplate);
                if (role == null) continue;
                trace.debugT("createDefaultRoles(Iterator,boolean,boolean)", "Adding actions of role template " + roleTemplate);
                actionIter = roleTemplate.getServiceActions();
                while (actionIter.hasNext()) {
                    Set roleActions;
                    action = (IServiceAction)actionIter.next();
                    boolean isNew = PermissionRoles.addAction(role, action);
                    if (!reset) continue;
                    manualCreatedRoles.remove(role.getUniqueID());
                    if (isNew || null == (roleActions = (Set)actionsToRemove.get(role.getUniqueID()))) continue;
                    roleActions.remove(action);
                }
                try {
                    role.commit();
                }
                catch (UMException exc) {
                    trace.errorT("createDefaultRoles(Iterator,boolean,boolean)", "Error at committing default role!", exc);
                }
            }
        }
        if (reset) {
            Iterator<Object> roleIDIter = manualCreatedRoles.iterator();
            while (roleIDIter.hasNext()) {
                roleID = (String)roleIDIter.next();
                if (deleteManualCreatedRoles) {
                    try {
                        roleFactory.deleteRole(roleID);
                    }
                    catch (UMException exc) {
                        trace.warningT("createDefaultRoles(Iterator,boolean,boolean)", "Couldn't delete non-default role " + roleID, exc);
                    }
                }
                actionsToRemove.remove(roleID);
            }
            roleIDIter = actionsToRemove.keySet().iterator();
            while (roleIDIter.hasNext()) {
                try {
                    IRole role = roleFactory.getMutableRole((String)roleIDIter.next());
                    Set roleActions = (Set)actionsToRemove.get(role.getUniqueID());
                    Iterator actionIter2 = roleActions.iterator();
                    while (actionIter2.hasNext()) {
                        IServiceAction action2 = (IServiceAction)actionIter2.next();
                        PermissionRoles.removeAction(role, action2);
                    }
                    role.commit();
                }
                catch (UMException exc) {
                    trace.errorT("createDefaultRoles(Iterator,boolean,boolean)", "Error at removing non default actions from role!", exc);
                }
            }
        }
    }

    private static IRole forceGetRole(IRoleTemplate roleTemplate) {
        String methodName = "forceGetRole(IRoleTemplate)";
        IRoleFactory roleFactory = UMFactory.getRoleFactory();
        String roleName = roleTemplate.getName();
        try {
            IRole role = roleFactory.getRoleByUniqueName(roleName);
            return roleFactory.getMutableRole(role.getUniqueID());
        }
        catch (UMException exc) {
            try {
                trace.debugT("forceGetRole(IRoleTemplate)", "Creating role " + roleName);
                IRole role = UMFactory.getRoleFactory().newRole(roleName);
                role.setDescription(roleTemplate.getDescription(Locale.getDefault()));
                return role;
            }
            catch (UMException ex) {
                trace.errorT("forceGetRole(IRoleTemplate)", "Role creation failed :" + roleName);
                return null;
            }
        }
    }
}

