/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.role.filter;

import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PermissionFilter
extends HttpServlet
implements Filter {
    private transient FilterConfig filterConfig = null;
    private Permission permission;
    private Class permissionClass;
    private String permissionName;
    private String permissionValue;
    private int status;
    private static final Class[] PERMISSION_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PermissionFilter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PermissionFilter.class$("java.lang.String")) : class$java$lang$String};
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/filter/PermissionFilter.java#3 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static final transient IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/role/filter/PermissionFilter.java#3 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    private static final int AUTHORISE = 1;
    private static final int AUTHENTICATE_ONLY = 2;
    private static final int ERROR = 3;
    static /* synthetic */ Class class$java$lang$String;

    public void init(FilterConfig config) throws ServletException {
        String methodName = "init";
        trace.entering(methodName);
        this.filterConfig = config;
        trace.debugT(methodName, "get init parameter enumeration from filter config object");
        Enumeration enumeration = this.filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            trace.debugT(methodName, "get init parameters from filter config object");
            String className = this.filterConfig.getInitParameter("permissionClass");
            String name = this.filterConfig.getInitParameter("permissionName");
            String value = this.filterConfig.getInitParameter("permissionValue");
            try {
                if (className == null) {
                    trace.warningT(methodName, "init parameter permissionClass not filled correctly in web.xml");
                    throw new ServletException();
                }
                if (name == null) {
                    trace.warningT(methodName, "init parameter permissionName not filled correctly in web.xml");
                    throw new ServletException();
                }
                if (value == null) {
                    trace.warningT(methodName, "init parameter permissionValue not filled correctly in web.xml");
                    throw new ServletException();
                }
            }
            catch (ServletException se) {
                trace.errorT(methodName, se.getMessage(), se);
                this.status = 3;
                return;
            }
            try {
                trace.debugT(methodName, "get permission class");
                this.permissionClass = Class.forName(className);
                trace.debugT(methodName, "get permission name");
                this.permissionName = name;
                trace.debugT(methodName, "get permission value");
                this.permissionValue = value;
            }
            catch (ClassNotFoundException e) {
                trace.errorT(methodName, e.getMessage(), e);
                this.status = 3;
                return;
            }
            try {
                trace.debugT(methodName, "get permission object");
                Constructor constructor = this.permissionClass.getConstructor(PERMISSION_ARGS);
                this.permission = (Permission)constructor.newInstance(this.permissionName, this.permissionValue);
                trace.debugT(methodName, "Permission Created: " + this.permission.toString());
                this.status = 1;
            }
            catch (NoSuchMethodException nsme) {
                trace.errorT(methodName, nsme.getMessage(), nsme);
                this.status = 3;
            }
            catch (InvocationTargetException ite) {
                trace.errorT(methodName, ite.getMessage(), ite);
                this.status = 3;
            }
            catch (IllegalAccessException iae) {
                trace.errorT(methodName, iae.getMessage(), iae);
                this.status = 3;
            }
            catch (InstantiationException ie) {
                trace.errorT(methodName, ie.getMessage(), ie);
                this.status = 3;
            }
        } else {
            trace.debugT(methodName, "no init parameters filled, perform no authentications check");
            this.status = 2;
        }
        trace.exiting(methodName);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String methodName = "doFilter";
        trace.entering(methodName);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.filterConfig == null) {
            this.status = 3;
        }
        trace.debugT(methodName, "force logged in user");
        IUser user = UMFactory.getAuthenticator().forceLoggedInUser(httpRequest, httpResponse);
        if (user == null) {
            trace.debugT(methodName, "user not logged in, redirect to logon page");
            return;
        }
        if (this.status == 1) {
            trace.debugT(methodName, "user logged in");
            try {
                trace.debugT(methodName, "checking user permission");
                user.checkPermission(this.permission);
            }
            catch (Exception e) {
                if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                    HashMap<String, Permission> auditDetails = new HashMap<String, Permission>();
                    auditDetails.put("permission", this.permission);
                    SecurityAudit.log("ACCESS.ERROR", user.getUniqueID(), auditDetails);
                }
                trace.errorT(methodName, e);
                try {
                    trace.debugT(methodName, "send error page 401");
                    httpResponse.sendError(401, "Unauthorized access.");
                }
                catch (IOException ioe) {
                    trace.errorT(methodName, ioe.getMessage(), ioe);
                }
                return;
            }
            try {
                trace.debugT(methodName, "perform filter chain");
                filterChain.doFilter(request, response);
            }
            catch (ServletException sx) {
                trace.errorT(methodName, sx.getMessage(), sx);
                this.filterConfig.getServletContext().log(sx.getMessage());
            }
            catch (IOException iox) {
                trace.errorT(methodName, iox.getMessage(), iox);
                this.filterConfig.getServletContext().log(iox.getMessage());
            }
        } else if (this.status == 2) {
            try {
                trace.debugT(methodName, "perform filter chain");
                filterChain.doFilter(request, response);
            }
            catch (ServletException sx) {
                trace.errorT(methodName, sx.getMessage(), sx);
                this.filterConfig.getServletContext().log(sx.getMessage());
            }
            catch (IOException iox) {
                trace.errorT(methodName, iox.getMessage(), iox);
                this.filterConfig.getServletContext().log(iox.getMessage());
            }
        } else if (this.status == 3) {
            trace.debugT(methodName, "an error occured in config");
            try {
                trace.debugT(methodName, "send error page 400");
                httpResponse.sendError(400, "Error in config.");
            }
            catch (IOException ioe) {
                trace.errorT(methodName, ioe.getMessage(), ioe);
            }
            return;
        }
        trace.exiting(methodName);
    }

    public void destroy() {
        String methodName = "destroy";
        trace.entering(methodName);
        this.filterConfig = null;
        trace.exiting(methodName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

