/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.umap.IUserMapping;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.ISecondaryStorage;
import com.sap.security.core.util.IUMTrace;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/Utils.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/Utils.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    public static final String REPLICATION_R3ADAPTER = "R3Adapter";
    public static final String REPLICATION_XMLADAPTER = "XMLAdapter";
    public static final String REPLICATION_SAPSU01ADAPTER = "SAPSU01Adapter";
    public static final String R3ADAPTER_XMLADAPTER_IMP = "com.sap.security.core.persistence.replication.imp.adapters.r3.UserPersistenceXML";
    public static final String SAPSU01ADAPTER_IMP = "com.sap.security.core.persistence.replication.imp.adapters.r3.UserPersistenceR3";
    public static final String REPLICATION_OPERATION_ASYNC = "ume.replication.operation.async";
    public static final String REPLICATION_ADAPTERS_PREFIX = "ume.replication.adapters.index_";
    public static final String ERROR_NO_USER = "UserSyncHandler, no snyc takes place, no user past";
    public static final String ERROR_NO_ADAPTER = "UserSyncHandler, no snyc takes place, no adapter defined";
    public static final String ERROR_NO_MODE_SPECIFIED = "UserSyncHandler, no snyc takes place, no mode specified";
    public static final String ERROR_NO_TP_SPECIFIED = "UserSyncHandler, no snyc takes place, no trading partner specified";
    private static final String prefix = "ume.replication.adapters.";
    private static final String SCOPE = "scope";
    private static final String COMPANIES = "companies";
    private static final String SEPERATOR = ",";

    public static String getR3ID(IUser user) {
        String r3mastersystem = UMFactory.getProperties().get("ume.r3.mastersystem");
        IUserMapping umap = UMFactory.getUserMapping();
        try {
            return umap.getR3UserName(user, r3mastersystem, null, true);
        }
        catch (UMException ex) {
            trace.errorT("getR3ID", "failed to generate r3 id", ex);
            return null;
        }
    }

    public static String getLogonId(IUser user) {
        String logonId = user.getUniqueName();
        try {
            IUserAccount[] ua = user.getUserAccounts();
            if (ua.length > 0) {
                logonId = ua[0].getLogonUid();
            }
        }
        catch (UMException ex) {
            trace.warningT("getlogonid from user", ex.getMessage(), ex);
        }
        return logonId;
    }

    public static ArrayList getSecondaryStorages() {
        ArrayList<ISecondaryStorage> adapters = new ArrayList<ISecondaryStorage>();
        ArrayList secondaryAdapters = Utils.getAdapters();
        if (secondaryAdapters.isEmpty()) {
            trace.infoT("getSecondaryStorages", "no adapters defined");
        } else {
            int size = secondaryAdapters.size();
            String sadp = null;
            ISecondaryStorage up = null;
            int i = 0;
            while (i < size) {
                sadp = (String)secondaryAdapters.get(i);
                sadp = sadp.trim();
                String sysid = Utils.getSystemId(sadp);
                up = Utils.loadClass(sadp = Utils.getPersistenceClass(sadp));
                if (up != null) {
                    up.setId(sysid);
                    up.setScope(Utils.getScope(sysid));
                    up.setCompanies(Utils.getCompanies(sysid));
                    trace.debugT("getSecondaryStorages", sadp + " being loaded as secondary adapter");
                    adapters.add(up);
                } else {
                    trace.errorT("getSecondaryStorages", " class " + sadp + " could not loaded.");
                }
                ++i;
            }
        }
        return adapters;
    }

    public static ArrayList getAdapters() {
        IUMParameters ump = UMFactory.getProperties();
        Enumeration<?> umpnames = ump.getProperties().propertyNames();
        ArrayList<String> secondaryAdapters = new ArrayList<String>();
        String name = null;
        String sadp = null;
        while (umpnames.hasMoreElements()) {
            name = (String)umpnames.nextElement();
            if (!name.startsWith(REPLICATION_ADAPTERS_PREFIX) || (sadp = ump.get(name)) == null || sadp.trim().length() < 1) continue;
            secondaryAdapters.add(sadp);
        }
        return secondaryAdapters;
    }

    public static Iterator getAdapterNames() {
        return ((AbstractList)Utils.getAdapters()).iterator();
    }

    protected static ArrayList loadPersistenceAdapters(ArrayList adapters) {
        if (null == adapters || adapters.isEmpty()) {
            return null;
        }
        return Utils.loadPersistenceAdapters(adapters.toArray(new String[adapters.size()]));
    }

    protected static ArrayList loadPersistenceAdapters(String[] adapters) {
        if (adapters == null) {
            return null;
        }
        ArrayList<ISecondaryStorage> v = new ArrayList<ISecondaryStorage>(adapters.length);
        int size = adapters.length;
        ISecondaryStorage up = null;
        int i = 0;
        while (i < size) {
            String sadp = adapters[i];
            String sysid = Utils.getSystemId(sadp);
            up = Utils.loadClass(sadp = Utils.getPersistenceClass(sadp));
            if (up != null) {
                if (sysid != null) {
                    up.setId(sysid);
                }
                v.add(up);
            }
            ++i;
        }
        return v;
    }

    protected static String getPersistenceClass(String adapter) {
        int ind = adapter.indexOf("?");
        if (ind > 0) {
            adapter = adapter.substring(0, ind);
        }
        return Utils.getPersistenceAdp(adapter);
    }

    protected static String getPersistenceAdp(String adp) {
        if (REPLICATION_R3ADAPTER.equalsIgnoreCase(adp) || REPLICATION_XMLADAPTER.equalsIgnoreCase(adp)) {
            return R3ADAPTER_XMLADAPTER_IMP;
        }
        if (REPLICATION_SAPSU01ADAPTER.equalsIgnoreCase(adp)) {
            return SAPSU01ADAPTER_IMP;
        }
        return adp;
    }

    protected static ISecondaryStorage loadClass(String cls) {
        try {
            return (ISecondaryStorage)Class.forName(cls.trim()).newInstance();
        }
        catch (ClassNotFoundException e) {
            trace.errorT("loadClass", cls + " : Adapter instantiation failed : class not found: " + e.getMessage(), e);
            return null;
        }
        catch (IllegalAccessException e) {
            trace.errorT("loadClass", cls + " : Adapter instantiation failed :IllegalAccessException: " + e.getMessage(), e);
            return null;
        }
        catch (InstantiationException e) {
            trace.errorT("loadClass", cls + " : Adapter instantiation failed :InstantiationException: " + e.getMessage(), e);
            return null;
        }
        catch (Throwable e) {
            trace.errorT("loadClass", cls + " : Adapter instantiation failed :Throwable: " + e.getMessage(), e);
            return null;
        }
    }

    protected static String getSystemId(String adapter) {
        int i;
        int ind = adapter.indexOf("?");
        if (ind > 0 && (i = adapter.indexOf("=")) > ind) {
            return adapter.substring(i + 1, adapter.length());
        }
        return null;
    }

    private static String[] getScope(String adpid) {
        StringBuffer scope = new StringBuffer(80);
        scope.append(prefix).append(adpid.toLowerCase()).append(".").append(SCOPE);
        return Utils.getProps(scope.toString());
    }

    private static String[] getCompanies(String adpid) {
        StringBuffer companies = new StringBuffer(80);
        companies.append(prefix).append(adpid.toLowerCase()).append(".").append(COMPANIES);
        return Utils.getProps(companies.toString());
    }

    private static String[] getProps(String prop_key) {
        IUMParameters ump = UMFactory.getProperties();
        String value = ump.get(prop_key);
        if (value == null || "".equals(value)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, SEPERATOR);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        return v.toArray(new String[v.size()]);
    }
}

