/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.IMessageHandler;
import com.sap.security.core.persistence.replication.imp.usersync.SyncService;
import com.sap.security.core.util.IUMTrace;
import java.util.Hashtable;

public class UserSyncHandler
implements IMessageHandler {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/UserSyncHandler.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/UserSyncHandler.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    static boolean _isServiceEnabled = false;

    public UserSyncHandler() {
        _isServiceEnabled = SyncService.isServiceEnabled();
    }

    public void onCreateMessage(IUser[] users) throws UMException {
        if (_isServiceEnabled) {
            if (users == null) {
                trace.warningT("onCreateMessage", "no sync takes place, user is null");
            } else {
                SyncService.autoSyncUsers(users, "CREATE");
            }
        }
    }

    public void onUpdateMessage(IUser[] users) throws UMException {
        if (_isServiceEnabled) {
            if (users == null) {
                trace.warningT("onUpdateMessage", "no sync takes place, user is null");
            } else {
                SyncService.autoSyncUsers(users, "UPDATE");
            }
        }
    }

    public void onDeleteMessage(String[] uniqueNames, Hashtable excludesys) throws UMException {
        if (_isServiceEnabled) {
            if (uniqueNames == null) {
                trace.warningT("onDeleteMessage", "no sync takes place, user is null");
            } else {
                SyncService.syncDeletedUsers(uniqueNames);
            }
        }
    }

    public void onRoleChangeMessage(String[] uniqueids) throws UMException {
    }
}

