/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.replication.ISecondaryStorage;
import com.sap.security.core.persistence.replication.imp.usersync.SyncUser;
import com.sap.security.core.persistence.replication.imp.usersync.SyncUserComparator;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class SyncUserDB {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncUserDB.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncUserDB.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    protected static final String DATE = "date";
    protected static final String DISPLAYNAME = "displayname";
    protected static final String ADAPTERID = "adapterid";
    protected static final int NONE = -1;
    protected static final int CREATED = 0;
    protected static final int UPDATED = 1;
    protected static final int DELETED = 2;
    private static final String iDColumn = "ID";
    private static final String userIDColumn = "USER_ID";
    private static final String userIDHashColumn = "USER_IDH";
    private static final String operationNameColumn = "OPERATION_NAME";
    private static final String operationNameHashColumn = "OPERATION_NAMEH";
    private static final String adapterClassColumn = "ADAPTER_CLASS";
    private static final String adapterClassHashColumn = "ADAPTER_CLASSH";
    private static final String adapterIDColumn = "ADAPTER_ID";
    private static final String adapterIDHashColumn = "ADAPTER_IDH";
    private static final String errorColumn = "ERROR";
    private static final String detailsColumn = "DETAILS";
    private static final String dTTimeColumn = "DT_TIME";
    private static final String syncTable = "UME_USERSYNC";
    private static StringBuffer sqlAll = new StringBuffer(110);
    private static IConnectionPool _pool = InternalUMFactory.getJdbcConnectionPool();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void saveSyncUser(SyncUser user) throws UMException {
        String adapterid;
        String adapterclass;
        String methodName = "saveSyncUser(SyncUser user)";
        String uid = user.getUid();
        SyncUser syncedUser = SyncUserDB.getSyncUser(uid, adapterclass = user.getAdapterClass(), adapterid = user.getAdapterId());
        if (null != syncedUser) {
            if (0 == SyncUserDB.getSyncUserStatus(syncedUser) && "SUCCESS".equalsIgnoreCase(syncedUser.getError())) {
                String errorMsg = "no save in sync table, because current operation is create, but the user has been successfully created";
                trace.warningT("saveSyncUser(SyncUser user)", errorMsg, new String[]{uid, adapterclass, adapterid});
                return;
            }
            SyncUserDB.updateSyncUser(user);
            return;
        }
        String error = user.getError();
        if (error == null) {
            error = "SUCCESS";
        }
        Connection conn = null;
        PreparedStatement stmtInsert = null;
        try {
            try {
                conn = _pool.getConnection("saveSyncUser");
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO ").append(syncTable);
                sql.append(" (");
                sql.append(iDColumn).append(",");
                sql.append(userIDColumn).append(",");
                sql.append(userIDHashColumn).append(",");
                sql.append(adapterClassColumn).append(",");
                sql.append(adapterClassHashColumn).append(",");
                sql.append(adapterIDColumn).append(",");
                sql.append(adapterIDHashColumn).append(",");
                sql.append(operationNameColumn).append(",");
                sql.append(operationNameHashColumn).append(",");
                sql.append(errorColumn).append(",");
                sql.append(detailsColumn).append(",");
                sql.append(dTTimeColumn);
                sql.append(") VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
                stmtInsert = conn.prepareStatement(sql.toString());
                stmtInsert.setString(1, user.getIndex());
                stmtInsert.setString(2, uid);
                stmtInsert.setLong(3, Util.getHash(uid));
                stmtInsert.setString(4, adapterclass);
                stmtInsert.setLong(5, Util.getHash(adapterclass));
                stmtInsert.setString(6, adapterid);
                stmtInsert.setLong(7, Util.getHash(adapterid));
                stmtInsert.setString(8, user.getOperation().toUpperCase());
                stmtInsert.setLong(9, Util.getHash(user.getOperation().toUpperCase()));
                if (error.length() > 254) {
                    error = error.substring(0, 255);
                }
                stmtInsert.setString(10, error);
                if (error.equalsIgnoreCase("SUCCESS")) {
                    stmtInsert.setString(11, " ");
                } else {
                    stmtInsert.setString(11, user.getDetails());
                }
                Date dt = new Date();
                stmtInsert.setTimestamp(12, new Timestamp(dt.getTime()));
                stmtInsert.executeUpdate();
                conn.commit();
            }
            catch (SQLException ex) {
                trace.errorT("saveSyncUser(SyncUser user)", ex.getMessage(), ex);
                throw new UMException((Throwable)ex);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SyncUserDB.closePreparedStatement(stmtInsert, "saveSyncUser(SyncUser user)");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(stmtInsert, "saveSyncUser(SyncUser user)");
        _pool.releaseConnection(conn);
    }

    protected static void updateSyncUser(SyncUser user) throws UMException {
        String methodName = "updateSyncUser(SyncUser user)";
        Connection conn = null;
        PreparedStatement stmtUpdate = null;
        trace.debugT("updateSyncUser", user.getAdapterClass());
        SyncUser syncUser = SyncUserDB.getSyncUser(user.getUid(), user.getAdapterClass(), user.getAdapterId());
        if (null == syncUser) {
            SyncUserDB.saveSyncUser(user);
            return;
        }
        try {
            try {
                conn = _pool.getConnection("updateSyncUser");
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ").append(syncTable);
                sql.append(" SET ");
                sql.append(operationNameColumn).append("=?, ");
                sql.append(operationNameHashColumn).append("=?, ");
                sql.append(errorColumn).append("=?, ");
                sql.append(detailsColumn).append("=?, ");
                sql.append(dTTimeColumn).append("=?");
                sql.append(" WHERE ");
                sql.append(iDColumn).append("=?");
                stmtUpdate = conn.prepareStatement(sql.toString());
                stmtUpdate.setString(1, user.getOperation().toUpperCase());
                stmtUpdate.setLong(2, Util.getHash(user.getOperation().toUpperCase()));
                String error = user.getError();
                if (error == null) {
                    error = "SUCCESS";
                } else if (error.length() > 254) {
                    error = error.substring(0, 255);
                }
                stmtUpdate.setString(3, error);
                if (error.equalsIgnoreCase("SUCCESS")) {
                    stmtUpdate.setString(4, " ");
                } else {
                    stmtUpdate.setString(4, user.getDetails());
                }
                Date dt = new Date();
                stmtUpdate.setTimestamp(5, new Timestamp(dt.getTime()));
                stmtUpdate.setString(6, syncUser.getIndex());
                stmtUpdate.executeUpdate();
                conn.commit();
            }
            catch (SQLException ex) {
                trace.errorT("updateSyncUser ", ex.getMessage());
                throw new UMException((Throwable)ex);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            SyncUserDB.closePreparedStatement(stmtUpdate, "updateSyncUser(SyncUser user)");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(stmtUpdate, "updateSyncUser(SyncUser user)");
        _pool.releaseConnection(conn);
    }

    protected static SyncUser[] getFailedUsers() throws UMException {
        String methodName = "getFailedUsers";
        StringBuffer sql = new StringBuffer(sqlAll.toString());
        Connection conn = null;
        PreparedStatement ps = null;
        SyncUser[] users = null;
        try {
            try {
                conn = _pool.getConnection("getFailedUsers");
                sql.append(" WHERE ");
                sql.append(errorColumn).append("<>'");
                sql.append("SUCCESS").append("'");
                ps = conn.prepareStatement(sql.toString());
                users = SyncUserDB.getSyncUsers(ps);
            }
            catch (Exception ex) {
                trace.errorT("getFailedUsers", ex.getMessage(), ex);
                throw new UMException((Throwable)ex);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SyncUserDB.closePreparedStatement(ps, "getFailedUsers");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(ps, "getFailedUsers");
        _pool.releaseConnection(conn);
        return users;
    }

    protected static SyncUser getSyncUser(String uniqueName, ISecondaryStorage adapter) {
        return SyncUserDB.getSyncUser(uniqueName, adapter.getClass().getName(), adapter.getId());
    }

    protected static SyncUser getSyncUser(String index) throws UMException {
        String methodName = "getSyncUser(String index)";
        Connection conn = null;
        StringBuffer sql = new StringBuffer(sqlAll.toString());
        PreparedStatement stmtGetOne = null;
        SyncUser[] users = null;
        try {
            try {
                conn = _pool.getConnection("getSyncUser");
                sql.append(" WHERE ").append(iDColumn).append("=?");
                stmtGetOne = conn.prepareStatement(sql.toString());
                stmtGetOne.setString(1, index);
                users = SyncUserDB.getSyncUsers(stmtGetOne);
            }
            catch (SQLException ex) {
                trace.errorT("getSyncUser(String index)", ex.getMessage(), ex);
                throw new UMException((Throwable)ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            SyncUserDB.closePreparedStatement(stmtGetOne, "getSyncUser(String index)");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(stmtGetOne, "getSyncUser(String index)");
        _pool.releaseConnection(conn);
        return SyncUserDB.getSyncUser(users);
    }

    protected static int getSyncUserStatus(SyncUser syncUser) {
        int status = -1;
        if (null != syncUser) {
            String lastOpt = syncUser.getOperation();
            String error = syncUser.getError();
            if ("CREATE".equalsIgnoreCase(lastOpt)) {
                status = "SUCCESS".equalsIgnoreCase(error) ? 0 : (error.toUpperCase().indexOf("already exists".toUpperCase()) >= 0 ? 0 : -1);
            } else if ("UPDATE".equalsIgnoreCase(lastOpt)) {
                status = "SUCCESS".equalsIgnoreCase(error) ? 1 : (error.toUpperCase().indexOf("does not exist".toUpperCase()) >= 0 ? -1 : 0);
            } else if ("DELETE".equalsIgnoreCase(lastOpt)) {
                status = "SUCCESS".equalsIgnoreCase(error) ? 2 : 0;
            }
        }
        return status;
    }

    protected static int getSyncUserStatus(String uniqueName, String adapterclass, String adapterid) {
        return SyncUserDB.getSyncUserStatus(SyncUserDB.getSyncUser(uniqueName, adapterclass, adapterid));
    }

    protected static void setSuccess(String id) throws UMException {
        String methodName = "setSuccess(String index)";
        Connection conn = null;
        PreparedStatement stmtUpdate = null;
        trace.debugT("setSuccess(String index)", "to user with id: " + id);
        try {
            try {
                conn = _pool.getConnection("setSuccess");
                StringBuffer sql = new StringBuffer(100);
                sql.append("UPDATE ");
                sql.append(syncTable);
                sql.append(" SET ");
                sql.append(errorColumn).append("=?, ");
                sql.append(detailsColumn).append("=?");
                sql.append(" WHERE ");
                sql.append(iDColumn).append("=?");
                stmtUpdate = conn.prepareStatement(sql.toString());
                stmtUpdate.setString(1, "SUCCESS");
                stmtUpdate.setString(2, " ");
                stmtUpdate.setString(3, id);
                stmtUpdate.executeUpdate();
                conn.commit();
            }
            catch (Exception ex) {
                trace.errorT("setSuccess ", ex.getMessage(), ex);
                throw new UMException((Throwable)ex);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SyncUserDB.closePreparedStatement(stmtUpdate, "setSuccess(String index)");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(stmtUpdate, "setSuccess(String index)");
        _pool.releaseConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SyncUser[] getSyncUsers(String uniqueid, String adapterclass, String adapterid) {
        String methodName = "getSyncUsers";
        StringBuffer sql = new StringBuffer(sqlAll.toString());
        Connection conn = null;
        PreparedStatement ps = null;
        SyncUser[] users = null;
        try {
            try {
                conn = _pool.getConnection("getSyncUsers");
                sql.append(" WHERE ");
                sql.append(userIDColumn).append("=? AND ");
                sql.append(userIDHashColumn).append("=? AND ");
                sql.append(adapterIDColumn).append("=? AND ");
                sql.append(adapterIDHashColumn).append("=? AND ");
                sql.append(adapterClassColumn).append("=? AND ");
                sql.append(adapterClassHashColumn).append("=?");
                ps = conn.prepareStatement(sql.toString());
                ps.setString(1, uniqueid);
                ps.setLong(2, Util.getHash(uniqueid));
                ps.setString(3, adapterid);
                ps.setLong(4, Util.getHash(adapterid));
                ps.setString(5, adapterclass);
                ps.setLong(6, Util.getHash(adapterclass));
                users = SyncUserDB.getSyncUsers(ps);
            }
            catch (Exception ex) {
                trace.errorT("getSyncUsers", ex.getMessage(), ex);
                Object var10_9 = null;
                SyncUserDB.closePreparedStatement(ps, "getSyncUsers");
                _pool.releaseConnection(conn);
                return users;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            SyncUserDB.closePreparedStatement(ps, "getSyncUsers");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(ps, "getSyncUsers");
        _pool.releaseConnection(conn);
        return users;
    }

    private static SyncUser[] getSyncUsers(PreparedStatement stmtGetAll) throws UMException {
        String methodName = "getSyncUsers";
        trace.debugT("getSyncUsers", "SQL = " + stmtGetAll.toString());
        Vector<SyncUser> tsUsers = new Vector<SyncUser>();
        ResultSet rs = null;
        try {
            try {
                rs = stmtGetAll.executeQuery();
                while (rs.next()) {
                    SyncUser user = new SyncUser(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getTimestamp(8), rs.getString(7));
                    tsUsers.add(user);
                }
            }
            catch (SQLException ex) {
                trace.errorT("getSyncUsers", ex.getMessage(), ex);
                throw new UMException((Throwable)ex);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SyncUserDB.closeResultSet(rs, "getSyncUsers");
            throw throwable;
        }
        SyncUserDB.closeResultSet(rs, "getSyncUsers");
        trace.debugT("getSyncUsers", tsUsers.size() + "users returned.");
        return tsUsers.isEmpty() ? null : tsUsers.toArray(new SyncUser[tsUsers.size()]);
    }

    private static SyncUser getSyncUser(String uniqueID, String adapterclass, String adapterid) {
        SyncUser[] users = SyncUserDB.getSyncUsers(uniqueID, adapterclass, adapterid);
        return SyncUserDB.getSyncUser(users);
    }

    private static SyncUser getSyncUser(SyncUser[] users) {
        SyncUser syncUser = null;
        if (null != users) {
            int size = users.length;
            syncUser = users[0];
            if (size > 1) {
                StringBuffer comparator = new StringBuffer(DATE);
                comparator.insert(0, "+");
                SyncUserComparator suc = new SyncUserComparator(comparator.toString());
                Arrays.sort(users, suc);
                syncUser = users[size - 1];
                SyncUser[] toBeDeletedUsers = new SyncUser[size - 1];
                int i = 0;
                while (i < size - 1) {
                    toBeDeletedUsers[i] = users[i];
                    ++i;
                }
                SyncUserDB.deleteSyncedUsers(toBeDeletedUsers);
            }
        }
        return syncUser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteSyncedUsers(SyncUser[] users) {
        String methodName = "deleteSyncedUsers";
        Connection conn = null;
        PreparedStatement stmtdel = null;
        try {
            try {
                conn = _pool.getConnection("deleteSyncedUsers");
                int size = users.length;
                SyncUser user = null;
                StringBuffer sql = new StringBuffer(100);
                sql.append("DELETE FROM ").append(syncTable);
                sql.append(" WHERE ");
                sql.append(userIDColumn).append("=? AND ");
                sql.append(adapterClassColumn).append("=? AND ");
                sql.append(adapterIDColumn).append("=? AND ");
                sql.append(dTTimeColumn).append("=?");
                stmtdel = conn.prepareStatement(sql.toString());
                int i = 0;
                while (true) {
                    if (i >= size) {
                        if (null != stmtdel) {
                            stmtdel.executeBatch();
                            conn.commit();
                        }
                        break;
                    }
                    user = users[i];
                    stmtdel.clearParameters();
                    stmtdel.setString(1, user.getUid());
                    stmtdel.setString(2, user.getAdapterClass());
                    stmtdel.setString(3, user.getAdapterId());
                    stmtdel.setTimestamp(4, user.getTimeStamp());
                    stmtdel.addBatch();
                    ++i;
                }
            }
            catch (ConnectionTimeoutException ex) {
                trace.errorT("deleteSyncedUsers", ex.getMessage(), (Throwable)((Object)ex));
                Object var9_11 = null;
                SyncUserDB.closePreparedStatement(stmtdel, "deleteSyncedUsers");
                _pool.releaseConnection(conn);
                return;
            }
            catch (SQLException ex) {
                trace.errorT("deleteSyncedUsers", ex.getMessage(), ex);
                Object var9_12 = null;
                SyncUserDB.closePreparedStatement(stmtdel, "deleteSyncedUsers");
                _pool.releaseConnection(conn);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            SyncUserDB.closePreparedStatement(stmtdel, "deleteSyncedUsers");
            _pool.releaseConnection(conn);
            throw throwable;
        }
        SyncUserDB.closePreparedStatement(stmtdel, "deleteSyncedUsers");
        _pool.releaseConnection(conn);
    }

    private static void closePreparedStatement(PreparedStatement stmt, String methodName) {
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (Exception ex) {
                trace.warningT(methodName, "Error while closing prepared statement: " + ex.getMessage(), ex);
            }
        }
    }

    private static void closeResultSet(ResultSet res, String methodName) {
        if (null != res) {
            try {
                res.close();
            }
            catch (Exception ex) {
                trace.warningT(methodName, "Error while closing result set: " + ex.getMessage(), ex);
            }
        }
    }

    static {
        sqlAll.append("SELECT ");
        sqlAll.append(iDColumn).append(", ");
        sqlAll.append(userIDColumn).append(", ");
        sqlAll.append(operationNameColumn).append(", ");
        sqlAll.append(adapterClassColumn).append(", ");
        sqlAll.append(adapterIDColumn).append(", ");
        sqlAll.append(errorColumn).append(", ");
        sqlAll.append(detailsColumn).append(", ");
        sqlAll.append(dTTimeColumn);
        sqlAll.append(" FROM ").append(syncTable);
    }
}

