/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.core.persistence.replication.imp.usersync.SyncUser;
import java.util.Comparator;
import java.util.Date;

public class SyncUserComparator
implements Comparator {
    public static final String DESC = "-";
    public static final String ASCE = "+";
    private String _orderby;

    public SyncUserComparator(String orderby) {
        this._orderby = orderby;
    }

    public int compare(Object obj1, Object obj2) throws ClassCastException {
        SyncUser user1 = (SyncUser)obj1;
        SyncUser user2 = (SyncUser)obj2;
        int i = 0;
        boolean desc = this.isDesc(this._orderby);
        String field = this.removePrefix(this._orderby);
        if ("displayname".equalsIgnoreCase(field)) {
            String dn2;
            String dn1 = user1.getDisplayName();
            i = dn1.compareToIgnoreCase(dn2 = user2.getDisplayName());
            if (i != 0) {
                return this.checkCondition(i, desc);
            }
            return 1;
        }
        if ("adapterid".equalsIgnoreCase(field)) {
            String dn2;
            String dn1 = user1.getAdapterId();
            i = dn1.compareToIgnoreCase(dn2 = user2.getAdapterId());
            if (i != 0) {
                return this.checkCondition(i, desc);
            }
            return 1;
        }
        if ("date".equalsIgnoreCase(field)) {
            Date dt1 = user1.getTime();
            Date dt2 = user2.getTime();
            i = 1;
            if (dt1.before(dt2)) {
                i = -1;
            }
            if (i != 0) {
                return this.checkCondition(i, desc);
            }
            return 1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof SyncUserComparator;
    }

    private boolean isDesc(String field) {
        return field.startsWith(DESC);
    }

    private String removePrefix(String field) {
        if (field.startsWith(ASCE) || field.startsWith(DESC)) {
            return field.substring(1, field.length());
        }
        return field;
    }

    private int checkCondition(int i, boolean desc) {
        if (desc) {
            if (i < 0) {
                return 1;
            }
            if (i > 0) {
                return -1;
            }
        }
        return i;
    }
}

