/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.replication.imp.usersync.UserSyncStruct;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SyncStore {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncStore.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncStore.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    private static IConnectionPool _pool = InternalUMFactory.getJdbcConnectionPool();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addUsers(UserSyncStruct uss, int isroleset) throws ConnectionTimeoutException {
        Connection conn;
        block9: {
            conn = null;
            Statement stmt = null;
            try {
                try {
                    conn = _pool.getConnection("addUsers");
                    String sql = "INSERT INTO UME_USERSYNCTEMP (ID,USER_ID,OPERATION_NAME,ISROLESET,USER_IDH,OPERATION_NAMEH) VALUES(?,?,?,?,?,?)";
                    stmt = conn.prepareStatement(sql);
                    stmt.setString(1, uss.getID());
                    stmt.setString(2, uss.getUserID());
                    stmt.setString(3, uss.getOperation());
                    stmt.setInt(4, isroleset);
                    stmt.setLong(5, Util.getHash(uss.getUserID()));
                    stmt.setLong(6, Util.getHash(uss.getOperation()));
                    stmt.executeUpdate();
                    conn.commit();
                }
                catch (SQLException e) {
                    trace.errorT("addUsers", "sqlexception occurred", e);
                    throw new UMRuntimeException((Throwable)e);
                }
                Object var6_6 = null;
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlex) {
                        throw new UMRuntimeException(sqlex.getMessage());
                    }
                }
                _pool.releaseConnection(conn);
                throw throwable;
            }
            try {}
            catch (SQLException sqlex) {
                throw new UMRuntimeException(sqlex.getMessage());
            }
            stmt.close();
        }
        _pool.releaseConnection(conn);
    }

    public static Enumeration getUsersToBeSynced() {
        Connection conn = null;
        Vector<UserSyncStruct> vSync = new Vector<UserSyncStruct>();
        try {
            try {
                conn = _pool.getConnection("getUsersToBeSynced");
                String sql = "SELECT ID,USER_ID,OPERATION_NAME,USER_IDH,OPERATION_NAMEH FROM UME_USERSYNCTEMP WHERE ISROLESET=1";
                PreparedStatement stmt = conn.prepareStatement(sql);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    UserSyncStruct uss = new UserSyncStruct(rs.getString(1), rs.getString(2), rs.getString(3));
                    vSync.add(uss);
                }
                stmt.close();
            }
            catch (Exception e) {
                trace.errorT("run", e.getMessage(), e);
                Enumeration enumeration = null;
                Object var7_9 = null;
                _pool.releaseConnection(conn);
                return enumeration;
            }
            Object var7_8 = null;
            _pool.releaseConnection(conn);
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            _pool.releaseConnection(conn);
            throw throwable;
        }
        return vSync.elements();
    }

    public static synchronized boolean lock(String id) throws ConnectionTimeoutException {
        Connection conn = null;
        try {
            try {
                conn = _pool.getConnection("lock");
                PreparedStatement stmt = conn.prepareStatement("INSERT INTO UME_USERSYNCLOCK(ID,WHENLOCKED) VALUES(?,?)");
                stmt.setString(1, id);
                stmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                stmt.executeUpdate();
                stmt.close();
            }
            catch (SQLException e) {
                trace.errorT("lock", e.getMessage(), e);
                boolean bl = false;
                Object var5_5 = null;
                _pool.releaseConnection(conn);
                return bl;
            }
            Object var5_4 = null;
            _pool.releaseConnection(conn);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            _pool.releaseConnection(conn);
            throw throwable;
        }
        return true;
    }

    public static synchronized boolean unlock(String id) throws ConnectionTimeoutException {
        Connection conn = null;
        try {
            try {
                conn = _pool.getConnection("unlock");
                PreparedStatement stmtdel = conn.prepareStatement("DELETE FROM UME_USERSYNCTEMP WHERE ID=?");
                stmtdel.setString(1, id);
                stmtdel.executeUpdate();
                stmtdel.close();
                PreparedStatement stmtdellock = conn.prepareStatement("DELETE FROM UME_USERSYNCLOCK WHERE ID=?");
                stmtdellock.setString(1, id);
                stmtdellock.executeUpdate();
                stmtdellock.close();
            }
            catch (SQLException e) {
                trace.errorT("unlock", e.getMessage(), e);
                boolean bl = false;
                Object var5_7 = null;
                _pool.releaseConnection(conn);
                return bl;
            }
            Object var5_6 = null;
            _pool.releaseConnection(conn);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            _pool.releaseConnection(conn);
            throw throwable;
        }
        return true;
    }
}

