/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.usersync;

import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.ISecondaryStorage;
import com.sap.security.core.persistence.replication.PersistenceException;
import com.sap.security.core.persistence.replication.PersistenceResult;
import com.sap.security.core.persistence.replication.imp.usersync.SyncUser;
import com.sap.security.core.persistence.replication.imp.usersync.SyncUserDB;
import com.sap.security.core.persistence.replication.imp.usersync.Utils;
import com.sap.security.core.role.IScopeDefinition;
import com.sap.security.core.role.IServiceRepository;
import com.sap.security.core.util.IUMTrace;
import com.sapmarkets.tpd.TradingPartnerDirectoryCommon;
import com.sapmarkets.tpd.master.PartnerID;
import com.sapmarkets.tpd.master.TradingPartnerDirectoryInterface;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import com.sapmarkets.tpd.util.TpdException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SyncService {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncService.java#6 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    public static final String DATE = "date";
    public static final String DISPLAYNAME = "displayname";
    public static final String ADAPTERID = "adapterid";
    public static final String CREATE = "CREATE";
    public static final String UPDATE = "UPDATE";
    public static final String DELETE = "DELETE";
    public static final int SYNC_SUCCESSFUL = 0;
    public static final int SYNC_FAILED = -1;
    public static final int USER_NOT_FOUND = 1;
    public static final int CLASSLOAD_FAILED = 2;
    public static final int USER_HAS_NOADAPTERID_ASSOCIATED = 3;
    public static final int USER_NOLONGER_EXIST_IN_UM = 11;
    public static final int USERACCOUNT_NOLONGER_EXIST_IN_UM = 12;
    public static final int RESEND_ALTERNATE_ON_DELETE = 21;
    public static final int NOT_SUPPORTED_OPERATION = 31;
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/usersync/SyncService.java#6 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    private static List _operations;
    private static ArrayList _alladapters;

    public static SyncUser[] getFailedUsers() {
        try {
            return SyncUserDB.getFailedUsers();
        }
        catch (UMException ex) {
            trace.debugT("getFailedUsers()", ex);
            return null;
        }
    }

    public static SyncUser getSyncUser(String index) {
        try {
            return SyncUserDB.getSyncUser(index);
        }
        catch (UMException ex) {
            trace.debugT("getSyncUser", ex);
            return null;
        }
    }

    public static int igoreErrors(String index) {
        try {
            SyncUserDB.setSuccess(index);
        }
        catch (UMException ex) {
            trace.warningT("ignoreErrors", ex.getMessage(), ex);
            return -1;
        }
        return 0;
    }

    public static int resend(String index, boolean alternate) {
        String methodName = "resendAlternate(String index)";
        SyncUser user = null;
        try {
            user = SyncUserDB.getSyncUser(index);
        }
        catch (UMException ex) {
            trace.warningT("resend", "failed to read from synctable");
            return 1;
        }
        if (user == null) {
            trace.warningT("resendAlternate(String index)", "Invalid index, no failed user found for this index", new String[]{index});
            return 1;
        }
        if (alternate) {
            String operation = user.getOperation();
            if (CREATE.equalsIgnoreCase(operation)) {
                user.setOperation(UPDATE);
            } else if (UPDATE.equalsIgnoreCase(operation)) {
                user.setOperation(CREATE);
            } else {
                if (DELETE.equalsIgnoreCase(operation)) {
                    trace.warningT("resendAlternate(String index)", "resendAlternate() can not be called on failed delete operation");
                    return 21;
                }
                return 31;
            }
        }
        ISecondaryStorage up = null;
        int size = _alladapters.size();
        String adapterClass = user.getAdapterClass().trim();
        int i = 0;
        while (i < size) {
            if (((ISecondaryStorage)_alladapters.get(i)).getClass().getName().equalsIgnoreCase(adapterClass)) {
                up = (ISecondaryStorage)_alladapters.get(i);
                break;
            }
            ++i;
        }
        if (null == up) {
            trace.errorT("resend", "resend failed, class can't be loaded");
            return 2;
        }
        String adapterId = user.getAdapterId();
        if (null == adapterId) {
            trace.errorT("resend", "resend failed, adapterid is not attached to the user");
            return 3;
        }
        IUser[] users = new IUser[1];
        IUserAccount ua = null;
        try {
            ua = UMFactory.getUserAccountFactory().getUserAccountByLogonId(user.getUid());
        }
        catch (UMException ex) {
            trace.errorT("resend", ex.getMessage(), ex);
            return 12;
        }
        try {
            users[0] = ua.getAssignedUser();
        }
        catch (UMException ex) {
            trace.errorT("resend", ex.getMessage(), ex);
            return 11;
        }
        up.setId(adapterId);
        ArrayList<ISecondaryStorage> adapter = new ArrayList<ISecondaryStorage>(1);
        adapter.add(up);
        try {
            SyncService.sync(users, user.getOperation(), adapter);
        }
        catch (UMException ex) {
            trace.errorT("resend", ex.getMessage(), ex);
            return -1;
        }
        return 0;
    }

    public static void syncUsers(IUser[] users, String mode, ArrayList adapters) throws UMException {
        if (null == adapters || adapters.isEmpty()) {
            trace.warningT("syncUsers", "no adapter defined, go back to caller");
            throw new UMException("UserSyncHandler, no snyc takes place, no adapter defined");
        }
        if (null == users) {
            trace.warningT("syncUsers", "no sync takes place, user is null");
            throw new UMException("UserSyncHandler, no snyc takes place, no user past");
        }
        if (null == mode || !_operations.contains(mode)) {
            trace.warningT("syncUsers", "no sync takes place, adapters is null");
            throw new UMException("UserSyncHandler, no snyc takes place, no mode specified");
        }
        SyncService.sync(users, mode, adapters);
    }

    public static void syncCompanyUsers(String tpid, String mode, ArrayList adapters) throws UMException {
        if (null == tpid) {
            trace.warningT("syncCompanyUsers", "no sync takes place, user is null");
            throw new UMException("UserSyncHandler, no snyc takes place, no trading partner specified");
        }
        if (null == adapters || adapters.isEmpty()) {
            trace.warningT("syncCompanyUsers", "no adapter defined, go back to caller");
            throw new UMException("UserSyncHandler, no snyc takes place, no adapter defined");
        }
        if (null == mode || !_operations.contains(mode)) {
            trace.warningT("syncCompanyUsers", "no sync takes place, adapters is null");
            throw new UMException("UserSyncHandler, no snyc takes place, no mode specified");
        }
        IUserFactory uf = UMFactory.getUserFactory();
        IUserSearchFilter filter = uf.getUserSearchFilter();
        filter.setCompany(tpid, 0, false);
        ISearchResult sres = uf.searchUsers(filter);
        int size = sres.size();
        if (size <= 0) {
            trace.warningT("SyncService", "no sync takes place, no user belong to the specified tp", new String[]{tpid});
            throw new UMException("UserSyncHandler, no snyc takes place, no user past");
        }
        IUser[] users = new IUser[size];
        int i = 0;
        while (sres.hasNext()) {
            users[i++] = uf.getUser((String)sres.next());
        }
        SyncService.sync(users, mode, adapters);
    }

    public static void syncAllUsers(String mode, ArrayList adapters) throws UMException {
        if (null == adapters || adapters.isEmpty()) {
            trace.warningT("syncAllUsers", "no adapter defined, go back to caller");
            throw new UMException("UserSyncHandler, no snyc takes place, no adapter defined");
        }
        if (null == mode || !_operations.contains(mode)) {
            trace.warningT("syncAllUsers", "no sync takes place, adapters is null");
            throw new UMException("UserSyncHandler, no snyc takes place, no mode specified");
        }
        IUserFactory uf = UMFactory.getUserFactory();
        ISearchResult sr = uf.getUniqueIDs();
        int size = sr.size();
        IUser[] users = new IUser[size];
        int i = 0;
        while (sr.hasNext()) {
            users[i++] = uf.getUser((String)sr.next());
        }
        SyncService.sync(users, mode, adapters);
    }

    public static boolean isServiceEnabled() {
        if (null == _alladapters || _alladapters.isEmpty()) {
            trace.warningT("isServiceEnabled", "no adapters defined");
            return false;
        }
        trace.debugT("isServiceEnabled", "adapters defined");
        return true;
    }

    protected static void autoSyncUsers(IUser[] users, String operation) throws UMException {
        if (_alladapters.isEmpty()) {
            trace.infoT("static", "no adapter defined, go back to caller");
            return;
        }
        if (null == users) {
            trace.warningT("SyncService", "no sync takes place, user is null");
            return;
        }
        if (null == operation || !_operations.contains(operation)) {
            trace.warningT("UserSyncHanlder", "no sync takes place, adapters is null");
            return;
        }
        ISecondaryStorage secondary = null;
        IUser[] tobeSyncedUsers = new IUser[1];
        IUser user = null;
        String tobeSyncedOperation = null;
        Exception th = null;
        PersistenceResult[] pr = null;
        int i = 0;
        int size = _alladapters.size();
        while (i < size) {
            secondary = (ISecondaryStorage)_alladapters.get(i);
            int j = 0;
            while (j < users.length) {
                block14: {
                    try {
                        pr = null;
                        user = users[j];
                        tobeSyncedOperation = SyncService.getToBeSyncedOperation(user, operation, secondary);
                        if (null == tobeSyncedOperation) break block14;
                        tobeSyncedUsers[0] = user;
                        if (UPDATE.equalsIgnoreCase(tobeSyncedOperation)) {
                            pr = secondary.updateUsers(tobeSyncedUsers);
                        } else if (CREATE.equalsIgnoreCase(tobeSyncedOperation)) {
                            pr = secondary.createUsers(tobeSyncedUsers);
                        } else {
                            IUserAccount[] ua = user.getUserAccounts();
                            String logonid = user.getUniqueName();
                            if (ua.length > 0) {
                                logonid = ua[0].getLogonUid();
                            }
                            pr = secondary.deleteUsers(new String[]{logonid, Utils.getR3ID(user)});
                        }
                    }
                    catch (Exception ex) {
                        String msg = ex.getMessage() == null ? "sync failed" : ex.getMessage();
                        trace.errorT("autoSync", msg, ex);
                        th = ex;
                    }
                    if (null != th) {
                        SyncService.saveSyncUsers(tobeSyncedUsers, tobeSyncedOperation, secondary, th);
                    } else {
                        SyncService.saveSyncUser(tobeSyncedUsers, pr, secondary, tobeSyncedOperation);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected static void syncDeletedUsers(String[] uniqueNames) {
        if (null == uniqueNames) {
            trace.infoT("static", "no unqiueIds passed, go back to caller");
            return;
        }
        Iterator ita = ((AbstractList)_alladapters).iterator();
        ISecondaryStorage secondary = null;
        int size = uniqueNames.length;
        PersistenceResult[] pr = null;
        String[] uniqueName = new String[2];
        String uName = null;
        String adapterid = null;
        String adapterclass = null;
        int status = -1;
        SyncUser syncUser = null;
        int i = 0;
        while (i < size) {
            uniqueName[0] = uName = uniqueNames[i];
            while (ita.hasNext()) {
                secondary = (ISecondaryStorage)ita.next();
                syncUser = SyncUserDB.getSyncUser(uName, secondary);
                adapterid = secondary.getId();
                adapterclass = secondary.getClass().getName();
                if (null == syncUser) {
                    trace.infoT("syncDeletedUsers", "not to delete user on that adapter since it has never been synced to that system", new String[]{uName, adapterclass, adapterid});
                    continue;
                }
                status = SyncUserDB.getSyncUserStatus(syncUser);
                if (status == 2) {
                    trace.infoT("syncDeletedUsers", "not to delete user on that adapter since it has been deleted from that system", new String[]{uName, adapterclass, adapterid});
                    continue;
                }
                Throwable th = null;
                uniqueName[1] = syncUser.getIndex();
                try {
                    pr = secondary.deleteUsers(uniqueName);
                }
                catch (Throwable te) {
                    trace.warningT("start", "storing failed operations in failed user db", te);
                    th = te;
                }
                if (null != th && null != pr && null != pr[0]) {
                    th = pr[0].getException();
                }
                try {
                    SyncService.saveSyncUser(uniqueName[1], uName, DELETE, secondary, th);
                }
                catch (Throwable te) {
                    trace.warningT("saveSyncUser", "storing failed operations in failed user db", te);
                }
            }
            ++i;
        }
    }

    private static void sync(IUser[] users, String operation, ArrayList adapters) throws UMException {
        if (users == null) {
            return;
        }
        Iterator ita = ((AbstractList)adapters).iterator();
        if (!(adapters.get(0) instanceof ISecondaryStorage)) {
            ita = ((AbstractList)Utils.loadPersistenceAdapters(adapters)).iterator();
        }
        while (ita.hasNext()) {
            ISecondaryStorage secondary = (ISecondaryStorage)ita.next();
            PersistenceResult[] pr = null;
            boolean isSyncUserSaved = false;
            try {
                if (CREATE.equalsIgnoreCase(operation)) {
                    pr = secondary.createUsers(users);
                } else if (UPDATE.equalsIgnoreCase(operation)) {
                    pr = secondary.updateUsers(users);
                } else if (DELETE.equalsIgnoreCase(operation)) {
                    int size = users.length;
                    String[] uniquenames = new String[size * 2];
                    IUser user = null;
                    IUserAccount[] ua = new IUserAccount[1];
                    int i = 0;
                    int j = 0;
                    while (i < size) {
                        user = users[i];
                        ua = user.getUserAccounts();
                        uniquenames[j] = user.getUniqueName();
                        if (ua.length > 0) {
                            uniquenames[j] = ua[0].getLogonUid();
                        }
                        uniquenames[++j] = Utils.getR3ID(user);
                        ++i;
                        ++j;
                    }
                    pr = secondary.deleteUsers(uniquenames);
                }
            }
            catch (Throwable te) {
                trace.warningT("sync", "storing failed operations in failed user db", te);
                SyncService.saveSyncUsers(users, operation, secondary, te);
                isSyncUserSaved = true;
            }
            if (isSyncUserSaved) continue;
            SyncService.saveSyncUser(users, pr, secondary, operation);
        }
    }

    private static void saveSyncUsers(IUser[] users, String mode, ISecondaryStorage observer, Throwable e) {
        IUser user = null;
        int i = 0;
        while (i < users.length) {
            user = users[i];
            SyncService.saveSyncUser(Utils.getR3ID(user), Utils.getLogonId(user), mode, observer, e);
            ++i;
        }
    }

    private static void saveSyncUser(IUser[] users, PersistenceResult[] pr, ISecondaryStorage observer, String mode) {
        Exception th = null;
        IUser user = null;
        int j = 0;
        while (j < users.length) {
            user = users[j];
            trace.debugT("saveSyncUser", user.getUniqueName() + " is being saved in SyncUser db");
            if (pr != null && pr[j] != null) {
                th = pr[j].getException();
            }
            SyncService.saveSyncUser(Utils.getR3ID(user), Utils.getLogonId(user), mode, observer, th);
            ++j;
        }
    }

    private static void saveSyncUser(String r3id, String useruniquename, String operation, ISecondaryStorage observer, Throwable e) {
        String details = null;
        String message = null;
        if (e != null) {
            if (e instanceof PersistenceException) {
                details = ((PersistenceException)((Object)e)).getDetails();
            }
            message = e.getMessage();
        }
        SyncUser syncuser = new SyncUser(r3id, useruniquename, operation, observer.getClass().getName(), observer.getId(), message, details);
        try {
            if (!CREATE.equalsIgnoreCase(operation)) {
                SyncUserDB.updateSyncUser(syncuser);
            } else {
                SyncUserDB.saveSyncUser(syncuser);
            }
        }
        catch (Exception ex) {
            trace.errorT("saveFailedUser", ex.getMessage(), ex);
        }
    }

    private static String getToBeSyncedOperation(IUser user, String operation, ISecondaryStorage adapter) {
        String toBeSyncedOperation = null;
        int status = SyncUserDB.getSyncUserStatus(user.getUniqueName(), adapter.getClass().getName(), adapter.getId());
        boolean withinScope = SyncService.checkScope(user, adapter);
        switch (status) {
            case -1: 
            case 2: {
                if (!withinScope) break;
                toBeSyncedOperation = CREATE;
                break;
            }
            case 0: 
            case 1: {
                if (withinScope) {
                    if (!UPDATE.equalsIgnoreCase(operation)) break;
                    toBeSyncedOperation = UPDATE;
                    break;
                }
                toBeSyncedOperation = DELETE;
                break;
            }
            default: {
                toBeSyncedOperation = null;
            }
        }
        return toBeSyncedOperation;
    }

    private static boolean tpScope(TradingPartnerInterface company, String[] scope) {
        boolean retval = false;
        IServiceRepository _sp = InternalUMFactory.getServiceRepository();
        int i = 0;
        while (i < scope.length) {
            IScopeDefinition _isd = _sp.getScopeDefinitionByName(scope[i]);
            if (_isd != null) {
                retval = retval || _sp.belongsToScope(company, _isd);
            }
            ++i;
        }
        return retval;
    }

    private static boolean checkScope(IUser user, ISecondaryStorage adapter) {
        String[] scope = adapter.getScope();
        String[] companies = adapter.getCompanies();
        Boolean retval1 = null;
        Boolean retval2 = null;
        String compid = user.getCompany();
        TradingPartnerInterface tp = null;
        if (null == scope) {
            if (null == companies) {
                return true;
            }
            if (null == compid) {
                retval2 = Boolean.FALSE;
            } else if (null == tp) {
                tp = SyncService.getCompany(compid);
                boolean bVal = false;
                int c = 0;
                while (c < companies.length) {
                    bVal = bVal || tp.getDisplayName().equalsIgnoreCase(companies[c]);
                    ++c;
                }
                retval2 = new Boolean(bVal);
            }
        } else if (compid == null) {
            retval1 = new Boolean(SyncService.tpScope(null, scope));
        } else {
            tp = SyncService.getCompany(compid);
            if (tp != null) {
                retval1 = new Boolean(SyncService.tpScope(tp, scope));
            } else {
                trace.errorT("checkScope", "Could not retrieve TP object from TPD API. Company id=" + compid);
                return false;
            }
        }
        if (null == retval1) {
            return null == retval2 ? false : retval2;
        }
        return null == retval2 ? retval1 : retval1 != false && retval2 != false;
    }

    private static TradingPartnerInterface getCompany(String companyid) {
        try {
            trace.debugT("getCompany", "Fetching company..." + companyid);
            TradingPartnerDirectoryInterface tpd = TradingPartnerDirectoryCommon.getTPD();
            PartnerID mpid = PartnerID.instantiatePartnerID((String)companyid);
            return tpd.getPartner(mpid);
        }
        catch (TpdException exp) {
            trace.errorT("getCompany", exp);
            throw new UMRuntimeException((Throwable)exp);
        }
        catch (Throwable exp) {
            trace.errorT("getCompany", "Please check the connection to the TPD DB. Message:", exp);
            throw new UMRuntimeException(exp);
        }
    }

    static {
        _alladapters = Utils.getSecondaryStorages();
        ArrayList<String> legalOpts = new ArrayList<String>(3);
        legalOpts.add(CREATE);
        legalOpts.add(UPDATE);
        legalOpts.add(DELETE);
        _operations = legalOpts;
    }
}

