/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.ISecondaryStorage;
import com.sap.security.core.persistence.replication.PersistenceException;
import com.sap.security.core.persistence.replication.PersistenceResult;
import com.sap.security.core.persistence.replication.imp.adapters.r3.CreateSyncXML;
import com.sap.security.core.persistence.replication.imp.adapters.r3.ProcessR3RespDoc;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmSyncR3;
import com.sap.security.core.util.IUMTrace;
import java.util.Vector;

public class UserPersistenceXML
implements ISecondaryStorage {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UserPersistenceXML.java#3 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace trace;
    private static IUMParameters mysapprop;
    private String _r3_id = null;
    private String _uid = null;
    private String _pswd = null;
    private String _adapter_name = null;
    private String[] _scope;
    private String[] _companies;

    public UserPersistenceXML() {
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        mysapprop = UMFactory.getProperties();
    }

    public UserPersistenceXML(String r3name) {
        this();
        this._r3_id = r3name;
    }

    public void setId(String id) {
        this._r3_id = id;
        trace.infoT("setId", "R3Name set to: " + id);
    }

    public void setUser(String uid, String pswd) {
        this._uid = uid.toUpperCase();
        this._pswd = pswd;
        trace.infoT("setUser", "R3 UserId set to: " + uid);
    }

    public String getName() {
        return this._adapter_name;
    }

    public String getId() {
        return this._r3_id;
    }

    public int hashCode() {
        return this.hashCode();
    }

    public boolean equals(Object adapter) {
        if (adapter == null || !(adapter instanceof UserPersistenceXML)) {
            return false;
        }
        UserPersistenceXML up = (UserPersistenceXML)adapter;
        return up.getId().equalsIgnoreCase(this._r3_id);
    }

    public PersistenceResult[] createUsers(IUser[] users) throws UMException {
        return this.syncDoc(users, "CREATE");
    }

    public PersistenceResult[] updateUsers(IUser[] users) throws UMException {
        return this.syncDoc(users, "UPDATE");
    }

    public PersistenceResult[] deleteUsers(String[] users) throws UMException {
        return this.syncDoc(users, "DELETE");
    }

    public ISearchResult getUniqueIDs() {
        return null;
    }

    public void setScope(String[] scope) {
        this._scope = scope;
    }

    public String[] getScope() {
        return this._scope;
    }

    public void setCompanies(String[] companies) {
        this._companies = companies;
    }

    public String[] getCompanies() {
        return this._companies;
    }

    private PersistenceResult[] syncDoc(Object[] userarray, String oper) throws PersistenceException {
        String methodname = "syncDoc-" + oper;
        trace.entering(methodname);
        IUser[] users = null;
        String[] uniquenames = null;
        int length = -1;
        if (null == userarray || userarray.length < 1) {
            trace.errorT(methodname, "failed to generate xml, no user past");
            return null;
        }
        length = userarray.length;
        if (userarray[0] instanceof IUser) {
            users = (IUser[])userarray;
        } else {
            uniquenames = (String[])userarray;
            length /= 2;
        }
        String errDoc = null;
        String errmsg = null;
        Vector<PersistenceResult> v = new Vector<PersistenceResult>();
        boolean connectionError = false;
        ProcessR3RespDoc r3SyncDoc = null;
        UmSyncR3 syncR3 = null;
        try {
            int i = 0;
            int k = 0;
            while (i < length) {
                byte[] iBytes;
                if ("DELETE".equalsIgnoreCase(oper)) {
                    trace.infoT(methodname, "Start Users syncDocs on " + this._r3_id + " for id: " + uniquenames[i]);
                } else {
                    trace.infoT(methodname, "Start Users syncDocs on " + this._r3_id + " for id: " + users[i].getDisplayName());
                }
                CreateSyncXML doc = new CreateSyncXML(this._r3_id);
                if ("CREATE".equalsIgnoreCase(oper)) {
                    iBytes = doc.getCreateSyncDoc(users[i]);
                } else if ("UPDATE".equalsIgnoreCase(oper)) {
                    iBytes = doc.getChangeSyncDoc(users[i]);
                } else if ("DELETE".equalsIgnoreCase(oper)) {
                    iBytes = doc.getDeleteSyncDoc(uniquenames[k], uniquenames[k + 1]);
                } else {
                    trace.errorT(methodname, "Invalid operations requested: " + oper);
                    return null;
                }
                errDoc = null;
                errmsg = null;
                if (iBytes != null && iBytes.length != 0) {
                    int n;
                    int nErrDocs;
                    block32: {
                        trace.debugT(methodname, "syncDoc: " + iBytes.toString());
                        nErrDocs = 0;
                        r3SyncDoc = null;
                        syncR3 = null;
                        try {
                            if (this._r3_id == null) {
                                trace.debugT(methodname, "*** Error: R3 id has not been set..update skipped ***");
                                break block32;
                            }
                            try {
                                syncR3 = new UmSyncR3(this._r3_id);
                            }
                            catch (Exception ex) {
                                connectionError = true;
                                errmsg = ex.getMessage();
                                trace.debugT(methodname, "R/3 Error: " + errmsg, ex);
                            }
                            if (!connectionError) {
                                IUser user = null;
                                if (users != null) {
                                    user = users[i];
                                }
                                syncR3.SMUM_TPUser(iBytes, user);
                                if (!syncR3.getUseJCoServer()) {
                                    String name = null;
                                    name = user == null ? uniquenames[i] : user.getUniqueName();
                                    trace.infoT(methodname, name + ": returnDoc: " + syncR3.getRetDocString());
                                    r3SyncDoc = new ProcessR3RespDoc(syncR3.getXMLDoc(), iBytes);
                                    nErrDocs = r3SyncDoc.createXML();
                                    trace.debugT(methodname, nErrDocs + " errors encounterd");
                                }
                            }
                        }
                        catch (Exception ex) {
                            errmsg = ex.getMessage();
                            trace.debugT(methodname, "Sync Error: " + errmsg, ex);
                        }
                    }
                    if (errmsg != null) {
                        trace.warningT(methodname, "Error", new Object[]{errmsg});
                        n = 0;
                        while (n < users.length) {
                            v.add(new PersistenceResult(users[n].getDisplayName(), (Exception)((Object)new PersistenceException(errmsg, errDoc))));
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < nErrDocs) {
                            String syncDoc = new String(iBytes).toString();
                            int j = syncDoc.indexOf("?>");
                            if (j > 0) {
                                syncDoc = syncDoc.substring(j + 2);
                            }
                            String eDoc = "<R3Docs>" + r3SyncDoc.getRespXML(n) + syncDoc + "</R3Docs>";
                            trace.debugT(methodname, "Error(" + n + ") msg: " + r3SyncDoc.getErrMsg(n));
                            trace.debugT(methodname, "Error(" + n + ") syncDoc: " + eDoc);
                            if (r3SyncDoc.getErrMsg(n) == null) {
                                v.add(new PersistenceResult(r3SyncDoc.getUserid(n), null));
                            } else {
                                v.add(new PersistenceResult(r3SyncDoc.getUserid(n), (Exception)((Object)new PersistenceException(r3SyncDoc.getErrMsg(n), eDoc))));
                            }
                            ++n;
                        }
                    }
                }
                ++i;
                ++k;
            }
        }
        catch (Exception e) {
            String error = e.getMessage();
            if (error == null) {
                error = "unknown exception";
            }
            throw new PersistenceException(error, e.toString());
        }
        PersistenceResult[] pes = null;
        if (v.size() > 0) {
            pes = v.toArray(new PersistenceResult[1]);
        }
        trace.debugT(methodname, v.size() + " error(s) returned.");
        trace.exiting(methodname);
        return pes;
    }
}

