/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.imp.r3.R3ConnectionSAP;
import com.sap.security.core.persistence.datasource.imp.r3.UmR3UserFactory;
import com.sap.security.core.persistence.replication.ISecondaryStorage;
import com.sap.security.core.persistence.replication.PersistenceException;
import com.sap.security.core.persistence.replication.PersistenceResult;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityUtils;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.IUserMaint;
import java.util.Vector;

public class UserPersistenceR3
implements ISecondaryStorage {
    private String _r3_id = null;
    private String _uid = null;
    private String _pswd = null;
    private String _adapter_name = null;
    private final String UPDATE = "UPDATE";
    private final String CREATE = "CREATE";
    private final String DELETE = "DELETE";
    private final int CREATE_ACTION = 1;
    private final int UPDATE_ACTION = 2;
    private final int DELETE_ACTION = 3;
    private final int PASSWORD_LENGTH = 8;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UserPersistenceR3.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace;
    private static IUMParameters mysapprop;
    private String[] _scope;
    private String[] _companies;
    private UmR3UserFactory r3UserFactory = null;

    public UserPersistenceR3() {
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        mysapprop = UMFactory.getProperties();
    }

    public UserPersistenceR3(String r3name) {
        this();
        this._r3_id = r3name;
    }

    public void setId(String id) {
        this._r3_id = id;
        trace.infoT("setId", "R3Name set to: " + id);
    }

    public void setUser(String uid, String pswd) {
        this._uid = uid.toUpperCase();
        this._pswd = pswd;
        trace.infoT("setUser", "R3 UserId set to: " + uid);
    }

    public String getName() {
        return this._adapter_name;
    }

    public String getId() {
        return this._r3_id;
    }

    public int hashCode() {
        return this.hashCode();
    }

    public boolean equals(Object adapter) {
        if (adapter == null || !(adapter instanceof UserPersistenceR3)) {
            return false;
        }
        UserPersistenceR3 up = (UserPersistenceR3)adapter;
        return up.getId().equalsIgnoreCase(this._r3_id);
    }

    public PersistenceResult[] createUsers(IUser[] users) throws UMException {
        String methodname = "createUsers";
        trace.entering(methodname);
        PersistenceResult[] pr = this.replicateUser(1, users);
        trace.exiting(methodname, pr.toString());
        return pr;
    }

    public PersistenceResult[] updateUsers(IUser[] users) throws UMException {
        String methodname = "updateUsers";
        trace.entering(methodname);
        PersistenceResult[] pr = this.replicateUser(2, users);
        trace.exiting(methodname, pr.toString());
        return pr;
    }

    public PersistenceResult[] deleteUsers(String[] uniquenames) throws UMException {
        String methodname = "deleteUsers";
        trace.entering(methodname);
        PersistenceResult[] pr = this.replicateUser(3, uniquenames);
        if (pr == null) {
            trace.debugT(methodname, "No sync error.");
        } else {
            trace.debugT(methodname, pr.length + " errors returned.");
        }
        trace.exiting(methodname);
        return pr;
    }

    private PersistenceResult[] replicateUser(int opType, Object[] users) throws PersistenceException {
        String action = null;
        switch (opType) {
            case 1: {
                action = "CREATE";
                break;
            }
            case 2: {
                action = "UPDATE";
                break;
            }
            case 3: {
                action = "DELETE";
                break;
            }
            default: {
                throw new PersistenceException("Invalie replication operation type: " + opType, null);
            }
        }
        String methodname = "replicateUser-" + action;
        trace.entering(methodname);
        this.r3UserFactory = R3ConnectionSAP.getR3Factory(this._r3_id);
        Vector<PersistenceResult> v = new Vector<PersistenceResult>();
        try {
            int i = 0;
            while (i < users.length) {
                String errmsg = null;
                if (opType == 3) {
                    trace.infoT(methodname, "Start Users replication on " + this._r3_id + " for id: " + (String)users[i]);
                } else {
                    trace.infoT(methodname, "Start Users replication on " + this._r3_id + " for id: " + ((IUser)users[i]).getDisplayName());
                }
                IUserMaint r3user = null;
                try {
                    switch (opType) {
                        case 1: {
                            r3user = this.r3UserFactory.newUser(((IUser)users[i]).getUniqueName());
                            r3user.prepare();
                            this.setR3UserValues((IUser)users[i], r3user);
                            r3user.getUserAccount().setPassword(SecurityUtils.GeneratePassword(8));
                            r3user.commit();
                            this.r3UserFactory.deactivatePassword(((IUser)users[i]).getUniqueName());
                            break;
                        }
                        case 2: {
                            r3user = (IUserMaint)this.r3UserFactory.getUser(((IUser)users[i]).getUniqueName());
                            r3user.prepare();
                            this.setR3UserValues((IUser)users[i], r3user);
                            r3user.commit();
                            break;
                        }
                        case 3: {
                            r3user = (IUserMaint)this.r3UserFactory.getUser((String)users[i]);
                            r3user.getUserAccount().delete();
                        }
                    }
                }
                catch (Exception ex) {
                    errmsg = ex.getMessage();
                    trace.debugT(methodname, "Replication Error: " + errmsg);
                }
                if (errmsg != null) {
                    trace.warningT(methodname, "Error", new Object[]{errmsg});
                    if (opType == 3) {
                        v.add(new PersistenceResult((String)users[i], (Exception)((Object)new PersistenceException(errmsg, null))));
                    } else {
                        v.add(new PersistenceResult(((IUser)users[i]).getDisplayName(), (Exception)((Object)new PersistenceException(errmsg, null))));
                    }
                } else if (opType == 3) {
                    v.add(new PersistenceResult((String)users[i], (Exception)((Object)new PersistenceException("SUCCESS", null))));
                } else {
                    v.add(new PersistenceResult(((IUser)users[i]).getDisplayName(), (Exception)((Object)new PersistenceException("SUCCESS", null))));
                }
                if (opType == 3) {
                    trace.infoT(methodname, "End Users syncDoc for system: " + this._r3_id + " for id: " + (String)users[i]);
                } else {
                    trace.infoT(methodname, "End Users syncDoc for system: " + this._r3_id + " for id: " + ((IUser)users[i]).getDisplayName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            String error = e.getMessage();
            if (error == null) {
                error = "unknown exception";
            }
            throw new PersistenceException(error, null);
        }
        PersistenceResult[] pes = null;
        if (v.size() > 0) {
            pes = v.toArray(new PersistenceResult[1]);
        }
        trace.debugT(methodname, v.size() + " error(s) returned.");
        trace.exiting(methodname);
        return pes;
    }

    public void setScope(String[] scope) {
        this._scope = scope;
    }

    public String[] getScope() {
        return this._scope;
    }

    public void setCompanies(String[] companies) {
        this._companies = companies;
    }

    public String[] getCompanies() {
        return this._companies;
    }

    private void setR3UserValues(IUser user, IUserMaint r3user) {
        String methodname = "setR3UserValues";
        try {
            r3user.setLastName(user.getLastName());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setFirstName(user.getFirstName());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setEmail(user.getEmail());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCity(user.getCity());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCompanyId(user.getCompany());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCompanyId(user.getCompany());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCountry(user.getCountry());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCurrency(user.getCurrency());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setDepartment(user.getDepartment());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setDisplayName(user.getDisplayName());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setFax(user.getFax());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setJobTitle(user.getJobTitle());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setCellPhone(user.getCellPhone());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setState(user.getState());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setStreet(user.getStreet());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setTelephone(user.getTelephone());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setLocale(user.getLocale());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setTitle(user.getTitle());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
        try {
            r3user.setZip(user.getZip());
        }
        catch (FeatureNotAvailableException e) {
            trace.warningT(methodname, e.getMessage(), e);
        }
    }
}

