/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.imp.r3.UmR3UserFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.ParseXML;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Connect;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.util.IUMTrace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class UmSyncR3 {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UmSyncR3.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace;
    private static IUMParameters mysapproperties;
    private IRepository repository;
    private String _retdoctype = null;
    private String _r3System = null;
    private byte[] _retdocstring = null;
    private ParseXML respParser = null;

    public UmSyncR3(String r3name) throws UMException {
        mysapproperties = UMFactory.getProperties();
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        this._r3System = r3name;
    }

    public int getNumberOfTags() {
        return this.respParser.getNumberOfTags();
    }

    public String getTagName(int i) {
        return this.respParser.getTagName(i);
    }

    public String getTagValue(int i) {
        return this.respParser.getTagValue(i);
    }

    public ParseXML getXMLDoc() {
        return this.respParser;
    }

    public String getRetDocType() {
        return this._retdoctype;
    }

    public byte[] getRetDocByteArray() {
        return this._retdocstring;
    }

    public String getRetDocString() {
        String retdocstring = new String(this._retdocstring);
        return retdocstring;
    }

    public boolean getUseJCoServer() {
        return mysapproperties.getBoolean("user.r3.sync.use_jco_server", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void SMUM_TPUser(byte[] iBytes, IUser user) throws Exception, UMException {
        String methodname = "SMUM_TPUser";
        trace.entering(methodname);
        UmR3Properties umProp = new UmR3Properties(this._r3System);
        JCO.Client client = null;
        try {
            client = this.getClient();
        }
        catch (UMException uex) {
            trace.debugT(methodname, "getClient error: " + uex.getMessage());
            throw new UMException(uex.getMessage());
        }
        try {
            block13: {
                try {
                    String sender = mysapproperties.get(UmR3UserFactory.XML_SENDER_USERID_KEY, UmR3UserFactory.XML_SENDER_USERID_DEFAULT);
                    String receiver = null;
                    if (user == null) {
                        trace.debugT(methodname, " user(s) is company user");
                        receiver = umProp.getReceiverId();
                    } else if (user.isCompanyUser()) {
                        if (user.getCompany() != null) {
                            trace.debugT(methodname, user.getDisplayName() + " is an approved company user: " + user.getCompany());
                            receiver = umProp.getReceiverId();
                        } else {
                            trace.debugT(methodname, user.getDisplayName() + " is not an approved company user: " + user.getCompany());
                            receiver = umProp.getReceiverIdGuest();
                        }
                    } else {
                        trace.debugT(methodname, user.getDisplayName() + " is guest user");
                        receiver = umProp.getReceiverIdGuest();
                    }
                    boolean asyncRequest = this.getUseJCoServer();
                    String requestmode = asyncRequest ? "ASYNC" : "SYNC";
                    IFunctionTemplate ftemplate = this.repository.getFunctionTemplate("SMUM_TPUSER");
                    JCO.Function function = new JCO.Function(ftemplate);
                    JCO.ParameterList input = function.getImportParameterList();
                    input.setValue(sender, "SENDER");
                    input.setValue(receiver, "RECEIVER");
                    input.setValue(requestmode, "REQUESTMODE");
                    input.setValue(iBytes, "DOCSTRING");
                    input.setValue("1234567890", "CORRELATIONID");
                    trace.debugT(methodname, "SENDER=" + sender);
                    trace.debugT(methodname, "RECEIVER=" + receiver);
                    trace.debugT(methodname, "REQUESTMODE=" + requestmode);
                    client.execute(function);
                    JCO.ParameterList output = function.getExportParameterList();
                    this._retdoctype = output.getString("RETDOCTYPE");
                    this._retdocstring = output.getByteArray("RETDOCSTRING");
                    if (asyncRequest) break block13;
                    this.respParser = new ParseXML(this._retdocstring);
                }
                catch (Exception ex) {
                    trace.errorT(methodname, "R/3 SMUM_TPUser failed: " + ex.getMessage(), ex);
                    throw new UMException(ex.getMessage());
                }
            }
            Object var15_16 = null;
            trace.exiting(methodname);
            if (client == null) return;
            UmR3Connect.disconnectR3(this._r3System, client);
            return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            trace.exiting(methodname);
            if (client == null) throw throwable;
            UmR3Connect.disconnectR3(this._r3System, client);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map crm_sup_register_check(String regid) {
        HashMap<String, Object> info;
        String methodname;
        block10: {
            methodname = "crm_sup_register_check";
            trace.entering(methodname, new Object[]{regid});
            String rfcName = "CRM_SUP_REGISTER_CHECK";
            info = new HashMap<String, Object>();
            JCO.Client client = null;
            try {
                try {
                    client = this.getClient();
                    IFunctionTemplate ftemplate = this.repository.getFunctionTemplate(rfcName);
                    JCO.Function function = new JCO.Function(ftemplate);
                    function.getImportParameterList().setValue(regid, "IV_REGID");
                    client.execute(function);
                    JCO.ParameterList out = function.getExportParameterList();
                    int returncode = out.getInt("EV_RETURNCODE");
                    String bpartner = out.getString("EV_BPARTNER");
                    info.put("EV_RETURNCODE", new Integer(returncode));
                    info.put("EV_BPARTNER", bpartner);
                    trace.debugT(methodname, "EV_RETURNCODE(" + returncode + ") EV_BPARTNER: " + bpartner);
                    JCO.Table tErrors = function.getTableParameterList().getTable("ET_MESSAGES");
                    Vector<String> vErrorType = new Vector<String>();
                    Vector<String> vErrorId = new Vector<String>();
                    Vector<String> vErrorNum = new Vector<String>();
                    Vector<String> vErrorMsg = new Vector<String>();
                    int i = 0;
                    while (true) {
                        if (i >= tErrors.getNumRows()) {
                            if (!vErrorId.isEmpty()) {
                                info.put("ERROR_TYPE", vErrorType);
                                info.put("ERROR_ID", vErrorId);
                                info.put("ERROR_NUMBER", vErrorNum);
                                info.put("ERROR_MSG", vErrorMsg);
                            }
                            break;
                        }
                        tErrors.setRow(i);
                        String type = tErrors.getString("TYPE");
                        String id = tErrors.getString("ID");
                        String number = tErrors.getString("NUMBER");
                        String message = tErrors.getString("MESSAGE");
                        vErrorType.add(type);
                        vErrorId.add(id);
                        vErrorNum.add(number);
                        vErrorMsg.add(message);
                        ++i;
                    }
                }
                catch (Exception e) {
                    trace.errorT(methodname, e.getMessage(), new Object[]{e});
                    Object var22_23 = null;
                    if (client != null) {
                        UmR3Connect.disconnectR3(this._r3System, client);
                    }
                    break block10;
                }
                Object var22_22 = null;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                if (client != null) {
                    UmR3Connect.disconnectR3(this._r3System, client);
                }
                throw throwable;
            }
            UmR3Connect.disconnectR3(this._r3System, client);
        }
        trace.exiting(methodname);
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map crm_mom_user_delete(String uid) {
        HashMap<String, Serializable> info;
        String methodname;
        block10: {
            methodname = "crm_mom_user_delete";
            trace.entering(methodname, new Object[]{uid});
            String rfcName = "CRM_MOM_USER_DELETE";
            Integer rc = null;
            info = new HashMap<String, Serializable>();
            JCO.Client client = null;
            try {
                try {
                    client = this.getClient();
                    IFunctionTemplate ftemplate = this.repository.getFunctionTemplate(rfcName);
                    JCO.Function function = new JCO.Function(ftemplate);
                    function.getImportParameterList().setValue(uid, "IV_USER");
                    client.execute(function);
                    int returncode = function.getExportParameterList().getInt("EV_RETURNCODE");
                    rc = new Integer(returncode);
                    info.put("EV_RETURNCODE", rc);
                    trace.debugT(methodname, "EV_RETURNCODE: " + returncode);
                    JCO.Table tErrors = function.getTableParameterList().getTable("ET_MESSAGES");
                    Vector<String> vErrorType = new Vector<String>();
                    Vector<String> vErrorId = new Vector<String>();
                    Vector<String> vErrorNum = new Vector<String>();
                    Vector<String> vErrorMsg = new Vector<String>();
                    int i = 0;
                    while (true) {
                        if (i >= tErrors.getNumRows()) {
                            if (!vErrorId.isEmpty()) {
                                info.put("ERROR_TYPE", vErrorType);
                                info.put("ERROR_ID", vErrorId);
                                info.put("ERROR_NUMBER", vErrorNum);
                                info.put("ERROR_MSG", vErrorMsg);
                            }
                            break;
                        }
                        tErrors.setRow(i);
                        String type = tErrors.getString("TYPE");
                        String id = tErrors.getString("ID");
                        String number = tErrors.getString("NUMBER");
                        String message = tErrors.getString("MESSAGE");
                        vErrorType.add(type);
                        vErrorId.add(id);
                        vErrorNum.add(number);
                        vErrorMsg.add(message);
                        ++i;
                    }
                }
                catch (Exception e) {
                    trace.errorT(methodname, e.getMessage(), new Object[]{e});
                    Object var21_22 = null;
                    if (client != null) {
                        UmR3Connect.disconnectR3(this._r3System, client);
                    }
                    break block10;
                }
                Object var21_21 = null;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                if (client != null) {
                    UmR3Connect.disconnectR3(this._r3System, client);
                }
                throw throwable;
            }
            UmR3Connect.disconnectR3(this._r3System, client);
        }
        trace.exiting(methodname);
        return info;
    }

    private JCO.Client getClient() throws UMException {
        JCO.Client client = null;
        try {
            client = UmR3Connect.connectR3(this._r3System);
            this.repository = new JCO.Repository("R3Repository", client);
        }
        catch (Exception ex) {
            trace.errorT("UmSyncR3", "R/3 Create repository failed", ex);
            if (client != null) {
                UmR3Connect.disconnectR3(this._r3System, client);
            }
            throw new UMException(ex.getMessage());
        }
        return client;
    }
}

