/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class UmR3Properties {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UmR3Properties.java#3 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static IUMTrace trace;
    private static IUMParameters mysapproperties;
    private static final String clientPrefix = "jco.client.";
    private static final String r3connectionPrefix = "ume.r3.connection.";
    private static final String clientP = "client";
    private static final String userP = "user";
    private static final String passwdP = "passwd";
    private static final String langP = "lang";
    private static final String ashostP = "ashost";
    private static final String gwhostP = "gwhost";
    private static final String gwservP = "gwserv";
    private static final String sysnrP = "sysnr";
    private static final String msghostP = "msghost";
    private static final String r3nameP = "r3name";
    private static final String groupP = "group";
    private static final String traceP = "trace";
    private static final String abap_debugP = "abap_debug";
    private static final String x509certP = "x509cert";
    private static final String snc_modeP = "snc_mode";
    private static final String snc_partnernameP = "snc_partnername";
    private static final String snc_qopP = "snc_qop";
    private static final String snc_mynameP = "snc_myname";
    private static final String snc_libP = "snc_lib";
    private static final String mysapsso2P = "mysapsso2";
    private static final String serviceP = "sevice";
    private static final String poolmaxsizeP = "poolmaxsize";
    private static final String poolmaxwaitP = "poolmaxwait";
    private static final String receiveridP = "receiverid";
    private static final String receiverid_guestP = "receiverid_guest";
    private static final String applicationP = "application";
    private static final String useroleP = "userole";
    private static final int maxSizeOfPool = 10;
    private String _client = null;
    private String _user = null;
    private String _passwd = null;
    private String _lang = "EN";
    private String _ashost = null;
    private String _sysnr = null;
    private String _systemid = null;
    private String _service = null;
    private String _poolmaxsize = null;
    private String _poolmaxwait = null;
    private String _msghost = null;
    private String _gwhost = null;
    private String _group = null;
    private String _r3name = null;
    private String _gwserv = null;
    private String _trace = null;
    private String _abap_debug = null;
    private String _x509cert = null;
    private String _snc_mode = null;
    private String _snc_partnername = null;
    private String _snc_qop = null;
    private String _snc_myname = null;
    private String _snc_lib = null;
    private String _receiverid = null;
    private String _receiverid_guest = null;
    private String _adapterid = null;
    private String _mysapsso2 = null;
    private String _application = null;
    private String _use_role = null;
    private StringBuffer _property = new StringBuffer("jco.client.");

    public UmR3Properties() {
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        mysapproperties = UMFactory.getProperties();
    }

    public UmR3Properties(String r3name) {
        this();
        this._adapterid = r3name;
        this.getUMProperties(r3name);
    }

    public void setUserid(String id) {
        this._user = id;
    }

    public void setPassword(String pswd) {
        this._passwd = pswd;
    }

    public void setX509Cert(String x509cert) {
        this._x509cert = x509cert;
    }

    public void setMysapsso2(String mysapsso2) {
        this._mysapsso2 = mysapsso2;
    }

    public Properties getR3Properties() {
        return this.getProperties("getR3Properties", true);
    }

    public Properties getSAPProperties() {
        return this.getProperties("getSAPProperties", false);
    }

    public String getClient() {
        return this._client;
    }

    public String getAdapterId() {
        return this._adapterid;
    }

    public String getUser() {
        return this._user;
    }

    public String getService() {
        return this._service;
    }

    public String getPasswd() {
        return this._passwd;
    }

    public String getLang() {
        return this._lang;
    }

    public String getAshost() {
        return this._ashost;
    }

    public String getMshost() {
        return this._msghost;
    }

    public String getGwhost() {
        return this._gwhost;
    }

    public String getGwserv() {
        return this._gwserv;
    }

    public String getGroup() {
        return this._group;
    }

    public String getR3name() {
        return this._r3name;
    }

    public String getSysnr() {
        return this._sysnr;
    }

    public String getSystemid() {
        return this._systemid;
    }

    public String getPoolMaxSize() {
        if (null == this._poolmaxsize || "".equals(this._poolmaxsize.trim())) {
            return String.valueOf(10);
        }
        return this._poolmaxsize;
    }

    public String getPoolMaxWait() {
        return this._poolmaxwait;
    }

    public String getX509Cert() {
        return this._x509cert;
    }

    public String getMysapsso2() {
        return this._mysapsso2;
    }

    public String getReceiverId() {
        return this._receiverid;
    }

    public String getReceiverIdGuest() {
        return this._receiverid_guest;
    }

    public String getApplication() {
        return this._application;
    }

    public String getUseRole() {
        return this._use_role;
    }

    private void getUMProperties(String r3name) {
        String methodname = "getUMProperties";
        trace.entering(methodname, new Object[]{r3name});
        StringBuffer um_r3name = new StringBuffer(40);
        um_r3name.append(r3connectionPrefix).append(r3name.toLowerCase()).append(".");
        final String prefix = um_r3name.toString();
        try {
            this._client = mysapproperties.get(this.getPropertyName(prefix, clientP), null);
            this._user = mysapproperties.get(this.getPropertyName(prefix, userP), null);
            this._passwd = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return mysapproperties.getPassword(UmR3Properties.this.getPropertyName(prefix, UmR3Properties.passwdP));
                }
            });
            this._sysnr = mysapproperties.get(this.getPropertyName(prefix, sysnrP));
            this._lang = mysapproperties.get(this.getPropertyName(prefix, langP));
            this._ashost = mysapproperties.get(this.getPropertyName(prefix, ashostP));
            this._msghost = mysapproperties.get(this.getPropertyName(prefix, msghostP));
            this._gwhost = mysapproperties.get(this.getPropertyName(prefix, gwhostP));
            this._gwserv = mysapproperties.get(this.getPropertyName(prefix, gwservP));
            this._r3name = mysapproperties.get(this.getPropertyName(prefix, r3nameP));
            this._systemid = mysapproperties.get(this.getPropertyName(prefix, r3nameP));
            this._group = mysapproperties.get(this.getPropertyName(prefix, groupP));
            this._trace = mysapproperties.get(this.getPropertyName(prefix, traceP));
            this._abap_debug = mysapproperties.get(this.getPropertyName(prefix, abap_debugP));
            this._x509cert = mysapproperties.get(this.getPropertyName(prefix, x509certP));
            this._snc_mode = mysapproperties.get(this.getPropertyName(prefix, snc_modeP));
            this._snc_partnername = mysapproperties.get(this.getPropertyName(prefix, snc_partnernameP));
            this._snc_qop = mysapproperties.get(this.getPropertyName(prefix, snc_qopP));
            this._snc_myname = mysapproperties.get(this.getPropertyName(prefix, snc_mynameP));
            this._snc_lib = mysapproperties.get(this.getPropertyName(prefix, snc_libP));
            this._service = mysapproperties.get(this.getPropertyName(prefix, serviceP));
            this._poolmaxsize = mysapproperties.get(this.getPropertyName(prefix, poolmaxsizeP));
            this._poolmaxwait = mysapproperties.get(this.getPropertyName(prefix, poolmaxwaitP));
            this._receiverid = mysapproperties.get(this.getPropertyName(prefix, receiveridP));
            if (!this.hasValue(this._receiverid)) {
                this._receiverid = r3name;
            }
            this._receiverid_guest = mysapproperties.get(this.getPropertyName(prefix, receiverid_guestP));
            if (!this.hasValue(this._receiverid_guest)) {
                this._receiverid_guest = this._receiverid;
            }
            this._application = mysapproperties.get(this.getPropertyName(prefix, applicationP));
            this._use_role = mysapproperties.get(this.getPropertyName(prefix, useroleP), null);
        }
        catch (Exception e) {
            trace.errorT(methodname, "Get UM R/3 properties faild: " + r3name, e);
        }
        trace.exiting(methodname);
    }

    private boolean hasValue(String val) {
        return val != null && !val.equals("");
    }

    private String getPropertyName(String prefix, String propertyName) {
        this._property.delete(0, this._property.length());
        this._property.append(prefix).append(propertyName);
        return this._property.toString();
    }

    private Properties getProperties(String type, boolean addPrefix) {
        String methodname = type;
        trace.entering(methodname);
        Properties r3Properties = new Properties();
        if (this.hasValue(this._client)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, clientP) : clientP, this._client);
        }
        if (this.hasValue(this._user)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, userP) : userP, this._user);
        }
        if (this._passwd != null) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, passwdP) : passwdP, this._passwd);
        }
        if (this.hasValue(this._lang)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, langP) : langP, this._lang);
        }
        if (this.hasValue(this._ashost)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, ashostP) : ashostP, this._ashost);
        }
        if (this.hasValue(this._sysnr)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, sysnrP) : sysnrP, this._sysnr);
        }
        if (this.hasValue(this._msghost)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, "mshost") : "mshost", this._msghost);
        }
        if (this.hasValue(this._gwhost)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, gwhostP) : gwhostP, this._gwhost);
        }
        if (this.hasValue(this._r3name)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, r3nameP) : r3nameP, this._r3name);
        }
        if (this.hasValue(this._group)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, groupP) : groupP, this._group);
        }
        if (this.hasValue(this._trace)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, traceP) : traceP, this._trace);
        }
        if (this.hasValue(this._abap_debug)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, abap_debugP) : abap_debugP, this._abap_debug);
        }
        if (this.hasValue(this._x509cert)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, x509certP) : x509certP, this._x509cert);
        }
        if (this.hasValue(this._snc_mode)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, snc_modeP) : snc_modeP, this._snc_mode);
        }
        if (this.hasValue(this._snc_partnername)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, snc_partnernameP) : snc_partnernameP, this._snc_partnername);
        }
        if (this.hasValue(this._snc_qop)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, snc_qopP) : snc_qopP, this._snc_qop);
        }
        if (this.hasValue(this._snc_myname)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, snc_mynameP) : snc_mynameP, this._snc_myname);
        }
        if (this.hasValue(this._snc_lib)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, snc_libP) : snc_libP, this._snc_lib);
        }
        if (this.hasValue(this._mysapsso2)) {
            r3Properties.setProperty(addPrefix ? this.getPropertyName(clientPrefix, mysapsso2P) : mysapsso2P, this._mysapsso2);
        }
        if (addPrefix && trace.beDebug()) {
            StringBuffer msg = new StringBuffer(80);
            msg.append("JCO Connection: user=").append(this._user);
            msg.append("\tclient=").append(this._client);
            msg.append("\tsysnr=").append(this._sysnr);
            trace.debugT(methodname, msg.toString());
            msg.delete(0, msg.length());
            if (this.hasValue(this._r3name)) {
                if (this.hasValue(this._msghost)) {
                    msg.append("JCO connection: r3name=").append(this._r3name).append("\tmshost=").append(this._msghost).append("\tgroup=").append(this._group);
                } else {
                    msg.append("JCO connection: r3name=").append(this._r3name).append("\tgroup=").append(this._group).append("\t(sapmsg.ini file required)");
                }
            } else if (this.hasValue(this._ashost)) {
                msg.append("JCO connection: ashost=").append(this._ashost);
            }
            if (msg.length() > 0) {
                trace.debugT(methodname, msg.toString());
            }
        }
        trace.exiting(methodname);
        return r3Properties;
    }
}

