/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.mw.jco.JCO;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.util.IUMTrace;
import java.util.Properties;

public class UmR3Connect {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UmR3Connect.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static JCO.PoolManager _poolMgr = null;
    private static String aliasName = "_R3";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/UmR3Connect.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private static IUMParameters mysapprop;

    public static JCO.Client connectR3(String r3name) throws UMException {
        String methodname = "connectR3";
        trace.entering("connectR3");
        JCO.Client client = null;
        try {
            client = UmR3Connect.getConnectionPool(r3name);
        }
        catch (Exception ex) {
            trace.errorT("connectR3", "Error connecting to R/3");
            throw new UMException((Throwable)ex);
        }
        trace.exiting("connectR3");
        return client;
    }

    public static void disconnectR3(String r3name, JCO.Client client) {
        String methodname = "disconnectR3";
        trace.entering(methodname, new Object[]{r3name, client});
        String poolAlias = r3name + aliasName;
        JCO.Pool pool = _poolMgr.getPool(poolAlias);
        try {
            JCO.releaseClient((JCO.Client)client);
            trace.debugT(methodname, "Returned client to pool");
            trace.infoT(methodname, "Returned connection to pool: " + pool.getNumUsed() + "/" + pool.getMaxUsed() + "/" + pool.getMaxPoolSize() + " connections in use");
        }
        catch (Exception ex) {
            trace.errorT(methodname, ex);
        }
        trace.exiting(methodname);
    }

    private static synchronized JCO.Client getConnectionPool(String r3name) throws UMException {
        String methodname = "getConnectionPool";
        trace.entering(methodname, new Object[]{r3name});
        if (_poolMgr == null) {
            trace.warningT(methodname, "Problem with R/3 connection - possible JCO library error");
            trace.exiting(methodname);
            throw new UMException("Problem with R/3 connection - possible JCO library error");
        }
        JCO.Client client = null;
        UmR3Properties umProp = null;
        String poolAlias = r3name + aliasName;
        try {
            client = JCO.getClient((String)poolAlias);
            if (client == null) {
                umProp = new UmR3Properties(r3name);
                Properties r3Properties = umProp.getR3Properties();
                Integer conn = new Integer(umProp.getPoolMaxSize());
                JCO.addClientPool((String)poolAlias, (int)conn, (Properties)r3Properties);
                trace.infoT(methodname, conn.toString() + " connections create on " + poolAlias);
                client = JCO.getClient((String)poolAlias);
            } else {
                trace.infoT(methodname, "Reusing R/3 connection pool(" + poolAlias + ")");
            }
        }
        catch (Exception ex) {
            if (umProp == null) {
                umProp = new UmR3Properties(r3name);
            }
            StringBuffer errMsg = new StringBuffer(80);
            errMsg.append(ex.getMessage()).append("-").append(umProp.getR3name());
            errMsg.append(" R/3 connection failed(").append(poolAlias);
            errMsg.append("): ").append(umProp.getR3name());
            errMsg.append("/").append(umProp.getSysnr()).append("/");
            errMsg.append(umProp.getClient()).append("/").append(umProp.getUser());
            trace.errorT(methodname, errMsg.toString(), ex);
            throw new UMException(errMsg.toString());
        }
        trace.debugT(methodname, "systemid=" + client.getSystemID());
        trace.exiting(methodname);
        return client;
    }

    static {
        try {
            _poolMgr = JCO.getClientPoolManager();
            mysapprop = UMFactory.getProperties();
        }
        catch (Throwable ex) {
            trace.errorT("UmR3Connect", "Error connecting to R/3", ex);
        }
    }
}

