/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.ParseXML;
import com.sap.security.core.util.IUMTrace;
import java.util.Vector;

public class ProcessR3RespDoc {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/ProcessR3RespDoc.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private final String MESSAGETYPECODED = "MessageTypeCoded";
    private final String MESSAGENUMBER = "MessageNumber";
    private final String MESSAGEDESCRIPTION = "MessageDescription";
    private final String ERROR = "E";
    private final String USER_START = "990";
    private final String USER_END = "991";
    private final String UPDATEMSG = "CALL_BADI_USER_CHANGE";
    private final String CREATEMSG = "CALL_BADI_USER_CREATE";
    private final String DELETEMSG = "CALL_BADI_USER_DELETE";
    private String syncOperation = null;
    private static IUMTrace trace;
    private static IUMParameters mysapprop;
    private ParseXML syncR3;
    private byte[] syncStr;
    private Vector vResp = new Vector();
    private Vector vErrMsg = new Vector();
    private Vector vUserid = new Vector();

    public ProcessR3RespDoc(ParseXML umSync) {
        this.syncR3 = umSync;
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        mysapprop = UMFactory.getProperties();
    }

    public ProcessR3RespDoc(ParseXML umSync, byte[] syncStream) {
        this(umSync);
        this.syncStr = syncStream;
    }

    public String getUserid(int n) {
        if (this.vUserid.size() == 0 || n - 1 > this.vUserid.size()) {
            return null;
        }
        return (String)this.vUserid.get(n);
    }

    public String getRespXML(int n) {
        if (this.vResp.size() == 0 || n - 1 > this.vResp.size()) {
            return null;
        }
        return (String)this.vResp.get(n);
    }

    public String getErrMsg(int n) {
        if (this.vErrMsg.size() == 0 || n - 1 > this.vErrMsg.size()) {
            return null;
        }
        return (String)this.vErrMsg.get(n);
    }

    public String getSyncOperation() {
        return this.syncOperation;
    }

    public int createXML() {
        trace.entering("createXML");
        String respDoc = "";
        int iStart = 0;
        String respDocBegin = "<TradingPartnerResponse><ListOfTradingPartnerResponseInfo>";
        respDocBegin = respDocBegin + "<TradingPartnerResponseInfo><ReturnMessageInformation>";
        respDocBegin = respDocBegin + "<ListOfSecondaryMessageInformation>";
        String respDocEnd = "</ListOfSecondaryMessageInformation></ReturnMessageInformation>";
        respDocEnd = respDocEnd + "</TradingPartnerResponseInfo></ListOfTradingPartnerResponseInfo>";
        respDocEnd = respDocEnd + "</TradingPartnerResponse>";
        iStart = this.getUserStart(iStart);
        boolean errorFound = false;
        String errMsg = null;
        while (iStart != 0) {
            int iEnd = this.getUserEnd(iStart);
            respDoc = "";
            int j = 0;
            String errNo = null;
            this.syncOperation = null;
            String errMsg1 = null;
            int i = iStart;
            while (i < iEnd) {
                if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageTypeCoded")) {
                    if (j != 0) {
                        respDoc = respDoc + "</SecondaryMessageInformation>";
                    }
                    respDoc = respDoc + "<SecondaryMessageInformation>";
                    errorFound = this.syncR3.getTagValue(i).equalsIgnoreCase("E");
                }
                respDoc = respDoc + "<" + this.syncR3.getTagName(i) + ">" + this.syncR3.getTagValue(i) + "</" + this.syncR3.getTagName(i) + ">";
                if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageNumber") && errorFound) {
                    errNo = this.syncR3.getTagValue(i);
                }
                if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageDescription")) {
                    if (this.syncR3.getTagValue(i).startsWith("CALL_BADI_USER_CHANGE")) {
                        this.syncOperation = "update";
                    }
                    if (this.syncR3.getTagValue(i).startsWith("CALL_BADI_USER_CREATE")) {
                        this.syncOperation = "create";
                    }
                    if (this.syncR3.getTagValue(i).startsWith("CALL_BADI_USER_DELETE")) {
                        this.syncOperation = "delete";
                    }
                    if (errorFound) {
                        errMsg = "E(" + errNo + ") - " + this.syncR3.getTagValue(i);
                        trace.debugT("createXML", "Error msg: " + errMsg);
                        if (errMsg1 == null) {
                            errMsg1 = errMsg;
                        }
                    }
                }
                ++j;
                ++i;
            }
            if (j != 0) {
                respDoc = respDoc + "</SecondaryMessageInformation>";
            }
            respDoc = respDocBegin + respDoc + respDocEnd;
            this.vResp.add(respDoc);
            if (errMsg1 == null && mysapprop.getBoolean("SAP_LOG_ALL_RESPONSE", false)) {
                errMsg1 = "Successful";
            }
            this.vErrMsg.add(errMsg1);
            iStart = this.getUserStart(iEnd);
        }
        trace.exiting("createXML", new Object[]{new Integer(this.vResp.size())});
        return this.vResp.size();
    }

    private int getUserStart(int istart) {
        trace.entering("getUserStart", new Object[]{new Integer(istart)});
        int startMsg = 0;
        int i = istart;
        while (i < this.syncR3.getNumberOfTags()) {
            if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageTypeCoded")) {
                if (startMsg == 0) {
                    startMsg = i;
                }
                if (this.syncR3.getTagName(++i).equalsIgnoreCase("MessageNumber") && this.syncR3.getTagValue(i).equalsIgnoreCase("990")) {
                    this.vUserid.add(this.syncR3.getTagValue(i + 1));
                    trace.exiting("getUserStart", new Object[]{new Integer(i - 1)});
                    return i - 1;
                }
            }
            ++i;
        }
        trace.exiting("getUserStart", new Object[]{new Integer(startMsg)});
        return startMsg;
    }

    private int getUserEnd(int istart) {
        trace.entering("getUserEnd", new Object[]{new Integer(istart)});
        int endMsg = 0;
        int i = istart;
        while (i < this.syncR3.getNumberOfTags()) {
            if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageDescription")) {
                endMsg = i + 1;
            }
            if (this.syncR3.getTagName(i).equalsIgnoreCase("MessageTypeCoded")) {
                endMsg = i + 1;
                if (this.syncR3.getTagName(++i).equalsIgnoreCase("MessageNumber") && this.syncR3.getTagValue(i).equalsIgnoreCase("991")) {
                    trace.exiting("getUserEnd", new Object[]{new Integer(i + 2)});
                    return i + 2;
                }
            }
            ++i;
        }
        trace.exiting("getUserEnd", new Object[]{new Integer(endMsg)});
        return endMsg;
    }
}

