/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseXML {
    private ArrayList keys = new ArrayList();
    private ArrayList values = new ArrayList();
    private String prevNodeName;
    private String xmlDoc = null;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/ParseXML.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    static final String outputEncoding = "UTF-8";
    private static IUMTrace trace;

    public ParseXML(byte[] buf) throws UMException {
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        this.xmlDoc = new String(buf);
        try {
            this.parseXMLDoc(buf);
        }
        catch (Exception ex) {
            throw new UMException(ex.getMessage());
        }
    }

    public String getDocString() {
        return this.xmlDoc;
    }

    public String getTagName(int i) {
        if (i > this.keys.size() - 1) {
            return null;
        }
        return (String)this.keys.get(i);
    }

    public String getTagValue(int i) {
        if (i > this.values.size() - 1) {
            return null;
        }
        return (String)this.values.get(i);
    }

    public int getNumberOfTags() {
        return this.keys.size();
    }

    public void parseXMLDoc(byte[] buf) throws UMException {
        DocumentBuilderFactory dbf;
        trace.entering("parseXMLDoc");
        ByteArrayInputStream ba = new ByteArrayInputStream(buf);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader mine = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mine);
            dbf = DocumentBuilderFactory.newInstance();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(current);
            throw throwable;
        }
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            trace.debugT("parseXMLDoc", "XML processing failed: ", pce);
        }
        db.setErrorHandler(new XMLErrorHandler());
        Document doc = null;
        try {
            doc = db.parse(ba);
        }
        catch (SAXException se) {
            trace.errorT("parseXMLDoc", "XML parsing failed: ", se);
            throw new UMException(se.getMessage());
        }
        catch (IOException ioe) {
            trace.errorT("parseXMLDoc", "XML parsing failed: ", ioe);
        }
        this.getNode(doc);
        trace.exiting("parseXMLDoc");
    }

    private void getNodeInfo(Node n) {
        String val = n.getNodeValue();
        if (val != null && !val.trim().equals("")) {
            this.keys.add(this.prevNodeName);
            this.values.add(n.getNodeValue());
        }
        this.prevNodeName = n.getNodeName();
    }

    private void getNode(Node n) {
        short type = n.getNodeType();
        switch (type) {
            case 2: {
                this.getNodeInfo(n);
                break;
            }
            case 1: {
                this.getNodeInfo(n);
                break;
            }
            case 3: {
                this.getNodeInfo(n);
            }
        }
        Node child = n.getFirstChild();
        while (child != null) {
            this.getNode(child);
            child = child.getNextSibling();
        }
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        XMLErrorHandler() {
        }

        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }
    }
}

