/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp.adapters.r3;

import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.R3TimeZone;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.persistence.replication.imp.usersync.Utils;
import com.sap.security.core.role.IAction;
import com.sap.security.core.role.IService;
import com.sap.security.core.role.imp.PermissionRoles;
import com.sap.security.core.util.IUMTrace;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateSyncXML {
    private Document doc;
    private String mR3Service = null;
    private String mR3Password = null;
    private boolean mR3PasswordChgReq = true;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/CreateSyncXML.java#4 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/adapters/r3/CreateSyncXML.java#4 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private static IUMParameters mysapproperties = UMFactory.getProperties();
    private static final String noValue = null;
    private static final String tradingPartnerUserDeletion = "TradingPartnerUserDeletion";
    private static final String tradingPartnerUserDelete = "TradingPartnerUserDelete";
    private static final String listOfTradingPartnerUserDeletion = "ListOfTradingPartnerUserDeletion";
    private static final String tradingPartnerUserInformation = "TradingPartnerUserInformation";
    private static final String tradingPartnerUserPurpose = "TradingPartnerUserPurpose";
    private static final String tradingPartnerUserPurposeCoded = "TradingPartnerUserPurposeCoded";
    private static final String processType = "ProcessType";
    private static final String listOfTradingPartnerUser = "ListOfTradingPartnerUser";
    private static final String tradingPartnerUser = "TradingPartnerUser";
    private static final String tradingPartnerOrganizationReference = "TradingPartnerOrganizationReference";
    private static final String identifications = "Identifications";
    private static final String primaryID = "PrimaryID";
    private static final String agency = "Agency";
    private static final String agencyCoded = "AgencyCoded";
    private static final String other = "Other";
    private static final String ident = "Ident";
    private static final String shortID = "ShortID";
    private static final String userID = "UserID";
    private static final String userShortID = "UserShortID";
    private static final String password = "Password";
    private static final String encryptedPassword = "X";
    private static final String pswdChgReq = "PswdChgReq";
    private static final String personProfile = "PersonProfile";
    private static final String title = "Title";
    private static final String titleCodedOther = "TitleCodedOther";
    private static final String titleCoded = "TitleCoded";
    private static final String academicTitle = "AcademicTitle";
    private static final String academicTitleCoded = "AcademicTitleCoded";
    private static final String lastName = "LastName";
    private static final String firstName = "FirstName";
    private static final String correspondenceLanguage = "CorrespondenceLanguage";
    private static final String language = "Language";
    private static final String languageCoded = "LanguageCoded";
    private static final String personTimezone = "PersonTimezone";
    private static final String timezone = "Timezone";
    private static final String timezoneCoded = "TimezoneCoded";
    private static final String personAddress = "PersonAddress";
    private static final String street = "Street";
    private static final String postalCode = "PostalCode";
    private static final String city = "City";
    private static final String country = "Country";
    private static final String countryCoded = "CountryCoded";
    private static final String orgUnit = "OrgUnit";
    private static final String building = "Building";
    private static final String floor = "Floor";
    private static final String roomNumber = "RoomNumber";
    private static final String inHouseMail = "InHouseMail";
    private static final String department = "Department";
    private static final String listOfCommunicationDetail = "ListOfCommunicationDetail";
    private static final String communicationDetail = "CommunicationDetail";
    private static final String communicationDetailDescription = "CommunicationDetailDescription";
    private static final String phoneNumber = "Phone Number";
    private static final String personCommunicationType = "PersonCommunicationType";
    private static final String personCommunicationTypeCoded = "PersonCommunicationTypeCoded";
    private static final String telephoneNumber = "TelephoneNumber";
    private static final String communicationValue = "CommunicationValue";
    private static final String emailAddress = "EmailAddress";
    private static final String email = "EMAIL Address";
    private static final String fax = "Fax Number";
    private static final String faxNumber = "FaxNumber";
    private static final String generalNotes = "GeneralNotes";
    private static final String listOfUserRole = "ListOfUserRole";
    private static final String userRole = "UserRole";
    private static final String userRoleName = "UserRoleName";
    private static final String userRoleID = "UserRoleID";
    private static final String UME_R3_USE_ROLES = "ume.r3.use.role";
    private static final String ENCODING = "UTF-8";
    private static final String SYNC_USERONLY = "USER";
    private static final String SYNC_ALLTYPES = "ALL";

    public CreateSyncXML() {
    }

    public CreateSyncXML(String service) {
        this.mR3Service = service;
        trace.infoT("CreateSyncXML", "R3 service = ", new String[]{service});
    }

    public void setR3Service(String service) {
        this.mR3Service = service;
        trace.infoT("setR3Service", "R3 service = " + this.mR3Service);
    }

    public void setR3Password(String password) {
        this.mR3Password = password;
    }

    public void setR3ChangePasswordRequired(boolean required) {
        this.mR3PasswordChgReq = required;
    }

    public byte[] getCreateSyncDoc(IUser user) {
        IUser[] users = new IUser[]{user};
        String xmlString = this.createSyncDoc(1, users);
        trace.debugT("getCreateSyncDoc", xmlString);
        byte[] xmlBytes = null;
        if (xmlString != null) {
            try {
                xmlBytes = xmlString.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                xmlBytes = xmlString.getBytes();
            }
        }
        return xmlBytes;
    }

    public byte[] getChangeSyncDoc(IUser user) {
        IUser[] users = new IUser[]{user};
        String xmlString = this.createSyncDoc(2, users);
        trace.debugT("getChangeSyncDoc", xmlString);
        byte[] xmlBytes = null;
        if (xmlString != null) {
            try {
                xmlBytes = xmlString.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                xmlBytes = xmlString.getBytes();
            }
        }
        return xmlBytes;
    }

    public byte[] getDeleteSyncDoc(String uniquename, String r3id) {
        DocumentBuilderFactory dbf;
        String methodname = "getDeleteSyncDocs(IUserMaint)";
        if (trace.bePath()) {
            trace.entering(methodname, new String[]{uniquename});
        }
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader mine = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mine);
            dbf = DocumentBuilderFactory.newInstance();
            Object var8_7 = null;
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(current);
            throw throwable;
        }
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            trace.debugT("createSyncDocs", "Document creation failed: ", pce);
        }
        this.doc = db.newDocument();
        Element TradingPartnerUserDelete = this.createElement(tradingPartnerUserDelete, noValue);
        this.doc.appendChild(TradingPartnerUserDelete);
        Element ListOfTradingPartnerUserDeletion = this.createElement(listOfTradingPartnerUserDeletion, noValue);
        TradingPartnerUserDelete.appendChild(ListOfTradingPartnerUserDeletion);
        Element TradingPartnerUserDeletion = this.createElement(tradingPartnerUserDeletion, noValue);
        ListOfTradingPartnerUserDeletion.appendChild(TradingPartnerUserDeletion);
        Element TradingPartnerOrganizationReference = this.createElement(tradingPartnerOrganizationReference, noValue);
        TradingPartnerUserDeletion.appendChild(TradingPartnerOrganizationReference);
        Element Identifications = this.createElement(identifications, noValue);
        TradingPartnerOrganizationReference.appendChild(Identifications);
        Element PrimaryID = this.createElement(primaryID, noValue);
        Identifications.appendChild(PrimaryID);
        Element Agency = this.createElement(agency, noValue);
        PrimaryID.appendChild(Agency);
        Element AgencyCoded = this.createElement(agencyCoded, other);
        Agency.appendChild(AgencyCoded);
        Element Ident = this.createElement(ident, "NA");
        PrimaryID.appendChild(Ident);
        Element ShortID = this.createElement(shortID, "NA");
        PrimaryID.appendChild(ShortID);
        Element UserID = this.createElement(userID, uniquename);
        UserID.setAttribute(userShortID, this.applyUIDRule(r3id));
        TradingPartnerUserDeletion.appendChild(UserID);
        String xmlString = this.doc2String();
        if (trace.bePath()) {
            trace.exiting(methodname);
        }
        try {
            return xmlString.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            trace.debugT("getDeleteSyncDoc", e);
            return xmlString.getBytes();
        }
    }

    private String createSyncDoc(int type, IUser[] users) {
        DocumentBuilderFactory dbf;
        String methodname = "createSyncDoc";
        trace.entering("createSyncDoc", new Object[]{new Integer(type), users});
        String r3Service = this.mR3Service;
        UmR3Properties umProp = new UmR3Properties(r3Service);
        String umService = umProp.getService();
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader mine = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mine);
            dbf = DocumentBuilderFactory.newInstance();
            Object var11_10 = null;
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Thread.currentThread().setContextClassLoader(current);
            throw throwable;
        }
        DocumentBuilder db = null;
        String[] values = null;
        boolean useRole = mysapproperties.getBoolean(UME_R3_USE_ROLES, false);
        String sysUseRole = umProp.getUseRole();
        if (sysUseRole != null) {
            useRole = sysUseRole.equalsIgnoreCase("true");
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            trace.errorT("createSyncDoc", "Document creation failed: ", pce);
            return null;
        }
        this.doc = db.newDocument();
        String purpose = null;
        switch (type) {
            case 1: {
                purpose = "Create";
                break;
            }
            case 2: {
                purpose = "Change";
            }
        }
        Element TradingPartnerUserInformation = this.createElement(tradingPartnerUserInformation, noValue);
        this.doc.appendChild(TradingPartnerUserInformation);
        Element TradingPartnerUserPurpose = this.createElement(tradingPartnerUserPurpose, noValue);
        TradingPartnerUserInformation.appendChild(TradingPartnerUserPurpose);
        Element TradingPartnerUserPurposeCoded = this.createElement(tradingPartnerUserPurposeCoded, purpose);
        TradingPartnerUserPurpose.appendChild(TradingPartnerUserPurposeCoded);
        Element ProcessType = this.createElement(processType, useRole ? SYNC_ALLTYPES : SYNC_USERONLY);
        TradingPartnerUserPurpose.appendChild(ProcessType);
        Element ListOfTradingPartnerUser = this.createElement(listOfTradingPartnerUser, noValue);
        TradingPartnerUserInformation.appendChild(ListOfTradingPartnerUser);
        IUser user = null;
        IRoleFactory rolefactory = UMFactory.getRoleFactory();
        int i = 0;
        while (i < users.length) {
            user = users[i];
            Element TradingPartnerUser = this.createElement(tradingPartnerUser, noValue);
            ListOfTradingPartnerUser.appendChild(TradingPartnerUser);
            Element TradingPartnerOrganizationReference = this.createElement(tradingPartnerOrganizationReference, noValue);
            TradingPartnerUser.appendChild(TradingPartnerOrganizationReference);
            Element Identifications = this.createElement(identifications, noValue);
            TradingPartnerOrganizationReference.appendChild(Identifications);
            Element PrimaryID = this.createElement(primaryID, noValue);
            Identifications.appendChild(PrimaryID);
            Element Agency = this.createElement(agency, noValue);
            PrimaryID.appendChild(Agency);
            Element AgencyCoded = this.createElement(agencyCoded, other);
            Agency.appendChild(AgencyCoded);
            String companyId = user.getCompany();
            if (null == companyId) {
                companyId = "";
            }
            Element Ident = this.createElement(ident, companyId);
            PrimaryID.appendChild(Ident);
            Element ShortID = this.createElement(shortID, companyId);
            PrimaryID.appendChild(ShortID);
            Element UserID = this.createElement(userID, Utils.getLogonId(user));
            UserID.setAttribute(userShortID, this.applyUIDRule(Utils.getR3ID(user)));
            TradingPartnerUser.appendChild(UserID);
            if (this.mR3Password != null) {
                Element passWord = this.createElement(password, this.mR3Password);
                TradingPartnerUser.appendChild(passWord);
                if (this.mR3PasswordChgReq) {
                    Element passwordChgReq = this.createElement(pswdChgReq, encryptedPassword);
                    TradingPartnerUser.appendChild(passwordChgReq);
                }
            }
            Element PersonProfile = this.createElement(personProfile, noValue);
            TradingPartnerUser.appendChild(PersonProfile);
            Element Title = this.createElement(title, noValue);
            PersonProfile.appendChild(Title);
            try {
                String[] sOrgunit = user.getAttribute("com.sap.security.core.usermanagement", orgUnit.toUpperCase());
                StringBuffer sFunction = new StringBuffer();
                if (sOrgunit != null && sOrgunit.length > 0) {
                    sFunction.append(sOrgunit[0]);
                    trace.debugT("createSyncDoc", "(IPrincipal.DEFAULT_NAMESPACE,ORGUNIT)=" + sFunction);
                }
                Iterator userRoles = user.getRoles(true);
                trace.debugT("createSyncDoc", "***Look for OrgUnit_Manager***");
                IRole role = null;
                Iterator userAction = null;
                block39: while (userRoles.hasNext()) {
                    role = rolefactory.getRole((String)userRoles.next());
                    userAction = PermissionRoles.getActions(role);
                    while (userAction.hasNext()) {
                        String actId = ((IAction)userAction.next()).getUniqueID();
                        int ind = actId.lastIndexOf(".");
                        if (ind > 0) {
                            actId = actId.substring(ind + 1);
                        }
                        trace.debugT("createSyncDoc", "***action=" + actId);
                        if (!actId.equalsIgnoreCase("OrgUnit_Manager")) continue;
                        sFunction.append(":").append(actId);
                        break block39;
                    }
                }
                Element TitleCodedOther = this.createElement(titleCodedOther, sFunction.toString());
                Title.appendChild(TitleCodedOther);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during creating xml document", ex);
            }
            Element TitleCoded = this.createElement(titleCoded, user.getSalutation());
            Title.appendChild(TitleCoded);
            try {
                values = user.getAttribute("com.sap.security.core.usermanagement", academicTitle);
                if (values != null && values.length > 0) {
                    Element AcademicTitle = this.createElement(academicTitle, noValue);
                    PersonProfile.appendChild(AcademicTitle);
                    Element AcademicTitleCoded = this.createElement(academicTitleCoded, values[0]);
                    AcademicTitle.appendChild(AcademicTitleCoded);
                }
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending academicTitle", ex);
            }
            Element LastName = this.createElement(lastName, user.getLastName());
            PersonProfile.appendChild(LastName);
            Element FirstName = this.createElement(firstName, user.getFirstName());
            PersonProfile.appendChild(FirstName);
            Element CorrespondenceLanguage = this.createElement(correspondenceLanguage, noValue);
            PersonProfile.appendChild(CorrespondenceLanguage);
            Element Language = this.createElement(language, noValue);
            CorrespondenceLanguage.appendChild(Language);
            Locale loc = user.getLocale();
            String languageKey = noValue;
            if (loc != null && (languageKey = loc.getLanguage()).equalsIgnoreCase("zh") && (loc.getCountry().equals("HK") || loc.equals(Locale.TAIWAN))) {
                languageKey = "zf";
            }
            Element LanguageCoded = this.createElement(languageCoded, languageKey);
            Language.appendChild(LanguageCoded);
            Element PersonTimezone = this.createElement(personTimezone, noValue);
            PersonProfile.appendChild(PersonTimezone);
            Element Timezone = this.createElement(timezone, noValue);
            PersonTimezone.appendChild(Timezone);
            String zoneId = user.getTimeZone() == null ? null : user.getTimeZone().getID();
            Element TimezoneCoded = this.createElement(timezoneCoded, R3TimeZone.getTimeZone(zoneId));
            Timezone.appendChild(TimezoneCoded);
            Element PersonAddress = this.createElement(personAddress, noValue);
            PersonProfile.appendChild(PersonAddress);
            try {
                Element Street = this.createElement(street, user.getStreet());
                PersonAddress.appendChild(Street);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:street", ex);
            }
            try {
                Element PostalCode = this.createElement(postalCode, user.getZip());
                PersonAddress.appendChild(PostalCode);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:postalCode", ex);
            }
            try {
                Element City = this.createElement(city, user.getCity());
                PersonAddress.appendChild(City);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:city", ex);
            }
            try {
                Element Country = this.createElement(country, noValue);
                PersonAddress.appendChild(Country);
                Element CountryCoded = this.createElement(countryCoded, user.getCountry());
                Country.appendChild(CountryCoded);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:countryCoded", ex);
            }
            try {
                values = user.getAttribute("com.sap.security.core.usermanagement", building.toUpperCase());
                if (values != null && values.length > 0) {
                    Element Building = this.createElement(building, values[0]);
                    PersonAddress.appendChild(Building);
                }
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:buidling", ex);
            }
            try {
                values = user.getAttribute("com.sap.security.core.usermanagement", floor.toUpperCase());
                if (values != null && values.length > 0) {
                    Element Floor = this.createElement(floor, values[0]);
                    PersonAddress.appendChild(Floor);
                }
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:floor", ex);
            }
            try {
                values = user.getAttribute("com.sap.security.core.usermanagement", roomNumber.toUpperCase());
                if (values != null && values.length > 0) {
                    Element RoomNumber = this.createElement(roomNumber, values[0]);
                    PersonAddress.appendChild(RoomNumber);
                }
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:roomNumber", ex);
            }
            try {
                values = user.getAttribute("com.sap.security.core.usermanagement", inHouseMail);
                if (values != null && values.length > 0) {
                    Element InHouseMail = this.createElement(inHouseMail, values[0]);
                    PersonAddress.appendChild(InHouseMail);
                }
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:inHouseMail", ex);
            }
            try {
                Element Department = this.createElement(department, user.getDepartment());
                PersonAddress.appendChild(Department);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending personAddress:department", ex);
            }
            Element ListOfCommunicationDetail = this.createElement(listOfCommunicationDetail, noValue);
            PersonAddress.appendChild(ListOfCommunicationDetail);
            Element CommunicationDetail = this.createElement(communicationDetail, noValue);
            ListOfCommunicationDetail.appendChild(CommunicationDetail);
            Element CommunicationDetailDescription = this.createElement(communicationDetailDescription, phoneNumber);
            CommunicationDetail.appendChild(CommunicationDetailDescription);
            Element PersonCommunicationType = this.createElement(personCommunicationType, noValue);
            CommunicationDetail.appendChild(PersonCommunicationType);
            Element PersonCommunicationTypeCoded = this.createElement(personCommunicationTypeCoded, telephoneNumber);
            PersonCommunicationType.appendChild(PersonCommunicationTypeCoded);
            Element CommunicationValue = null;
            try {
                CommunicationValue = this.createElement(communicationValue, user.getTelephone());
                CommunicationDetail.appendChild(CommunicationValue);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending commnunicationDetail:phonenumber", ex);
            }
            CommunicationDetail = this.createElement(communicationDetail, noValue);
            ListOfCommunicationDetail.appendChild(CommunicationDetail);
            CommunicationDetailDescription = this.createElement(communicationDetailDescription, email);
            CommunicationDetail.appendChild(CommunicationDetailDescription);
            PersonCommunicationType = this.createElement(personCommunicationType, noValue);
            CommunicationDetail.appendChild(PersonCommunicationType);
            PersonCommunicationTypeCoded = this.createElement(personCommunicationTypeCoded, emailAddress);
            PersonCommunicationType.appendChild(PersonCommunicationTypeCoded);
            try {
                CommunicationValue = this.createElement(communicationValue, user.getEmail());
                CommunicationDetail.appendChild(CommunicationValue);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending commnunicationDetail:email", ex);
            }
            CommunicationDetail = this.createElement(communicationDetail, noValue);
            ListOfCommunicationDetail.appendChild(CommunicationDetail);
            CommunicationDetailDescription = this.createElement(communicationDetailDescription, fax);
            CommunicationDetail.appendChild(CommunicationDetailDescription);
            PersonCommunicationType = this.createElement(personCommunicationType, noValue);
            CommunicationDetail.appendChild(PersonCommunicationType);
            PersonCommunicationTypeCoded = this.createElement(personCommunicationTypeCoded, faxNumber);
            PersonCommunicationType.appendChild(PersonCommunicationTypeCoded);
            try {
                CommunicationValue = this.createElement(communicationValue, user.getFax());
                CommunicationDetail.appendChild(CommunicationValue);
            }
            catch (Exception ex) {
                trace.warningT("createSyncDoc", "error occurred during appending commnunicationDetail:fax", ex);
            }
            Element GeneralNotes = this.createElement(generalNotes, noValue);
            PersonAddress.appendChild(GeneralNotes);
            if (useRole) {
                Element ListOfUserRole = this.createElement(listOfUserRole, noValue);
                TradingPartnerUser.appendChild(ListOfUserRole);
                Element UserRole = null;
                Element UserRoleName = null;
                Element UserRoleID = null;
                trace.debugT("createSyncDoc", "****service=" + umService);
                Iterator userRoles = user.getRoles(true);
                try {
                    while (userRoles.hasNext()) {
                        String roleId = (String)userRoles.next();
                        IRole role = rolefactory.getRole(roleId);
                        trace.debugT("createSyncDoc", "**role name=" + role.getDisplayName());
                        Iterator userAction = PermissionRoles.getActions(role);
                        while (userAction.hasNext()) {
                            IAction action = (IAction)userAction.next();
                            IService service = action.getService();
                            String serviceName = service.getName();
                            trace.debugT("createSyncDoc", "---role service name=" + serviceName);
                            if (umService != null && !serviceName.equalsIgnoreCase(umService)) continue;
                            String actId = action.getUniqueID();
                            int ind = actId.indexOf(".");
                            if (ind > 0) {
                                actId = actId.substring(ind + 1);
                            }
                            String actionName = actId;
                            trace.debugT("createSyncDoc", "------action name=" + actionName);
                            String actionId = actId;
                            UserRole = this.createElement(userRole, noValue);
                            ListOfUserRole.appendChild(UserRole);
                            UserRoleName = this.createElement(userRoleName, actionName);
                            UserRole.appendChild(UserRoleName);
                            UserRoleID = this.createElement(userRoleID, actionId);
                            UserRole.appendChild(UserRoleID);
                        }
                    }
                }
                catch (Exception e) {
                    trace.errorT("createSyncDoc", "Error retrieving roles", e);
                }
            }
            ++i;
        }
        String xmlString = this.doc2String();
        return xmlString;
    }

    private String doc2String() {
        TransformerFactory transformerFactory;
        String methodname = "doc2String";
        if (trace.bePath()) {
            trace.entering(methodname);
        }
        String xmlString = null;
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader mine = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mine);
            transformerFactory = TransformerFactory.newInstance();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(current);
            throw throwable;
        }
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            xmlString = writer.toString();
        }
        catch (Exception ex) {
            trace.errorT(methodname, "Error creating XML string", ex);
        }
        if (trace.beDebug()) {
            trace.debugT(methodname, "xml string: " + xmlString);
        }
        if (trace.bePath()) {
            trace.exiting(methodname);
        }
        return xmlString;
    }

    private String applyUIDRule(String shortUID) {
        StringBuffer result = new StringBuffer(30);
        result.append(shortUID);
        result.append("~~~~~~~~~~~");
        return result.toString().substring(0, 12);
    }

    private Element createElement(String name, String value) {
        Element elem = this.doc.createElement(name);
        if (value != null) {
            elem.appendChild(this.doc.createTextNode(value));
        }
        return elem;
    }
}

