/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.replication.imp;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.IMessageHandler;
import com.sap.security.core.util.IUMTrace;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class MessagingHandler {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/MessagingHandler.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    static final IUMTrace _trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/replication/imp/MessagingHandler.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final String REPLICATION_MESSAGING_HANDLERS = "ume.replication.messaging.handlers";
    private static final String REPLICATION_MESSAGING_ACTIVE = "ume.replication.messaging.active";
    static final boolean MESSAGING_DEFAULT_STATUS = false;
    static final String SECONDARYSYNC = "secondarysync";
    static final String USER_SYNC_HANDLER = "com.sap.security.core.persistence.replication.imp.usersync.UserSyncHandler";
    private static MessagingHandler _instance;
    private static final IUMParameters _prop;
    private static boolean _isActivated;
    private Vector _handlers = new Vector();

    public static synchronized MessagingHandler getInstance() {
        if (null == _instance) {
            _instance = new MessagingHandler();
        }
        return _instance;
    }

    public void onCreateMessage(IUser[] users) throws UMException {
        if (MessagingHandler.isMessagingEnabled()) {
            if (null == users) {
                _trace.errorT("onCreateMessage", "Input user array is null");
            } else {
                Iterator it = ((AbstractList)this._handlers).iterator();
                while (it.hasNext()) {
                    IMessageHandler mh = (IMessageHandler)it.next();
                    mh.onCreateMessage(users);
                }
            }
        }
    }

    public void onUpdateMessage(IUser[] users) throws UMException {
        if (MessagingHandler.isMessagingEnabled()) {
            if (null == users) {
                _trace.errorT("onUpdateMessage", "Input user array is null");
            } else {
                Iterator it = ((AbstractList)this._handlers).iterator();
                while (it.hasNext()) {
                    IMessageHandler mh = (IMessageHandler)it.next();
                    mh.onUpdateMessage(users);
                }
            }
        }
    }

    public void onDeleteMessage(String[] uniqueNames, Hashtable excludesys) throws UMException {
        if (MessagingHandler.isMessagingEnabled()) {
            if (null == uniqueNames) {
                _trace.errorT("onDeleteMessage", "Input user array is null");
                return;
            }
            Iterator it = ((AbstractList)this._handlers).iterator();
            while (it.hasNext()) {
                IMessageHandler mh = (IMessageHandler)it.next();
                mh.onDeleteMessage(uniqueNames, excludesys);
            }
        }
    }

    public void onRoleChangeMessage(String[] users) throws UMException {
    }

    private MessagingHandler() {
        this.setMessagingEnability(_prop.getBoolean(REPLICATION_MESSAGING_ACTIVE, false));
        if (MessagingHandler.isMessagingEnabled()) {
            String allclasses = _prop.get(REPLICATION_MESSAGING_HANDLERS, SECONDARYSYNC);
            StringTokenizer st = new StringTokenizer(allclasses, ",");
            String cls = null;
            IMessageHandler mh = null;
            while (st.hasMoreTokens()) {
                cls = this.getClass(st.nextToken());
                try {
                    mh = (IMessageHandler)Class.forName(cls.trim()).newInstance();
                    this._handlers.add(mh);
                }
                catch (ClassNotFoundException e) {
                    _trace.errorT("loadClass", cls + " : Adapter instantiation failed : class not found: " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    _trace.errorT("loadClass", cls + " : Adapter instantiation failed :IllegalAccessException: " + e.getMessage(), e);
                }
                catch (InstantiationException e) {
                    _trace.errorT("loadClass", cls + " : Adapter instantiation failed :InstantiationException: " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    _trace.errorT("loadClass", cls + " : Adapter instantiation failed :Throwable: " + e.getMessage(), e);
                }
            }
            if (this._handlers.isEmpty()) {
                this.setMessagingEnability(false);
            }
        }
    }

    private String getClass(String cls) {
        if (SECONDARYSYNC.equalsIgnoreCase(cls)) {
            return USER_SYNC_HANDLER;
        }
        return cls;
    }

    private void setMessagingEnability(boolean isEnabled) {
        _isActivated = isEnabled;
    }

    private static boolean isMessagingEnabled() {
        return _isActivated;
    }

    static {
        _prop = UMFactory.getProperties();
        _isActivated = false;
    }
}

