/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.LinkedList;

public class WorkQueue {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/WorkQueue.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/WorkQueue.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private final int nThreads;
    private final PoolWorker[] threads;
    private final LinkedList queue;

    public WorkQueue(int nThreads) {
        this.nThreads = nThreads;
        this.queue = new LinkedList();
        this.threads = new PoolWorker[nThreads];
        int i = 0;
        while (i < nThreads) {
            this.threads[i] = new PoolWorker("UME_Persistence_Thread_" + i);
            this.threads[i].start();
            ++i;
        }
    }

    public void execute(Runnable r) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(r);
            this.queue.notify();
        }
    }

    private class PoolWorker
    extends Thread {
        public PoolWorker(String name) {
            super(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Runnable r;
                LinkedList linkedList = WorkQueue.this.queue;
                synchronized (linkedList) {
                    while (WorkQueue.this.queue.isEmpty()) {
                        try {
                            WorkQueue.this.queue.wait();
                        }
                        catch (InterruptedException ignored) {
                            if (!mTrace.beDebug()) continue;
                            mTrace.debugT("run", ignored);
                        }
                    }
                    r = (Runnable)WorkQueue.this.queue.removeFirst();
                }
                try {
                    r.run();
                    continue;
                }
                catch (RuntimeException e) {
                    if (!mTrace.beDebug()) continue;
                    mTrace.debugT("run", e);
                    continue;
                }
                break;
            }
        }
    }
}

