/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.persistence.ISearchElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SearchCriteria
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/SearchCriteria.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final int SEARCH_RESULT_OK = 0;
    public static final int SEARCH_RESULT_INCOMPLETE = 1;
    public static final int SEARCH_RESULT_UNDEFINED = 2;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int TIME_LIMIT_EXCEEDED = 8;
    private boolean isOrMode;
    private List elements;
    private String mPrincipalType;
    private int mSearchStatus;
    private String[] mDataSourcesToSearch;
    private int mSearchSizeLimit;

    public SearchCriteria() {
    }

    public SearchCriteria(String principalType) {
        this(false, principalType);
    }

    public SearchCriteria(String principalType, String[] searchDataSources) {
        this(false, principalType);
        this.mDataSourcesToSearch = searchDataSources;
    }

    public SearchCriteria(boolean orMode, String principalType) {
        this.isOrMode = orMode;
        this.mPrincipalType = principalType;
        this.elements = new ArrayList();
        this.mSearchStatus = 0;
        this.addEqualsElement("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", principalType, true);
        this.mSearchSizeLimit = 0;
    }

    public SearchCriteria(boolean orMode, String principalType, String[] searchDataSources) {
        this(orMode, principalType);
        this.mDataSourcesToSearch = searchDataSources;
    }

    public void setSearchSizeLimit(int sizeLimit) {
        if (sizeLimit < 1) {
            this.mSearchSizeLimit = 0;
        } else {
            if (this.elements.size() > 2 && !this.isOrMode) {
                throw new UMRuntimeException("Using search size limits is only allowed if the search criteria for and search contains exactly one attribute.");
            }
            this.mSearchSizeLimit = sizeLimit;
        }
    }

    public int getSearchSizeLimit() {
        return this.mSearchSizeLimit;
    }

    public void errorOccurred(int errorType) {
        this.mSearchStatus |= errorType;
    }

    public boolean isErrorOccurred(int errorType) {
        return (this.mSearchStatus & errorType) == errorType;
    }

    public boolean isErrorOccurred() {
        return this.mSearchStatus != 0;
    }

    public int getSearchStatus() {
        return this.mSearchStatus;
    }

    public String getPrincipalType() {
        return this.mPrincipalType;
    }

    public void addGreaterThanElement(String nameSpace, String attributeName, Object attributeValue, boolean caseSensitive) {
        if (!this.isOrMode && this.mSearchSizeLimit > 0 && this.elements.size() == 2) {
            throw new UMRuntimeException("Using search size limits is only allowed if the search criteria for and search contains exactly one attribute.");
        }
        this.elements.add(new Element(nameSpace, attributeName, attributeValue, 2, caseSensitive));
    }

    public void addLessThanElement(String nameSpace, String attributeName, Object attributeValue, boolean caseSensitive) {
        if (!this.isOrMode && this.mSearchSizeLimit > 0 && this.elements.size() == 2) {
            throw new UMRuntimeException("Using search size limits is only allowed if the search criteria for and search contains exactly one attribute.");
        }
        this.elements.add(new Element(nameSpace, attributeName, attributeValue, 3, caseSensitive));
    }

    public void addEqualsElement(String nameSpace, String attributeName, Object attributeValue, boolean caseSensitive) {
        if (!this.isOrMode && this.mSearchSizeLimit > 0 && this.elements.size() == 2) {
            throw new UMRuntimeException("Using search size limits is only allowed if the search criteria for and search contains exactly one attribute.");
        }
        this.elements.add(new Element(nameSpace, attributeName, attributeValue, 0, caseSensitive));
    }

    public void addLikeElement(String nameSpace, String attributeName, Object attributeValue, boolean caseSensitive) {
        if (!this.isOrMode && this.mSearchSizeLimit > 0 && this.elements.size() == 2) {
            throw new UMRuntimeException("Using search size limits is only allowed if the search criteria for and search contains exactly one attribute.");
        }
        this.elements.add(new Element(nameSpace, attributeName, attributeValue, 1, caseSensitive));
    }

    public boolean isOrMode() {
        return this.isOrMode;
    }

    public ISearchElement getElement(int i) {
        return (ISearchElement)this.elements.get(i);
    }

    public ISearchAttribute getAttribute(int i) {
        return (ISearchAttribute)this.elements.get(i);
    }

    public int getElementSize() {
        return this.elements.size();
    }

    public String[] getDataSourcesToSearch() {
        return this.mDataSourcesToSearch;
    }

    public void setDataSourcesToSearch(String[] searchDataSources) {
        this.mDataSourcesToSearch = searchDataSources;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("***************************************************************************\n");
        res.append("* ");
        res.append(this.getClass().getName());
        res.append("\n");
        res.append("* looking for: \"");
        res.append(this.mPrincipalType);
        if (this.mDataSourcesToSearch == null) {
            res.append("\" on all repositories");
        } else {
            res.append("\" on [");
            boolean firstSet = false;
            int i = 0;
            while (i < this.mDataSourcesToSearch.length) {
                if (firstSet) {
                    res.append(",");
                }
                res.append(this.mDataSourcesToSearch[i]);
                firstSet = true;
                ++i;
            }
            res.append("]");
        }
        res.append(".\n");
        res.append("* Using ");
        if (this.isOrMode) {
            res.append("OR");
        } else {
            res.append("AND");
        }
        res.append(" mode");
        if (this.mSearchSizeLimit > 0) {
            res.append(" with size limit ");
            res.append(this.mSearchSizeLimit);
        } else {
            res.append(" without size limit");
        }
        res.append(".\n");
        res.append("*\n");
        int i = 0;
        while (i < this.elements.size()) {
            res.append("* ");
            res.append(((ISearchAttribute)this.elements.get(i)).toString());
            res.append("\n");
            ++i;
        }
        res.append("***************************************************************************\n");
        return res.toString();
    }

    private static class Element
    implements ISearchAttribute,
    ISearchElement {
        private final String nameSpace;
        private final String attributeName;
        private final Object attributeValue;
        private final int op;
        private final boolean mcaseSensitive;

        private Element(String nameSpace, String attributeName, Object attributeValue, int op, boolean caseSensitive) {
            this.nameSpace = nameSpace;
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
            this.op = op;
            this.mcaseSensitive = caseSensitive;
        }

        private Element(String nameSpace, String attributeName, Object attributeValue, int op) {
            this(nameSpace, attributeName, attributeValue, op, false);
        }

        private Element(String nameSpace, String attributeName, Object attributeValue) {
            this(nameSpace, attributeName, attributeValue, 0, false);
        }

        public boolean isCaseSensitive() {
            return this.mcaseSensitive;
        }

        public String getAttributeNameSpace() {
            return this.nameSpace;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public int getOperator() {
            return this.op;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append(this.nameSpace);
            res.append("|->");
            res.append(this.attributeName);
            if (this.attributeValue == null) {
                res.append(" NOT_SET ");
            } else {
                switch (this.op) {
                    case 1: {
                        res.append(" LIKE ");
                        break;
                    }
                    case 3: {
                        res.append(" LESS_THAN ");
                        break;
                    }
                    case 2: {
                        res.append(" GREATER_THAN ");
                        break;
                    }
                    case 0: {
                        res.append(" EQUALS ");
                    }
                }
                res.append(this.attributeValue);
                if (this.mcaseSensitive) {
                    res.append(" (case sensitive)");
                } else {
                    res.append(" (not case sensitive)");
                }
            }
            return res.toString();
        }
    }
}

