/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PrincipalDatabagMaint
extends PrincipalDatabag
implements IPrincipalDatabagMaint,
IInternalPrincipalDatabagMaint {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/PrincipalDatabagMaint.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    protected static final String SERIALIZE_CLASS_TAG = "{IPrincipalDatabagMaint}";
    protected Hashtable additionalData = new Hashtable();
    protected Hashtable removedData = new Hashtable();
    protected Hashtable setData = new Hashtable();
    protected Hashtable deleteData = new Hashtable();
    protected boolean isNew = true;

    public PrincipalDatabagMaint(String uniqueID) {
        super(uniqueID);
    }

    public synchronized void clear() {
        this.undoChanges();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setAttributeMaintValues(String nameSpace, String attributeName, Vector values) {
        Hashtable removedAttributes;
        Hashtable additionalAttributes;
        Vector deleteAttributes;
        if (nameSpace == null) {
            throw new UMRuntimeException("Cannot set values if namespace is null!");
        }
        if (attributeName == null) {
            throw new UMRuntimeException("Cannot set values if the name of the attribute is null!");
        }
        if (values != null) {
            int size = values.size();
            int i = 0;
            while (i < size) {
                if (values.elementAt(i) == null) {
                    StringBuffer errorMessage = new StringBuffer("Setting null values is not allowed.");
                    if (this.id != null) {
                        errorMessage.append("(");
                        errorMessage.append(this.id);
                        errorMessage.append(")");
                    }
                    throw new IllegalArgumentException(errorMessage.toString());
                }
                ++i;
            }
        }
        this.isNew = false;
        Hashtable namespaceProperties = (Hashtable)this.setData.get(nameSpace);
        if (namespaceProperties == null) {
            namespaceProperties = new Hashtable();
        }
        if (this.deleteData != null && (deleteAttributes = (Vector)this.deleteData.get(nameSpace)) != null && deleteAttributes.contains(attributeName)) {
            deleteAttributes.remove(attributeName);
            this.deleteData.put(nameSpace, deleteAttributes);
        }
        if (this.additionalData != null && (additionalAttributes = (Hashtable)this.additionalData.get(nameSpace)) != null && additionalAttributes.containsKey(attributeName)) {
            additionalAttributes.remove(attributeName);
            this.additionalData.put(nameSpace, additionalAttributes);
        }
        if (this.removedData != null && (removedAttributes = (Hashtable)this.removedData.get(nameSpace)) != null && removedAttributes.containsKey(attributeName)) {
            removedAttributes.remove(attributeName);
            this.removedData.put(nameSpace, removedAttributes);
        }
        if (values == null) {
            values = new Vector();
        }
        namespaceProperties.put(attributeName, values);
        this.setData.put(nameSpace, namespaceProperties);
    }

    public void deleteAttributeMaintValues(String nameSpace, String attributeName) {
        Vector<String> deleteAttributes;
        Hashtable removedAttributes;
        Hashtable additionalAttributes;
        Hashtable namespaceProperties;
        if (nameSpace == null) {
            throw new UMRuntimeException("Cannot delete attribute if namespace is null!");
        }
        if (attributeName == null) {
            throw new UMRuntimeException("Cannot delete attribute if the name of the attribute is null!");
        }
        this.isNew = false;
        if (this.setData != null && (namespaceProperties = (Hashtable)this.setData.get(nameSpace)) != null) {
            namespaceProperties.remove(attributeName);
            this.setData.put(nameSpace, namespaceProperties);
        }
        if (this.additionalData != null && (additionalAttributes = (Hashtable)this.additionalData.get(nameSpace)) != null && additionalAttributes.containsKey(attributeName)) {
            additionalAttributes.remove(attributeName);
            this.additionalData.put(nameSpace, additionalAttributes);
        }
        if (this.removedData != null && (removedAttributes = (Hashtable)this.removedData.get(nameSpace)) != null && removedAttributes.containsKey(attributeName)) {
            removedAttributes.remove(attributeName);
            this.removedData.put(nameSpace, removedAttributes);
        }
        if (this.deleteData == null) {
            this.deleteData = new Hashtable();
        }
        if ((deleteAttributes = (Vector<String>)this.deleteData.get(nameSpace)) == null) {
            deleteAttributes = new Vector<String>();
        }
        if (!deleteAttributes.contains(attributeName)) {
            deleteAttributes.add(attributeName);
            this.deleteData.put(nameSpace, deleteAttributes);
        }
    }

    public boolean containsIllegalData() {
        Object value;
        int size;
        Vector values;
        String attribute;
        String namespace;
        if (super.containsIllegalData()) {
            return true;
        }
        Enumeration en1 = this.getNameSpaces(2);
        while (en1.hasMoreElements()) {
            namespace = (String)en1.nextElement();
            if (this.isIllegalString(namespace)) {
                return true;
            }
            Enumeration en2 = this.getAttributesOnNamespace(namespace, 2);
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                if (this.isIllegalString(attribute)) {
                    return true;
                }
                values = this.getAttributeValues(namespace, attribute, 2);
                size = values.size();
                int i = 0;
                while (i < size) {
                    value = values.elementAt(i);
                    if (value instanceof String && this.isIllegalString((String)value)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        Enumeration en12 = this.getNameSpaces(0);
        while (en12.hasMoreElements()) {
            namespace = (String)en12.nextElement();
            if (this.isIllegalString(namespace)) {
                return true;
            }
            Enumeration en2 = this.getAttributesOnNamespace(namespace, 0);
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                if (this.isIllegalString(attribute)) {
                    return true;
                }
                values = this.getAttributeValues(namespace, attribute, 0);
                size = values.size();
                int i = 0;
                while (i < size) {
                    value = values.elementAt(i);
                    if (value instanceof String && this.isIllegalString((String)value)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        Enumeration en13 = this.getNameSpaces(1);
        while (en13.hasMoreElements()) {
            namespace = (String)en13.nextElement();
            if (this.isIllegalString(namespace)) {
                return true;
            }
            Enumeration en2 = this.getAttributesOnNamespace(namespace, 1);
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                if (this.isIllegalString(attribute)) {
                    return true;
                }
                values = this.getAttributeValues(namespace, attribute, 1);
                size = values.size();
                int i = 0;
                while (i < size) {
                    value = values.elementAt(i);
                    if (value instanceof String && this.isIllegalString((String)value)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        Enumeration en14 = this.getNameSpaces(3);
        while (en14.hasMoreElements()) {
            namespace = (String)en14.nextElement();
            if (this.isIllegalString(namespace)) {
                return true;
            }
            Enumeration en2 = this.getAttributesOnNamespace(namespace, 3);
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                if (!this.isIllegalString(attribute)) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration getAttributesOnNamespace(String nameSpace, int dataType) {
        Hashtable namespaceProberties = null;
        switch (dataType) {
            case 0: {
                namespaceProberties = (Hashtable)this.additionalData.get(nameSpace);
                break;
            }
            case 1: {
                namespaceProberties = (Hashtable)this.removedData.get(nameSpace);
                break;
            }
            case 2: {
                namespaceProberties = (Hashtable)this.setData.get(nameSpace);
                break;
            }
            case 3: {
                Vector attributes = (Vector)this.deleteData.get(nameSpace);
                if (attributes != null) {
                    return attributes.elements();
                }
                return new Vector().elements();
            }
            default: {
                throw new UMRuntimeException("Unknown dataType");
            }
        }
        if (namespaceProberties != null) {
            return namespaceProberties.keys();
        }
        return new Hashtable().keys();
    }

    public Enumeration getNameSpaces(int dataType) {
        switch (dataType) {
            case 0: {
                return this.additionalData.keys();
            }
            case 1: {
                return this.removedData.keys();
            }
            case 2: {
                return this.setData.keys();
            }
            case 3: {
                return this.deleteData.keys();
            }
        }
        throw new UMRuntimeException("Unknown dataType");
    }

    public AttributeList getModifiedAttributes() {
        int attrType;
        AttributeList modifiedAttributes = new AttributeList(false);
        String namespace = null;
        String attribute = null;
        Vector v = null;
        Object o = null;
        Enumeration namespaces = this.getNameSpaces(2);
        while (namespaces.hasMoreElements()) {
            namespace = (String)namespaces.nextElement();
            Enumeration attributes = this.getAttributesOnNamespace(namespace, 2);
            while (attributes.hasMoreElements()) {
                attribute = (String)attributes.nextElement();
                attrType = 0;
                v = this.getAttributeValues(namespace, attribute, 2);
                if (v != null && !v.isEmpty() && (o = v.firstElement()) != null) {
                    if (o instanceof String) {
                        attrType = 1;
                    } else if (o instanceof byte[]) {
                        attrType = 2;
                    }
                }
                modifiedAttributes.addAttribute(namespace, attribute, attrType);
            }
        }
        Enumeration namespaces2 = this.getNameSpaces(3);
        while (namespaces2.hasMoreElements()) {
            namespace = (String)namespaces2.nextElement();
            Enumeration attributes = this.getAttributesOnNamespace(namespace, 3);
            while (attributes.hasMoreElements()) {
                attribute = (String)attributes.nextElement();
                attrType = 0;
                modifiedAttributes.addAttribute(namespace, attribute, attrType);
            }
        }
        Enumeration namespaces3 = this.getNameSpaces(0);
        while (namespaces3.hasMoreElements()) {
            namespace = (String)namespaces3.nextElement();
            Enumeration attributes = this.getAttributesOnNamespace(namespace, 0);
            while (attributes.hasMoreElements()) {
                attribute = (String)attributes.nextElement();
                attrType = 0;
                v = this.getAttributeValues(namespace, attribute, 0);
                if (v != null && !v.isEmpty() && (o = v.firstElement()) != null) {
                    if (o instanceof String) {
                        attrType = 1;
                    } else if (o instanceof byte[]) {
                        attrType = 2;
                    }
                }
                modifiedAttributes.addAttribute(namespace, attribute, attrType);
            }
        }
        Enumeration namespaces4 = this.getNameSpaces(1);
        while (namespaces4.hasMoreElements()) {
            namespace = (String)namespaces4.nextElement();
            Enumeration attributes = this.getAttributesOnNamespace(namespace, 1);
            while (attributes.hasMoreElements()) {
                attribute = (String)attributes.nextElement();
                attrType = 0;
                v = this.getAttributeValues(namespace, attribute, 1);
                if (v != null && !v.isEmpty() && (o = v.firstElement()) != null) {
                    if (o instanceof String) {
                        attrType = 1;
                    } else if (o instanceof byte[]) {
                        attrType = 2;
                    }
                }
                modifiedAttributes.addAttribute(namespace, attribute, attrType);
            }
        }
        return modifiedAttributes;
    }

    public void addAttributeMaintValue(String nameSpace, String attributeName, Object value) {
        Vector<Object> addAttribute;
        Hashtable addNamespaceProperties;
        if (nameSpace == null) {
            throw new UMRuntimeException("Cannot add value if namespace is null!");
        }
        if (attributeName == null) {
            throw new UMRuntimeException("Cannot add value if the name of the attribute is null!");
        }
        if (value != null) {
            Object o;
            Vector removeAttribute;
            this.isNew = false;
            addNamespaceProperties = (Hashtable)this.additionalData.get(nameSpace);
            Hashtable<String, Vector> removeNamespaceProperties = (Hashtable<String, Vector>)this.removedData.get(nameSpace);
            if (addNamespaceProperties == null) {
                addNamespaceProperties = new Hashtable();
            }
            if (removeNamespaceProperties == null) {
                removeNamespaceProperties = new Hashtable<String, Vector>();
            }
            if ((removeAttribute = (Vector)removeNamespaceProperties.get(attributeName)) != null && removeAttribute.contains(value)) {
                removeAttribute.remove(value);
                removeNamespaceProperties.put(attributeName, removeAttribute);
                this.removedData.put(nameSpace, removeNamespaceProperties);
                return;
            }
            addAttribute = (Vector<Object>)addNamespaceProperties.get(attributeName);
            if (addAttribute == null) {
                addAttribute = new Vector<Object>();
            } else if (!addAttribute.isEmpty() && (o = addAttribute.firstElement()) != null && !o.getClass().equals(value.getClass())) {
                throw new UMRuntimeException("Object of class " + value.getClass() + " cannot be added to set of class " + o.getClass());
            }
        } else {
            StringBuffer errorMessage = new StringBuffer("Cannot add null value from attribute.");
            if (this.id != null) {
                errorMessage.append("(");
                errorMessage.append(this.id);
                errorMessage.append(")");
            }
            throw new IllegalArgumentException(errorMessage.toString());
        }
        addAttribute.add(value);
        addNamespaceProperties.put(attributeName, addAttribute);
        this.additionalData.put(nameSpace, addNamespaceProperties);
    }

    public Vector getAttributeValues(String nameSpace, String attribute, int dataType) {
        Hashtable namespaceProberties = null;
        switch (dataType) {
            case 0: {
                namespaceProberties = (Hashtable)this.additionalData.get(nameSpace);
                break;
            }
            case 1: {
                namespaceProberties = (Hashtable)this.removedData.get(nameSpace);
                break;
            }
            case 2: {
                namespaceProberties = (Hashtable)this.setData.get(nameSpace);
                break;
            }
            case 3: {
                throw new UMRuntimeException("Deleted attributes have no values!");
            }
            default: {
                throw new UMRuntimeException("Unknown dataType");
            }
        }
        if (namespaceProberties != null) {
            return (Vector)namespaceProberties.get(attribute);
        }
        return null;
    }

    public void removeAttributeMaintValue(String nameSpace, String attributeName, Object value) {
        Vector<Object> removeAttribute;
        Hashtable removeNamespaceProperties;
        if (nameSpace == null) {
            throw new UMRuntimeException("Cannot remove value if namespace is null!");
        }
        if (attributeName == null) {
            throw new UMRuntimeException("Cannot remove value if the name of the attribute is null!");
        }
        if (value != null) {
            Vector addAttribute;
            this.isNew = false;
            Hashtable<String, Vector> addNamespaceProperties = (Hashtable<String, Vector>)this.additionalData.get(nameSpace);
            removeNamespaceProperties = (Hashtable)this.removedData.get(nameSpace);
            if (addNamespaceProperties == null) {
                addNamespaceProperties = new Hashtable<String, Vector>();
            }
            if (removeNamespaceProperties == null) {
                removeNamespaceProperties = new Hashtable();
            }
            if ((addAttribute = (Vector)addNamespaceProperties.get(attributeName)) != null && addAttribute.contains(value)) {
                addAttribute.remove(value);
                addNamespaceProperties.put(attributeName, addAttribute);
                this.additionalData.put(nameSpace, addNamespaceProperties);
                return;
            }
            removeAttribute = (Vector<Object>)removeNamespaceProperties.get(attributeName);
            if (removeAttribute == null) {
                removeAttribute = new Vector<Object>();
            }
            if (!removeAttribute.contains(value)) {
                removeAttribute.add(value);
            }
        } else {
            StringBuffer errorMessage = new StringBuffer("Cannot remove null value from attribute.");
            if (this.id != null) {
                errorMessage.append("(");
                errorMessage.append(this.id);
                errorMessage.append(")");
            }
            throw new IllegalArgumentException(errorMessage.toString());
        }
        removeNamespaceProperties.put(attributeName, removeAttribute);
        this.removedData.put(nameSpace, removeNamespaceProperties);
    }

    public Vector getAttributeValues(String nameSpace, String attribute) {
        Vector removedAttributes;
        Vector values = super.getAttributeValues(nameSpace, attribute);
        Hashtable namespaceSet = (Hashtable)this.setData.get(nameSpace);
        Vector setValues = null;
        if (namespaceSet != null) {
            setValues = (Vector)namespaceSet.get(attribute);
        }
        if (setValues != null) {
            values = setValues;
        }
        if ((removedAttributes = (Vector)this.deleteData.get(nameSpace)) != null && removedAttributes.contains(attribute)) {
            values = new Vector();
        }
        Hashtable namespaceAdd = (Hashtable)this.additionalData.get(nameSpace);
        Vector addValues = null;
        if (namespaceAdd != null) {
            addValues = (Vector)namespaceAdd.get(attribute);
        }
        if (addValues != null) {
            int i = 0;
            while (i < addValues.size()) {
                if (values == null) {
                    values = addValues;
                }
                if (!values.contains(addValues.elementAt(i))) {
                    values.add(addValues.elementAt(i));
                }
                ++i;
            }
        }
        Hashtable namespaceRemove = (Hashtable)this.removedData.get(nameSpace);
        Vector removeValues = null;
        if (namespaceRemove != null) {
            removeValues = (Vector)namespaceRemove.get(attribute);
        }
        if (removeValues != null) {
            int i = 0;
            while (i < removeValues.size()) {
                if (values != null && values.contains(removeValues.elementAt(i))) {
                    values.remove(removeValues.elementAt(i));
                }
                ++i;
            }
        }
        return values;
    }

    public boolean isValueInAttribute(String nameSpace, String attribute, Object value) {
        Vector readValues = this.getAttributeValues(nameSpace, attribute);
        if (readValues == null && value == null) {
            return true;
        }
        if (readValues == null) {
            return false;
        }
        return readValues.contains(value);
    }

    public void undoChanges() {
        this.additionalData.clear();
        this.removedData.clear();
        this.setData.clear();
        this.deleteData.clear();
        this.isNew = true;
    }

    public Enumeration getAttributesOnNamespace(String nameSpace) {
        Object nextElement;
        Vector collector = new Vector();
        Enumeration en = super.getAttributesOnNamespace(nameSpace);
        while (en.hasMoreElements()) {
            nextElement = en.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        Enumeration en2 = this.getAttributesOnNamespace(nameSpace, 2);
        while (en2.hasMoreElements()) {
            nextElement = en2.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        Enumeration en3 = this.getAttributesOnNamespace(nameSpace, 0);
        while (en3.hasMoreElements()) {
            nextElement = en3.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        return collector.elements();
    }

    public Enumeration getNameSpaces() {
        Object nextElement;
        Vector collector = new Vector();
        Enumeration en = super.getNameSpaces();
        while (en.hasMoreElements()) {
            nextElement = en.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        Enumeration en2 = this.getNameSpaces(2);
        while (en2.hasMoreElements()) {
            nextElement = en2.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        Enumeration en3 = this.getNameSpaces(0);
        while (en3.hasMoreElements()) {
            nextElement = en3.nextElement();
            if (collector.contains(nextElement)) continue;
            collector.add(nextElement);
        }
        return collector.elements();
    }

    public Vector getReadAttributeValues(String nameSpace, String attribute) {
        return super.getAttributeValues(nameSpace, attribute);
    }
}

