/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.persistence.ISearchElement;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.UserAdminHelper;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.locking.imp.LockManager;
import com.sap.security.core.logon.imp.AnonymousUser;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceMetaData;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.CompanyGroups;
import com.sap.security.core.persistence.datasource.imp.Configuration;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DataBasePersistence;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.OutOfOrderSubstituteDataSource;
import com.sap.security.core.persistence.datasource.imp.R3PersistenceBase;
import com.sap.security.core.persistence.datasource.imp.SuperGroups;
import com.sap.security.core.persistence.datasource.imp.SuperUser;
import com.sap.security.core.persistence.imp.DataSourceMetaData;
import com.sap.security.core.persistence.imp.DistributedTransaction;
import com.sap.security.core.persistence.imp.FutureResult;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.persistence.imp.WorkQueue;
import com.sap.security.core.persistence.notification.IPersistenceNotification;
import com.sap.security.core.persistence.notification.IPersistenceNotificationListener;
import com.sap.security.core.persistence.notification.NotificationException;
import com.sap.security.core.persistence.notification.imp.CleanupNotification;
import com.sap.security.core.persistence.notification.imp.PersistenceNotificationListener;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import com.sap.tc.logging.Location;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import com.sapmarkets.tpd.TradingPartnerDirectoryCommon;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PrincipalDatabagFactoryInstance
implements IPrincipalDatabagFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/PrincipalDatabagFactoryInstance.java#8 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    public static final String MONITOR_PERFORMANCE = "ume.persistence.performance_monitor.activated";
    public static final String BATCH_METHOD_PAGE_SIZE = "ume.persistence.batch.page_size";
    public static final String MULTITHREADING_ENABLED = "ume.persistence.multithreading_enabled";
    public static final String WORKQUEUE_SIZE = "ume.persistence.workqueue_size";
    private IDataSource[] mDataSource;
    private IDataSource[] mDataSourceInCommitOrder;
    private Collection mDataBaseDataSources;
    private IPersistenceNotificationListener mPersistenceNotificationListener;
    private Vector mNotificationListeners;
    private IDataSourceMetaData[] mDataSourceMetaData;
    private Configuration[] mConfiguration;
    private Hashtable openTransactions;
    private static IPrincipalDatabagFactory _instance = null;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/PrincipalDatabagFactoryInstance.java#8 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)");
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$persistence$imp$PrincipalDatabagFactoryInstance == null ? (class$com$sap$security$core$persistence$imp$PrincipalDatabagFactoryInstance = PrincipalDatabagFactoryInstance.class$("com.sap.security.core.persistence.imp.PrincipalDatabagFactoryInstance")) : class$com$sap$security$core$persistence$imp$PrincipalDatabagFactoryInstance));
    private int mRuntimeMode;
    private boolean mMonitorPerformance;
    private int mBatchMethodPageSize;
    private boolean mMultithreadingEnabled;
    private WorkQueue mWorkQueue;
    private boolean mUseAttributeTimeLimits;
    static /* synthetic */ Class class$com$sap$security$core$persistence$imp$PrincipalDatabagFactoryInstance;

    public Configuration[] getCurrentConfiguration() throws PersistenceException {
        return this.mConfiguration;
    }

    public DSConfigurationModel[] getRuntimeConfiguration() throws PersistenceException {
        int size = this.mDataSource.length;
        DSConfigurationModel[] result = new DSConfigurationModel[size];
        int i = 0;
        while (i < size) {
            result[i] = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
            ++i;
        }
        return result;
    }

    public IDataSourceMetaData[] getDataSourceMetaData() throws PersistenceException {
        return this.mDataSourceMetaData;
    }

    public IDataSourceMetaData[] getDataSourcesForPrincipalCreation(IPrincipalDatabag principalTemplate) throws PersistenceException {
        PrincipalDatabagMaint p = new PrincipalDatabagMaint(null);
        p.assimilatePrincipalDatabag((IInternalPrincipalDatabag)principalTemplate);
        int length = this.mDataSource.length;
        Vector<IDataSourceMetaData> result = new Vector<IDataSourceMetaData>();
        int i = 0;
        while (i < length) {
            if (((DataSourceBaseImplementation)this.mDataSource[i]).bindNewPrincipalDatabag(p)) {
                p.setUniqueID(null);
                result.add(this.mDataSourceMetaData[i]);
            }
            ++i;
        }
        return result.toArray(new IDataSourceMetaData[result.size()]);
    }

    public IDataSourceMetaData[] getDataSourcesForPrincipalSearch(SearchCriteria criteria) throws PersistenceException {
        int length = this.mDataSource.length;
        Vector<IDataSourceMetaData> result = new Vector<IDataSourceMetaData>();
        String type = criteria.getPrincipalType();
        int size = criteria.getElementSize();
        int i = 0;
        while (i < length) {
            boolean responsibleForAtLeastOneAttribute = false;
            int j = 0;
            while (j < size && !responsibleForAtLeastOneAttribute) {
                ISearchElement dummy = criteria.getElement(j);
                if (((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(type, dummy.getAttributeNameSpace(), dummy.getAttributeName())) {
                    responsibleForAtLeastOneAttribute = true;
                    result.add(this.mDataSourceMetaData[i]);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IDataSourceMetaData[result.size()]);
    }

    public int getNumberOfDataSources() {
        return this.mDataSource.length;
    }

    public String getDataSourceIDAt(int index) throws PersistenceException {
        if (index < 0 || index > this.mDataSource.length) {
            throw new PersistenceException("Invalid index " + index);
        }
        return this.mDataSource[index].getId();
    }

    public PrincipalDatabagFactoryInstance(InputStream[] dataSourcesConfigurationFile) throws PersistenceException {
        boolean superGroupsEnabled;
        boolean superAdminEnabled;
        if (mTrace.beInfo()) {
            mTrace.infoT("constructor", "Init with data source definition: " + dataSourcesConfigurationFile);
        }
        this.mPersistenceNotificationListener = new PersistenceNotificationListener();
        this.mNotificationListeners = new Vector();
        this.mConfiguration = new Configuration[dataSourcesConfigurationFile.length];
        int i = 0;
        while (i < dataSourcesConfigurationFile.length) {
            this.mConfiguration[i] = new Configuration(dataSourcesConfigurationFile[i]);
            ++i;
        }
        Vector dsConfs = null;
        int i2 = 0;
        while (i2 < dataSourcesConfigurationFile.length) {
            dsConfs = this.buildUnion(new Vector[]{dsConfs, this.mConfiguration[i2].getDataSourceConfigurations()});
            ++i2;
        }
        int size = dsConfs.size();
        Vector<String> names = new Vector<String>();
        int i3 = 0;
        while (i3 < size) {
            String dsID = ((DSConfigurationModel)dsConfs.elementAt(i3)).getDataSourceID();
            if (names.contains(dsID)) {
                String errorMessage = "Found more than one data source with id \"" + dsID + "\"";
                throw new PersistenceException(errorMessage);
            }
            names.add(dsID);
            ++i3;
        }
        Vector<IDataSource> persistencies = new Vector<IDataSource>();
        if (dsConfs != null) {
            int i4 = 0;
            while (i4 < dsConfs.size()) {
                DSConfigurationModel currentConfig = (DSConfigurationModel)dsConfs.elementAt(i4);
                String className = currentConfig.getClassName();
                try {
                    if (mTrace.beInfo()) {
                        mTrace.infoT("constructor", "Trying to instantiate data source class " + className);
                    }
                    Class<?> currentClass = Class.forName(className);
                    persistencies.add((IDataSource)currentClass.newInstance());
                    if (mTrace.beInfo()) {
                        mTrace.infoT("constructor", "Trying to initialize data source class " + className);
                    }
                    try {
                        currentConfig.setNotificationListener(this.mPersistenceNotificationListener);
                        ((IDataSource)persistencies.elementAt(i4)).init(currentConfig);
                    }
                    catch (PersistenceException pex) {
                        mTrace.logFatalT("Initialization of UME persistence adapter \"{0}\" failed.", new Object[]{((IDataSource)persistencies.elementAt(i4)).getId()});
                        myLoc.traceThrowableT(500, "constructor", "Initialization of data source class {0} failed", new Object[]{((IDataSource)persistencies.elementAt(i4)).getId()}, (Throwable)((Object)pex));
                        throw pex;
                    }
                }
                catch (ClassNotFoundException cnfex) {
                    throw new PersistenceException(cnfex);
                }
                catch (IllegalAccessException iaex) {
                    throw new PersistenceException(iaex);
                }
                catch (InstantiationException inex) {
                    throw new PersistenceException(inex);
                }
                ++i4;
            }
        }
        if (superAdminEnabled = UMFactory.getProperties().getBoolean("ume.superadmin.activated", false)) {
            SuperUser.SUPERUSER_IS_ACTIVE = true;
            System.out.println("WARNING: SAP* is active on this system. For security reasons, disable after initial set up");
            mTrace.warningT("init", "SAP* is active on this system. For security reasons, disable after initial set up");
            SuperUser superUserDataSource = new SuperUser();
            superUserDataSource.init(null);
            persistencies.add(superUserDataSource);
        }
        if (superGroupsEnabled = UMFactory.getProperties().getBoolean("ume.supergroups.activated", true)) {
            SuperGroups superGroupDataSource = new SuperGroups();
            superGroupDataSource.init(null);
            persistencies.add(superGroupDataSource);
        }
        if (UserAdminHelper.isDefaultTPDEnabled() || UserAdminHelper.isCompanyConceptEnabled() && UMFactory.getProperties().getBoolean("ume.company_groups.enabled", false)) {
            if (TradingPartnerDirectoryCommon.getTPD() != null) {
                CompanyGroups companyGroupsDataSource = new CompanyGroups();
                companyGroupsDataSource.init(null);
                persistencies.add(companyGroupsDataSource);
            } else if (mTrace.beWarning()) {
                mTrace.warningT("init", "No TPD available because TradingPartnerDirectoryCommon.getTPD() returned null. CompanyGroups datasource will NOT be added.");
            }
        }
        Iterator iter = ((AbstractList)persistencies).iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof R3PersistenceBase) {
                Util.setRepositoryAvailable(1);
                continue;
            }
            if (!"com.sapportals.portal.prt.service.usermanagement.persistence.pcd.GLRolePersistence".equals(((DataSourceBaseImplementation)o).mConfigurationModel.getClassName())) continue;
            Util.setRepositoryAvailable(2);
        }
        this.mDataSource = new IDataSource[persistencies.size()];
        int i5 = 0;
        while (i5 < persistencies.size()) {
            this.mDataSource[i5] = (IDataSource)persistencies.elementAt(i5);
            ++i5;
        }
        this.mDataSourceMetaData = new IDataSourceMetaData[persistencies.size()];
        int i6 = 0;
        while (i6 < persistencies.size()) {
            this.mDataSourceMetaData[i6] = this.getMetaData((IDataSource)persistencies.elementAt(i6));
            ++i6;
        }
        this.mDataSourceInCommitOrder = this.getDataSourcesInCommitOrder();
        this.mDataBaseDataSources = null;
        boolean created = false;
        int i7 = 0;
        while (i7 < this.mDataSource.length && !created) {
            block32: {
                if (this.mDataSource[i7] instanceof DataBasePersistence && ((DataBasePersistence)this.mDataSource[i7]).wasEmptyOnStartup()) {
                    try {
                        PrincipalDatabag p = new PrincipalDatabag(null);
                        Vector<String> ptype = new Vector<String>();
                        ptype.add("OOOO");
                        p.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", ptype);
                        Vector<String> timest = new Vector<String>();
                        timest.add(Util.getTimeStamp());
                        p.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", timest);
                        Vector<String> string = new Vector<String>();
                        string.add("PKL");
                        p.setAttributeValues("com.sap.security.core.usermanagement", "LKP", string);
                        IDataSourceTransaction dstrans = this.mDataSource[i7].beginTransaction();
                        if (dstrans.bindNewPrincipalDatabag(p)) {
                            dstrans.createPrincipalDatabag(p);
                            dstrans.commit();
                            created = true;
                        }
                    }
                    catch (PersistenceException pex) {
                        if (!mTrace.beInfo()) break block32;
                        mTrace.infoT("constructor", "Cannot create licensing object because of PersistenceException.", (Throwable)((Object)pex));
                    }
                }
            }
            ++i7;
        }
        this.openTransactions = new Hashtable();
        this.mMonitorPerformance = UMFactory.getProperties().getBoolean(MONITOR_PERFORMANCE, false);
        this.mBatchMethodPageSize = UMFactory.getProperties().getNumber(BATCH_METHOD_PAGE_SIZE, 25);
        this.mMultithreadingEnabled = UMFactory.getProperties().getBoolean(MULTITHREADING_ENABLED, false);
        this.mWorkQueue = this.mMultithreadingEnabled ? new WorkQueue(UMFactory.getProperties().getNumber(WORKQUEUE_SIZE, 100)) : null;
        this.mRuntimeMode = 0;
        this.mUseAttributeTimeLimits = this.timeLimitedAttributesPresent();
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public synchronized void resetPerformanceMonitor() {
        int size = this.mDataSourceMetaData.length;
        int i = 0;
        while (i < size) {
            DataSourceMetaData dummy = (DataSourceMetaData)this.mDataSourceMetaData[i];
            dummy.mCheckCredentialsCount = 0L;
            dummy.mCheckCredentialsTime = 0L;
            dummy.mCheckCredentialsMinTime = 0L;
            dummy.mCheckCredentialsMaxTime = 0L;
            dummy.mCommitCount = 0L;
            dummy.mCommitTime = 0L;
            dummy.mCommitMinTime = 0L;
            dummy.mCommitMaxTime = 0L;
            dummy.mPopulatePrincipalCount = 0L;
            dummy.mPopulatePrincipalTime = 0L;
            dummy.mPopulatePrincipalMinTime = 0L;
            dummy.mPopulatePrincipalMaxTime = 0L;
            dummy.mPopulateAttributeCount = 0L;
            dummy.mPopulateAttributeTime = 0L;
            dummy.mPopulateAttributeMinTime = 0L;
            dummy.mPopulateAttributeMaxTime = 0L;
            dummy.mDeleteCount = 0L;
            dummy.mDeleteTime = 0L;
            dummy.mDeleteMinTime = 0L;
            dummy.mDeleteMaxTime = 0L;
            dummy.mUpdateCount = 0L;
            dummy.mUpdateTime = 0L;
            dummy.mUpdateMinTime = 0L;
            dummy.mUpdateMaxTime = 0L;
            dummy.mCreateCount = 0L;
            dummy.mCreateTime = 0L;
            dummy.mCreateMinTime = 0L;
            dummy.mCreateMaxTime = 0L;
            dummy.mSearchCount = 0L;
            dummy.mSearchTime = 0L;
            dummy.mSearchMinTime = 0L;
            dummy.mSearchMaxTime = 0L;
            ++i;
        }
    }

    public synchronized void addSearchTime(long searchTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addSearchTime(searchTime);
    }

    public synchronized void addPopulateAttributeTime(long populateAttributeTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addPopulateAttributeTime(populateAttributeTime);
    }

    public synchronized void addPopulatePrincipalTime(long populatePrincipalTime, int dsNumber) {
        this.addPopulatePrincipalTime(populatePrincipalTime, 1, dsNumber);
    }

    public synchronized void addGetDirectParentsTime(long getDirectParentsTime, int numberOfPrincipals, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addGetDirectParentsTime(getDirectParentsTime, numberOfPrincipals);
    }

    private synchronized void addPopulatePrincipalTime(long populatePrincipalTime, int numberOfPopulatedPrincipals, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addPopulatePrincipalTime(populatePrincipalTime, numberOfPopulatedPrincipals);
    }

    public void registerPersistenceNotificationListener(IPersistenceNotificationListener persistenceNotificationListener) {
        if (!this.mNotificationListeners.contains(persistenceNotificationListener)) {
            this.mNotificationListeners.add(persistenceNotificationListener);
        }
    }

    public void unregisterPersistenceNotificationListener(IPersistenceNotificationListener persistenceNotificationListener) {
        this.mNotificationListeners.remove(persistenceNotificationListener);
    }

    public synchronized void addCreateTime(long createTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addCreateTime(createTime);
    }

    public synchronized void addDeleteTime(long deleteTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addDeleteTime(deleteTime);
    }

    public synchronized void addUpdateTime(long updateTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addUpdateTime(updateTime);
    }

    public synchronized void addCommitTime(long commitTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addCommitTime(commitTime);
    }

    public synchronized void addCheckCredentialsTime(long checkCredentialsTime, int dsNumber) {
        ((DataSourceMetaData)this.mDataSourceMetaData[dsNumber]).addCheckCredentialsTime(checkCredentialsTime);
    }

    public synchronized void notify(IPersistenceNotification persistenceNotification) throws NotificationException {
        block12: {
            if (persistenceNotification == null) {
                throw new NotificationException("IPersistenceNotification object for notification is null.");
            }
            String methodName = "notify";
            if (persistenceNotification instanceof CleanupNotification) {
                String uniqueID = ((CleanupNotification)persistenceNotification).getUniqueID();
                String callerID = persistenceNotification.getCaller();
                PrincipalDatabag pdb = new PrincipalDatabag(uniqueID);
                int size = this.mDataSource.length;
                int i = 0;
                while (i < size) {
                    block11: {
                        try {
                            if (!this.mDataSource[i].getId().equals(callerID)) {
                                IDataSourceTransaction dummyTransaction = this.mDataSource[i].beginTransaction();
                                dummyTransaction.deletePrincipalDatabag(pdb);
                                dummyTransaction.commit();
                            }
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beInfo()) break block11;
                            mTrace.infoT(methodName, "Cleanup of \"" + uniqueID + "\" requested by \"" + callerID + "\" reported errors: " + pex.getMessage(), (Throwable)((Object)pex));
                        }
                    }
                    ++i;
                }
            } else {
                String errorMessge = "Unknown IPersistenceNotification received: " + persistenceNotification.getClass();
                if (mTrace.beInfo()) {
                    mTrace.infoT(methodName, errorMessge);
                }
                throw new NotificationException(errorMessge);
            }
            int dsize = this.mNotificationListeners.size();
            try {
                int i = 0;
                while (i < dsize) {
                    ((IPersistenceNotificationListener)this.mNotificationListeners.elementAt(i)).notify(persistenceNotification);
                    ++i;
                }
            }
            catch (NotificationException nex) {
                if (!mTrace.beInfo()) break block12;
                mTrace.infoT(methodName, "Notification of a listener failed.", (Throwable)((Object)nex));
            }
        }
    }

    public void cleanupPrincipalDatabag(String uniqueID) throws PersistenceException {
        this.cleanupPrincipalDatabag(uniqueID, null);
    }

    public void cleanupPrincipalDatabag(String uniqueID, Collection datasources) throws PersistenceException {
        int size;
        Vector principalSets;
        Vector accounts;
        String methodName;
        block46: {
            if (uniqueID == null) {
                throw new PersistenceException("uniqueID must not be null.");
            }
            if (uniqueID != null) {
                try {
                    if (uniqueID.startsWith("USER") ? AnonymousUser.getInstance().isAnonymousUserUniqueId(uniqueID) : uniqueID.startsWith("UACC") && AnonymousUser.getInstance().isAnonymousUserAccountUniqueId(uniqueID)) {
                        return;
                    }
                }
                catch (UMException umex) {
                    throw new PersistenceException(umex);
                }
            }
            String[] ds = null;
            if (datasources != null) {
                ds = datasources.toArray(new String[datasources.size()]);
            }
            methodName = "cleanupPrincipalDatabag";
            accounts = null;
            if (uniqueID.startsWith("USER")) {
                SearchCriteria sc = new SearchCriteria("UACC");
                sc.addEqualsElement("com.sap.security.core.usermanagement", "userid", uniqueID, true);
                if (ds != null) {
                    sc.setDataSourcesToSearch(ds);
                }
                accounts = this.searchPrincipalDatabags(sc);
            } else {
                accounts = new Vector();
            }
            principalSets = new Vector();
            try {
                String[] principalSetTypes = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getKnownPrincipalSetTypes();
                size = principalSetTypes.length;
                int i = 0;
                while (i < size) {
                    SearchCriteria searchFilter = new SearchCriteria(principalSetTypes[i]);
                    searchFilter.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
                    if (ds != null) {
                        searchFilter.setDataSourcesToSearch(ds);
                    }
                    principalSets = this.buildUnion(new Vector[]{principalSets, this.searchPrincipalDatabags(searchFilter)});
                    ++i;
                }
            }
            catch (UMException umex) {
                if (!mTrace.beInfo()) break block46;
                mTrace.infoT(methodName, "Error during determination of direct parents of \"" + uniqueID + "\": " + umex.getMessage(), umex);
            }
        }
        Vector<PrincipalDatabag> principalsToDelete = new Vector<PrincipalDatabag>();
        Vector<PrincipalDatabagMaint> principalsToUpdate = new Vector<PrincipalDatabagMaint>();
        size = accounts.size();
        int i = 0;
        while (i < size) {
            principalsToDelete.add(new PrincipalDatabag((String)accounts.elementAt(i)));
            ++i;
        }
        principalsToDelete.add(new PrincipalDatabag(uniqueID));
        size = principalSets.size();
        int i2 = 0;
        while (i2 < size) {
            PrincipalDatabagMaint pdbMaint = new PrincipalDatabagMaint((String)principalSets.elementAt(i2));
            pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
            principalsToUpdate.add(pdbMaint);
            ++i2;
        }
        size = this.mDataSource.length;
        int i3 = 0;
        while (i3 < size) {
            if (!this.mDataSource[i3].isReadonly() && (datasources == null || datasources.contains(this.mDataSource[i3].getId()))) {
                IDataSourceTransaction dummyTransaction;
                String currentID;
                int listSize = principalsToUpdate.size();
                int j = 0;
                while (j < listSize) {
                    block47: {
                        currentID = ((IPrincipalDatabagMaint)principalsToUpdate.elementAt(j)).getUniqueID();
                        try {
                            dummyTransaction = this.mDataSource[i3].beginTransaction();
                            dummyTransaction.updatePrincipalDatabag((PrincipalDatabagMaint)principalsToUpdate.elementAt(j));
                            dummyTransaction.commit();
                            try {
                                if (currentID.startsWith("ROLE")) {
                                    if (uniqueID.startsWith("GRUP")) {
                                        RoleFactory.unassignGroupPerformed(currentID, uniqueID);
                                    } else if (uniqueID.startsWith("USER")) {
                                        RoleFactory.unassignUserPerformed(currentID, uniqueID);
                                    }
                                    RoleFactory.invalidateRoleInCache(currentID);
                                    break block47;
                                }
                                if (currentID.startsWith("GRUP")) {
                                    if (uniqueID.startsWith("GRUP")) {
                                        GroupFactory.unassignGroupPerformed(uniqueID, currentID);
                                    } else if (uniqueID.startsWith("USER")) {
                                        GroupFactory.unassignUserPerformed(uniqueID, currentID);
                                    }
                                    GroupFactory.invalidateGroupInCache(currentID);
                                    break block47;
                                }
                                PrincipalFactory.unassignPrincipalPerformed(currentID, uniqueID);
                                PrincipalFactory.invalidatePrincipalInCache(currentID);
                            }
                            catch (UMException umex) {
                                if (mTrace.beInfo()) {
                                    mTrace.infoT(methodName, "Notification to listener for unassignment \"" + currentID + "\"-->\"" + uniqueID + "\" reported errors: " + umex.getMessage(), umex);
                                }
                            }
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beInfo()) break block47;
                            mTrace.infoT(methodName, "Cleanup of assignment \"" + currentID + "\"-->\"" + uniqueID + "\" reported errors: " + pex.getMessage(), (Throwable)((Object)pex));
                        }
                    }
                    ++j;
                }
                listSize = principalsToDelete.size();
                int j2 = 0;
                while (j2 < listSize) {
                    block48: {
                        currentID = ((PrincipalDatabag)principalsToDelete.elementAt(j2)).getUniqueID();
                        try {
                            dummyTransaction = this.mDataSource[i3].beginTransaction();
                            dummyTransaction.deletePrincipalDatabag((PrincipalDatabag)principalsToDelete.elementAt(j2));
                            dummyTransaction.commit();
                            try {
                                if (currentID.startsWith("UACC")) {
                                    UserAccountFactory.removeUserAccountPerformed(currentID);
                                    UserAccountFactory.invalidateUserAccountInCache(currentID);
                                } else if (currentID.startsWith("USER")) {
                                    UserFactory.removeUserPerformed(currentID);
                                    UserFactory.invalidateUserInCache(currentID);
                                } else if (currentID.startsWith("GRUP")) {
                                    GroupFactory.removeGroupPerformed(currentID);
                                    GroupFactory.invalidateGroupInCache(currentID);
                                } else if (currentID.startsWith("ROLE")) {
                                    RoleFactory.removeRolePerformed(currentID);
                                    RoleFactory.invalidateRoleInCache(currentID);
                                } else {
                                    PrincipalFactory.removePrincipalPerformed(currentID);
                                    PrincipalFactory.invalidatePrincipalInCache(currentID);
                                }
                                String[] aclManagers = UMFactory.getAllAclManagers();
                                if (aclManagers.length > 0) {
                                    UMFactory.getAclManager((String)aclManagers[0]).deletePrincipal(currentID);
                                }
                            }
                            catch (UMException umex) {
                                if (mTrace.beInfo()) {
                                    mTrace.infoT(methodName, "Notification to listener for unassignment \"" + currentID + "\"-->\"" + uniqueID + "\" reported errors: " + umex.getMessage(), umex);
                                }
                            }
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beInfo()) break block48;
                            mTrace.infoT(methodName, "Cleanup of \"" + currentID + "\" reported errors: " + pex.getMessage(), (Throwable)((Object)pex));
                        }
                    }
                    ++j2;
                }
            }
            ++i3;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        block42: {
            block41: {
                monitor = null;
                monitorString = "UME:PrincipalDatabagFactory:checkCredentials";
                try {
                    block49: {
                        block48: {
                            if (ConfMonitor.getComponentLevel() == 2) {
                                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:checkCredentials");
                                monitor.startComponent(2, "UME:PrincipalDatabagFactory:checkCredentials");
                            }
                            length = this.mDataSource.length;
                            if (!this.mMultithreadingEnabled) break block48;
                            checkResults = new Boolean[length];
                            results = new FutureResult[length];
                            commands = new Runnable[length];
                            dsToCheck = (String[])credentials.get("dataSourceIDs");
                            dsMetadata = this.getDataSourceMetaData();
                            i = 0;
                            if (true) ** GOTO lbl68
                        }
                        successful = false;
                        persEx = null;
                        dsMetadata = this.getDataSourceMetaData();
                        dsToCheck = (String[])credentials.get("dataSourceIDs");
                        if (!this.mMonitorPerformance && monitor == null) break block49;
                        i = 0;
                        if (true) ** GOTO lbl173
                    }
                    i = 0;
lbl26:
                    // 2 sources

                    while (true) {
                        block50: {
                            if (i >= length || successful) break block41;
                            if (!this.mDataSource[i].isPrimary() || !dsMetadata[i].isUsedForCheckingCredentials()) break block42;
                            if (dsToCheck == null) break block50;
                            k = 0;
                            if (true) ** GOTO lbl196
                        }
                        try {
                            successful = this.mDataSource[i].checkCredentials(credentials) != false || successful != false;
                        }
                        catch (PersistenceException pex) {
                            if (persEx == null) {
                                persEx = pex;
                            }
                            if (PrincipalDatabagFactoryInstance.mTrace.beError()) {
                                PrincipalDatabagFactoryInstance.mTrace.errorT("checkCredentials", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                            }
                            break block42;
                        }
                        break;
                    }
                }
                catch (Throwable var16_46) {
                    var17_45 = null;
                    if (monitor == null) throw var16_46;
                    monitor.endComponent("UME:PrincipalDatabagFactory:checkCredentials");
                    monitor.endRequest("UME:PrincipalDatabagFactory:checkCredentials");
                    throw var16_46;
                }
                do {
                    block51: {
                        block52: {
                            if (!this.mDataSource[i].isPrimary() || !dsMetadata[i].isUsedForCheckingCredentials()) break block51;
                            if (dsToCheck == null) break block52;
                            k = 0;
                            if (true) ** GOTO lbl65
                        }
                        results[i] = new FutureResult(this);
                        commands[i] = results[i].checkCredentialsSetter(this.mDataSource[i], credentials, this.mMonitorPerformance, i);
                        this.mWorkQueue.execute(commands[i]);
                        break block51;
                        do {
                            if (dsToCheck[k] != null && dsToCheck[k].equals(this.mDataSource[i].getId())) {
                                results[i] = new FutureResult(this);
                                commands[i] = results[i].checkCredentialsSetter(this.mDataSource[i], credentials, this.mMonitorPerformance, i);
                                this.mWorkQueue.execute(commands[i]);
                            }
                            ++k;
lbl65:
                            // 2 sources

                        } while (k < dsToCheck.length);
                    }
                    ++i;
lbl68:
                    // 2 sources

                } while (i < length);
                persEx = null;
                i = 0;
                while (i < length) {
                    block43: {
                        if (results[i] != null) {
                            try {
                                checkResults[i] = (Boolean)results[i].get();
                                if (!checkResults[i].booleanValue()) break block43;
                                var13_26 = true;
                                var17_41 = null;
                                if (monitor == null) return var13_26;
                            }
                            catch (InterruptedException irex) {
                                block44: {
                                    checkResults[i] = Boolean.FALSE;
                                    if (!PrincipalDatabagFactoryInstance.mTrace.beInfo()) break block43;
                                    id = "NOT AVAILABLE";
                                    try {
                                        id = this.mDataSource[i].getId();
                                    }
                                    catch (PersistenceException p) {
                                        if (!PrincipalDatabagFactoryInstance.mTrace.beDebug()) break block44;
                                        PrincipalDatabagFactoryInstance.mTrace.debugT("checkCredentials", (Throwable)p);
                                    }
                                }
                                PrincipalDatabagFactoryInstance.mTrace.infoT("checkCredentials", "checking credentials on datasource \"" + id + "\" was interrupted.", irex);
                                break block43;
                            }
                            catch (InvocationTargetException itex) {
                                checkResults[i] = Boolean.FALSE;
                                if (PrincipalDatabagFactoryInstance.mTrace.beError()) {
                                    pex = itex.getTargetException();
                                    if (persEx == null) {
                                        persEx = pex;
                                    }
                                    PrincipalDatabagFactoryInstance.mTrace.errorT("checkCredentials", this.mDataSource[i].getId() + " " + pex.getMessage(), pex);
                                }
                                break block43;
                            }
                            monitor.endComponent("UME:PrincipalDatabagFactory:checkCredentials");
                            monitor.endRequest("UME:PrincipalDatabagFactory:checkCredentials");
                            return var13_26;
                        }
                        checkResults[i] = Boolean.FALSE;
                    }
                    ++i;
                }
                i = 0;
                while (i < length) {
                    if (checkResults[i].booleanValue()) {
                        itex = true;
                        var17_42 = null;
                        if (monitor == null) return itex;
                        monitor.endComponent("UME:PrincipalDatabagFactory:checkCredentials");
                        monitor.endRequest("UME:PrincipalDatabagFactory:checkCredentials");
                        return itex;
                    }
                    ++i;
                }
                if (persEx != null) {
                    throw (PersistenceException)persEx;
                }
                itex = false;
                var17_43 = null;
                if (monitor == null) return itex;
                monitor.endComponent("UME:PrincipalDatabagFactory:checkCredentials");
                monitor.endRequest("UME:PrincipalDatabagFactory:checkCredentials");
                return itex;
                do {
                    block45: {
                        block53: {
                            if (!this.mDataSource[i].isPrimary() || !dsMetadata[i].isUsedForCheckingCredentials()) break block45;
                            if (dsToCheck == null) break block53;
                            k = 0;
                            if (true) ** GOTO lbl170
                        }
                        try {
                            startTimeStamp = System.currentTimeMillis();
                            successful = this.mDataSource[i].checkCredentials(credentials) != false || successful != false;
                            endTimeStamp = System.currentTimeMillis();
                            this.addCheckCredentialsTime(endTimeStamp - startTimeStamp, i);
                            if (monitor != null) {
                                buf = new StringBuffer("DataSource").append(i).append(" checkCredentialsTime: ").append(endTimeStamp - startTimeStamp);
                                monitor.compAction(2, "UME:PrincipalDatabagFactory:checkCredentials", buf.toString());
                            }
                            break block45;
                        }
                        catch (PersistenceException pex) {
                            if (persEx == null) {
                                persEx = pex;
                            }
                            if (PrincipalDatabagFactoryInstance.mTrace.beError()) {
                                PrincipalDatabagFactoryInstance.mTrace.errorT("checkCredentials", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                            }
                            break block45;
                        }
                        do {
                            block46: {
                                if (dsToCheck[k] != null && dsToCheck[k].equals(this.mDataSource[i].getId())) {
                                    try {
                                        startTimeStamp = System.currentTimeMillis();
                                        successful = this.mDataSource[i].checkCredentials(credentials) != false || successful != false;
                                        endTimeStamp = System.currentTimeMillis();
                                        this.addCheckCredentialsTime(endTimeStamp - startTimeStamp, i);
                                        if (monitor != null) {
                                            buf = new StringBuffer("DataSource").append(i).append(" checkCredentialsTime: ").append(endTimeStamp - startTimeStamp);
                                            monitor.compAction(2, "UME:PrincipalDatabagFactory:checkCredentials", buf.toString());
                                        }
                                    }
                                    catch (PersistenceException pex) {
                                        if (persEx == null) {
                                            persEx = pex;
                                        }
                                        if (!PrincipalDatabagFactoryInstance.mTrace.beError()) break block46;
                                        PrincipalDatabagFactoryInstance.mTrace.errorT("checkCredentials", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                                    }
                                }
                            }
                            ++k;
lbl170:
                            // 2 sources

                        } while (k < dsToCheck.length);
                    }
                    ++i;
lbl173:
                    // 2 sources

                } while (i < length && !successful);
            }
            if (!successful && persEx != null) {
                throw persEx;
            }
            var9_16 = successful;
            var17_44 = null;
            if (monitor == null) return var9_16;
            monitor.endComponent("UME:PrincipalDatabagFactory:checkCredentials");
            monitor.endRequest("UME:PrincipalDatabagFactory:checkCredentials");
            return var9_16;
            do {
                block47: {
                    if (dsToCheck[k] != null && dsToCheck[k].equals(this.mDataSource[i].getId())) {
                        try {
                            successful = this.mDataSource[i].checkCredentials(credentials) != false || successful != false;
                        }
                        catch (PersistenceException pex) {
                            if (persEx == null) {
                                persEx = pex;
                            }
                            if (!PrincipalDatabagFactoryInstance.mTrace.beError()) break block47;
                            PrincipalDatabagFactoryInstance.mTrace.errorT("checkCredentials", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                        }
                    }
                }
                ++k;
lbl196:
                // 2 sources

            } while (k < dsToCheck.length);
        }
        ++i;
        ** while (true)
    }

    public void addDataSource(InputStream configuration) throws PersistenceException {
        if (configuration == null) {
            throw new PersistenceException("No configuration given. The stream is null!");
        }
        Configuration conf = new Configuration(configuration);
        Vector dsConfs = conf.getDataSourceConfigurations();
        DSConfigurationModel currentConfig = null;
        String className = null;
        Class<?> currentClass = null;
        Vector<IDataSource> persistencies = new Vector<IDataSource>();
        int size = dsConfs.size();
        int i = 0;
        while (i < size) {
            currentConfig = (DSConfigurationModel)dsConfs.elementAt(i);
            className = currentConfig.getClassName();
            try {
                if (mTrace.beInfo()) {
                    mTrace.infoT("constructor", "Trying to instantiate data source class " + className);
                }
                currentClass = Class.forName(className);
                persistencies.add((IDataSource)currentClass.newInstance());
                if (mTrace.beInfo()) {
                    mTrace.infoT("constructor", "Trying to initialize data source class " + className);
                }
                try {
                    currentConfig.setNotificationListener(this.mPersistenceNotificationListener);
                    ((IDataSource)persistencies.elementAt(i)).init(currentConfig);
                }
                catch (PersistenceException pex) {
                    if (mTrace.beError()) {
                        mTrace.errorT("constructor", "Initialization of data source class " + ((IDataSource)persistencies.elementAt(i)).getId() + " failed: " + pex.getMessage(), (Throwable)((Object)pex));
                    }
                }
            }
            catch (ClassNotFoundException cnfex) {
                throw new PersistenceException(cnfex);
            }
            catch (IllegalAccessException iaex) {
                throw new PersistenceException(iaex);
            }
            catch (InstantiationException inex) {
                throw new PersistenceException(inex);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < persistencies.size()) {
            this.addDataSource((IDataSource)persistencies.elementAt(i2));
            ++i2;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("addDataSource");
        }
    }

    public void addDataSource(IDataSource newDataSource, InputStream configuration) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("addDataSource", new Object[]{newDataSource, configuration});
        }
        if (configuration == null) {
            throw new PersistenceException("No configuration given. The stream is null!");
        }
        if (newDataSource == null) {
            throw new PersistenceException("No datasource class given!");
        }
        Configuration conf = new Configuration(configuration);
        Vector dsConf = conf.getDataSourceConfigurations();
        int size = dsConf.size();
        if (size < 1) {
            throw new PersistenceException("The given configuration contains no datasource configuration!");
        }
        if (size > 1) {
            throw new PersistenceException("The given configuration contains more than one datasource configuration!");
        }
        if (!(newDataSource instanceof OutOfOrderSubstituteDataSource) && !newDataSource.getClass().getName().equals(((DSConfigurationModel)dsConf.elementAt(0)).getClassName())) {
            throw new PersistenceException("The given datasource doesn't match the given datasource configuration (wrong class name)!");
        }
        ((DSConfigurationModel)dsConf.elementAt(0)).setNotificationListener(this.mPersistenceNotificationListener);
        newDataSource.init((DSConfigurationModel)dsConf.elementAt(0));
        this.addDataSource(newDataSource);
        if (mTrace.bePath()) {
            mTrace.exiting("addDataSource");
        }
    }

    private IDataSourceMetaData getMetaData(IDataSource dataSource) throws PersistenceException {
        DSConfigurationModel dsConf;
        boolean isUsedForCheckingCredentials;
        block9: {
            String methodName = "getMetaData";
            isUsedForCheckingCredentials = false;
            dsConf = null;
            try {
                dsConf = ((DataSourceBaseImplementation)dataSource).mConfigurationModel;
            }
            catch (ClassCastException ccex) {
                throw new PersistenceException(ccex);
            }
            if (dsConf == null) {
                String errorMessage = "DSConfigurationModel of datasource \"" + dataSource.getId() + "\" is null!";
                throw new PersistenceException(errorMessage);
            }
            if (dataSource.isPrimary()) {
                if (dsConf.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "j_user") && dsConf.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "j_password") || dsConf.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate")) {
                    isUsedForCheckingCredentials = true;
                } else {
                    try {
                        if (dsConf.getPrivateAttributeBooleanValue("check_credentials")) {
                            isUsedForCheckingCredentials = true;
                        }
                    }
                    catch (PersistenceException pex) {
                        if (!mTrace.beInfo()) break block9;
                        mTrace.infoT(methodName, (Throwable)((Object)pex));
                    }
                }
            }
        }
        return new DataSourceMetaData(dsConf.getDataSourceID(), dsConf.getDisplayName(), isUsedForCheckingCredentials, dsConf.getClassName(), dsConf.getIsReadonly(), dsConf.getIsPrimary());
    }

    public void addDataSource(IDataSource newDataSource) throws PersistenceException {
        if (newDataSource == null) {
            throw new PersistenceException("No datasource class given!");
        }
        int size = this.mDataSource.length;
        int index = -1;
        int i = 0;
        while (i < size && index == -1) {
            if (this.mDataSource[i].getId().equals(newDataSource.getId())) {
                index = i;
            }
            ++i;
        }
        if (newDataSource instanceof R3PersistenceBase) {
            Util.setRepositoryAvailable(1);
        } else if ("com.sapportals.portal.prt.service.usermanagement.persistence.pcd.GLRolePersistence".equals(((DataSourceBaseImplementation)newDataSource).mConfigurationModel.getClassName())) {
            Util.setRepositoryAvailable(2);
        }
        if (index == -1) {
            IDataSource[] dummy = new IDataSource[size + 1];
            IDataSourceMetaData[] dummy2 = new IDataSourceMetaData[size + 1];
            int i2 = 0;
            while (i2 < size) {
                dummy[i2] = this.mDataSource[i2];
                dummy2[i2] = this.mDataSourceMetaData[i2];
                ++i2;
            }
            dummy[size] = newDataSource;
            dummy2[size] = this.getMetaData(newDataSource);
            this.mDataSource = dummy;
            this.mDataSourceMetaData = dummy2;
            this.mDataSourceInCommitOrder = this.getDataSourcesInCommitOrder();
            this.mDataBaseDataSources = null;
        } else {
            IDataSource[] dummy = new IDataSource[size];
            IDataSourceMetaData[] dummy2 = new IDataSourceMetaData[size];
            int i3 = 0;
            while (i3 < size) {
                if (i3 != index) {
                    dummy[i3] = this.mDataSource[i3];
                    dummy2[i3] = this.mDataSourceMetaData[i3];
                } else {
                    if (newDataSource instanceof OutOfOrderSubstituteDataSource) {
                        newDataSource.init(((DataSourceBaseImplementation)this.mDataSource[i3]).mConfigurationModel);
                    }
                    dummy[i3] = newDataSource;
                    dummy2[i3] = this.getMetaData(newDataSource);
                }
                ++i3;
            }
            this.mDataSource = dummy;
            this.mDataSourceMetaData = dummy2;
            this.mDataSourceInCommitOrder = this.getDataSourcesInCommitOrder();
            this.mDataBaseDataSources = null;
        }
        PrincipalDatabagFactory.addDataSource(newDataSource, this);
    }

    public IDataSourceMetaData getHomeDataSource(String uniqueID) throws PersistenceException {
        if (uniqueID == null) {
            throw new PersistenceException("Cannot check existence if unique id is null.");
        }
        int length = this.mDataSourceMetaData.length;
        String[] idParts = null;
        int homeDatasourceNum = -1;
        int j = 0;
        while (j < length && homeDatasourceNum == -1) {
            if (idParts == null) {
                idParts = ((DataSourceBaseImplementation)this.mDataSource[j]).splitPrincipalDatabagID(uniqueID);
            }
            if (this.mDataSourceMetaData[j].getDataSourceID().equals(idParts[1])) {
                return this.mDataSourceMetaData[j];
            }
            ++j;
        }
        throw new PersistenceException("Home data source for \"" + uniqueID + "\" not found.");
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        boolean exists;
        block10: {
            String uniqueID = principal.getUniqueID();
            if (uniqueID == null) {
                throw new PersistenceException("Cannot check existence if unique id is null.");
            }
            int length = this.mDataSource.length;
            exists = false;
            String[] idParts = principal.getIDParts();
            int homeDatasourceNum = -1;
            int j = 0;
            while (j < length && homeDatasourceNum == -1) {
                if (this.mDataSource[j].getId().equals(idParts[1])) {
                    homeDatasourceNum = j;
                }
                ++j;
            }
            if (homeDatasourceNum == -1) {
                throw new PersistenceException("Home data source for principal \"" + principal.getUniqueID() + "\" not found.");
            }
            try {
                String lockOwnerID = null;
                try {
                    lockOwnerID = LockManager.getInstance().getReadLock("$library.com.sap.security.core", principal.getUniqueID());
                    exists = this.mDataSource[homeDatasourceNum].principalDatabagExists((PrincipalDatabag)principal);
                    if (exists) {
                        ((IInternalPrincipalDatabag)principal).setExists(true);
                    } else {
                        ((IInternalPrincipalDatabag)principal).setExists(false);
                    }
                    Object var10_10 = null;
                    LockManager.getInstance().releaseLocks(lockOwnerID);
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    LockManager.getInstance().releaseLocks(lockOwnerID);
                    throw throwable;
                }
            }
            catch (PersistenceException pex) {
                if (!mTrace.beError()) break block10;
                mTrace.errorT("principalDatabagExists", this.mDataSource[homeDatasourceNum].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
            }
        }
        return exists;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPrincipalDatabag getPrincipalDatabag(String uniqueID, AttributeList populateAttributes, boolean checkExistence) throws PersistenceException {
        block38: {
            block39: {
                block32: {
                    lockOwnerID = null;
                    monitor = null;
                    monitorString = "UME:PrincipalDatabagFactory:getPrincipalDatabag";
                    try {
                        block37: {
                            block36: {
                                if (ConfMonitor.getComponentLevel() == 2) {
                                    monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:getPrincipalDatabag");
                                    monitor.startComponent(2, "UME:PrincipalDatabagFactory:getPrincipalDatabag");
                                }
                                if (monitor != null) {
                                    monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabag", "trying to getReadLock");
                                }
                                lockOwnerID = LockManager.getInstance().getReadLock("$library.com.sap.security.core", uniqueID);
                                if (monitor != null) {
                                    monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabag", "getReadLock");
                                }
                                length = this.mDataSource.length;
                                p = new PrincipalDatabag(uniqueID);
                                idParts = p.getIDParts();
                                if (!this.mMultithreadingEnabled) break block36;
                                results = new FutureResult[length];
                                commands = new Runnable[length];
                                i = 0;
                                if (true) ** GOTO lbl55
                            }
                            if (!this.mMonitorPerformance && monitor == null) break block37;
                            i = 0;
                            if (true) ** GOTO lbl104
                        }
                        i = 0;
                        while (i < length) {
                            block31: {
                                if (this.mDataSource[i].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(idParts[0])) {
                                    try {
                                        this.mDataSource[i].populatePrincipalDatabag(p, populateAttributes);
                                    }
                                    catch (PersistenceException pex) {
                                        if (idParts[1].equals(this.mDataSource[i].getId())) {
                                            throw pex;
                                        }
                                        if (!PrincipalDatabagFactoryInstance.mTrace.beError()) break block31;
                                        PrincipalDatabagFactoryInstance.mTrace.errorT("getPrincipalDatabag", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                                    }
                                }
                            }
                            ++i;
                        }
                        break block32;
                    }
                    catch (Throwable var17_34) {
                        var18_33 = null;
                        LockManager.getInstance().releaseLocks(lockOwnerID);
                        if (monitor == null) throw var17_34;
                        monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                        monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                        throw var17_34;
                    }
                    do {
                        if (this.mDataSource[i].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(idParts[0])) {
                            results[i] = new FutureResult(this);
                            commands[i] = results[i].populatePrincipalSetter(this.mDataSource[i], p, populateAttributes, this.mMonitorPerformance, i);
                            this.mWorkQueue.execute(commands[i]);
                        }
                        ++i;
lbl55:
                        // 2 sources

                    } while (i < length);
                    i = 0;
                    while (i < length) {
                        block33: {
                            if (results[i] != null) {
                                try {
                                    results[i].get();
                                }
                                catch (InterruptedException irex) {
                                    block34: {
                                        if (!PrincipalDatabagFactoryInstance.mTrace.beInfo()) break block33;
                                        id = "NOT AVAILABLE";
                                        try {
                                            id = this.mDataSource[i].getId();
                                        }
                                        catch (PersistenceException persex) {
                                            if (!PrincipalDatabagFactoryInstance.mTrace.beDebug()) break block34;
                                            PrincipalDatabagFactoryInstance.mTrace.debugT("getPrincipalDatabag", (Throwable)persex);
                                        }
                                    }
                                    PrincipalDatabagFactoryInstance.mTrace.infoT("getPrincipalDatabag", "populate principal on datasource \"" + id + "\" was interrupted.", irex);
                                }
                                catch (InvocationTargetException itex) {
                                    if (idParts[1].equals(this.mDataSource[i].getId())) {
                                        pex = itex.getTargetException();
                                        throw (PersistenceException)pex;
                                    }
                                    if (!PrincipalDatabagFactoryInstance.mTrace.beError()) break block33;
                                    pex = itex.getTargetException();
                                    PrincipalDatabagFactoryInstance.mTrace.errorT("getPrincipalDatabag", this.mDataSource[i].getId() + " " + pex.getMessage(), pex);
                                }
                            }
                        }
                        ++i;
                    }
                    break block32;
                    do {
                        block35: {
                            if (this.mDataSource[i].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(idParts[0])) {
                                try {
                                    startTimeStamp = System.currentTimeMillis();
                                    this.mDataSource[i].populatePrincipalDatabag(p, populateAttributes);
                                    endTimeStamp = System.currentTimeMillis();
                                    this.addPopulatePrincipalTime(endTimeStamp - startTimeStamp, i);
                                    if (monitor != null) {
                                        buf = new StringBuffer("DataSource").append(i).append(" PopulatePrincipalTime: ").append(endTimeStamp - startTimeStamp);
                                        monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabag", buf.toString());
                                    }
                                }
                                catch (PersistenceException pex) {
                                    if (idParts[1].equals(this.mDataSource[i].getId())) {
                                        throw pex;
                                    }
                                    if (!PrincipalDatabagFactoryInstance.mTrace.beError()) break block35;
                                    PrincipalDatabagFactoryInstance.mTrace.errorT("getPrincipalDatabag", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)pex);
                                }
                            }
                        }
                        ++i;
lbl104:
                        // 2 sources

                    } while (i < length);
                }
                if (!checkExistence) break block38;
                if (!p.isExistenceChecked()) break block39;
                if (!p.exists()) {
                    i = null;
                    var18_29 = null;
                    LockManager.getInstance().releaseLocks(lockOwnerID);
                    if (monitor == null) return i;
                    monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                    monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                    return i;
                }
                break block38;
            }
            finished = false;
            i = 0;
            if (true) ** GOTO lbl147
        }
lbl123:
        // 2 sources

        while (true) {
            this.setInitialAttributeTimeLimits(p);
            var10_10 = p;
            var18_32 = null;
            LockManager.getInstance().releaseLocks(lockOwnerID);
            if (monitor == null) return var10_10;
            monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabag");
            monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabag");
            return var10_10;
        }
        do {
            if (idParts[1].equals(this.mDataSource[i].getId())) {
                if (!this.mDataSource[i].principalDatabagExists(p)) {
                    var12_19 = null;
                    var18_30 = null;
                    LockManager.getInstance().releaseLocks(lockOwnerID);
                    if (monitor == null) return var12_19;
                    monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                    monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabag");
                    return var12_19;
                }
                p.setExists(true);
                finished = true;
            }
            ++i;
lbl147:
            // 2 sources

        } while (i < length && !finished);
        ** while (finished)
lbl149:
        // 1 sources

        var12_20 = null;
        var18_31 = null;
        LockManager.getInstance().releaseLocks(lockOwnerID);
        if (monitor == null) return var12_20;
        monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabag");
        monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabag");
        return var12_20;
    }

    public boolean isPrincipalDatabagAttributeModifiable(IPrincipalDatabag principal, String nameSpace, String attributeName) throws PersistenceException {
        if (this.getRuntimeMode() == 1) {
            return false;
        }
        boolean isModifiable = false;
        int length = this.mDataSource.length;
        String[] idParts = principal.getIDParts();
        int i = 0;
        while (i < length) {
            if (this.mDataSource[i].isPrimary()) {
                DSConfigurationModel dsConf = null;
                try {
                    dsConf = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
                }
                catch (ClassCastException ccex) {
                    throw new PersistenceException(ccex);
                }
                if (dsConf == null) {
                    String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSource[i].getId() + "\" is null!";
                    throw new PersistenceException(errorMessage);
                }
                if (this.mDataSource[i].getId().equals(idParts[1])) {
                    if (dsConf.feelsResponsible(idParts[0], nameSpace, attributeName)) {
                        return dsConf.isAttributeModifiable(idParts[0], nameSpace, attributeName);
                    }
                } else if (!this.mDataSource[i].isReadonly()) {
                    isModifiable = isModifiable || dsConf.feelsResponsible(idParts[0], nameSpace, attributeName) && dsConf.isAttributeModifiable(idParts[0], nameSpace, attributeName);
                }
            }
            ++i;
        }
        return isModifiable;
    }

    public int getPrincipalDatabagAttributeCacheTime(IPrincipalDatabag principal, String nameSpace, String attributeName) throws PersistenceException {
        int cacheTime = -1;
        int length = this.mDataSource.length;
        String[] idParts = principal.getIDParts();
        int i = 0;
        while (i < length) {
            if (this.mDataSource[i].isPrimary()) {
                int currentValue;
                DSConfigurationModel dsConf = null;
                try {
                    dsConf = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
                }
                catch (ClassCastException ccex) {
                    throw new PersistenceException(ccex);
                }
                if (dsConf == null) {
                    String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSource[i].getId() + "\" is null!";
                    throw new PersistenceException(errorMessage);
                }
                if (this.mDataSource[i].getId().equals(idParts[1])) {
                    if (dsConf.feelsResponsible(idParts[0], nameSpace, attributeName)) {
                        return dsConf.getAttributeCacheTime(idParts[0], nameSpace, attributeName);
                    }
                } else if (dsConf.feelsResponsible(idParts[0], nameSpace, attributeName) && (currentValue = dsConf.getAttributeCacheTime(idParts[0], nameSpace, attributeName)) != -1) {
                    if (cacheTime == -1) {
                        cacheTime = currentValue;
                    } else if (currentValue < cacheTime) {
                        cacheTime = currentValue;
                    }
                }
            }
            ++i;
        }
        return cacheTime;
    }

    public boolean timeLimitedAttributesPresent() throws PersistenceException {
        boolean timeLimitedAttributesPresent = false;
        int length = this.mDataSource.length;
        int i = 0;
        while (i < length && !timeLimitedAttributesPresent) {
            if (this.mDataSource[i].isPrimary()) {
                DSConfigurationModel dsConf = null;
                try {
                    dsConf = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
                }
                catch (ClassCastException ccex) {
                    throw new PersistenceException(ccex);
                }
                if (dsConf == null) {
                    String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSource[i].getId() + "\" is null!";
                    throw new PersistenceException(errorMessage);
                }
                timeLimitedAttributesPresent = dsConf.timeLimitedAttributesPresent() || timeLimitedAttributesPresent;
            }
            ++i;
        }
        return timeLimitedAttributesPresent;
    }

    public boolean isPrincipalDatabagDeletable(String uniqueID) throws PersistenceException {
        if (this.getRuntimeMode() == 1) {
            return false;
        }
        if (uniqueID != null) {
            try {
                if (uniqueID.startsWith("USER") ? AnonymousUser.getInstance().isAnonymousUserUniqueId(uniqueID) : uniqueID.startsWith("UACC") && AnonymousUser.getInstance().isAnonymousUserAccountUniqueId(uniqueID)) {
                    return false;
                }
            }
            catch (UMException umex) {
                throw new PersistenceException(umex);
            }
        }
        boolean isDeletable = false;
        int length = this.mDataSource.length;
        String[] idParts = null;
        int i = 0;
        while (i < length && !isDeletable) {
            if (idParts == null) {
                idParts = ((DataSourceBaseImplementation)this.mDataSource[i]).splitPrincipalDatabagID(uniqueID);
            }
            if (this.mDataSource[i].isPrimary() && !this.mDataSource[i].isReadonly()) {
                isDeletable = this.mDataSource[i].getId().equals(idParts[1]);
            }
            ++i;
        }
        return isDeletable;
    }

    public boolean isPrincipalDatabagModifiable(String uniqueID) throws PersistenceException {
        if (this.getRuntimeMode() == 1) {
            return false;
        }
        boolean isModifiable = false;
        if (uniqueID.equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK") || uniqueID.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            return false;
        }
        int length = this.mDataSource.length;
        int i = 0;
        while (i < length && !isModifiable) {
            if (this.mDataSource[i].isPrimary() && !this.mDataSource[i].isReadonly()) {
                DSConfigurationModel dsConf = null;
                try {
                    dsConf = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
                }
                catch (ClassCastException ccex) {
                    throw new PersistenceException(ccex);
                }
                if (dsConf == null) {
                    String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSource[i].getId() + "\" is null!";
                    throw new PersistenceException(errorMessage);
                }
                String[] idParts = ((DataSourceBaseImplementation)this.mDataSource[i]).splitPrincipalDatabagID(uniqueID);
                isModifiable = dsConf.feelsResponsible(idParts[0]);
            }
            ++i;
        }
        return isModifiable;
    }

    public boolean isPerformanceMonitorActivated() throws PersistenceException {
        return this.mMonitorPerformance;
    }

    public void activatePerformanceMonitor() throws PersistenceException {
        this.mMonitorPerformance = true;
    }

    public void deactivatePerformanceMonitor() throws PersistenceException {
        this.mMonitorPerformance = false;
    }

    public void activateMultithreadingMode() throws PersistenceException {
        this.mWorkQueue = new WorkQueue(UMFactory.getProperties().getNumber(WORKQUEUE_SIZE, 100));
        this.mMultithreadingEnabled = true;
    }

    public void deactivateMultithreadingMode() throws PersistenceException {
        this.mMultithreadingEnabled = false;
        this.mWorkQueue = null;
    }

    public boolean isMultithreadingActivated() throws PersistenceException {
        return this.mMultithreadingEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populatePrincipalDatabagAttribute(IPrincipalDatabag princ, String nameSpace, String attribute) throws PersistenceException {
        String lockOwnerID = null;
        IMonitor monitor = null;
        String monitorString = "UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute";
        try {
            int cachingTime;
            int i;
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
                monitor.startComponent(2, "UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
            }
            if (monitor != null) {
                monitor.compAction(2, "UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute", "trying to getReadLock");
            }
            lockOwnerID = LockManager.getInstance().getReadLock("$library.com.sap.security.core", princ.getUniqueID());
            if (monitor != null) {
                monitor.compAction(2, "UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute", "getReadLock");
            }
            int length = this.mDataSource.length;
            boolean responsibleDataSourceFound = false;
            PrincipalDatabag principal = new PrincipalDatabag(princ.getUniqueID());
            String[] idParts = principal.getIDParts();
            if (this.mMultithreadingEnabled) {
                Boolean[] checkResults = new Boolean[length];
                FutureResult[] results = new FutureResult[length];
                Runnable[] commands = new Runnable[length];
                int i2 = 0;
                while (i2 < length) {
                    if (this.mDataSource[i2].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i2]).mConfigurationModel.feelsResponsible(idParts[0], nameSpace, attribute)) {
                        results[i2] = new FutureResult(this);
                        commands[i2] = results[i2].populateAttributeSetter(this.mDataSource[i2], principal, nameSpace, attribute, false, i2);
                        this.mWorkQueue.execute(commands[i2]);
                    }
                    ++i2;
                }
                i = 0;
                while (i < length) {
                    block38: {
                        if (results[i] != null) {
                            try {
                                checkResults[i] = (Boolean)results[i].get();
                            }
                            catch (InterruptedException irex) {
                                String id;
                                block39: {
                                    if (!mTrace.beInfo()) break block38;
                                    id = "NOT AVAILABLE";
                                    try {
                                        id = this.mDataSource[i].getId();
                                    }
                                    catch (PersistenceException persex) {
                                        if (!mTrace.beDebug()) break block39;
                                        mTrace.debugT("populatePrincipalDatabagAttribute", (Throwable)((Object)persex));
                                    }
                                }
                                mTrace.infoT("populatePrincipalDatabagAttribute", "populate attribute on datasource \"" + id + "\" was interrupted.", irex);
                            }
                            catch (InvocationTargetException itex) {
                                Throwable pex;
                                if (idParts[1].equals(this.mDataSource[i].getId())) {
                                    pex = itex.getTargetException();
                                    throw (PersistenceException)((Object)pex);
                                }
                                if (mTrace.beError()) {
                                    pex = itex.getTargetException();
                                    mTrace.errorT("populatePrincipalDatabagAttribute", this.mDataSource[i].getId() + " " + pex.getMessage(), pex);
                                }
                                break block38;
                            }
                        }
                        checkResults[i] = Boolean.FALSE;
                    }
                    ++i;
                }
                int i3 = 0;
                while (i3 < length) {
                    responsibleDataSourceFound = checkResults[i3] != false || responsibleDataSourceFound;
                    ++i3;
                }
            } else if (this.mMonitorPerformance || monitor != null) {
                i = 0;
                while (i < length) {
                    block40: {
                        if (this.mDataSource[i].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(idParts[0], nameSpace, attribute)) {
                            try {
                                long startTimeStamp = System.currentTimeMillis();
                                responsibleDataSourceFound = this.mDataSource[i].populatePrincipalDatabag(principal, nameSpace, attribute) || responsibleDataSourceFound;
                                long endTimeStamp = System.currentTimeMillis();
                                this.addPopulateAttributeTime(endTimeStamp - startTimeStamp, i);
                                if (monitor != null) {
                                    StringBuffer buf = new StringBuffer("DataSource").append(i).append(" PopulateAttributeTime: ").append(endTimeStamp - startTimeStamp);
                                    monitor.compAction(2, "UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute", buf.toString());
                                }
                            }
                            catch (PersistenceException pex) {
                                if (idParts[1].equals(this.mDataSource[i].getId())) {
                                    throw pex;
                                }
                                if (!mTrace.beError()) break block40;
                                mTrace.errorT("populatePrincipalDatabagAttribute", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                            }
                        }
                    }
                    ++i;
                }
            } else {
                int i4 = 0;
                while (i4 < length) {
                    block41: {
                        if (this.mDataSource[i4].isPrimary() && ((DataSourceBaseImplementation)this.mDataSource[i4]).mConfigurationModel.feelsResponsible(idParts[0], nameSpace, attribute)) {
                            try {
                                responsibleDataSourceFound = this.mDataSource[i4].populatePrincipalDatabag(principal, nameSpace, attribute) || responsibleDataSourceFound;
                            }
                            catch (PersistenceException pex) {
                                if (idParts[1].equals(this.mDataSource[i4].getId())) {
                                    throw pex;
                                }
                                if (!mTrace.beError()) break block41;
                                mTrace.errorT("populatePrincipalDatabagAttribute", this.mDataSource[i4].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                            }
                        }
                    }
                    ++i4;
                }
            }
            if (!responsibleDataSourceFound) {
                String errorMessage = "No responsible data source found for attribute \"" + attribute + "\" on namespace \"" + nameSpace + "\"";
                throw new PersistenceException(errorMessage);
            }
            if (!principal.isExistenceChecked() || !principal.exists()) {
                boolean finished = false;
                int i5 = 0;
                while (i5 < length && !finished) {
                    if (idParts[1].equals(this.mDataSource[i5].getId())) {
                        if (!this.mDataSource[i5].principalDatabagExists(principal)) {
                            throw new PersistenceException("Principal \"" + principal.getUniqueID() + "\" doesn't exist on persistent storage");
                        }
                        ((IInternalPrincipalDatabag)principal).setExists(true);
                        finished = true;
                    }
                    ++i5;
                }
            }
            if (this.mUseAttributeTimeLimits && (cachingTime = this.getPrincipalDatabagAttributeCacheTime(principal, nameSpace, attribute)) != -1) {
                ((IInternalPrincipalDatabag)principal).setCachingTime(nameSpace, attribute, cachingTime);
            }
            ((IInternalPrincipalDatabag)princ).assimilatePrincipalDatabag(principal);
            Object var20_31 = null;
            LockManager.getInstance().releaseLocks(lockOwnerID);
            if (monitor == null) return;
        }
        catch (Throwable throwable) {
            Object var20_32 = null;
            LockManager.getInstance().releaseLocks(lockOwnerID);
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
            monitor.endRequest("UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
            throw throwable;
        }
        monitor.endComponent("UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
        monitor.endRequest("UME:PrincipalDatabagFactory:populatePrincipalDatabagAttribute");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection[] getDirectParents(String[] uniqueIDs, String[] principalTypes) throws PersistenceException {
        Collection[] collectionArray;
        IMonitor monitor = null;
        String monitorString = "UME:PrincipalDatabagFactory:getDirectParents";
        try {
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:getDirectParents");
                monitor.startComponent(2, "UME:PrincipalDatabagFactory:getDirectParents");
            }
            int size = uniqueIDs.length;
            int length = this.mDataSource.length;
            Collection[] result = new Collection[size];
            Collection[] tempResult = null;
            int i = 0;
            while (i < length) {
                block18: {
                    if (this.mDataSource[i].isPrimary()) {
                        if (this.mMonitorPerformance || monitor != null) {
                            try {
                                long startTimeStamp = System.currentTimeMillis();
                                tempResult = this.mDataSource[i].getDirectParents(uniqueIDs, principalTypes);
                                long endTimeStamp = System.currentTimeMillis();
                                this.addGetDirectParentsTime(endTimeStamp - startTimeStamp, uniqueIDs.length, i);
                                if (monitor != null) {
                                    StringBuffer buf = new StringBuffer("DataSource").append(i).append(" GetDirectParentsTime: ").append(endTimeStamp - startTimeStamp);
                                    monitor.compAction(2, "UME:PrincipalDatabagFactory:getDirectParents", buf.toString());
                                }
                                break block18;
                            }
                            catch (PersistenceException pex) {
                                if (mTrace.beError()) {
                                    mTrace.errorT("getDirectParents", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                }
                                break block18;
                            }
                        }
                        try {
                            tempResult = this.mDataSource[i].getDirectParents(uniqueIDs, principalTypes);
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beError()) break block18;
                            mTrace.errorT("getDirectParents", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                        }
                    }
                }
                if (tempResult != null) {
                    int j = 0;
                    while (j < size) {
                        if (tempResult[j] != null && !tempResult[j].isEmpty()) {
                            if (result[j] == null) {
                                result[j] = new HashSet();
                            }
                            result[j].addAll(tempResult[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < size) {
                if (result[i2] == null) {
                    result[i2] = new Vector();
                }
                ++i2;
            }
            collectionArray = result;
            Object var17_18 = null;
            if (monitor == null) return collectionArray;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:PrincipalDatabagFactory:getDirectParents");
            monitor.endRequest("UME:PrincipalDatabagFactory:getDirectParents");
            throw throwable;
        }
        monitor.endComponent("UME:PrincipalDatabagFactory:getDirectParents");
        monitor.endRequest("UME:PrincipalDatabagFactory:getDirectParents");
        return collectionArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getDirectParents(String principalid, String[] principalTypes) throws PersistenceException {
        HashSet hashSet;
        IMonitor monitor = null;
        String monitorString = "UME:PrincipalDatabagFactory:getDirectParents";
        try {
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:getDirectParents");
                monitor.startComponent(2, "UME:PrincipalDatabagFactory:getDirectParents");
            }
            int length = this.mDataSource.length;
            HashSet result = new HashSet();
            Collection tempResult = null;
            int i = 0;
            while (i < length) {
                block13: {
                    if (this.mDataSource[i].isPrimary()) {
                        if (this.mMonitorPerformance || monitor != null) {
                            try {
                                long startTimeStamp = System.currentTimeMillis();
                                tempResult = this.mDataSource[i].getDirectParents(principalid, principalTypes);
                                long endTimeStamp = System.currentTimeMillis();
                                this.addGetDirectParentsTime(endTimeStamp - startTimeStamp, 1, i);
                                if (monitor != null) {
                                    StringBuffer buf = new StringBuffer("DataSource").append(i).append(" GetDirectParentsTime: ").append(endTimeStamp - startTimeStamp);
                                    monitor.compAction(2, "UME:PrincipalDatabagFactory:getDirectParents", buf.toString());
                                }
                                break block13;
                            }
                            catch (PersistenceException pex) {
                                if (mTrace.beError()) {
                                    mTrace.errorT("getDirectParents", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                }
                                break block13;
                            }
                        }
                        try {
                            tempResult = this.mDataSource[i].getDirectParents(principalid, principalTypes);
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beError()) break block13;
                            mTrace.errorT("getDirectParents", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                        }
                    }
                }
                if (tempResult != null && tempResult != null && !tempResult.isEmpty()) {
                    result.addAll(tempResult);
                }
                ++i;
            }
            hashSet = result;
            Object var15_14 = null;
            if (monitor == null) return hashSet;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:PrincipalDatabagFactory:getDirectParents");
            monitor.endRequest("UME:PrincipalDatabagFactory:getDirectParents");
            throw throwable;
        }
        monitor.endComponent("UME:PrincipalDatabagFactory:getDirectParents");
        monitor.endRequest("UME:PrincipalDatabagFactory:getDirectParents");
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPrincipalDatabag[] getPrincipalDatabags(String[] uniqueIDs, AttributeList populateAttributes, boolean checkExistence) throws PersistenceException {
        IPrincipalDatabag[] iPrincipalDatabagArray;
        String lockOwnerID = null;
        IMonitor monitor = null;
        String monitorString = "UME:PrincipalDatabagFactory:getPrincipalDatabags";
        try {
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:getPrincipalDatabags");
                monitor.startComponent(2, "UME:PrincipalDatabagFactory:getPrincipalDatabags");
            }
            if (monitor != null) {
                monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabags", "trying to getReadLock");
            }
            lockOwnerID = LockManager.getInstance().getReadLocks("$library.com.sap.security.core", uniqueIDs);
            if (monitor != null) {
                monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabags", "getReadLock");
            }
            int size = uniqueIDs.length;
            int length = this.mDataSource.length;
            IPrincipalDatabag[] result = new IInternalPrincipalDatabag[size];
            int pageSize = this.mBatchMethodPageSize;
            int currentPage = 0;
            while (currentPage * pageSize < size) {
                int alreadyProcessed = currentPage * pageSize;
                IInternalPrincipalDatabag[] pageResult = size < (currentPage + 1) * pageSize ? new IInternalPrincipalDatabag[size - alreadyProcessed] : new IInternalPrincipalDatabag[pageSize];
                int i = 0;
                while (i < pageResult.length) {
                    pageResult[i] = new PrincipalDatabag(uniqueIDs[alreadyProcessed + i]);
                    ++i;
                }
                Vector<String> homeDataSources = null;
                homeDataSources = new Vector<String>();
                int k = 0;
                while (k < pageResult.length) {
                    String[] idParts = pageResult[k].getIDParts();
                    if (!homeDataSources.contains(idParts[1])) {
                        homeDataSources.add(idParts[1]);
                    }
                    ++k;
                }
                int i2 = 0;
                while (i2 < length) {
                    block31: {
                        if (this.mDataSource[i2].isPrimary()) {
                            if (this.mMonitorPerformance || monitor != null) {
                                try {
                                    long startTimeStamp = System.currentTimeMillis();
                                    this.mDataSource[i2].populatePrincipalDatabags(pageResult, populateAttributes);
                                    long endTimeStamp = System.currentTimeMillis();
                                    this.addPopulatePrincipalTime(endTimeStamp - startTimeStamp, pageResult.length, i2);
                                    if (monitor != null) {
                                        StringBuffer buf = new StringBuffer("DataSource").append(i2).append(" PopulatePrincipalTime: ").append(endTimeStamp - startTimeStamp);
                                        monitor.compAction(2, "UME:PrincipalDatabagFactory:getPrincipalDatabags", buf.toString());
                                    }
                                    break block31;
                                }
                                catch (PersistenceException pex) {
                                    if (homeDataSources.contains(this.mDataSource[i2].getId())) {
                                        throw pex;
                                    }
                                    if (mTrace.beError()) {
                                        mTrace.errorT("getPrincipalDatabags", this.mDataSource[i2].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                    }
                                    break block31;
                                }
                            }
                            try {
                                this.mDataSource[i2].populatePrincipalDatabags(pageResult, populateAttributes);
                            }
                            catch (PersistenceException pex) {
                                if (homeDataSources.contains(this.mDataSource[i2].getId())) {
                                    throw pex;
                                }
                                if (!mTrace.beError()) break block31;
                                mTrace.errorT("getPrincipalDatabags", this.mDataSource[i2].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                            }
                        }
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < pageResult.length) {
                    if (checkExistence) {
                        if (pageResult[i3].isExistenceChecked()) {
                            if (!pageResult[i3].exists()) {
                                pageResult[i3] = null;
                            }
                        } else {
                            String[] idParts = pageResult[i3].getIDParts();
                            boolean finished = false;
                            int u = 0;
                            while (u < length && !finished) {
                                if (idParts[1].equals(this.mDataSource[u].getId())) {
                                    if (!this.mDataSource[u].principalDatabagExists(pageResult[i3])) {
                                        pageResult[i3] = null;
                                    } else {
                                        pageResult[i3].setExists(true);
                                    }
                                    finished = true;
                                }
                                ++u;
                            }
                            if (!finished) {
                                pageResult[i3] = null;
                            }
                        }
                    }
                    ++i3;
                }
                int i4 = 0;
                while (i4 < pageResult.length) {
                    result[alreadyProcessed + i4] = pageResult[i4];
                    ++i4;
                }
                ++currentPage;
            }
            iPrincipalDatabagArray = result;
            Object var27_30 = null;
            LockManager.getInstance().releaseLocks(lockOwnerID);
            if (monitor == null) return iPrincipalDatabagArray;
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            LockManager.getInstance().releaseLocks(lockOwnerID);
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabags");
            monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabags");
            throw throwable;
        }
        monitor.endComponent("UME:PrincipalDatabagFactory:getPrincipalDatabags");
        monitor.endRequest("UME:PrincipalDatabagFactory:getPrincipalDatabags");
        return iPrincipalDatabagArray;
    }

    private void setInitialAttributeTimeLimits(IInternalPrincipalDatabag principal) {
        if (this.mUseAttributeTimeLimits) {
            String uniqueID = principal.getUniqueID();
            AttributeList attrList = principal.getPopulatedAttributes();
            if (attrList != null) {
                int size = attrList.getSize();
                int i = 0;
                while (i < size) {
                    block6: {
                        String namespace = attrList.getNameSpaceOfAttributeAt(i);
                        String attribute = attrList.getAttributeNameOfAttributeAt(i);
                        try {
                            int cachingTime = this.getPrincipalDatabagAttributeCacheTime(principal, namespace, attribute);
                            if (cachingTime != -1) {
                                principal.setCachingTime(namespace, attribute, cachingTime);
                            }
                        }
                        catch (PersistenceException pex) {
                            if (!mTrace.beInfo()) break block6;
                            mTrace.infoT("setInitialAttributeTimeLimits", "Error during reading cache time of principal \"" + uniqueID + "\" namespace \"" + namespace + "\" attribute \"" + uniqueID + "\"", (Throwable)((Object)pex));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private Vector buildIntersection(Vector[] sets) {
        Vector objectsInAllResults = null;
        int length = sets.length;
        int i = 0;
        while (i < length && (objectsInAllResults == null || objectsInAllResults.size() != 0)) {
            Vector currentRes = sets[i] != null ? sets[i] : null;
            if (currentRes != null) {
                if (objectsInAllResults == null) {
                    objectsInAllResults = currentRes;
                } else {
                    Vector intersection = new Vector();
                    int j = 0;
                    while (j < objectsInAllResults.size()) {
                        Object id = objectsInAllResults.elementAt(j);
                        if (currentRes.contains(id)) {
                            intersection.add(id);
                        }
                        ++j;
                    }
                    objectsInAllResults = intersection;
                }
            }
            ++i;
        }
        return objectsInAllResults;
    }

    private Vector buildUnion(Vector[] sets) {
        return this.buildUnion(sets, 0);
    }

    private Vector buildUnion(Vector[] sets, int sizeLimit) {
        boolean checkSizeLimit = sizeLimit > 0;
        boolean sizeLimitReached = false;
        Vector objectsInAllResults = null;
        int length = sets.length;
        int counter = 0;
        int i = 0;
        while (i < length && !sizeLimitReached) {
            Vector currentRes;
            if (sets[i] != null && (currentRes = sets[i]) != null) {
                if (objectsInAllResults == null) {
                    objectsInAllResults = new Vector();
                }
                int j = 0;
                while (j < currentRes.size() && !sizeLimitReached) {
                    Object id = currentRes.elementAt(j);
                    if (!objectsInAllResults.contains(id)) {
                        objectsInAllResults.add(id);
                        if (checkSizeLimit) {
                            sizeLimitReached = ++counter == sizeLimit;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return objectsInAllResults;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        SearchCriteria notNullSearch = new SearchCriteria(criteria.isOrMode(), criteria.getPrincipalType(), criteria.getDataSourcesToSearch());
        SearchCriteria nullSearch = new SearchCriteria(!criteria.isOrMode(), criteria.getPrincipalType(), criteria.getDataSourcesToSearch());
        int size = criteria.getElementSize();
        int i = 0;
        while (i < size) {
            ISearchAttribute dummy = criteria.getAttribute(i);
            Object value = dummy.getAttributeValue();
            String nameSpace = dummy.getAttributeNameSpace();
            String attribute = dummy.getAttributeName();
            if (!nameSpace.equals("com.sap.security.core.usermanagement") || !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                if (value == null) {
                    nullSearch.addLikeElement(nameSpace, attribute, "*", false);
                } else {
                    int op = dummy.getOperator();
                    boolean cs = dummy.isCaseSensitive();
                    switch (op) {
                        case 1: {
                            notNullSearch.addLikeElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 0: {
                            notNullSearch.addEqualsElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 2: {
                            notNullSearch.addGreaterThanElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 3: {
                            notNullSearch.addLessThanElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        default: {
                            throw new PersistenceException("Unknown search operator");
                        }
                    }
                }
            }
            ++i;
        }
        Vector result = new Vector();
        if (nullSearch.getElementSize() > 1) {
            if (criteria.getSearchSizeLimit() > 0) {
                throw new PersistenceException("Search size limits are not supported, if the searched value is null.");
            }
            if (!criteria.isOrMode()) {
                Vector tempResult1 = null;
                if (notNullSearch.getElementSize() > 1) {
                    tempResult1 = this.searchPrincipalDatabagsInternal(notNullSearch);
                    criteria.errorOccurred(notNullSearch.getSearchStatus());
                } else {
                    SearchCriteria searchForAll = new SearchCriteria(true, criteria.getPrincipalType(), criteria.getDataSourcesToSearch());
                    if (criteria.getPrincipalType().equals("UACC")) {
                        searchForAll.addLikeElement("com.sap.security.core.usermanagement", "j_user", "*", false);
                    } else {
                        searchForAll.addLikeElement("com.sap.security.core.usermanagement", "uniquename", "*", false);
                    }
                    tempResult1 = this.searchPrincipalDatabagsInternal(searchForAll);
                    if (searchForAll.isErrorOccurred()) {
                        criteria.errorOccurred(1);
                    }
                    criteria.errorOccurred(searchForAll.getSearchStatus());
                }
                if (tempResult1 == null || tempResult1.isEmpty()) {
                    result = new Vector();
                } else {
                    Vector tempResult2 = this.searchPrincipalDatabagsInternal(nullSearch);
                    if (nullSearch.isErrorOccurred()) {
                        criteria.errorOccurred(2);
                    }
                    criteria.errorOccurred(nullSearch.getSearchStatus());
                    if (tempResult2 == null || tempResult2.isEmpty()) {
                        result = tempResult1;
                    } else {
                        int tempResult2Size = tempResult2.size();
                        int i2 = 0;
                        while (i2 < tempResult2Size) {
                            Object o = tempResult2.elementAt(i2);
                            if (tempResult1.contains(o)) {
                                tempResult1.remove(o);
                            }
                            ++i2;
                        }
                        result = tempResult1;
                    }
                }
            } else {
                SearchCriteria searchForAll = new SearchCriteria(true, criteria.getPrincipalType(), criteria.getDataSourcesToSearch());
                if (criteria.getPrincipalType().equals("UACC")) {
                    searchForAll.addLikeElement("com.sap.security.core.usermanagement", "j_user", "*", false);
                } else {
                    searchForAll.addLikeElement("com.sap.security.core.usermanagement", "uniquename", "*", false);
                }
                Vector tempResult1 = this.searchPrincipalDatabagsInternal(searchForAll);
                if (searchForAll.isErrorOccurred()) {
                    criteria.errorOccurred(1);
                }
                criteria.errorOccurred(searchForAll.getSearchStatus());
                Vector tempResult2 = this.searchPrincipalDatabagsInternal(nullSearch);
                if (nullSearch.isErrorOccurred()) {
                    criteria.errorOccurred(2);
                }
                criteria.errorOccurred(nullSearch.getSearchStatus());
                if (tempResult2 == null || tempResult2.isEmpty()) {
                    result = tempResult1;
                } else {
                    if (tempResult1 != null && !tempResult1.isEmpty()) {
                        int tempResult2Size = tempResult2.size();
                        int i3 = 0;
                        while (i3 < tempResult2Size) {
                            Object o = tempResult2.elementAt(i3);
                            if (tempResult1.contains(o)) {
                                tempResult1.remove(o);
                            }
                            ++i3;
                        }
                    }
                    Vector tempResult3 = this.searchPrincipalDatabagsInternal(notNullSearch);
                    if (notNullSearch.isErrorOccurred()) {
                        criteria.errorOccurred(1);
                    }
                    criteria.errorOccurred(notNullSearch.getSearchStatus());
                    result = this.buildUnion(new Vector[]{tempResult1, tempResult3});
                }
            }
        } else {
            result = this.searchPrincipalDatabagsInternal(criteria);
        }
        if (result == null) {
            result = new Vector();
        }
        return result;
    }

    public void setRuntimeMode(int mode) throws PersistenceException {
        boolean changed = this.mRuntimeMode != mode;
        this.mRuntimeMode = mode;
        if (mTrace.beWarning() && changed) {
            String md = "unknown";
            if (this.mRuntimeMode == 0) {
                md = "read/write";
            } else if (this.mRuntimeMode == 1) {
                md = "readonly";
            }
            mTrace.warningT("setRuntimeMode", "Persistence manager switched to " + md + " mode.");
        }
    }

    public int getRuntimeMode() throws PersistenceException {
        return this.mRuntimeMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector searchPrincipalDatabagsInternal(SearchCriteria criteria) throws PersistenceException {
        Vector vector;
        IMonitor monitor = null;
        String monitorString = "UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal";
        try {
            Vector[] searchResults;
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
                monitor.startComponent(2, "UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
            }
            int length = this.mDataSource.length;
            Vector objectsInAllResults = null;
            if (!criteria.isOrMode() && criteria.getElementSize() > 2) {
                searchResults = new Vector[length];
                int i = 0;
                while (i < length) {
                    if (this.mDataSource[i].isPrimary()) {
                        DSConfigurationModel dsConf = null;
                        try {
                            dsConf = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel;
                        }
                        catch (ClassCastException ccex) {
                            throw new PersistenceException(ccex);
                        }
                        if (dsConf == null) {
                            String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSource[i].getId() + "\" is null!";
                            throw new PersistenceException(errorMessage);
                        }
                        String type = criteria.getPrincipalType();
                        String[] dataSourcesToSearch = criteria.getDataSourcesToSearch();
                        SearchCriteria scCurrent = new SearchCriteria(type, dataSourcesToSearch);
                        SearchCriteria scAllDS = new SearchCriteria(type, dataSourcesToSearch);
                        String namespace = null;
                        String attribute = null;
                        int j = 0;
                        while (j < criteria.getElementSize()) {
                            ISearchAttribute element = criteria.getAttribute(j);
                            namespace = element.getAttributeNameSpace();
                            attribute = element.getAttributeName();
                            if (!namespace.equals("com.sap.security.core.usermanagement") || !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                                String errorMessage;
                                int operatore = element.getOperator();
                                boolean caseSensitive = element.isCaseSensitive();
                                if (dsConf.feelsResponsible(type, namespace, attribute)) {
                                    switch (operatore) {
                                        case 0: {
                                            scCurrent.addEqualsElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 1: {
                                            scCurrent.addLikeElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 2: {
                                            scCurrent.addGreaterThanElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 3: {
                                            scCurrent.addLessThanElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        default: {
                                            errorMessage = "Unknown search operator!";
                                            throw new PersistenceException(errorMessage);
                                        }
                                    }
                                } else {
                                    switch (operatore) {
                                        case 0: {
                                            scAllDS.addEqualsElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 1: {
                                            scAllDS.addLikeElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 2: {
                                            scAllDS.addGreaterThanElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        case 3: {
                                            scAllDS.addLessThanElement(namespace, attribute, element.getAttributeValue(), caseSensitive);
                                            break;
                                        }
                                        default: {
                                            errorMessage = "Unknown search operator!";
                                            throw new PersistenceException(errorMessage);
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                        String[] dsToSearch = scCurrent.getDataSourcesToSearch();
                        boolean found = false;
                        if (dsToSearch != null) {
                            int k = 0;
                            int s = dsToSearch.length;
                            while (k < s && !found) {
                                if (this.mDataSource[i].getId().equals(dsToSearch[k])) {
                                    found = true;
                                }
                                ++k;
                            }
                        } else {
                            found = true;
                        }
                        if (scCurrent.getElementSize() > 1 && found && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(scCurrent.getPrincipalType())) {
                            Vector resultsOfCurrentDS;
                            block82: {
                                resultsOfCurrentDS = null;
                                if (this.mMonitorPerformance || monitor != null) {
                                    try {
                                        long startTimeStamp = System.currentTimeMillis();
                                        resultsOfCurrentDS = this.mDataSource[i].searchPrincipalDatabags(scCurrent);
                                        criteria.errorOccurred(scCurrent.getSearchStatus());
                                        long endTimeStamp = System.currentTimeMillis();
                                        this.addSearchTime(endTimeStamp - startTimeStamp, i);
                                        if (monitor != null) {
                                            StringBuffer buf = new StringBuffer("DataSource").append(i).append(" SearchTime: ").append(endTimeStamp - startTimeStamp);
                                            monitor.compAction(2, "UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal", buf.toString());
                                        }
                                        break block82;
                                    }
                                    catch (PersistenceException pex) {
                                        criteria.errorOccurred(2);
                                        if (mTrace.beError()) {
                                            mTrace.errorT("searchPrincipalDatabagsInternal", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                        }
                                        break block82;
                                    }
                                }
                                try {
                                    resultsOfCurrentDS = this.mDataSource[i].searchPrincipalDatabags(scCurrent);
                                    criteria.errorOccurred(scCurrent.getSearchStatus());
                                }
                                catch (PersistenceException pex) {
                                    criteria.errorOccurred(2);
                                    if (!mTrace.beError()) break block82;
                                    mTrace.errorT("searchPrincipalDatabagsInternal", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                }
                            }
                            if (scAllDS.getElementSize() > 1) {
                                Vector resultsOfAllOtherDS = this.searchPrincipalDatabagsInternal(scAllDS);
                                criteria.errorOccurred(scAllDS.getSearchStatus());
                                searchResults[i] = this.buildIntersection(new Vector[]{resultsOfCurrentDS, resultsOfAllOtherDS});
                            } else {
                                searchResults[i] = resultsOfCurrentDS;
                            }
                        } else {
                            searchResults[i] = null;
                        }
                    }
                    ++i;
                }
                objectsInAllResults = this.buildUnion(searchResults);
            } else {
                searchResults = new Vector[length];
                if (this.mMultithreadingEnabled) {
                    boolean sizeLimitReached = false;
                    int searchSizeLimit = criteria.getSearchSizeLimit();
                    boolean checkSearchSizeLimit = searchSizeLimit > 0;
                    int resultsSoFar = 0;
                    FutureResult[] results = new FutureResult[length];
                    Runnable[] commands = new Runnable[length];
                    int i = 0;
                    while (i < length) {
                        if (this.mDataSource[i].isPrimary()) {
                            String[] dsToSearch = criteria.getDataSourcesToSearch();
                            boolean found = false;
                            if (dsToSearch != null) {
                                int k = 0;
                                int s = dsToSearch.length;
                                while (k < s && !found) {
                                    if (this.mDataSource[i].getId().equals(dsToSearch[k])) {
                                        found = true;
                                    }
                                    ++k;
                                }
                            } else {
                                found = true;
                            }
                            if (found && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(criteria.getPrincipalType())) {
                                results[i] = new FutureResult(this);
                                commands[i] = results[i].searchSetter(this.mDataSource[i], criteria, this.mMonitorPerformance, i);
                                this.mWorkQueue.execute(commands[i]);
                            }
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < length && !sizeLimitReached) {
                        block83: {
                            if (results[i2] != null) {
                                try {
                                    Vector temp;
                                    searchResults[i2] = (Vector)results[i2].get();
                                    if (checkSearchSizeLimit && searchResults[i2] != null && (temp = this.buildUnion(searchResults)) != null) {
                                        resultsSoFar = temp.size();
                                        boolean bl = sizeLimitReached = resultsSoFar >= searchSizeLimit;
                                        if (sizeLimitReached && (resultsSoFar > searchSizeLimit || i2 < length - 1 && resultsSoFar == searchSizeLimit)) {
                                            criteria.errorOccurred(4);
                                        }
                                    }
                                }
                                catch (InterruptedException irex) {
                                    String id;
                                    block84: {
                                        criteria.errorOccurred(2);
                                        if (!mTrace.beInfo()) break block83;
                                        id = "NOT AVAILABLE";
                                        try {
                                            id = this.mDataSource[i2].getId();
                                        }
                                        catch (PersistenceException p) {
                                            if (!mTrace.beDebug()) break block84;
                                            mTrace.debugT("searchPrincipalDatabagsInternal", (Throwable)((Object)p));
                                        }
                                    }
                                    mTrace.infoT("searchPrincipalDatabagsInternal", "search on datasource \"" + id + "\" was interrupted.", irex);
                                }
                                catch (InvocationTargetException itex) {
                                    criteria.errorOccurred(2);
                                    if (!mTrace.beError()) break block83;
                                    Throwable pex = itex.getTargetException();
                                    mTrace.errorT("searchPrincipalDatabagsInternal", this.mDataSource[i2].getId() + " " + pex.getMessage(), pex);
                                }
                            }
                        }
                        ++i2;
                    }
                } else if (this.mMonitorPerformance || monitor != null) {
                    boolean sizeLimitReached = false;
                    int searchSizeLimit = criteria.getSearchSizeLimit();
                    boolean checkSearchSizeLimit = searchSizeLimit > 0;
                    int resultsSoFar = 0;
                    int i = 0;
                    while (i < length && !sizeLimitReached) {
                        Vector temp;
                        block85: {
                            String[] dsToSearch = criteria.getDataSourcesToSearch();
                            boolean found = false;
                            if (dsToSearch != null) {
                                int k = 0;
                                int s = dsToSearch.length;
                                while (k < s && !found) {
                                    if (this.mDataSource[i].getId().equals(dsToSearch[k])) {
                                        found = true;
                                    }
                                    ++k;
                                }
                            } else {
                                found = true;
                            }
                            if (this.mDataSource[i].isPrimary() && found && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(criteria.getPrincipalType())) {
                                try {
                                    long startTimeStamp = System.currentTimeMillis();
                                    searchResults[i] = this.mDataSource[i].searchPrincipalDatabags(criteria);
                                    long endTimeStamp = System.currentTimeMillis();
                                    this.addSearchTime(endTimeStamp - startTimeStamp, i);
                                    if (monitor != null) {
                                        StringBuffer buf = new StringBuffer("DataSource").append(i).append(" SearchTime: ").append(endTimeStamp - startTimeStamp);
                                        monitor.compAction(2, "UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal", buf.toString());
                                    }
                                }
                                catch (PersistenceException pex) {
                                    criteria.errorOccurred(2);
                                    if (!mTrace.beError()) break block85;
                                    mTrace.errorT("searchPrincipalDatabagsInternal", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                }
                            }
                        }
                        if (checkSearchSizeLimit && searchResults[i] != null && (temp = this.buildUnion(searchResults)) != null) {
                            resultsSoFar = temp.size();
                            boolean bl = sizeLimitReached = resultsSoFar >= searchSizeLimit;
                            if (sizeLimitReached && (resultsSoFar > searchSizeLimit || i < length - 1 && resultsSoFar == searchSizeLimit)) {
                                criteria.errorOccurred(4);
                            }
                        }
                        ++i;
                    }
                } else {
                    boolean sizeLimitReached = false;
                    int searchSizeLimit = criteria.getSearchSizeLimit();
                    boolean checkSearchSizeLimit = searchSizeLimit > 0;
                    int resultsSoFar = 0;
                    int i = 0;
                    while (i < length && !sizeLimitReached) {
                        Vector temp;
                        block86: {
                            String[] dsToSearch = criteria.getDataSourcesToSearch();
                            boolean found = false;
                            if (dsToSearch != null) {
                                int k = 0;
                                int s = dsToSearch.length;
                                while (k < s && !found) {
                                    if (this.mDataSource[i].getId().equals(dsToSearch[k])) {
                                        found = true;
                                    }
                                    ++k;
                                }
                            } else {
                                found = true;
                            }
                            if (this.mDataSource[i].isPrimary() && found && ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.feelsResponsible(criteria.getPrincipalType())) {
                                try {
                                    searchResults[i] = this.mDataSource[i].searchPrincipalDatabags(criteria);
                                }
                                catch (PersistenceException pex) {
                                    criteria.errorOccurred(2);
                                    if (!mTrace.beError()) break block86;
                                    mTrace.errorT("searchPrincipalDatabagsInternal", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                                }
                            }
                        }
                        if (checkSearchSizeLimit && searchResults[i] != null && (temp = this.buildUnion(searchResults)) != null) {
                            resultsSoFar = temp.size();
                            boolean bl = sizeLimitReached = resultsSoFar >= searchSizeLimit;
                            if (sizeLimitReached && (resultsSoFar > searchSizeLimit || i < length - 1 && resultsSoFar == searchSizeLimit)) {
                                criteria.errorOccurred(4);
                            }
                        }
                        ++i;
                    }
                }
                objectsInAllResults = this.buildUnion(searchResults, criteria.getSearchSizeLimit());
            }
            vector = objectsInAllResults;
            Object var28_76 = null;
            if (monitor == null) return vector;
        }
        catch (Throwable throwable) {
            Object var28_77 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
            monitor.endRequest("UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
            throw throwable;
        }
        monitor.endComponent("UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
        monitor.endRequest("UME:PrincipalDatabagFactory:searchPrincipalDatabagsInternal");
        return vector;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria, int pageSize) throws PersistenceException {
        Vector pit = this.searchPrincipalDatabags(criteria);
        if (pit.size() < pageSize) {
            pageSize = pit.size();
        }
        Vector page = new Vector(pageSize);
        int i = 0;
        while (i < pageSize) {
            page.add(pit.elementAt(i));
            ++i;
        }
        return page;
    }

    public IDistributedTransaction createDistributedTransaction() {
        DistributedTransaction dtrans = new DistributedTransaction(this.mMonitorPerformance, this);
        IDataSource[] dsCopy = new IDataSource[this.mDataSourceInCommitOrder.length];
        System.arraycopy(this.mDataSourceInCommitOrder, 0, dsCopy, 0, dsCopy.length);
        dtrans.storeDataSources(dsCopy);
        return dtrans;
    }

    public IPrincipalDatabagMaint createPrincipalDatabag(IDistributedTransaction distributedTransaction, IPrincipalDatabag principalTemplate) {
        PrincipalDatabagMaint p = new PrincipalDatabagMaint(null);
        p.assimilatePrincipalDatabag((IInternalPrincipalDatabag)principalTemplate);
        ((DistributedTransaction)distributedTransaction).createAddAction(p);
        return p;
    }

    public IPrincipalDatabagMaint getModifyPrincipalDatabag(IPrincipalDatabag principal) {
        PrincipalDatabagMaint pm = new PrincipalDatabagMaint(principal.getUniqueID());
        pm.assimilatePrincipalDatabag((PrincipalDatabag)principal);
        return pm;
    }

    public void updatePrincipalDatabag(IPrincipalDatabagMaint principalMaint, IDistributedTransaction distributedTransaction) {
        ((DistributedTransaction)distributedTransaction).createUpdateAction((PrincipalDatabagMaint)principalMaint);
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal, IDistributedTransaction distributedTransaction) {
        ((DistributedTransaction)distributedTransaction).createDeleteAction((PrincipalDatabag)principal);
    }

    public AttributeList getAllAttributes(IPrincipalDatabag principal) throws PersistenceException {
        Vector namespaces = this.getAttributeNamespaces(principal);
        AttributeList attrList = new AttributeList(false);
        int size = namespaces.size();
        int i = 0;
        while (i < size) {
            String namespace = (String)namespaces.elementAt(i);
            Vector attributes = this.getAttributeNames(principal, namespace);
            int size2 = attributes.size();
            int j = 0;
            while (j < size2) {
                attrList.addAttribute(namespace, (String)attributes.elementAt(j), 0);
                ++j;
            }
            ++i;
        }
        return attrList;
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        int length = this.mDataSource.length;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < length) {
            if (this.mDataSource[i].isPrimary()) {
                Vector dummy;
                block7: {
                    dummy = null;
                    try {
                        dummy = this.mDataSource[i].getAttributeNamespaces(principal);
                    }
                    catch (PersistenceException pex) {
                        if (!mTrace.beError()) break block7;
                        mTrace.errorT("getAttributeNamespaces", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                    }
                }
                if (dummy != null) {
                    int size = dummy.size();
                    int j = 0;
                    while (j < size) {
                        String namespace = (String)dummy.elementAt(j);
                        if (namespace != null && !result.contains(namespace)) {
                            result.add(namespace);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        int length = this.mDataSource.length;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < length) {
            if (this.mDataSource[i].isPrimary()) {
                Vector dummy;
                block7: {
                    dummy = null;
                    try {
                        dummy = this.mDataSource[i].getAttributeNames(principal, nameSpace);
                    }
                    catch (PersistenceException pex) {
                        if (!mTrace.beError()) break block7;
                        mTrace.errorT("getAttributeNames", this.mDataSource[i].getId() + " " + pex.getMessage(), (Throwable)((Object)pex));
                    }
                }
                if (dummy != null) {
                    int size = dummy.size();
                    int j = 0;
                    while (j < size) {
                        String attribute = (String)dummy.elementAt(j);
                        if (!result.contains(attribute)) {
                            result.add(attribute);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public Vector getKnownPrincipalTypes() throws PersistenceException {
        int length = this.mDataSource.length;
        Vector[] results = new Vector[length];
        int i = 0;
        while (i < length) {
            results[i] = ((DataSourceBaseImplementation)this.mDataSource[i]).mConfigurationModel.getResponsiblePrincipalTypes();
            ++i;
        }
        return this.buildUnion(results);
    }

    public Collection getDatabaseDataSources() throws PersistenceException {
        if (this.mDataBaseDataSources == null) {
            IDataSourceMetaData[] dsMD = this.getDataSourceMetaData();
            HashSet<String> result = new HashSet<String>();
            int j = 0;
            while (j < dsMD.length) {
                if (dsMD[j].getClassName().equals("com.sap.security.core.persistence.datasource.imp.DataBasePersistence")) {
                    result.add(dsMD[j].getDataSourceID());
                }
                ++j;
            }
            this.mDataBaseDataSources = result;
        }
        return this.mDataBaseDataSources;
    }

    private IDataSource[] getDataSourcesInCommitOrder() throws PersistenceException {
        IDataSourceMetaData[] dsMD = this.getDataSourceMetaData();
        Vector<IDataSource> result = new Vector<IDataSource>();
        int j = 0;
        while (j < dsMD.length) {
            if (dsMD[j].getClassName().equals("com.sap.security.core.persistence.datasource.imp.DataBasePersistence")) {
                result.add(this.mDataSource[j]);
            } else {
                result.insertElementAt(this.mDataSource[j], 0);
            }
            ++j;
        }
        return result.toArray(new IDataSource[dsMD.length]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

