/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.Configuration;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.OutOfOrderSubstituteDataSource;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactoryInstance;
import com.sap.security.core.persistence.notification.IPersistenceNotificationListener;
import com.sap.security.core.util.IUMTrace;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class PrincipalDatabagFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/PrincipalDatabagFactory.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IPrincipalDatabagFactory[] _instances = null;
    private static IPrincipalDatabagFactory _activeInstance;
    private static Vector _registeredListeners;
    private static Vector _addedDatasources;
    private static IUMTrace mTrace;
    private static boolean mInitMode;

    public static synchronized int getNumberOfInstances() throws PersistenceException {
        if (_instances == null) {
            PrincipalDatabagFactory.getInstance();
        }
        return _instances.length;
    }

    private static synchronized void addDataSource(IDataSource newDatasource) throws PersistenceException {
        if (_instances == null) {
            PrincipalDatabagFactory.getInstance();
        }
        if (_instances.length == 0) {
            throw new PersistenceException("No instances of IPrincipalDatabagFactory available to add the IDataSource object.");
        }
        PrincipalDatabagFactory.addDatasourceToList(newDatasource);
        _instances[0].addDataSource(newDatasource);
    }

    public static synchronized void addDataSource(IDataSource newDatasource, IPrincipalDatabagFactory callingFactory) throws PersistenceException {
        if (mInitMode) {
            return;
        }
        if (_instances == null) {
            PrincipalDatabagFactory.getInstance();
        }
        PrincipalDatabagFactory.addDatasourceToList(newDatasource);
        int size = _instances.length;
        int i = 0;
        while (i < size) {
            if (_instances[i] != callingFactory) {
                _instances[i].addDataSource(newDatasource);
            }
            ++i;
        }
    }

    private static synchronized void addDatasourceToList(IDataSource newDatasource) throws PersistenceException {
        if (mInitMode) {
            return;
        }
        int size = _addedDatasources.size();
        int index = -1;
        int i = 0;
        while (i < size && index == -1) {
            if (((IDataSource)_addedDatasources.elementAt(i)).getId().equals(newDatasource.getId())) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            _addedDatasources.add(newDatasource);
        } else {
            _addedDatasources.setElementAt(newDatasource, index);
        }
    }

    public static synchronized void registerPersistenceNotificationListener(IPersistenceNotificationListener persistenceNotificationListener) throws PersistenceException {
        if (_instances == null) {
            PrincipalDatabagFactory.getInstance();
        }
        if (_registeredListeners.contains(persistenceNotificationListener)) {
            return;
        }
        _registeredListeners.add(persistenceNotificationListener);
        int size = _instances.length;
        int i = 0;
        while (i < size) {
            _instances[i].registerPersistenceNotificationListener(persistenceNotificationListener);
            ++i;
        }
    }

    public static synchronized void activateInstance(int index) throws PersistenceException {
        if (index < 0 || _instances == null || index > _instances.length) {
            throw new IllegalArgumentException("Array index out of bounds.");
        }
        _activeInstance = _instances[index];
        UserFactory.invalidateCache();
        UserAccountFactory.invalidateCache();
        GroupFactory.invalidateCache();
        RoleFactory.invalidateCache();
        PrincipalFactory.invalidateCache();
    }

    public static synchronized void addInstance(InputStream[] streams) throws PersistenceException {
        if (_instances == null) {
            PrincipalDatabagFactory.getInstance();
        }
        try {
            mInitMode = true;
            PrincipalDatabagFactoryInstance newInstance = new PrincipalDatabagFactoryInstance(streams);
            int size = _registeredListeners.size();
            int i = 0;
            while (i < size) {
                newInstance.registerPersistenceNotificationListener((IPersistenceNotificationListener)_registeredListeners.elementAt(i));
                ++i;
            }
            size = _addedDatasources.size();
            int i2 = 0;
            while (i2 < size) {
                newInstance.addDataSource((IDataSource)_addedDatasources.elementAt(i2));
                ++i2;
            }
            int oldSize = _instances.length;
            IPrincipalDatabagFactory[] newList = new IPrincipalDatabagFactory[oldSize + 1];
            int i3 = 0;
            while (i3 < oldSize) {
                newList[i3] = _instances[i3];
                ++i3;
            }
            newList[oldSize] = newInstance;
            _instances = newList;
            Object var9_8 = null;
            mInitMode = false;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            mInitMode = false;
            throw throwable;
        }
    }

    public static synchronized IPrincipalDatabagFactory getInstance() throws PersistenceException {
        if (_instances == null) {
            try {
                mInitMode = true;
                PrincipalDatabagFactoryInstance newInstance = null;
                String configurationFile = UMFactory.getProperties().get("ume.persistence.data_source_configuration", null);
                if (mTrace.beInfo()) {
                    mTrace.infoT("getInstance", "ume.persistence.data_source_configuration = " + configurationFile);
                }
                if (configurationFile == null || configurationFile.equals("")) {
                    throw new PersistenceException("Parameter ume.persistence.data_source_configuration cannot be read from the properties file");
                }
                StringTokenizer strt = new StringTokenizer(configurationFile, ",", false);
                InputStream[] streams = new InputStream[strt.countTokens()];
                int counter = 0;
                while (strt.hasMoreTokens()) {
                    String currentFile = strt.nextToken().trim();
                    if (currentFile.equals("")) continue;
                    streams[counter] = UMFactory.getProperties().getInputStream(currentFile);
                    ++counter;
                }
                newInstance = new PrincipalDatabagFactoryInstance(streams);
                if (newInstance == null) {
                    throw new PersistenceException("Initialization with configuration \"" + configurationFile + "\" failed. PrincipalDatabagFactory is not initialized!");
                }
                _instances = new IPrincipalDatabagFactory[]{newInstance};
                _activeInstance = newInstance;
                String roleAdapter = UMFactory.getProperties().get("ume.persistence.ume_roles_data_source_configuration", null);
                if (roleAdapter != null) {
                    InputStream stream = UMFactory.getProperties().getInputStream(roleAdapter);
                    PrincipalDatabagFactory.addDataSource(stream);
                }
                Object var7_6 = null;
                mInitMode = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                mInitMode = false;
                throw throwable;
            }
        }
        return _activeInstance;
    }

    public static synchronized void addDataSource(IDataSource newDataSource, InputStream configuration) throws PersistenceException {
        if (configuration == null) {
            throw new PersistenceException("No configuration given. The stream is null!");
        }
        if (newDataSource == null) {
            throw new PersistenceException("No datasource class given!");
        }
        Configuration conf = new Configuration(configuration);
        Vector dsConf = conf.getDataSourceConfigurations();
        int size = dsConf.size();
        if (size < 1) {
            throw new PersistenceException("The given configuration contains no datasource configuration!");
        }
        if (size > 1) {
            throw new PersistenceException("The given configuration contains more than one datasource configuration!");
        }
        if (!(newDataSource instanceof OutOfOrderSubstituteDataSource) && !newDataSource.getClass().getName().equals(((DSConfigurationModel)dsConf.elementAt(0)).getClassName())) {
            throw new PersistenceException("The given datasource doesn't match the given datasource configuration (wrong class name)!");
        }
        newDataSource.init((DSConfigurationModel)dsConf.elementAt(0));
        PrincipalDatabagFactory.addDataSource(newDataSource);
    }

    private static synchronized void addDataSource(InputStream configuration) throws PersistenceException {
        if (configuration == null) {
            throw new PersistenceException("No configuration given. The stream is null!");
        }
        Configuration conf = new Configuration(configuration);
        Vector dsConfs = conf.getDataSourceConfigurations();
        DSConfigurationModel currentConfig = null;
        String className = null;
        Class<?> currentClass = null;
        Vector<IDataSource> persistencies = new Vector<IDataSource>();
        int size = dsConfs.size();
        int i = 0;
        while (i < size) {
            currentConfig = (DSConfigurationModel)dsConfs.elementAt(i);
            className = currentConfig.getClassName();
            try {
                if (mTrace.beInfo()) {
                    mTrace.infoT("constructor", "Trying to instantiate data source class " + className);
                }
                currentClass = Class.forName(className);
                persistencies.add((IDataSource)currentClass.newInstance());
                if (mTrace.beInfo()) {
                    mTrace.infoT("constructor", "Trying to initialize data source class " + className);
                }
                try {
                    ((IDataSource)persistencies.elementAt(i)).init(currentConfig);
                }
                catch (PersistenceException pex) {
                    if (mTrace.beError()) {
                        mTrace.errorT("constructor", "Initialization of data source class " + ((IDataSource)persistencies.elementAt(i)).getId() + " failed: " + pex.getMessage(), (Throwable)((Object)pex));
                    }
                }
            }
            catch (ClassNotFoundException cnfex) {
                throw new PersistenceException(cnfex);
            }
            catch (IllegalAccessException iaex) {
                throw new PersistenceException(iaex);
            }
            catch (InstantiationException inex) {
                throw new PersistenceException(inex);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < persistencies.size()) {
            PrincipalDatabagFactory.addDataSource((IDataSource)persistencies.elementAt(i2));
            ++i2;
        }
    }

    static {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        _registeredListeners = new Vector();
        _addedDatasources = new Vector();
    }
}

