/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.TimeStampInfo;
import com.sap.security.core.persistence.datasource.PersistenceException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PrincipalDatabag
implements IPrincipalDatabag,
IInternalPrincipalDatabag {
    protected Hashtable nameSpaces;
    protected Hashtable timeStamps;
    protected String id;
    protected String[] idParts;
    protected boolean mExistenceChecked;
    protected boolean mExists;
    protected Hashtable mDirectParents;
    protected AttributeList mModifiedByAddOperation;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/PrincipalDatabag.java#5 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private String[] mDataSourcesToCreate;
    private int mPriority;

    public PrincipalDatabag() {
        this.mExistenceChecked = false;
        this.nameSpaces = new Hashtable();
    }

    public PrincipalDatabag(String uniqueID, String[] dataSources) {
        this(uniqueID);
        this.mDataSourcesToCreate = dataSources;
    }

    protected boolean isIllegalString(String value) {
        return value.startsWith(" ") || value.endsWith(" ");
    }

    public synchronized void setDirectParents(Collection directParents, String[] principalTypes) {
        if (this.mDirectParents == null) {
            this.mDirectParents = new Hashtable();
        }
        int size = principalTypes.length;
        int i = 0;
        while (i < size) {
            HashSet dummy = (HashSet)this.mDirectParents.get(principalTypes[i]);
            if (dummy == null) {
                this.mDirectParents.put(principalTypes[i], new HashSet());
            } else {
                dummy.clear();
            }
            ++i;
        }
        Iterator it = directParents.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            ((HashSet)this.mDirectParents.get(id.substring(0, 4))).add(id);
        }
    }

    public synchronized boolean allDirectParentsAvailable(String[] principalTypes) {
        boolean result = false;
        if (this.mDirectParents != null && !this.mDirectParents.isEmpty()) {
            int size = principalTypes.length;
            int i = 0;
            while (i < size) {
                if (this.mDirectParents.get(principalTypes[i]) == null) {
                    return false;
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    public synchronized Collection getDirectParents(String principalType) {
        if (this.mDirectParents != null && !this.mDirectParents.isEmpty()) {
            return (Collection)this.mDirectParents.get(principalType);
        }
        return null;
    }

    public synchronized Collection getDirectParents(String[] principalTypes) {
        if (!this.allDirectParentsAvailable(principalTypes)) {
            return null;
        }
        int size = principalTypes.length;
        Vector result = new Vector();
        int i = 0;
        while (i < size) {
            result.addAll((Collection)this.mDirectParents.get(principalTypes[i]));
            ++i;
        }
        return result;
    }

    public boolean containsIllegalData() {
        Enumeration en1 = this.getNameSpaces();
        while (en1.hasMoreElements()) {
            String namespace = (String)en1.nextElement();
            if (this.isIllegalString(namespace)) {
                return true;
            }
            Enumeration en2 = this.getAttributesOnNamespace(namespace);
            while (en2.hasMoreElements()) {
                String attribute = (String)en2.nextElement();
                if (this.isIllegalString(attribute)) {
                    return true;
                }
                Vector values = this.getAttributeValues(namespace, attribute);
                int size = values.size();
                int i = 0;
                while (i < size) {
                    Object value = values.elementAt(i);
                    if (value instanceof String && this.isIllegalString((String)value)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected void setPrincipalDatabagIDParts(String principalID) {
        int PRINCIPAL_ID_SEPARATOR = 46;
        if (principalID == null) {
            this.idParts = null;
            return;
        }
        int firstOccurrence = principalID.indexOf(PRINCIPAL_ID_SEPARATOR);
        this.idParts = new String[3];
        boolean valid = false;
        if (firstOccurrence != -1) {
            this.idParts[0] = principalID.substring(0, firstOccurrence);
            if ((firstOccurrence = (principalID = principalID.substring(firstOccurrence + 1, principalID.length())).indexOf(PRINCIPAL_ID_SEPARATOR)) != -1) {
                this.idParts[1] = principalID.substring(0, firstOccurrence);
                this.idParts[2] = principalID.substring(firstOccurrence + 1, principalID.length());
                boolean bl = valid = this.idParts[0].length() == 4;
            }
        }
        if (!valid) {
            this.idParts = null;
        }
    }

    public PrincipalDatabag(String uniqueID) {
        this.nameSpaces = new Hashtable();
        this.id = uniqueID;
        this.setPrincipalDatabagIDParts(uniqueID);
        this.mExistenceChecked = false;
        this.mPriority = 0;
    }

    public String[] getDataSourcesToCreate() {
        return this.mDataSourcesToCreate;
    }

    public void setDataSourcesToCreate(String[] searchDataSources) {
        this.mDataSourcesToCreate = searchDataSources;
    }

    public void setPriority(int priority) {
        if (priority > -1 && priority < 10) {
            this.mPriority = priority;
        }
    }

    public synchronized void clear() {
        this.nameSpaces.clear();
    }

    public int getPriority() {
        return this.mPriority;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IPrincipalDatabag) && !(o instanceof IInternalPrincipalDatabag)) {
            return false;
        }
        IPrincipalDatabag p = (IPrincipalDatabag)o;
        if (this.id != null && p.getUniqueID() != null) {
            return p.getUniqueID().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public synchronized void setAttributeValues(String nameSpace, String attributeName, Vector values) {
        Hashtable<String, Vector> namespaceProberties = (Hashtable<String, Vector>)this.nameSpaces.get(nameSpace);
        if (namespaceProberties == null) {
            namespaceProberties = new Hashtable<String, Vector>();
        }
        if (values != null) {
            namespaceProberties.put(attributeName, values);
        } else {
            namespaceProberties.remove(attributeName);
            this.setTimeStamp(nameSpace, attributeName, null);
        }
        this.nameSpaces.put(nameSpace, namespaceProberties);
    }

    public synchronized void deleteAttributeValues(String nameSpace, String attributeName) {
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties == null) {
            namespaceProberties = new Hashtable();
            return;
        }
        namespaceProberties.remove(attributeName);
        this.nameSpaces.put(nameSpace, namespaceProberties);
    }

    public synchronized void assimilatePrincipalDatabag(IInternalPrincipalDatabag principal) {
        if (principal != null) {
            Enumeration en1 = principal.getNameSpaces();
            while (en1.hasMoreElements()) {
                String nameSpace = (String)en1.nextElement();
                Enumeration en2 = principal.getAttributesOnNamespace(nameSpace);
                while (en2.hasMoreElements()) {
                    Vector values;
                    int size;
                    String attributeName = (String)en2.nextElement();
                    TimeStampInfo ts1 = principal.getTimeStamp(nameSpace, attributeName);
                    TimeStampInfo ts2 = this.getTimeStamp(nameSpace, attributeName);
                    if (ts2 == null && ts1 != null) {
                        this.setTimeStamp(nameSpace, attributeName, ts1);
                    }
                    if (ts1 != null && ts2 != null && ts1.validUntil < ts2.validUntil) {
                        this.setTimeStamp(nameSpace, attributeName, ts1);
                    }
                    if ((size = (values = principal.getAttributeValues(nameSpace, attributeName)).size()) == 0 && this.getAttributeValues(nameSpace, attributeName) == null) {
                        this.setAttributeValues(nameSpace, attributeName, new Vector());
                        continue;
                    }
                    if (this.getAttributeValues(nameSpace, attributeName) == null || this.getAttributeValues(nameSpace, attributeName).size() == 0) {
                        this.setAttributeValues(nameSpace, attributeName, (Vector)values.clone());
                        continue;
                    }
                    int i = 0;
                    while (i < size) {
                        this.addAttributeValue(nameSpace, attributeName, values.elementAt(i));
                        ++i;
                    }
                }
            }
            boolean eChecked = principal.isExistenceChecked();
            boolean bl = this.mExistenceChecked = this.mExistenceChecked || eChecked;
            if (eChecked) {
                this.mExists = this.mExists || principal.exists();
            }
        }
    }

    public synchronized TimeStampInfo getTimeStamp(String nameSpace, String attributeName) {
        Hashtable namespaceProberties;
        if (this.timeStamps != null && (namespaceProberties = (Hashtable)this.timeStamps.get(nameSpace)) != null) {
            TimeStampInfo ts = (TimeStampInfo)namespaceProberties.get(attributeName);
            return ts;
        }
        return null;
    }

    public synchronized void setTimeStamp(String nameSpace, String attributeName, TimeStampInfo tsi) {
        Hashtable<String, TimeStampInfo> namespaceProberties;
        if (this.timeStamps == null) {
            this.timeStamps = new Hashtable();
        }
        if ((namespaceProberties = (Hashtable<String, TimeStampInfo>)this.timeStamps.get(nameSpace)) == null) {
            namespaceProberties = new Hashtable<String, TimeStampInfo>();
        }
        if (tsi == null) {
            namespaceProberties.remove(attributeName);
        } else {
            namespaceProberties.put(attributeName, tsi);
        }
        this.timeStamps.put(nameSpace, namespaceProberties);
    }

    public synchronized void mergePrincipalDatabag(IInternalPrincipalDatabag principal) {
        if (principal != null) {
            String nameSpace;
            if (principal instanceof IInternalPrincipalDatabagMaint) {
                int size;
                Vector values;
                String attributeName;
                Enumeration en1 = ((IInternalPrincipalDatabagMaint)principal).getNameSpaces(2);
                while (en1.hasMoreElements()) {
                    nameSpace = (String)en1.nextElement();
                    Enumeration en2 = ((IInternalPrincipalDatabagMaint)principal).getAttributesOnNamespace(nameSpace, 2);
                    while (en2.hasMoreElements()) {
                        attributeName = (String)en2.nextElement();
                        values = ((IInternalPrincipalDatabagMaint)principal).getAttributeValues(nameSpace, attributeName, 2);
                        if (values == null) continue;
                        this.setAttributeValues(nameSpace, attributeName, values);
                    }
                }
                Enumeration en12 = ((IInternalPrincipalDatabagMaint)principal).getNameSpaces(3);
                while (en12.hasMoreElements()) {
                    nameSpace = (String)en12.nextElement();
                    Enumeration en2 = ((IInternalPrincipalDatabagMaint)principal).getAttributesOnNamespace(nameSpace, 3);
                    while (en2.hasMoreElements()) {
                        attributeName = (String)en2.nextElement();
                        this.setAttributeValues(nameSpace, attributeName, new Vector());
                    }
                }
                Enumeration en13 = ((IInternalPrincipalDatabagMaint)principal).getNameSpaces(0);
                while (en13.hasMoreElements()) {
                    nameSpace = (String)en13.nextElement();
                    Enumeration en2 = ((IInternalPrincipalDatabagMaint)principal).getAttributesOnNamespace(nameSpace, 0);
                    while (en2.hasMoreElements()) {
                        attributeName = (String)en2.nextElement();
                        values = ((IInternalPrincipalDatabagMaint)principal).getAttributeValues(nameSpace, attributeName, 0);
                        Vector alreadySetValues = this.getAttributeValues(nameSpace, attributeName);
                        if (values == null || alreadySetValues == null) continue;
                        if (alreadySetValues.size() == 0) {
                            this.setAttributeValues(nameSpace, attributeName, (Vector)values.clone());
                            continue;
                        }
                        size = values.size();
                        int i = 0;
                        while (i < size) {
                            Object o = values.elementAt(i);
                            this.addAttributeValue(nameSpace, attributeName, o);
                            ++i;
                        }
                    }
                }
                Enumeration en14 = ((IInternalPrincipalDatabagMaint)principal).getNameSpaces(1);
                while (en14.hasMoreElements()) {
                    nameSpace = (String)en14.nextElement();
                    Enumeration en2 = ((IInternalPrincipalDatabagMaint)principal).getAttributesOnNamespace(nameSpace, 1);
                    while (en2.hasMoreElements()) {
                        attributeName = (String)en2.nextElement();
                        values = ((IInternalPrincipalDatabagMaint)principal).getAttributeValues(nameSpace, attributeName, 1);
                        Vector alreadySetValues = this.getAttributeValues(nameSpace, attributeName);
                        if (values == null || alreadySetValues == null || alreadySetValues.size() == 0) continue;
                        size = values.size();
                        int i = 0;
                        while (i < size) {
                            Object o = values.elementAt(i);
                            this.removeAttributeValue(nameSpace, attributeName, o);
                            ++i;
                        }
                    }
                }
            } else {
                Enumeration en1 = principal.getNameSpaces();
                while (en1.hasMoreElements()) {
                    nameSpace = (String)en1.nextElement();
                    Enumeration en2 = principal.getAttributesOnNamespace(nameSpace);
                    while (en2.hasMoreElements()) {
                        String attributeName = (String)en2.nextElement();
                        TimeStampInfo ts1 = principal.getTimeStamp(nameSpace, attributeName);
                        TimeStampInfo ts2 = this.getTimeStamp(nameSpace, attributeName);
                        if (ts2 == null && ts1 != null) {
                            this.setTimeStamp(nameSpace, attributeName, ts1);
                        }
                        if (ts1 != null && ts2 != null && ts1.validUntil < ts2.validUntil) {
                            this.setTimeStamp(nameSpace, attributeName, ts1);
                        }
                        Vector values = principal.getAttributeValues(nameSpace, attributeName);
                        this.setAttributeValues(nameSpace, attributeName, values);
                    }
                }
            }
            boolean eChecked = principal.isExistenceChecked();
            boolean bl = this.mExistenceChecked = this.mExistenceChecked || eChecked;
            if (eChecked) {
                this.mExists = this.mExists || principal.exists();
            }
        }
    }

    public synchronized void addAttributeValue(String nameSpace, String attributeName, Object value) {
        Object o;
        Vector<Object> addAttribute;
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties == null) {
            namespaceProberties = new Hashtable();
        }
        if ((addAttribute = (Vector<Object>)namespaceProberties.get(attributeName)) == null) {
            addAttribute = new Vector<Object>();
        } else if (!addAttribute.isEmpty() && (o = addAttribute.firstElement()) != null && !o.getClass().equals(value.getClass())) {
            throw new UMRuntimeException("Object of class " + value.getClass() + " cannot be added to set of class " + o.getClass());
        }
        if (!addAttribute.isEmpty()) {
            if (this.mModifiedByAddOperation == null) {
                this.mModifiedByAddOperation = new AttributeList();
            }
            this.mModifiedByAddOperation.addAttribute(nameSpace, attributeName);
        }
        addAttribute.add(value);
        namespaceProberties.put(attributeName, addAttribute);
        this.nameSpaces.put(nameSpace, namespaceProberties);
    }

    public synchronized void removeAttributeValue(String nameSpace, String attributeName, Object value) {
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties == null) {
            return;
        }
        Vector removeAttribute = (Vector)namespaceProberties.get(attributeName);
        if (removeAttribute != null && removeAttribute.contains(value)) {
            removeAttribute.remove(value);
            namespaceProberties.put(attributeName, removeAttribute);
            this.nameSpaces.put(nameSpace, namespaceProberties);
        }
    }

    public synchronized Vector getAttributeValues(String nameSpace, String attribute) {
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties != null) {
            Vector result = (Vector)namespaceProberties.get(attribute);
            if (result != null && this.mModifiedByAddOperation != null && this.mModifiedByAddOperation.getSize() != 0 && this.mModifiedByAddOperation.containsAttribute(nameSpace, attribute)) {
                Vector resultSet = new Vector(result.size());
                HashSet hs = new HashSet(result);
                Iterator it = hs.iterator();
                while (it.hasNext()) {
                    resultSet.add(it.next());
                }
                namespaceProberties.put(attribute, resultSet);
                this.mModifiedByAddOperation.removeAttribute(nameSpace, attribute);
                result = resultSet;
            }
            return result;
        }
        return null;
    }

    public synchronized boolean isValueInAttribute(String nameSpace, String attribute, Object value) {
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties != null) {
            Vector readValues = (Vector)namespaceProberties.get(attribute);
            if (readValues == null && value == null) {
                return true;
            }
            if (readValues == null) {
                return false;
            }
            if (value != null) {
                return readValues.contains(value);
            }
            return false;
        }
        return false;
    }

    public String getUniqueID() {
        return this.id;
    }

    public synchronized Enumeration getNameSpaces() {
        return this.nameSpaces.keys();
    }

    public void setUniqueID(String uniqueID) {
        this.id = uniqueID;
        this.setPrincipalDatabagIDParts(uniqueID);
    }

    public synchronized Enumeration getAttributesOnNamespace(String nameSpace) {
        Hashtable namespaceProberties = (Hashtable)this.nameSpaces.get(nameSpace);
        if (namespaceProberties != null) {
            return namespaceProberties.keys();
        }
        return new Hashtable().keys();
    }

    public synchronized AttributeList getPopulatedAttributes() {
        AttributeList populatedAttributes = new AttributeList(false);
        String namespace = null;
        String attribute = null;
        Vector v = null;
        Object o = null;
        Enumeration namespaces = this.getNameSpaces();
        while (namespaces.hasMoreElements()) {
            namespace = (String)namespaces.nextElement();
            Enumeration attributes = this.getAttributesOnNamespace(namespace);
            while (attributes.hasMoreElements()) {
                attribute = (String)attributes.nextElement();
                int attrType = 0;
                v = this.getAttributeValues(namespace, attribute);
                if (v != null && !v.isEmpty() && (o = v.firstElement()) != null) {
                    if (o instanceof String) {
                        attrType = 1;
                    } else if (o instanceof byte[]) {
                        attrType = 2;
                    }
                }
                populatedAttributes.addAttribute(namespace, attribute, attrType);
            }
        }
        return populatedAttributes;
    }

    public synchronized boolean containsNotEmptyAttributes() {
        boolean isNotEmpty = false;
        String nameSpace = null;
        String attribute = null;
        Hashtable dummy = null;
        Vector dummy2 = null;
        Enumeration en1 = this.nameSpaces.keys();
        while (en1.hasMoreElements()) {
            nameSpace = (String)en1.nextElement();
            dummy = (Hashtable)this.nameSpaces.get(nameSpace);
            Enumeration en2 = dummy.keys();
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                dummy2 = (Vector)dummy.get(attribute);
                if (dummy2 == null || dummy2.isEmpty()) continue;
                return true;
            }
        }
        return isNotEmpty;
    }

    public String[] getIDParts() throws PersistenceException {
        if (this.idParts != null) {
            return this.idParts;
        }
        if (this.id != null) {
            String errorMessage = "The unique ID \"" + this.id + "\" is not valid!";
            throw new PersistenceException(errorMessage);
        }
        String errorMessage = "The unique ID is null!";
        throw new PersistenceException(errorMessage);
    }

    public synchronized void setCachingTime(String nameSpace, String attributeName, int lifetimeInSeconds) {
        TimeStampInfo ts = new TimeStampInfo(lifetimeInSeconds);
        this.setTimeStamp(nameSpace, attributeName, ts);
    }

    public synchronized boolean isExpired(String nameSpace, String attributeName) {
        TimeStampInfo ts = this.getTimeStamp(nameSpace, attributeName);
        if (ts != null && ts.isExpired()) {
            this.deleteAttributeValues(nameSpace, attributeName);
            return true;
        }
        return false;
    }

    public synchronized boolean isOnlyOnceReadable(String nameSpace, String attributeName) {
        TimeStampInfo ts = this.getTimeStamp(nameSpace, attributeName);
        if (ts != null) {
            return ts.cachingTimeSeconds == 0;
        }
        return false;
    }

    public boolean isExistenceChecked() {
        return this.mExistenceChecked;
    }

    public boolean exists() {
        if (!this.mExistenceChecked) {
            throw new IllegalStateException();
        }
        return this.mExists;
    }

    public void setExists(boolean exists) {
        this.mExistenceChecked = true;
        this.mExists = exists;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        String id = this.getUniqueID();
        res.append("***************************************************************************\n");
        res.append("* ");
        res.append(this.getClass().getName());
        res.append(" ");
        res.append(new Date().toString());
        res.append("\n");
        if (id == null) {
            res.append("* No UniqueID available because the principal databag is not bound \n");
            res.append("* or not populated by the factory\n");
        } else {
            res.append("* UniqueID: ");
            res.append(id + "\n");
        }
        if (this.idParts == null) {
            res.append("* No type, home data source and private id part available \n");
        } else {
            res.append("* Type: ");
            res.append(this.idParts[0] + "\n");
            res.append("* Home data source: ");
            res.append(this.idParts[1] + "\n");
            res.append("* Private id part: ");
            res.append(this.idParts[2] + "\n");
        }
        res.append("*\n");
        boolean firstSet = false;
        Enumeration en = this.getNameSpaces();
        while (en.hasMoreElements()) {
            String nameSpace = (String)en.nextElement();
            Enumeration en2 = this.getAttributesOnNamespace(nameSpace);
            while (en2.hasMoreElements()) {
                String attribute = (String)en2.nextElement();
                Vector v = this.getAttributeValues(nameSpace, attribute);
                firstSet = false;
                res.append("* \"");
                res.append(nameSpace);
                res.append("\"|->\"");
                res.append(attribute);
                res.append("\"");
                TimeStampInfo ts = this.getTimeStamp(nameSpace, attribute);
                if (ts == null) {
                    res.append(" (no time limit)");
                } else {
                    res.append(" (");
                    res.append(ts.cachingTimeSeconds);
                    res.append("s->");
                    res.append(new Date(ts.validUntil).toString());
                    res.append(")");
                }
                res.append("=");
                if (v != null) {
                    int i = 0;
                    while (i < v.size()) {
                        Object o;
                        if (firstSet) {
                            res.append(",");
                        }
                        if (nameSpace.equals("com.sap.security.core.usermanagement") && (attribute.equals("j_password") || attribute.equals("oldpassword") || attribute.equals("MYSAPSSO2_STRING"))) {
                            if (attribute.equals("MYSAPSSO2_STRING")) {
                                String theTicketString = (String)v.elementAt(i);
                                o = theTicketString.substring(0, 50) + "... (total length: " + theTicketString.length() + " characters)";
                            } else {
                                o = "********";
                            }
                        } else {
                            o = v.elementAt(i);
                        }
                        if (o != null) {
                            if (o instanceof String) {
                                res.append("\"");
                                res.append((String)o);
                                res.append("\"");
                            } else if (o instanceof byte[]) {
                                res.append("byte[");
                                res.append(((byte[])o).length);
                                res.append("]");
                            } else {
                                res.append(o.toString());
                            }
                        } else {
                            res.append("null");
                        }
                        firstSet = true;
                        ++i;
                    }
                } else {
                    res.append("not populated yet.");
                }
                res.append("\n");
            }
        }
        res.append("***************************************************************************\n");
        return res.toString();
    }
}

