/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactoryInstance;
import com.sap.security.core.persistence.imp.SearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class FutureResult {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/FutureResult.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    protected Object value = null;
    protected boolean ready = false;
    protected InvocationTargetException exception = null;
    private PrincipalDatabagFactoryInstance mPrincipalDatabagFactory;

    public FutureResult(PrincipalDatabagFactoryInstance pdbFactory) {
        this.mPrincipalDatabagFactory = pdbFactory;
    }

    public synchronized Object get() throws InterruptedException, InvocationTargetException {
        while (!this.ready) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public Runnable searchSetter(IDataSource datasource, SearchCriteria criteria, boolean monitorPerformance, int dsNumber) {
        return new SearchRunnable(datasource, criteria, monitorPerformance, dsNumber);
    }

    public Runnable populatePrincipalSetter(IDataSource datasource, IInternalPrincipalDatabag principal, AttributeList populateAttributes, boolean monitorPerformance, int dsNumber) {
        return new PopulatePrincipalRunnable(datasource, principal, populateAttributes, monitorPerformance, dsNumber);
    }

    public Runnable populateAttributeSetter(IDataSource datasource, IInternalPrincipalDatabag principal, String namespace, String attribute, boolean monitorPerformance, int dsNumber) {
        return new PopulateAttributeRunnable(datasource, principal, namespace, attribute, monitorPerformance, dsNumber);
    }

    public Runnable checkCredentialsSetter(IDataSource datasource, Hashtable credentials, boolean monitorPerformance, int dsNumber) {
        return new CheckCredentialsRunnable(datasource, credentials, monitorPerformance, dsNumber);
    }

    private synchronized void set(Object result) {
        this.value = result;
        this.ready = true;
        this.notifyAll();
    }

    private synchronized void setException(Throwable e) {
        this.exception = new InvocationTargetException(e);
        this.ready = true;
        this.notifyAll();
    }

    public class CheckCredentialsRunnable
    implements Runnable {
        IDataSource mDatasource;
        Hashtable mCredentials;
        int mDsNumber;
        boolean mMonitorPerformance;

        public CheckCredentialsRunnable(IDataSource datasource, Hashtable credentials, boolean monitorPerformance, int dsNumber) {
            this.mDatasource = datasource;
            this.mCredentials = credentials;
            this.mMonitorPerformance = monitorPerformance;
            this.mDsNumber = dsNumber;
        }

        public void run() {
            try {
                if (this.mMonitorPerformance) {
                    long startTimeStamp = System.currentTimeMillis();
                    FutureResult.this.set(new Boolean(this.mDatasource.checkCredentials(this.mCredentials)));
                    FutureResult.this.mPrincipalDatabagFactory.addCheckCredentialsTime(System.currentTimeMillis() - startTimeStamp, this.mDsNumber);
                } else {
                    FutureResult.this.set(new Boolean(this.mDatasource.checkCredentials(this.mCredentials)));
                }
            }
            catch (Throwable e) {
                FutureResult.this.setException(e);
            }
        }
    }

    public class PopulateAttributeRunnable
    implements Runnable {
        IDataSource mDatasource;
        IInternalPrincipalDatabag mPrincipal;
        String mNamespace;
        String mAttribute;
        int mDsNumber;
        boolean mMonitorPerformance;

        public PopulateAttributeRunnable(IDataSource datasource, IInternalPrincipalDatabag principal, String namespace, String attribute, boolean monitorPerformance, int dsNumber) {
            this.mDatasource = datasource;
            this.mPrincipal = principal;
            this.mNamespace = namespace;
            this.mAttribute = attribute;
            this.mMonitorPerformance = monitorPerformance;
            this.mDsNumber = dsNumber;
        }

        public void run() {
            try {
                if (this.mMonitorPerformance) {
                    long startTimeStamp = System.currentTimeMillis();
                    FutureResult.this.set(new Boolean(this.mDatasource.populatePrincipalDatabag(this.mPrincipal, this.mNamespace, this.mAttribute)));
                    FutureResult.this.mPrincipalDatabagFactory.addPopulateAttributeTime(System.currentTimeMillis() - startTimeStamp, this.mDsNumber);
                } else {
                    FutureResult.this.set(new Boolean(this.mDatasource.populatePrincipalDatabag(this.mPrincipal, this.mNamespace, this.mAttribute)));
                }
            }
            catch (Throwable e) {
                FutureResult.this.setException(e);
            }
        }
    }

    public class PopulatePrincipalRunnable
    implements Runnable {
        IDataSource mDatasource;
        IInternalPrincipalDatabag mPrincipal;
        AttributeList mPopulateAttributes;
        int mDsNumber;
        boolean mMonitorPerformance;

        public PopulatePrincipalRunnable(IDataSource datasource, IInternalPrincipalDatabag principal, AttributeList populateAttributes, boolean monitorPerformance, int dsNumber) {
            this.mDatasource = datasource;
            this.mPrincipal = principal;
            this.mPopulateAttributes = populateAttributes;
            this.mMonitorPerformance = monitorPerformance;
            this.mDsNumber = dsNumber;
        }

        public void run() {
            try {
                if (this.mMonitorPerformance) {
                    long startTimeStamp = System.currentTimeMillis();
                    this.mDatasource.populatePrincipalDatabag(this.mPrincipal, this.mPopulateAttributes);
                    FutureResult.this.mPrincipalDatabagFactory.addPopulatePrincipalTime(System.currentTimeMillis() - startTimeStamp, this.mDsNumber);
                    FutureResult.this.set(null);
                } else {
                    this.mDatasource.populatePrincipalDatabag(this.mPrincipal, this.mPopulateAttributes);
                    FutureResult.this.set(null);
                }
            }
            catch (Throwable e) {
                FutureResult.this.setException(e);
            }
        }
    }

    public class SearchRunnable
    implements Runnable {
        IDataSource mDatasource;
        SearchCriteria mSearchCriteria;
        int mDsNumber;
        boolean mMonitorPerformance;

        public SearchRunnable(IDataSource datasource, SearchCriteria criteria, boolean monitorPerformance, int dsNumber) {
            this.mDatasource = datasource;
            this.mSearchCriteria = criteria;
            this.mMonitorPerformance = monitorPerformance;
            this.mDsNumber = dsNumber;
        }

        public void run() {
            try {
                if (this.mMonitorPerformance) {
                    long startTimeStamp = System.currentTimeMillis();
                    FutureResult.this.set(this.mDatasource.searchPrincipalDatabags(this.mSearchCriteria));
                    FutureResult.this.mPrincipalDatabagFactory.addSearchTime(System.currentTimeMillis() - startTimeStamp, this.mDsNumber);
                } else {
                    FutureResult.this.set(this.mDatasource.searchPrincipalDatabags(this.mSearchCriteria));
                }
            }
            catch (Throwable e) {
                FutureResult.this.setException(e);
            }
        }
    }
}

