/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.api.UMException;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.locking.imp.LockManager;
import com.sap.security.core.logon.imp.AnonymousUser;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactoryInstance;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import com.sap.security.core.util.imp.Util;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class DistributedTransaction
implements IDistributedTransaction {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/DistributedTransaction.java#6 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    public static final int ADD_ACTION = 0;
    public static final int UPDATE_ACTION = 1;
    public static final int DELETE_ACTION = 2;
    private boolean isCommited;
    private Vector actions;
    private String transactionID;
    private IDataSource[] mDataSources;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/DistributedTransaction.java#6 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)");
    private boolean mMonitorPerformance;
    private PrincipalDatabagFactoryInstance mPrincipalDatabagFactory;
    private Collection mDatabaseDataSources;

    public DistributedTransaction() {
    }

    public DistributedTransaction(boolean monitorPerformance, PrincipalDatabagFactoryInstance pdbFactory) {
        block4: {
            if (mTrace.bePath()) {
                mTrace.entering("constructor");
            }
            try {
                this.mDatabaseDataSources = pdbFactory.getDatabaseDataSources();
            }
            catch (PersistenceException pex) {
                if (!mTrace.beInfo()) break block4;
                mTrace.infoT("constructor", (Throwable)((Object)pex));
            }
        }
        this.mPrincipalDatabagFactory = pdbFactory;
        this.isCommited = false;
        this.actions = new Vector();
        this.mMonitorPerformance = monitorPerformance;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("******************************************************************************************************\n");
        res.append("* ");
        res.append(VERSIONSTRING);
        res.append("\n");
        res.append("* begin Transaction:");
        res.append(this.getTransactionID());
        res.append("\n");
        res.append("******************************************************************************************************\n");
        int size = this.actions.size();
        int i = 0;
        while (i < size) {
            res.append(((ActionWrapper)this.actions.elementAt(i)).toString());
            ++i;
        }
        res.append("******************************************************************************************************\n");
        res.append("* end Transaction:");
        res.append(this.getTransactionID());
        res.append("\n");
        res.append("******************************************************************************************************\n");
        return res.toString();
    }

    public synchronized String getTransactionID() {
        if (mTrace.bePath()) {
            mTrace.entering("getTransactionID");
        }
        if (this.transactionID == null) {
            this.transactionID = "TRANSACTION_" + Util.createGUID();
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getTransactionID", this.transactionID);
        }
        return this.transactionID;
    }

    public void storeDataSources(IDataSource[] dataSources) {
        if (mTrace.bePath()) {
            mTrace.entering("storeDataSources", new Object[0]);
        }
        this.mDataSources = dataSources;
        if (mTrace.bePath()) {
            mTrace.exiting("storeDataSources");
        }
    }

    public void createAddAction(PrincipalDatabag principal) {
        if (mTrace.bePath()) {
            mTrace.entering("createAddAction", new Object[]{principal});
        }
        ActionWrapper aw = new ActionWrapper(0, principal);
        this.actions.add(aw);
        this.isCommited = false;
        if (mTrace.bePath()) {
            mTrace.exiting("createAddAction");
        }
    }

    public void createUpdateAction(PrincipalDatabagMaint principal) {
        if (mTrace.bePath()) {
            mTrace.entering("createUpdateAction", new Object[]{principal});
        }
        ActionWrapper aw = new ActionWrapper(1, principal);
        this.actions.add(aw);
        this.isCommited = false;
        if (mTrace.bePath()) {
            mTrace.exiting("createUpdateAction");
        }
    }

    public void createDeleteAction(PrincipalDatabag principal) {
        if (mTrace.bePath()) {
            mTrace.entering("createDeleteAction", new Object[]{principal});
        }
        ActionWrapper aw = new ActionWrapper(2, principal);
        this.actions.add(aw);
        this.isCommited = false;
        if (mTrace.bePath()) {
            mTrace.exiting("createDeleteAction");
        }
    }

    private int getHomeDatasourceNumber(IInternalPrincipalDatabag princ) throws PersistenceException {
        int homeDatasourceNumb = -1;
        String homeDSID = princ.getIDParts()[1];
        int j = 0;
        while (j < this.mDataSources.length && homeDatasourceNumb == -1) {
            if (this.mDataSources[j].getId().equals(homeDSID)) {
                homeDatasourceNumb = j;
            }
            ++j;
        }
        if (homeDatasourceNumb == -1) {
            throw new PersistenceException("No home datasource found for principal \"" + princ.getUniqueID() + "\".");
        }
        return homeDatasourceNumb;
    }

    private DSConfigurationModel getDSConfigurationModel(int datasourceNumber) throws PersistenceException {
        DSConfigurationModel dsConf = null;
        try {
            dsConf = ((DataSourceBaseImplementation)this.mDataSources[datasourceNumber]).mConfigurationModel;
        }
        catch (ClassCastException ccex) {
            throw new PersistenceException(ccex);
        }
        if (dsConf == null) {
            String errorMessage = "DSConfigurationModel of datasource \"" + this.mDataSources[datasourceNumber].getId() + "\" is null!";
            throw new PersistenceException(errorMessage);
        }
        return dsConf;
    }

    /*
     * Unable to fully structure code
     */
    public void commit() throws PersistenceException {
        block212: {
            monitor = null;
            monitorString = "UME:DistributedTransaction:commit";
            try {
                block213: {
                    block211: {
                        if (DistributedTransaction.mTrace.bePath()) {
                            DistributedTransaction.mTrace.entering("commit");
                        }
                        if (ConfMonitor.getComponentLevel() == 2) {
                            monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:DistributedTransaction:commit");
                            monitor.startComponent(2, "UME:DistributedTransaction:commit");
                        }
                        if (this.mPrincipalDatabagFactory.getRuntimeMode() == 1) {
                            errorMessage = "Commit is not available because the persistence manager is in readonly mode!";
                            if (DistributedTransaction.mTrace.beInfo()) {
                                DistributedTransaction.mTrace.infoT("commit", errorMessage);
                            }
                            throw new PersistenceException(errorMessage);
                        }
                        i = 0;
                        size = this.actions.size();
                        if (monitor != null) {
                            monitor.compAction(2, "UME:DistributedTransaction:commit", "lock principals");
                        }
                        lockOwnerID = null;
                        returnFormerValues = SecurityAudit.logOldAttributeValues();
                        formerValues = null;
                        checkExistenceForUpdate = null;
                        try {
                            block209: {
                                block206: {
                                    principalsToLock = new Vector<String>();
                                    i = 0;
                                    while (i < size) {
                                        actionWrapper = (ActionWrapper)this.actions.elementAt(i);
                                        uniqueIdOfPrincipal = actionWrapper.getPrincipalDatabag().getUniqueID();
                                        switch (actionWrapper.getActionType()) {
                                            case 0: {
                                                break;
                                            }
                                            case 2: {
                                                if (principalsToLock.contains(uniqueIdOfPrincipal)) break;
                                                principalsToLock.add(uniqueIdOfPrincipal);
                                                break;
                                            }
                                            case 1: {
                                                if (actionWrapper.getPrincipalDatabag().isExistenceChecked()) {
                                                    if (!actionWrapper.getPrincipalDatabag().exists()) {
                                                        throw new PersistenceException("Update of principal \"" + uniqueIdOfPrincipal + "\" rejected because the principal doesn't exist anymore.");
                                                    }
                                                } else {
                                                    if (checkExistenceForUpdate == null) {
                                                        checkExistenceForUpdate = new Hashtable<String, Vector<E>>();
                                                    }
                                                    if ((principalsToCheck = (Vector<String>)checkExistenceForUpdate.get((idPartsOfPrincipal = actionWrapper.getPrincipalDatabag().getIDParts())[1])) == null) {
                                                        principalsToCheck = new Vector<String>();
                                                    }
                                                    if (!principalsToCheck.contains(uniqueIdOfPrincipal)) {
                                                        principalsToCheck.add(uniqueIdOfPrincipal);
                                                    }
                                                    checkExistenceForUpdate.put(idPartsOfPrincipal[1], principalsToCheck);
                                                }
                                                if (principalsToLock.contains(uniqueIdOfPrincipal)) break;
                                                principalsToLock.add(uniqueIdOfPrincipal);
                                            }
                                        }
                                        ++i;
                                    }
                                    if (checkExistenceForUpdate != null && !checkExistenceForUpdate.isEmpty()) {
                                        testpdb = new PrincipalDatabag();
                                        en = checkExistenceForUpdate.keys();
                                        while (en.hasMoreElements()) {
                                            dsID = (String)en.nextElement();
                                            principalsToCheck = (Vector)checkExistenceForUpdate.get(dsID);
                                            if (principalsToCheck == null || principalsToCheck.isEmpty()) continue;
                                            k = 0;
                                            while (k < this.mDataSources.length) {
                                                if (this.mDataSources[k].getId().equals(dsID)) {
                                                    principalsToCheckSize = principalsToCheck.size();
                                                    j = 0;
                                                    while (j < principalsToCheckSize) {
                                                        principalID = (String)principalsToCheck.elementAt(j);
                                                        testpdb.setUniqueID(principalID);
                                                        if (!this.mDataSources[k].principalDatabagExists(testpdb)) {
                                                            throw new PersistenceException("Update of principal \"" + principalID + "\" rejected because the principal doesn't exist anymore.");
                                                        }
                                                        ++j;
                                                    }
                                                }
                                                ++k;
                                            }
                                        }
                                    }
                                    if (returnFormerValues) {
                                        formerValues = new IPrincipalDatabag[size];
                                        pdbFactory = this.mPrincipalDatabagFactory;
                                        i = 0;
                                        while (i < size) {
                                            block205: {
                                                try {
                                                    actionWrapper = (ActionWrapper)this.actions.elementAt(i);
                                                    uniqueIdOfPrincipal = actionWrapper.getPrincipalDatabag().getUniqueID();
                                                    switch (actionWrapper.getActionType()) {
                                                        case 0: {
                                                            formerValues[i] = null;
                                                            break;
                                                        }
                                                        case 2: {
                                                            attrList = pdbFactory.getAllAttributes(actionWrapper.getPrincipalDatabag());
                                                            formerValues[i] = pdbFactory.getPrincipalDatabag(uniqueIdOfPrincipal, attrList, true);
                                                            break;
                                                        }
                                                        case 1: {
                                                            attrList = ((IInternalPrincipalDatabagMaint)actionWrapper.getPrincipalDatabag()).getModifiedAttributes();
                                                            attrList.addAttribute("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", 1);
                                                            formerValues[i] = pdbFactory.getPrincipalDatabag(uniqueIdOfPrincipal, attrList, true);
                                                        }
                                                    }
                                                }
                                                catch (PersistenceException pex) {
                                                    formerValues[i] = null;
                                                    if (!DistributedTransaction.mTrace.beWarning()) break block205;
                                                    DistributedTransaction.mTrace.warningT("commit", "Error while reading former principal values for security audit.", (Throwable)pex);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    if (!principalsToLock.isEmpty()) {
                                        if (monitor != null) {
                                            monitor.compAction(2, "UME:DistributedTransaction:commit", "trying to getWriteLocks");
                                        }
                                        lockOwnerID = LockManager.getInstance().getWriteLocks("$library.com.sap.security.core", principalsToLock.toArray(new String[principalsToLock.size()]));
                                        if (monitor != null) {
                                            monitor.compAction(2, "UME:DistributedTransaction:commit", "getWriteLocks");
                                        }
                                    }
                                    if (monitor != null) {
                                        monitor.compAction(2, "UME:DistributedTransaction:commit", "beginTransaction");
                                    }
                                    mDataSourceTransactions = new IDataSourceTransaction[this.mDataSources.length];
                                    j = 0;
                                    while (j < mDataSourceTransactions.length) {
                                        mDataSourceTransactions[j] = this.mDataSources[j].beginTransaction();
                                        ++j;
                                    }
                                    try {
                                        i = 0;
                                        while (i < size) {
                                            actionWrapper = (ActionWrapper)this.actions.elementAt(i);
                                            switch (actionWrapper.getActionType()) {
                                                case 0: {
                                                    bound = false;
                                                    princ = (IInternalPrincipalDatabag)actionWrapper.getPrincipalDatabag();
                                                    homeDatasourceNumber = -1;
                                                    prio = 0;
                                                    while (prio < 10 && !bound) {
                                                        princ.setPriority(prio);
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length && !bound) {
                                                            if (this.mDataSources[j].isPrimary() && !this.mDataSources[j].isReadonly()) {
                                                                v0 = bound = bound != false || mDataSourceTransactions[j].bindNewPrincipalDatabag(princ) != false;
                                                                if (bound) {
                                                                    homeDatasourceNumber = j;
                                                                }
                                                            }
                                                            ++j;
                                                        }
                                                        ++prio;
                                                    }
                                                    if (!bound) {
                                                        errorMessage = "No data source feels responsible for principal!";
                                                        throw new PersistenceException(errorMessage);
                                                    }
                                                    uID = princ.getUniqueID();
                                                    if (uID == null) ** GOTO lbl156
                                                    try {
                                                        if (this.mDataSources[homeDatasourceNumber].principalDatabagExists(princ)) {
                                                            throw new DuplicateKeyException("Principal \"" + uID + "\" already exists.");
                                                        }
                                                        if (AnonymousUser.isInitialized()) {
                                                            PrincipalDatabagFactory.getInstance().cleanupPrincipalDatabag(uID, this.mDatabaseDataSources);
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        if (!DistributedTransaction.mTrace.beDebug()) ** GOTO lbl156
                                                        DistributedTransaction.mTrace.debugT("commit", "Error during cleanup of uniqueID \"" + uID + "\"");
                                                    }
lbl156:
                                                    // 4 sources

                                                    dates = new Vector<String>();
                                                    dates.add(Util.getTimeStamp());
                                                    princ.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", dates);
                                                    dsConf = this.getDSConfigurationModel(homeDatasourceNumber);
                                                    type = princ.getIDParts()[0];
                                                    notHomePrincipal = new PrincipalDatabag[mDataSourceTransactions.length];
                                                    en1 = princ.getNameSpaces();
                                                    while (en1.hasMoreElements()) {
                                                        nameSpace = (String)en1.nextElement();
                                                        en2 = princ.getAttributesOnNamespace(nameSpace);
                                                        while (en2.hasMoreElements()) {
                                                            attributeName = (String)en2.nextElement();
                                                            if (!((attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) && nameSpace.equals("com.sap.security.core.usermanagement") || this.mPrincipalDatabagFactory.isPrincipalDatabagAttributeModifiable(princ, nameSpace, attributeName))) {
                                                                throw new PersistenceException("Attribute \"" + attributeName + "\" on namespace \"" + nameSpace + "\" of principal \"" + princ.getUniqueID() + "\" is not modifiable.");
                                                            }
                                                            if (dsConf.feelsResponsible(type, nameSpace, attributeName)) continue;
                                                            found = false;
                                                            l = 0;
                                                            while (l < mDataSourceTransactions.length && !found) {
                                                                if (l != homeDatasourceNumber && !this.mDataSources[l].isReadonly() && (dummy = this.getDSConfigurationModel(l)).feelsResponsible(type, nameSpace, attributeName)) {
                                                                    found = true;
                                                                    values = princ.getAttributeValues(nameSpace, attributeName);
                                                                    size2 = values.size();
                                                                    k = 0;
                                                                    while (k < size2) {
                                                                        if (notHomePrincipal[l] == null) {
                                                                            notHomePrincipal[l] = new PrincipalDatabag(princ.getUniqueID());
                                                                        }
                                                                        notHomePrincipal[l].addAttributeValue(nameSpace, attributeName, values.elementAt(k));
                                                                        ++k;
                                                                    }
                                                                }
                                                                ++l;
                                                            }
                                                        }
                                                    }
                                                    if (this.mMonitorPerformance || monitor != null) {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (j == homeDatasourceNumber) {
                                                                startTimeStamp = System.currentTimeMillis();
                                                                mDataSourceTransactions[j].createPrincipalDatabag(princ);
                                                                endTimeStamp = System.currentTimeMillis();
                                                                this.mPrincipalDatabagFactory.addCreateTime(endTimeStamp - startTimeStamp, j);
                                                                if (monitor != null) {
                                                                    buf = new StringBuffer("HomeDataSource").append(j).append(" creationTime: ").append(endTimeStamp - startTimeStamp);
                                                                    monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                                                }
                                                            } else if (notHomePrincipal[j] != null) {
                                                                startTimeStamp = System.currentTimeMillis();
                                                                mDataSourceTransactions[j].createPrincipalDatabag(notHomePrincipal[j]);
                                                                endTimeStamp = System.currentTimeMillis();
                                                                this.mPrincipalDatabagFactory.addCreateTime(endTimeStamp - startTimeStamp, j);
                                                                if (monitor != null) {
                                                                    buf = new StringBuffer("DataSource").append(j).append(" creationTime: ").append(endTimeStamp - startTimeStamp);
                                                                    monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                                                }
                                                            }
                                                            ++j;
                                                        }
                                                    } else {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (j == homeDatasourceNumber) {
                                                                mDataSourceTransactions[j].createPrincipalDatabag(princ);
                                                            } else if (notHomePrincipal[j] != null) {
                                                                mDataSourceTransactions[j].createPrincipalDatabag(notHomePrincipal[j]);
                                                            }
                                                            ++j;
                                                        }
                                                    }
                                                    break;
                                                }
                                                case 2: {
                                                    pid = actionWrapper.getPrincipalDatabag().getUniqueID();
                                                    if (!this.mPrincipalDatabagFactory.isPrincipalDatabagDeletable(pid)) {
                                                        throw new PersistenceException("Principal \"" + actionWrapper.getPrincipalDatabag().getUniqueID() + "\" is not deletable.");
                                                    }
                                                    if (pid != null) {
                                                        try {
                                                            if (pid.startsWith("USER")) {
                                                                if (AnonymousUser.getInstance().isAnonymousUserUniqueId(pid)) {
                                                                    throw new PersistenceException("Guest user \"" + pid + "\" cannot be deleted.");
                                                                }
                                                            } else if (pid.startsWith("UACC") && AnonymousUser.getInstance().isAnonymousUserAccountUniqueId(pid)) {
                                                                throw new PersistenceException("Guest user account \"" + pid + "\" cannot be deleted.");
                                                            }
                                                        }
                                                        catch (UMException umex) {
                                                            throw new PersistenceException(umex);
                                                        }
                                                    }
                                                    homeDatasourceNumb = this.getHomeDatasourceNumber((IInternalPrincipalDatabag)actionWrapper.getPrincipalDatabag());
                                                    if (this.mMonitorPerformance || monitor != null) {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (!this.mDataSources[j].isReadonly() || j == homeDatasourceNumb) {
                                                                startTimeStamp = System.currentTimeMillis();
                                                                mDataSourceTransactions[j].deletePrincipalDatabag(actionWrapper.getPrincipalDatabag());
                                                                endTimeStamp = System.currentTimeMillis();
                                                                this.mPrincipalDatabagFactory.addDeleteTime(endTimeStamp - startTimeStamp, j);
                                                                if (monitor != null) {
                                                                    buf = new StringBuffer("DataSource").append(j).append(" deleteTime: ").append(endTimeStamp - startTimeStamp);
                                                                    monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                                                }
                                                            }
                                                            ++j;
                                                        }
                                                    } else {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (!this.mDataSources[j].isReadonly() || j == homeDatasourceNumb) {
                                                                mDataSourceTransactions[j].deletePrincipalDatabag(actionWrapper.getPrincipalDatabag());
                                                            }
                                                            ++j;
                                                        }
                                                    }
                                                    if (!pid.startsWith("ROOT")) break;
                                                    PrincipalFactory.invalidateMetaDataCache();
                                                    break;
                                                }
                                                case 1: {
                                                    princMaint = (IInternalPrincipalDatabagMaint)actionWrapper.getPrincipalDatabag();
                                                    uniqueID = princMaint.getUniqueID();
                                                    if (uniqueID == null) {
                                                        throw new PersistenceException("Cannot modify principal if unique id is null.");
                                                    }
                                                    date = new Vector<String>();
                                                    date.add(Util.getTimeStamp());
                                                    princMaint.setAttributeMaintValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", date);
                                                    homeDatasourceNum = this.getHomeDatasourceNumber(princMaint);
                                                    dsConf2 = this.getDSConfigurationModel(homeDatasourceNum);
                                                    type2 = princMaint.getIDParts()[0];
                                                    p = new PrincipalDatabagMaint[mDataSourceTransactions.length];
                                                    addValues = null;
                                                    removeValues = null;
                                                    somethingForNotHomeDSFound = false;
                                                    somethingForHomeDSFound = false;
                                                    en = princMaint.getNameSpaces(2);
                                                    while (en.hasMoreElements()) {
                                                        nameSp = (String)en.nextElement();
                                                        innerEn = princMaint.getAttributesOnNamespace(nameSp, 2);
                                                        while (innerEn.hasMoreElements()) {
                                                            attributeN = (String)innerEn.nextElement();
                                                            if (!((attributeN.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeN.equals("oldpassword")) && nameSp.equals("com.sap.security.core.usermanagement") || this.mPrincipalDatabagFactory.isPrincipalDatabagAttributeModifiable(princMaint, nameSp, attributeN))) {
                                                                throw new PersistenceException("Attribute \"" + attributeN + "\" on namespace \"" + nameSp + "\" of principal \"" + uniqueID + "\" is not modifiable.");
                                                            }
                                                            if (!dsConf2.feelsResponsible(type2, nameSp, attributeN)) {
                                                                somethingForNotHomeDSFound = true;
                                                                found = false;
                                                                l = 0;
                                                                while (l < mDataSourceTransactions.length && !found) {
                                                                    if (l != homeDatasourceNum && !this.mDataSources[l].isReadonly() && (dummy = this.getDSConfigurationModel(l)).feelsResponsible(type2, nameSp, attributeN)) {
                                                                        found = true;
                                                                        if (p[l] == null) {
                                                                            p[l] = new PrincipalDatabagMaint(uniqueID);
                                                                        }
                                                                        p[l].setAttributeMaintValues(nameSp, attributeN, princMaint.getAttributeValues(nameSp, attributeN, 2));
                                                                    }
                                                                    ++l;
                                                                }
                                                                continue;
                                                            }
                                                            somethingForHomeDSFound = true;
                                                        }
                                                    }
                                                    en = princMaint.getNameSpaces(3);
                                                    while (en.hasMoreElements()) {
                                                        nameSp = (String)en.nextElement();
                                                        innerEn = princMaint.getAttributesOnNamespace(nameSp, 3);
                                                        while (innerEn.hasMoreElements()) {
                                                            attributeN = (String)innerEn.nextElement();
                                                            if (!((attributeN.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeN.equals("oldpassword")) && nameSp.equals("com.sap.security.core.usermanagement") || this.mPrincipalDatabagFactory.isPrincipalDatabagAttributeModifiable(princMaint, nameSp, attributeN))) {
                                                                throw new PersistenceException("Attribute \"" + attributeN + "\" on namespace \"" + nameSp + "\" of principal \"" + uniqueID + "\" is not modifiable.");
                                                            }
                                                            if (!dsConf2.feelsResponsible(type2, nameSp, attributeN)) {
                                                                somethingForNotHomeDSFound = true;
                                                                found = false;
                                                                l = 0;
                                                                while (l < mDataSourceTransactions.length && !found) {
                                                                    if (l != homeDatasourceNum && !this.mDataSources[l].isReadonly() && (dummy = this.getDSConfigurationModel(l)).feelsResponsible(type2, nameSp, attributeN)) {
                                                                        found = true;
                                                                        if (p[l] == null) {
                                                                            p[l] = new PrincipalDatabagMaint(uniqueID);
                                                                        }
                                                                        p[l].deleteAttributeMaintValues(nameSp, attributeN);
                                                                    }
                                                                    ++l;
                                                                }
                                                                continue;
                                                            }
                                                            somethingForHomeDSFound = true;
                                                        }
                                                    }
                                                    en = princMaint.getNameSpaces(0);
                                                    while (en.hasMoreElements()) {
                                                        nameSp = (String)en.nextElement();
                                                        innerEn = princMaint.getAttributesOnNamespace(nameSp, 0);
                                                        while (innerEn.hasMoreElements()) {
                                                            attributeN = (String)innerEn.nextElement();
                                                            if (!((attributeN.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeN.equals("oldpassword")) && nameSp.equals("com.sap.security.core.usermanagement") || this.mPrincipalDatabagFactory.isPrincipalDatabagAttributeModifiable(princMaint, nameSp, attributeN))) {
                                                                throw new PersistenceException("Attribute \"" + attributeN + "\" on namespace \"" + nameSp + "\" of principal \"" + uniqueID + "\" is not modifiable.");
                                                            }
                                                            if (!dsConf2.feelsResponsible(type2, nameSp, attributeN)) {
                                                                found = false;
                                                                l = 0;
                                                                while (l < mDataSourceTransactions.length && !found) {
                                                                    if (l != homeDatasourceNum && !this.mDataSources[l].isReadonly() && (dummy = this.getDSConfigurationModel(l)).feelsResponsible(type2, nameSp, attributeN)) {
                                                                        found = true;
                                                                        addValues = princMaint.getAttributeValues(nameSp, attributeN, 0);
                                                                        if (addValues != null) {
                                                                            k = 0;
                                                                            while (k < addValues.size()) {
                                                                                if (p[l] == null) {
                                                                                    p[l] = new PrincipalDatabagMaint(uniqueID);
                                                                                }
                                                                                somethingForNotHomeDSFound = true;
                                                                                p[l].addAttributeMaintValue(nameSp, attributeN, addValues.elementAt(k));
                                                                                ++k;
                                                                            }
                                                                        }
                                                                    }
                                                                    ++l;
                                                                }
                                                                continue;
                                                            }
                                                            somethingForHomeDSFound = true;
                                                        }
                                                    }
                                                    en = princMaint.getNameSpaces(1);
                                                    while (en.hasMoreElements()) {
                                                        nameSp = (String)en.nextElement();
                                                        innerEn = princMaint.getAttributesOnNamespace(nameSp, 1);
                                                        while (innerEn.hasMoreElements()) {
                                                            attributeN = (String)innerEn.nextElement();
                                                            if (!((attributeN.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeN.equals("oldpassword")) && nameSp.equals("com.sap.security.core.usermanagement") || this.mPrincipalDatabagFactory.isPrincipalDatabagAttributeModifiable(princMaint, nameSp, attributeN))) {
                                                                throw new PersistenceException("Attribute \"" + attributeN + "\" on namespace \"" + nameSp + "\" of principal \"" + uniqueID + "\" is not modifiable.");
                                                            }
                                                            if (!dsConf2.feelsResponsible(type2, nameSp, attributeN)) {
                                                                removeValues = princMaint.getAttributeValues(nameSp, attributeN, 1);
                                                                if (removeValues == null) continue;
                                                                found = false;
                                                                l = 0;
                                                                while (l < mDataSourceTransactions.length && !found) {
                                                                    if (l != homeDatasourceNum && !this.mDataSources[l].isReadonly() && (dummy = this.getDSConfigurationModel(l)).feelsResponsible(type2, nameSp, attributeN)) {
                                                                        found = true;
                                                                        k = 0;
                                                                        while (k < removeValues.size()) {
                                                                            if (p[l] == null) {
                                                                                p[l] = new PrincipalDatabagMaint(uniqueID);
                                                                            }
                                                                            somethingForNotHomeDSFound = true;
                                                                            p[l].removeAttributeMaintValue(nameSp, attributeN, removeValues.elementAt(k));
                                                                            ++k;
                                                                        }
                                                                    }
                                                                    ++l;
                                                                }
                                                                continue;
                                                            }
                                                            somethingForHomeDSFound = true;
                                                        }
                                                    }
                                                    if (this.mMonitorPerformance || monitor != null) {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (j == homeDatasourceNum) {
                                                                if (somethingForHomeDSFound) {
                                                                    startTimeStamp = System.currentTimeMillis();
                                                                    mDataSourceTransactions[j].updatePrincipalDatabag(princMaint);
                                                                    endTimeStamp = System.currentTimeMillis();
                                                                    this.mPrincipalDatabagFactory.addUpdateTime(endTimeStamp - startTimeStamp, j);
                                                                    if (monitor != null) {
                                                                        buf = new StringBuffer("HomeDataSource").append(j).append(" updateTime: ").append(endTimeStamp - startTimeStamp);
                                                                        monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                                                    }
                                                                }
                                                            } else if (somethingForNotHomeDSFound && p[j] != null && !this.mDataSources[j].isReadonly()) {
                                                                startTimeStamp = System.currentTimeMillis();
                                                                mDataSourceTransactions[j].updatePrincipalDatabag(p[j]);
                                                                endTimeStamp = System.currentTimeMillis();
                                                                this.mPrincipalDatabagFactory.addUpdateTime(endTimeStamp - startTimeStamp, j);
                                                                if (monitor != null) {
                                                                    buf = new StringBuffer("DataSource").append(j).append(" updateTime: ").append(endTimeStamp - startTimeStamp);
                                                                    monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                                                }
                                                            }
                                                            ++j;
                                                        }
                                                    } else {
                                                        j = 0;
                                                        while (j < mDataSourceTransactions.length) {
                                                            if (j == homeDatasourceNum) {
                                                                if (somethingForHomeDSFound) {
                                                                    mDataSourceTransactions[j].updatePrincipalDatabag(princMaint);
                                                                }
                                                            } else if (somethingForNotHomeDSFound && p[j] != null && !this.mDataSources[j].isReadonly()) {
                                                                mDataSourceTransactions[j].updatePrincipalDatabag(p[j]);
                                                            }
                                                            ++j;
                                                        }
                                                    }
                                                    break;
                                                }
                                                default: {
                                                    errorMessage = "Unsupported action in Distributed Transaction!";
                                                    throw new PersistenceException(errorMessage);
                                                }
                                            }
                                            ++i;
                                        }
                                        break block206;
                                    }
                                    catch (PersistenceException pex) {
                                        j = 0;
                                        ** while (j < mDataSourceTransactions.length)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        block207: {
                                            try {
                                                mDataSourceTransactions[j].rollback();
                                            }
                                            catch (PersistenceException pex2) {
                                                if (!DistributedTransaction.mTrace.beWarning()) break block207;
                                                DistributedTransaction.mTrace.warningT("commit", "Rollback because of exception during commit failed.", (Throwable)pex2);
                                            }
                                        }
                                        ++j;
                                        continue;
                                    }
lbl440:
                                    // 1 sources

                                    throw pex;
                                }
                                committed = new boolean[mDataSourceTransactions.length];
                                try {
                                    if (this.mMonitorPerformance || monitor != null) {
                                        j = 0;
                                        while (j < mDataSourceTransactions.length) {
                                            committed[j] = false;
                                            startTimeStamp = System.currentTimeMillis();
                                            mDataSourceTransactions[j].commit();
                                            endTimeStamp = System.currentTimeMillis();
                                            committed[j] = true;
                                            this.mPrincipalDatabagFactory.addCommitTime(endTimeStamp - startTimeStamp, j);
                                            if (monitor != null) {
                                                buf = new StringBuffer("DataSource").append(j).append(" commitTime: ").append(endTimeStamp - startTimeStamp);
                                                monitor.compAction(2, "UME:DistributedTransaction:commit", buf.toString());
                                            }
                                            ++j;
                                        }
                                    } else {
                                        j = 0;
                                        while (j < mDataSourceTransactions.length) {
                                            committed[j] = false;
                                            mDataSourceTransactions[j].commit();
                                            committed[j] = true;
                                            ++j;
                                        }
                                    }
                                    var57_102 = null;
                                    j = 0;
                                    ** while (j < mDataSourceTransactions.length)
                                }
                                catch (Throwable var56_108) {
                                    var57_103 = null;
                                    j = 0;
                                    ** while (j < mDataSourceTransactions.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    block208: {
                                        if (!committed[j]) {
                                            try {
                                                mDataSourceTransactions[j].rollback();
                                            }
                                            catch (PersistenceException pex) {
                                                if (!DistributedTransaction.mTrace.beWarning()) break block208;
                                                DistributedTransaction.mTrace.warningT("commit", "Cannot rollback after commit because of exception.", (Throwable)pex);
                                            }
                                        }
                                    }
                                    ++j;
                                    continue;
lbl479:
                                    // 1 sources

                                    break block209;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    block210: {
                                        if (!committed[j]) {
                                            try {
                                                mDataSourceTransactions[j].rollback();
                                            }
                                            catch (PersistenceException pex) {
                                                if (!DistributedTransaction.mTrace.beWarning()) break block210;
                                                DistributedTransaction.mTrace.warningT("commit", "Cannot rollback after commit because of exception.", (Throwable)pex);
                                            }
                                        }
                                    }
                                    ++j;
                                    continue;
                                }
lbl495:
                                // 1 sources

                                throw var56_108;
                            }
                            this.isCommited = true;
                            var61_109 = null;
                            if (monitor == null) break block211;
                        }
                        catch (Throwable var60_111) {
                            var61_110 = null;
                            if (monitor != null) {
                                monitor.compAction(2, "UME:DistributedTransaction:commit", "trying to releaseLocks");
                            }
                            LockManager.getInstance().releaseLocks(lockOwnerID);
                            if (monitor != null) {
                                monitor.compAction(2, "UME:DistributedTransaction:commit", "releaseLocks");
                            }
                            throw var60_111;
                        }
                        monitor.compAction(2, "UME:DistributedTransaction:commit", "trying to releaseLocks");
                    }
                    LockManager.getInstance().releaseLocks(lockOwnerID);
                    if (monitor != null) {
                        monitor.compAction(2, "UME:DistributedTransaction:commit", "releaseLocks");
                    }
                    break block213;
                    {
                        catch (Exception e) {
                            if (e instanceof PersistenceException) {
                                throw (PersistenceException)e;
                            }
                            throw new PersistenceException(e);
                        }
                    }
                }
                if (monitor != null) {
                    monitor.compAction(2, "UME:DistributedTransaction:commit", "inform SecurityAudit");
                }
                logDetails = null;
                logAction = null;
                i = 0;
                while (i < size) {
                    actionWrapper = (ActionWrapper)this.actions.elementAt(i);
                    dummyDatabag = actionWrapper.getPrincipalDatabag();
                    actionType = actionWrapper.getActionType();
                    if (actionType == 1) {
                        if (SecurityAudit.isLogged("PRINCIPAL.MODIFY", dummyDatabag.getUniqueID())) {
                            logDetails = new HashMap<String[], Vector[]>();
                            dataType = 0;
                            logAction = "ADD_VALUES";
                            allDataTypesProcessed = false;
                            while (!allDataTypesProcessed) {
                                en1 = ((IInternalPrincipalDatabagMaint)dummyDatabag).getNameSpaces(dataType);
                                while (en1.hasMoreElements()) {
                                    namespaceName = (String)en1.nextElement();
                                    en2 = ((IInternalPrincipalDatabagMaint)dummyDatabag).getAttributesOnNamespace(namespaceName, dataType);
                                    while (en2.hasMoreElements()) {
                                        attributeName = (String)en2.nextElement();
                                        values = dataType != 3 ? ((IInternalPrincipalDatabagMaint)dummyDatabag).getAttributeValues(namespaceName, attributeName, dataType) : null;
                                        if (values == null) {
                                            values = new Vector<String>();
                                        }
                                        if (returnFormerValues && formerValues[i] != null) {
                                            oldValues = ((IInternalPrincipalDatabag)formerValues[i]).getAttributeValues(namespaceName, attributeName);
                                            if (oldValues == null) {
                                                if (DistributedTransaction.mTrace.beWarning()) {
                                                    DistributedTransaction.mTrace.warningT("commit", "Old values for security audit were not readable (principal=\"" + formerValues[i].getUniqueID() + "\", namespace=\"" + namespaceName + "\", attribute=\"" + attributeName + "\").");
                                                }
                                                oldValues = new Vector<String>();
                                            }
                                            if (namespaceName.equals("com.sap.security.core.usermanagement") && (attributeName.equals("j_password") || attributeName.equals("oldpassword"))) {
                                                l = values.size();
                                                values = new Vector<E>();
                                                k = 0;
                                                while (k < l) {
                                                    values.add("********");
                                                    ++k;
                                                }
                                                l = oldValues.size();
                                                oldValues = new Vector<E>();
                                                k = 0;
                                                while (k < l) {
                                                    oldValues.add("********");
                                                    ++k;
                                                }
                                            }
                                            logDetails.put(new String[]{logAction, namespaceName, attributeName}, new Vector[]{oldValues, values});
                                            continue;
                                        }
                                        if (namespaceName.equals("com.sap.security.core.usermanagement") && (attributeName.equals("j_password") || attributeName.equals("oldpassword"))) {
                                            l = values.size();
                                            values = new Vector<E>();
                                            k = 0;
                                            while (k < l) {
                                                values.add("********");
                                                ++k;
                                            }
                                        }
                                        logDetails.put(new String[]{logAction, namespaceName, attributeName}, new Vector[]{null, values});
                                    }
                                }
                                if (dataType == 0) {
                                    dataType = 1;
                                    logAction = "REMOVE_VALUES";
                                    continue;
                                }
                                if (dataType == 1) {
                                    dataType = 2;
                                    logAction = "SET_ATTRIBUTE";
                                    continue;
                                }
                                if (dataType == 2) {
                                    dataType = 3;
                                    logAction = "DELETE_ATTRIBUTE";
                                    continue;
                                }
                                if (dataType != 3) continue;
                                allDataTypesProcessed = true;
                                logAction = "NOT_AVAILABLE";
                            }
                        }
                    } else if (actionType == 2) {
                        if (SecurityAudit.isLogged("PRINCIPAL.DELETE", dummyDatabag.getUniqueID())) {
                            logDetails = new HashMap<K, V>();
                            if (returnFormerValues && formerValues[i] != null) {
                                en1 = ((IInternalPrincipalDatabag)formerValues[i]).getNameSpaces();
                                while (en1.hasMoreElements()) {
                                    namespaceName = (String)en1.nextElement();
                                    en2 = ((IInternalPrincipalDatabag)formerValues[i]).getAttributesOnNamespace(namespaceName);
                                    while (en2.hasMoreElements()) {
                                        attributeName = (String)en2.nextElement();
                                        oldValues = ((IInternalPrincipalDatabag)formerValues[i]).getAttributeValues(namespaceName, attributeName);
                                        if (oldValues == null) {
                                            if (DistributedTransaction.mTrace.beWarning()) {
                                                DistributedTransaction.mTrace.warningT("commit", "Old values for security audit were not readable (principal=\"" + formerValues[i].getUniqueID() + "\", namespace=\"" + namespaceName + "\", attribute=\"" + attributeName + "\").");
                                            }
                                            oldValues = new Vector<String>();
                                        }
                                        if (namespaceName.equals("com.sap.security.core.usermanagement") && (attributeName.equals("j_password") || attributeName.equals("oldpassword"))) {
                                            l = oldValues.size();
                                            oldValues = new Vector<E>();
                                            k = 0;
                                            while (k < l) {
                                                oldValues.add("********");
                                                ++k;
                                            }
                                        }
                                        logDetails.put(new String[]{"DELETE_ATTRIBUTE", namespaceName, attributeName}, new Vector[]{oldValues, null});
                                    }
                                }
                            }
                        }
                    } else if (actionType == 0 && SecurityAudit.isLogged("PRINCIPAL.CREATE", dummyDatabag.getUniqueID())) {
                        logDetails = new HashMap<K, V>();
                        en1 = ((IInternalPrincipalDatabag)dummyDatabag).getNameSpaces();
                        while (en1.hasMoreElements()) {
                            namespaceName = (String)en1.nextElement();
                            en2 = ((IInternalPrincipalDatabag)dummyDatabag).getAttributesOnNamespace(namespaceName);
                            while (en2.hasMoreElements()) {
                                attributeName = (String)en2.nextElement();
                                values = ((IInternalPrincipalDatabag)dummyDatabag).getAttributeValues(namespaceName, attributeName);
                                if (values == null) {
                                    values = new Vector<String>();
                                }
                                if (namespaceName.equals("com.sap.security.core.usermanagement") && (attributeName.equals("j_password") || attributeName.equals("oldpassword"))) {
                                    l = values.size();
                                    values = new Vector<E>();
                                    k = 0;
                                    while (k < l) {
                                        values.add("********");
                                        ++k;
                                    }
                                }
                                logDetails.put(new String[]{"SET_ATTRIBUTE", namespaceName, attributeName}, new Vector[]{null, values});
                            }
                        }
                    }
                    switch (actionType) {
                        case 0: {
                            if (!SecurityAudit.isLogged("PRINCIPAL.CREATE", dummyDatabag.getUniqueID())) break;
                            SecurityAudit.log("PRINCIPAL.CREATE", dummyDatabag.getUniqueID(), logDetails);
                            break;
                        }
                        case 1: {
                            if (!SecurityAudit.isLogged("PRINCIPAL.MODIFY", dummyDatabag.getUniqueID())) break;
                            SecurityAudit.log("PRINCIPAL.MODIFY", dummyDatabag.getUniqueID(), logDetails);
                            break;
                        }
                        case 2: {
                            if (!SecurityAudit.isLogged("PRINCIPAL.DELETE", dummyDatabag.getUniqueID())) break;
                            SecurityAudit.log("PRINCIPAL.DELETE", dummyDatabag.getUniqueID(), logDetails);
                        }
                    }
                    ++i;
                }
                this.actions = new Vector<E>();
                var63_112 = null;
                if (monitor == null) break block212;
            }
            catch (Throwable var62_114) {
                var63_113 = null;
                if (monitor != null) {
                    monitor.endComponent("UME:DistributedTransaction:commit");
                    monitor.endRequest("UME:DistributedTransaction:commit");
                }
                if (DistributedTransaction.mTrace.bePath()) {
                    DistributedTransaction.mTrace.exiting("commit");
                }
                throw var62_114;
            }
            monitor.endComponent("UME:DistributedTransaction:commit");
            monitor.endRequest("UME:DistributedTransaction:commit");
        }
        if (DistributedTransaction.mTrace.bePath()) {
            DistributedTransaction.mTrace.exiting("commit");
        }
    }

    public boolean isCommited() {
        if (mTrace.bePath()) {
            mTrace.entering("isCommited");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("isCommited", new Boolean(this.isCommited));
        }
        return this.isCommited;
    }

    public class ActionWrapper
    implements Serializable {
        private int mActionType;
        private IPrincipalDatabag mPrincipalDatabag;

        public ActionWrapper() {
        }

        public ActionWrapper(int actionType, IPrincipalDatabag principal) {
            this.mActionType = actionType;
            this.mPrincipalDatabag = principal;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ActionWrapper)) {
                return false;
            }
            ActionWrapper aw = (ActionWrapper)o;
            return aw.getActionType() == this.mActionType && aw.getPrincipalDatabag().equals(this.mPrincipalDatabag);
        }

        public IPrincipalDatabag getPrincipalDatabag() {
            return this.mPrincipalDatabag;
        }

        public int getActionType() {
            return this.mActionType;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            switch (this.mActionType) {
                case 0: {
                    res.append("ADD:\n");
                    break;
                }
                case 2: {
                    res.append("DELETE:\n");
                    break;
                }
                case 1: {
                    res.append("UPDATE:\n");
                    break;
                }
                default: {
                    String errorMessage = "Unsupported Action in Distributed Transaction!";
                    throw new UMRuntimeException(errorMessage);
                }
            }
            res.append(this.mPrincipalDatabag.toString());
            return res.toString();
        }
    }
}

