/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.imp;

import com.sap.security.core.persistence.datasource.IDataSourceMetaData;

public class DataSourceMetaData
implements IDataSourceMetaData {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/imp/DataSourceMetaData.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    public long mSearchTime;
    public long mSearchMaxTime;
    public long mSearchMinTime;
    public long mSearchCount;
    public long mCreateTime;
    public long mCreateMaxTime;
    public long mCreateMinTime;
    public long mCreateCount;
    public long mUpdateTime;
    public long mUpdateMaxTime;
    public long mUpdateMinTime;
    public long mUpdateCount;
    public long mDeleteTime;
    public long mDeleteMaxTime;
    public long mDeleteMinTime;
    public long mDeleteCount;
    public long mPopulateAttributeTime;
    public long mPopulateAttributeMaxTime;
    public long mPopulateAttributeMinTime;
    public long mPopulateAttributeCount;
    public long mPopulatePrincipalTime;
    public long mPopulatePrincipalMaxTime;
    public long mPopulatePrincipalMinTime;
    public long mPopulatePrincipalCount;
    public long mGetDirectParentsTime;
    public long mGetDirectParentsMaxTime;
    public long mGetDirectParentsMinTime;
    public long mGetDirectParentsCount;
    public long mCommitTime;
    public long mCommitMaxTime;
    public long mCommitMinTime;
    public long mCommitCount;
    public long mCheckCredentialsTime;
    public long mCheckCredentialsMaxTime;
    public long mCheckCredentialsMinTime;
    public long mCheckCredentialsCount;
    private String mDataSourceID;
    private String mDisplayName;
    private boolean mUsedForCeckingCredentials;
    private String mImplementationClass;
    private boolean mIsReadonly;
    private boolean mIsPrimary;

    public DataSourceMetaData() {
    }

    public DataSourceMetaData(String dataSourceID, String displayName, boolean isUsedForCheckingCredentials, String implementationClass, boolean isReadonly, boolean isPrimary) {
        this.mDataSourceID = dataSourceID;
        this.mDisplayName = displayName;
        this.mUsedForCeckingCredentials = isUsedForCheckingCredentials;
        this.mImplementationClass = implementationClass;
        this.mIsReadonly = isReadonly;
        this.mIsPrimary = isPrimary;
    }

    public synchronized void addSearchTime(long searchTime) {
        if (searchTime != 0L) {
            if (this.mSearchTime == 0L) {
                this.mSearchMaxTime = searchTime;
                this.mSearchMinTime = searchTime;
            } else {
                if (searchTime < this.mSearchMinTime) {
                    this.mSearchMinTime = searchTime;
                }
                if (searchTime > this.mSearchMaxTime) {
                    this.mSearchMaxTime = searchTime;
                }
            }
            this.mSearchTime += searchTime;
            ++this.mSearchCount;
        }
    }

    public synchronized void addCreateTime(long createTime) {
        if (createTime != 0L) {
            if (this.mCreateTime == 0L) {
                this.mCreateMaxTime = createTime;
                this.mCreateMinTime = createTime;
            } else {
                if (createTime < this.mCreateMinTime) {
                    this.mCreateMinTime = createTime;
                }
                if (createTime > this.mCreateMaxTime) {
                    this.mCreateMaxTime = createTime;
                }
            }
            this.mCreateTime += createTime;
            ++this.mCreateCount;
        }
    }

    public synchronized void addUpdateTime(long updateTime) {
        if (updateTime != 0L) {
            if (this.mUpdateTime == 0L) {
                this.mUpdateMaxTime = updateTime;
                this.mUpdateMinTime = updateTime;
            } else {
                if (updateTime < this.mUpdateMinTime) {
                    this.mUpdateMinTime = updateTime;
                }
                if (updateTime > this.mUpdateMaxTime) {
                    this.mUpdateMaxTime = updateTime;
                }
            }
            this.mUpdateTime += updateTime;
            ++this.mUpdateCount;
        }
    }

    public synchronized void addDeleteTime(long deleteTime) {
        if (deleteTime != 0L) {
            if (this.mDeleteTime == 0L) {
                this.mDeleteMaxTime = deleteTime;
                this.mDeleteMinTime = deleteTime;
            } else {
                if (deleteTime < this.mDeleteMinTime) {
                    this.mDeleteMinTime = deleteTime;
                }
                if (deleteTime > this.mDeleteMaxTime) {
                    this.mDeleteMaxTime = deleteTime;
                }
            }
            this.mDeleteTime += deleteTime;
            ++this.mDeleteCount;
        }
    }

    public synchronized void addPopulateAttributeTime(long populateAttributeTime) {
        if (populateAttributeTime != 0L) {
            if (this.mPopulateAttributeTime == 0L) {
                this.mPopulateAttributeMaxTime = populateAttributeTime;
                this.mPopulateAttributeMinTime = populateAttributeTime;
            } else {
                if (populateAttributeTime < this.mPopulateAttributeMinTime) {
                    this.mPopulateAttributeMinTime = populateAttributeTime;
                }
                if (populateAttributeTime > this.mPopulateAttributeMaxTime) {
                    this.mPopulateAttributeMaxTime = populateAttributeTime;
                }
            }
            this.mPopulateAttributeTime += populateAttributeTime;
            ++this.mPopulateAttributeCount;
        }
    }

    public synchronized void addPopulatePrincipalTime(long populatePrincipalTime) {
        this.addPopulatePrincipalTime(populatePrincipalTime, 1);
    }

    public synchronized void addGetDirectParentsTime(long getDirectParentsTime, int numberOfPrincipals) {
        if (getDirectParentsTime != 0L) {
            long averageGetParentsTime = numberOfPrincipals == 1 ? getDirectParentsTime : Math.round((double)getDirectParentsTime / (double)numberOfPrincipals);
            if (this.mGetDirectParentsTime == 0L) {
                this.mGetDirectParentsMaxTime = averageGetParentsTime;
                this.mGetDirectParentsMinTime = averageGetParentsTime;
            } else {
                if (averageGetParentsTime < this.mGetDirectParentsMinTime) {
                    this.mGetDirectParentsMinTime = averageGetParentsTime;
                }
                if (averageGetParentsTime > this.mGetDirectParentsMaxTime) {
                    this.mGetDirectParentsMaxTime = averageGetParentsTime;
                }
            }
            this.mGetDirectParentsTime += getDirectParentsTime;
            this.mGetDirectParentsCount += (long)numberOfPrincipals;
        }
    }

    public synchronized void addPopulatePrincipalTime(long populatePrincipalTime, int numberOfPopulatedPrincipals) {
        if (populatePrincipalTime != 0L) {
            long averagePopulateTime = numberOfPopulatedPrincipals == 1 ? populatePrincipalTime : Math.round((double)populatePrincipalTime / (double)numberOfPopulatedPrincipals);
            if (this.mPopulatePrincipalTime == 0L) {
                this.mPopulatePrincipalMaxTime = averagePopulateTime;
                this.mPopulatePrincipalMinTime = averagePopulateTime;
            } else {
                if (averagePopulateTime < this.mPopulatePrincipalMinTime) {
                    this.mPopulatePrincipalMinTime = averagePopulateTime;
                }
                if (averagePopulateTime > this.mPopulatePrincipalMaxTime) {
                    this.mPopulatePrincipalMaxTime = averagePopulateTime;
                }
            }
            this.mPopulatePrincipalTime += populatePrincipalTime;
            this.mPopulatePrincipalCount += (long)numberOfPopulatedPrincipals;
        }
    }

    public synchronized void addCommitTime(long commitTime) {
        if (commitTime != 0L) {
            if (this.mCommitTime == 0L) {
                this.mCommitMaxTime = commitTime;
                this.mCommitMinTime = commitTime;
            } else {
                if (commitTime < this.mCommitMinTime) {
                    this.mCommitMinTime = commitTime;
                }
                if (commitTime > this.mCommitMaxTime) {
                    this.mCommitMaxTime = commitTime;
                }
            }
            this.mCommitTime += commitTime;
            ++this.mCommitCount;
        }
    }

    public synchronized void addCheckCredentialsTime(long checkCredentialsTime) {
        if (checkCredentialsTime != 0L) {
            if (this.mCheckCredentialsTime == 0L) {
                this.mCheckCredentialsMaxTime = checkCredentialsTime;
                this.mCheckCredentialsMinTime = checkCredentialsTime;
            } else {
                if (checkCredentialsTime < this.mCheckCredentialsMinTime) {
                    this.mCheckCredentialsMinTime = checkCredentialsTime;
                }
                if (checkCredentialsTime > this.mCheckCredentialsMaxTime) {
                    this.mCheckCredentialsMaxTime = checkCredentialsTime;
                }
            }
            this.mCheckCredentialsTime += checkCredentialsTime;
            ++this.mCheckCredentialsCount;
        }
    }

    public double getAverageSearchTime() {
        if (this.mSearchCount == 0L) {
            return -1.0;
        }
        return (double)this.mSearchTime / (double)this.mSearchCount;
    }

    public long getMinSearchTime() {
        if (this.mSearchCount == 0L) {
            return -1L;
        }
        return this.mSearchMinTime;
    }

    public long getMaxSearchTime() {
        if (this.mSearchCount == 0L) {
            return -1L;
        }
        return this.mSearchMaxTime;
    }

    public long getSearchCounter() {
        return this.mSearchCount;
    }

    public long getTotalSearchTime() {
        if (this.mSearchCount == 0L) {
            return -1L;
        }
        return this.mSearchTime;
    }

    public double getAveragePopulateAttributeTime() {
        if (this.mPopulateAttributeCount == 0L) {
            return -1.0;
        }
        return (double)this.mPopulateAttributeTime / (double)this.mPopulateAttributeCount;
    }

    public long getMaxPopulateAttributeTime() {
        if (this.mPopulateAttributeCount == 0L) {
            return -1L;
        }
        return this.mPopulateAttributeMaxTime;
    }

    public long getPopulateAttributeCounter() {
        return this.mPopulateAttributeCount;
    }

    public long getTotalPopulateAttributeTime() {
        if (this.mPopulateAttributeCount == 0L) {
            return -1L;
        }
        return this.mPopulateAttributeTime;
    }

    public long getMinPopulateAttributeTime() {
        if (this.mPopulateAttributeCount == 0L) {
            return -1L;
        }
        return this.mPopulateAttributeMinTime;
    }

    public double getAveragePopulatePrincipalTime() {
        if (this.mPopulatePrincipalCount == 0L) {
            return -1.0;
        }
        return (double)this.mPopulatePrincipalTime / (double)this.mPopulatePrincipalCount;
    }

    public long getMaxPopulatePrincipalTime() {
        if (this.mPopulatePrincipalCount == 0L) {
            return -1L;
        }
        return this.mPopulatePrincipalMaxTime;
    }

    public long getPopulatePrincipalCounter() {
        return this.mPopulatePrincipalCount;
    }

    public long getTotalPopulatePrincipalTime() {
        if (this.mPopulatePrincipalCount == 0L) {
            return -1L;
        }
        return this.mPopulatePrincipalTime;
    }

    public long getMinPopulatePrincipalTime() {
        if (this.mPopulatePrincipalCount == 0L) {
            return -1L;
        }
        return this.mPopulatePrincipalMinTime;
    }

    public double getAverageCreatePrincipalTime() {
        if (this.mCreateCount == 0L) {
            return -1.0;
        }
        return (double)this.mCreateTime / (double)this.mCreateCount;
    }

    public long getMaxCreatePrincipalTime() {
        if (this.mCreateCount == 0L) {
            return -1L;
        }
        return this.mCreateMaxTime;
    }

    public long getCreatePrincipalCounter() {
        return this.mCreateCount;
    }

    public long getTotalCreatePrincipalTime() {
        if (this.mCreateCount == 0L) {
            return -1L;
        }
        return this.mCreateTime;
    }

    public long getMinCreatePrincipalTime() {
        if (this.mCreateCount == 0L) {
            return -1L;
        }
        return this.mCreateMinTime;
    }

    public double getAverageCommitPrincipalTime() {
        if (this.mCommitCount == 0L) {
            return -1.0;
        }
        return (double)this.mCommitTime / (double)this.mCommitCount;
    }

    public long getMaxCommitPrincipalTime() {
        if (this.mCommitCount == 0L) {
            return -1L;
        }
        return this.mCommitMaxTime;
    }

    public long getCommitPrincipalCounter() {
        return this.mCommitCount;
    }

    public long getTotalCommitPrincipalTime() {
        if (this.mCommitCount == 0L) {
            return -1L;
        }
        return this.mCommitTime;
    }

    public long getMinCommitPrincipalTime() {
        if (this.mCommitCount == 0L) {
            return -1L;
        }
        return this.mCommitMinTime;
    }

    public double getAverageCheckCredentialsTime() {
        if (this.mCheckCredentialsCount == 0L) {
            return -1.0;
        }
        return (double)this.mCheckCredentialsTime / (double)this.mCheckCredentialsCount;
    }

    public long getMaxCheckCredentialsTime() {
        if (this.mCheckCredentialsCount == 0L) {
            return -1L;
        }
        return this.mCheckCredentialsMaxTime;
    }

    public long getCheckCredentialsCounter() {
        return this.mCheckCredentialsCount;
    }

    public long getTotalCheckCredentialsTime() {
        if (this.mCheckCredentialsCount == 0L) {
            return -1L;
        }
        return this.mCheckCredentialsTime;
    }

    public long getMinCheckCredentialsTime() {
        if (this.mCheckCredentialsCount == 0L) {
            return -1L;
        }
        return this.mCheckCredentialsMinTime;
    }

    public double getAverageDeletePrincipalTime() {
        if (this.mDeleteCount == 0L) {
            return -1.0;
        }
        return (double)this.mDeleteTime / (double)this.mDeleteCount;
    }

    public long getMinDeletePrincipalTime() {
        if (this.mDeleteCount == 0L) {
            return -1L;
        }
        return this.mDeleteMinTime;
    }

    public long getMaxDeletePrincipalTime() {
        if (this.mDeleteCount == 0L) {
            return -1L;
        }
        return this.mDeleteMaxTime;
    }

    public long getDeletePrincipalCounter() {
        return this.mDeleteCount;
    }

    public long getTotalDeletePrincipalTime() {
        if (this.mDeleteCount == 0L) {
            return -1L;
        }
        return this.mDeleteTime;
    }

    public double getAverageUpdatePrincipalTime() {
        if (this.mUpdateCount == 0L) {
            return -1.0;
        }
        return (double)this.mUpdateTime / (double)this.mUpdateCount;
    }

    public long getMaxUpdatePrincipalTime() {
        if (this.mUpdateCount == 0L) {
            return -1L;
        }
        return this.mUpdateMaxTime;
    }

    public long getUpdatePrincipalCounter() {
        return this.mUpdateCount;
    }

    public long getTotalUpdatePrincipalTime() {
        if (this.mUpdateCount == 0L) {
            return -1L;
        }
        return this.mUpdateTime;
    }

    public long getMinUpdatePrincipalTime() {
        if (this.mUpdateCount == 0L) {
            return -1L;
        }
        return this.mUpdateMinTime;
    }

    public String getDataSourceID() {
        return this.mDataSourceID;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean isUsedForCheckingCredentials() {
        return this.mUsedForCeckingCredentials;
    }

    public String getClassName() {
        return this.mImplementationClass;
    }

    public boolean isReadonly() {
        return this.mIsReadonly;
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public double getAverageGetDirectParentsTime() {
        if (this.mGetDirectParentsCount == 0L) {
            return -1.0;
        }
        return (double)this.mGetDirectParentsTime / (double)this.mGetDirectParentsCount;
    }

    public long getMaxGetDirectParentsTime() {
        if (this.mGetDirectParentsCount == 0L) {
            return -1L;
        }
        return this.mGetDirectParentsMaxTime;
    }

    public long getGetDirectParentsCounter() {
        return this.mGetDirectParentsCount;
    }

    public long getTotalGetDirectParentsTime() {
        if (this.mGetDirectParentsCount == 0L) {
            return -1L;
        }
        return this.mGetDirectParentsTime;
    }

    public long getMinGetDirectParentsTime() {
        if (this.mGetDirectParentsCount == 0L) {
            return -1L;
        }
        return this.mGetDirectParentsMinTime;
    }
}

